package com.jfsoftware.disablecliptray;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.PowerManager;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.app.ActionBarActivity;
import android.os.Bundle;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.widget.Button;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;

import eu.chainfire.libsuperuser.Shell;


public class MainActivity extends ActionBarActivity {

    private TextView lblStatus;
    private LinearLayout grpEnableDisable;
    private LinearLayout grpEnable;
    private LinearLayout grpDisable;
    private Button btnDisableOptionA;
    private Button btnDisableOptionB;
    private FrameLayout progBar;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_main);

        lblStatus = (TextView)findViewById(R.id.lblStatus);
        grpEnableDisable = (LinearLayout)findViewById(R.id.grpEnableDisable);
        grpEnable = (LinearLayout)findViewById(R.id.grpEnable);
        grpDisable = (LinearLayout)findViewById(R.id.grpDisable);
        btnDisableOptionA = (Button)findViewById(R.id.btnDisableOptionA);
        btnDisableOptionB = (Button)findViewById(R.id.btnDisableOptionB);
        TextView lblAbout = (TextView)findViewById(R.id.lblAbout);
        TextView lblAboutLink = (TextView)findViewById(R.id.lblAboutLink);
        progBar = (FrameLayout)findViewById(R.id.progBar);

        lblAbout.setText(getString(R.string.about) + BuildConfig.VERSION_NAME);
        lblAboutLink.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
            startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(getString(R.string.about_link))));
            }
        });
        lblAboutLink.setClickable(true);

        if(!Shell.SU.available()) {
            findViewById(R.id.lblRootWarning).setVisibility(View.VISIBLE);
            grpEnableDisable.setVisibility(View.GONE);
            progBar.setVisibility(View.GONE);
        } else {
            grpEnableDisable.setVisibility(View.GONE);
            if(Build.VERSION.SDK_INT >= 11) {
                progBar.setVisibility(View.VISIBLE);
            }
            new GetClipTrayEnabledTask().execute(this);
        }
    }

    public void btnEnable_Click(View v) {
        new EnableClipTrayTask().execute(this);
    }

    public void btnDisableOptionA_Click(View v) {
        new DisableClipTrayTaskA().execute(this);
    }

    public void btnDisableOptionB_Click(View v) {
        new DisableClipTrayTaskB().execute(this);
    }

    protected void ClipTrayChanged(final @Nullable Context context) {
        if(context != null) {
            lblStatus.setText(context.getString(R.string.status_loading));

            AlertDialog.Builder builder = new AlertDialog.Builder(context);
            builder.setTitle(context.getString(R.string.title_reboot));
            builder.setMessage(context.getString(R.string.message_reboot));
            builder.setPositiveButton(context.getString(R.string.button_yes), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    Shell.SU.run("reboot");
                    dialog.cancel();
                }
            });
            builder.setNegativeButton(context.getString(R.string.button_no), new DialogInterface.OnClickListener() {
                @Override
                public void onClick(DialogInterface dialog, int which) {
                    dialog.cancel();
                }
            });
            builder.create().show();
        }
        grpEnableDisable.setVisibility(View.GONE);
        if(Build.VERSION.SDK_INT >= 11) {
            progBar.setVisibility(View.VISIBLE);
        }
        new GetClipTrayEnabledTask().execute(context);
    }

    private class DisableClipTrayTaskA extends AsyncTask<Context, Void, Void> {
        private Context _context;

        @Override
        protected Void doInBackground(Context... params) {
            if(!Shell.SU.available()) return null;
            _context = params[0];
            try {
                File xmlFile = new File("/system/etc/permissions", "com.lge.software.cliptray.xml");
                if (!xmlFile.exists()) return null;
                BufferedReader br = new BufferedReader(new FileReader(xmlFile));
                StringBuilder sb = new StringBuilder();
                String line = null;
                while((line = br.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                br.close();

                String contents = sb.toString().replace("<permissions>", "<!-- <permissions>").replace("</permissions>", "</permissions> -->");
                FileOutputStream outputStream = openFileOutput("temp.xml", Context.MODE_PRIVATE);
                outputStream.write(contents.getBytes());
                outputStream.close();

                Shell.SU.run(new String[]{
                    "mount -o rw,remount /system",
                    "cat " + _context.getFilesDir().getAbsolutePath() + "/temp.xml > /system/etc/permissions/com.lge.software.cliptray.xml",
                    "mount -o ro,remount /system"
                });
                if(new File("/data/data/com.lge.systemservice/databases/clipdata.db").isDirectory()) {
                    Shell.SU.run("rm -rf /data/data/com.lge.systemservice/databases/clipdata.db");
                }
                if(new File("/data/data/com.lge.systemservice/databases/clipdata.db-journal").isDirectory()) {
                    Shell.SU.run("rm -rf /data/data/com.lge.systemservice/databases/clipdata.db-journal");
                }
            } catch (Exception ex) {
                return null;
            }

            return null;
        }

        @Override
        protected void onPostExecute(Void v) {
            ClipTrayChanged(_context);
        }
    }

    private class DisableClipTrayTaskB extends AsyncTask<Context, Void, Void> {
        private Context _context;

        @Override
        protected Void doInBackground(Context... params) {
            if(!Shell.SU.available()) return null;
            _context = params[0];
            try {
                Shell.SU.run(new String[]{
                        "rm -rf /data/data/com.lge.systemservice/databases/clipdata.db",
                        "rm -rf /data/data/com.lge.systemservice/databases/clipdata.db-journal",
                        "mkdir /data/data/com.lge.systemservice/databases/clipdata.db",
                        "mkdir /data/data/com.lge.systemservice/databases/clipdata.db-journal"
                });

                try {
                    File xmlFile = new File("/system/etc/permissions", "com.lge.software.cliptray.xml");
                    if (xmlFile.exists()) {
                        BufferedReader br = new BufferedReader(new FileReader(xmlFile));
                        StringBuilder sb = new StringBuilder();
                        String line = null;
                        while ((line = br.readLine()) != null) {
                            sb.append(line).append("\n");
                        }
                        br.close();

                        String contents = sb.toString().replace("<!-- <permissions>", "<permissions>").replace("</permissions> -->", "</permissions>");
                        FileOutputStream outputStream = openFileOutput("temp.xml", Context.MODE_PRIVATE);
                        outputStream.write(contents.getBytes());
                        outputStream.close();

                        Shell.SU.run(new String[]{
                                "mount -o rw,remount /system",
                                "cat " + _context.getFilesDir().getAbsolutePath() + "/temp.xml > /system/etc/permissions/com.lge.software.cliptray.xml",
                                "mount -o ro,remount /system"
                        });
                    }
                } catch (Exception ignored) {
                }
            } catch (Exception ex) {
                return null;
            }

            return null;
        }

        @Override
        protected void onPostExecute(Void v) {
            ClipTrayChanged(_context);
        }
    }

    private class EnableClipTrayTask extends AsyncTask<Context, Void, Void> {
        private Context _context;

        @Override
        protected Void doInBackground(Context... params) {
            if(!Shell.SU.available()) return null;
            _context = params[0];
            try {
                File xmlFile = new File("/system/etc/permissions", "com.lge.software.cliptray.xml");
                if (!xmlFile.exists()) return null;
                BufferedReader br = new BufferedReader(new FileReader(xmlFile));
                StringBuilder sb = new StringBuilder();
                String line = null;
                while((line = br.readLine()) != null) {
                    sb.append(line).append("\n");
                }
                br.close();

                String contents = sb.toString().replace("<!-- <permissions>", "<permissions>").replace("</permissions> -->", "</permissions>");
                FileOutputStream outputStream = openFileOutput("temp.xml", Context.MODE_PRIVATE);
                outputStream.write(contents.getBytes());
                outputStream.close();

                Shell.SU.run(new String[]{
                    "mount -o rw,remount /system",
                    "cat " + _context.getFilesDir().getAbsolutePath() + "/temp.xml > /system/etc/permissions/com.lge.software.cliptray.xml",
                    "mount -o ro,remount /system"
                });
                if(new File("/data/data/com.lge.systemservice/databases/clipdata.db").isDirectory()) {
                    Shell.SU.run("rm -rf /data/data/com.lge.systemservice/databases/clipdata.db");
                }
                if(new File("/data/data/com.lge.systemservice/databases/clipdata.db-journal").isDirectory()) {
                    Shell.SU.run("rm -rf /data/data/com.lge.systemservice/databases/clipdata.db-journal");
                }
            } catch (Exception ex) {
                return null;
            }

            return null;
        }

        @Override
        protected void onPostExecute(Void v) {
            ClipTrayChanged(_context);
        }
    }

    private class GetClipTrayEnabledTask extends AsyncTask<Context, Void, Integer> {
        private Context _context;

        @Override
        protected Integer doInBackground(Context... params) {
            _context = params[0];
            try {
                File xmlFile = new File("/system/etc/permissions", "com.lge.software.cliptray.xml");
                if (xmlFile.exists()) {
                    BufferedReader br = new BufferedReader(new FileReader(xmlFile));
                    StringBuilder sb = new StringBuilder();
                    String line = null;
                    while ((line = br.readLine()) != null) {
                        sb.append(line).append("\n");
                    }
                    br.close();
                    if(sb.toString().contains("<!-- <permissions>")) return R.string.status_disabled_a;
                }

                File dbFile = new File("/data/data/com.lge.systemservice/databases/clipdata.db");
                File journalFile = new File("/data/data/com.lge.systemservice/databases/clipdata.db-journal");
                if(dbFile.isDirectory() || journalFile.isDirectory()) return R.string.status_disabled_b;

                return xmlFile.exists() || dbFile.exists() || journalFile.exists() ? R.string.status_enabled : R.string.status_baddevice;
            } catch (Exception ex) {
                return R.string.status_unknown;
            }
        }

        @Override
        protected void onPostExecute(Integer status) {
            if(_context == null) return;
            lblStatus.setText(_context.getString(status));
            if(Shell.SU.available()) {
                switch(status) {
                    case R.string.status_enabled:
                        grpEnableDisable.setVisibility(View.VISIBLE);
                        grpEnable.setVisibility(View.GONE);
                        grpDisable.setVisibility(View.VISIBLE);
                        btnDisableOptionA.setEnabled(true);
                        btnDisableOptionB.setEnabled(true);
                        break;
                    case R.string.status_disabled_a:
                    case R.string.status_disabled_b:
                        grpEnableDisable.setVisibility(View.VISIBLE);
                        grpEnable.setVisibility(View.VISIBLE);
                        grpDisable.setVisibility(View.VISIBLE);
                        btnDisableOptionA.setEnabled(status != R.string.status_disabled_a);
                        btnDisableOptionB.setEnabled(status != R.string.status_disabled_b);
                        break;
                    default:
                        grpEnableDisable.setVisibility(View.GONE);
                        break;
                }
                progBar.setVisibility(View.GONE);
            }
        }
    }
}
