package com.jfsoftware.ipv6autodisable;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.AsyncTask;
import android.preference.PreferenceManager;
import android.util.Log;
import android.widget.Toast;

import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;

public class NetworkChangeReceiver extends BroadcastReceiver {
    public NetworkChangeReceiver() {
    }

    @Override
    public void onReceive(Context context, Intent intent) {
        final SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences(context);
        final boolean isEnabled = sharedPref.getBoolean(context.getString(R.string.pref_enabled), true);
        if(!isEnabled) return;

        NetworkChangeService.launchService(context);
    }
}
