package com.jfsoftware.ipv6autodisable;

import android.annotation.TargetApi;
import android.app.ActionBar;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.res.Configuration;
import android.media.Ringtone;
import android.media.RingtoneManager;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.Uri;
import android.os.AsyncTask;
import android.os.Build;
import android.os.Bundle;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceCategory;
import android.preference.PreferenceFragment;
import android.preference.PreferenceManager;
import android.preference.RingtonePreference;
import android.text.Layout;
import android.text.TextUtils;
import android.text.util.Linkify;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsoluteLayout;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import android.widget.ListView;
import android.widget.RelativeLayout;
import android.widget.TextView;


import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.List;

import eu.chainfire.libsuperuser.Shell;

/**
 * A {@link PreferenceActivity} that presents a set of application settings. On
 * handset devices, settings are presented as a single list. On tablets,
 * settings are split by category, with category headers shown to the left of
 * the list of settings.
 * <p/>
 * See <a href="http://developer.android.com/design/patterns/settings.html">
 * Android Design: Settings</a> for design guidelines and the <a
 * href="http://developer.android.com/guide/topics/ui/settings.html">Settings
 * API Guide</a> for more information on developing a Settings UI.
 */
public class SettingsActivity extends PreferenceActivity implements SharedPreferences.OnSharedPreferenceChangeListener {
    private TextView tvStatus;
    private Button bEnable;
    private Button bDisable;

    @Override
    protected void onPostCreate(Bundle savedInstanceState) {
        super.onPostCreate(savedInstanceState);
        addPreferencesFromResource(R.xml.preferences);
        final Context context = this;
        ListView v = getListView();
        RelativeLayout rlStatus = new RelativeLayout(this);
        rlStatus.setLayoutParams(new ListView.LayoutParams(ListView.LayoutParams.MATCH_PARENT, ListView.LayoutParams.WRAP_CONTENT));

        tvStatus = new TextView(this);
        tvStatus.setText(getString(R.string.status_refreshing));
        tvStatus.setTextAppearance(this, android.R.style.TextAppearance_Medium);
        RelativeLayout.LayoutParams lpTextViewStatus = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        lpTextViewStatus.addRule(RelativeLayout.CENTER_VERTICAL, RelativeLayout.TRUE);
        tvStatus.setLayoutParams(lpTextViewStatus);
        rlStatus.addView(tvStatus);

        ImageButton ibRefreshStatus = new ImageButton(this);
        ibRefreshStatus.setImageResource(R.drawable.ic_action_refresh);
        RelativeLayout.LayoutParams lpButtonRefreshStatus = new RelativeLayout.LayoutParams(RelativeLayout.LayoutParams.WRAP_CONTENT, RelativeLayout.LayoutParams.WRAP_CONTENT);
        lpButtonRefreshStatus.addRule(RelativeLayout.ALIGN_PARENT_END, RelativeLayout.TRUE);
        ibRefreshStatus.setLayoutParams(lpButtonRefreshStatus);
        rlStatus.addView(ibRefreshStatus);
        ibRefreshStatus.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                tvStatus.setText(getString(R.string.status_refreshing));
                new GetIPv6StatusTask().execute(context);
            }
        });

        v.addFooterView(rlStatus);

        LinearLayout llEnableDisable = new LinearLayout(this);

        bEnable = new Button(this);
        bEnable.setText(getString(R.string.button_enable));
        bEnable.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                new EnableIPv6Task().execute(context);
            }
        });
        bEnable.setEnabled(false);
        llEnableDisable.addView(bEnable);

        bDisable = new Button(this);
        bDisable.setText(getString(R.string.button_disable));
        bDisable.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                new DisableIPv6Task().execute(context);
            }
        });
        bDisable.setEnabled(false);
        llEnableDisable.addView(bDisable);

        v.addFooterView(llEnableDisable);

        LinearLayout llAbout = new LinearLayout(this);
        llAbout.setOrientation(LinearLayout.VERTICAL);
        llAbout.setLayoutParams(new ListView.LayoutParams(ListView.LayoutParams.MATCH_PARENT, ListView.LayoutParams.WRAP_CONTENT));
        llAbout.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                context.startActivity(new Intent(Intent.ACTION_VIEW, Uri.parse(context.getString(R.string.about_link))));
            }
        });
        llAbout.setClickable(true);

        TextView tvAboutHeader = new TextView(this);
        tvAboutHeader.setText(getString(R.string.about) + BuildConfig.VERSION_NAME);
        tvAboutHeader.setTextAppearance(this, android.R.style.TextAppearance_Medium);
        llAbout.addView(tvAboutHeader);

        TextView tvAboutCopyright = new TextView(this);
        tvAboutCopyright.setText(getString(R.string.about_copyright));
        llAbout.addView(tvAboutCopyright);

        TextView tvAboutLink = new TextView(this);
        tvAboutLink.setText(getString(R.string.about_link));
        tvAboutLink.setAutoLinkMask(Linkify.WEB_URLS);
        llAbout.addView(tvAboutLink);

        Button bSendLog = new Button(this);
        bSendLog.setText(getString(R.string.button_send_error_log));
        bSendLog.setOnClickListener(new View.OnClickListener() {
            @Override
            public void onClick(View v) {
                String logContents = "";
                try {
                    Process process = Runtime.getRuntime().exec("logcat -d -v long -s " + getString(R.string.log_tag));
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    StringBuilder log = new StringBuilder();
                    String line = "";
                    while((line = bufferedReader.readLine()) != null) {
                        log.append(line).append("\r\n");
                    }
                    logContents = log.toString();
                }
                catch(IOException ex) {
                    AlertDialog.Builder builder = new AlertDialog.Builder(SettingsActivity.this);
                    builder.setTitle(getString(R.string.title_unable_send_log));
                    builder.setMessage(getString(R.string.error_unable_get_log));
                    builder.setNegativeButton(getString(R.string.button_ok), new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            dialog.cancel();
                        }
                    });
                    builder.create().show();
                }
                try
                {
                    Intent i = new Intent(Intent.ACTION_SEND);
                    i.setType("message/rfc822");
                    i.putExtra(Intent.EXTRA_EMAIL, new String[]{getString(R.string.about_email)});
                    i.putExtra(Intent.EXTRA_SUBJECT, getString(R.string.subject_error_log) + BuildConfig.VERSION_NAME);
                    i.putExtra(Intent.EXTRA_TEXT, logContents);
                    startActivity(Intent.createChooser(i, getString(R.string.title_sending_log)));
                }
                catch(Exception ex) {
                    AlertDialog.Builder builder = new AlertDialog.Builder(SettingsActivity.this);
                    builder.setTitle(getString(R.string.title_unable_send_log));
                    builder.setMessage(getString(R.string.error_unable_send_log));
                    builder.setNegativeButton(getString(R.string.button_ok), new DialogInterface.OnClickListener() {
                        @Override
                        public void onClick(DialogInterface dialog, int which) {
                            dialog.cancel();
                        }
                    });
                    builder.create().show();
                }
            }
        });
        llAbout.addView(bSendLog);

        v.addFooterView(llAbout);

        final SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences(this);
        sharedPref.registerOnSharedPreferenceChangeListener(this);
        new GetIPv6StatusTask().execute(this);
    }

    @Override
    public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
        if(key.equals(getString(R.string.pref_enabled)) && sharedPreferences.getBoolean(getString(R.string.pref_enabled), true)) {
            NetworkChangeService.launchService(this);
        }
        int timerDuration = Integer.valueOf(sharedPreferences.getString(getString(R.string.pref_timerduration), "10"));
        if((key.equals(getString(R.string.pref_timerenabled)) || key.equals(getString(R.string.pref_timerduration))) && sharedPreferences.getBoolean(getString(R.string.pref_timerenabled), false) && timerDuration > 0) {
            BootReceiver.startAlarm(this, timerDuration);
        } else {
            BootReceiver.stopAlarm(this);
        }
    }

    private class DisableIPv6Task extends AsyncTask<Context, Void, Void> {
        private Context _context;

        @Override
        protected Void doInBackground(Context... params) {
            _context = params[0];
            NetworkChangeService.disableIPv6(_context);
            return null;
        }

        @Override
        protected void onPostExecute(Void v) {
            if(_context != null) tvStatus.setText(_context.getString(R.string.status_refreshing));
            new GetIPv6StatusTask().execute(_context);
        }
    }

    private class EnableIPv6Task extends AsyncTask<Context, Void, Void> {
        private Context _context;

        @Override
        protected Void doInBackground(Context... params) {
            _context = params[0];
            NetworkChangeService.enableIPv6(_context);
            return null;
        }

        @Override
        protected void onPostExecute(Void v) {
            if(_context != null) tvStatus.setText(_context.getString(R.string.status_refreshing));
            new GetIPv6StatusTask().execute(_context);
        }
    }

    private class GetIPv6StatusTask extends AsyncTask<Context, Void, Integer> {
        private Context _context;

        @Override
        protected Integer doInBackground(Context... params) {
            if(!Shell.SU.available()) return R.string.status_noroot;
            _context = params[0];
            final ConnectivityManager connMgr = (ConnectivityManager)getSystemService(Context.CONNECTIVITY_SERVICE);
            if(connMgr == null) return R.string.status_unknown;
            final NetworkInfo wifi = connMgr.getNetworkInfo(ConnectivityManager.TYPE_WIFI);
            if(wifi != null && wifi.isConnected()) {
                try {
                    File disableFile = new File("/proc/sys/net/ipv6/conf/wlan0", "disable_ipv6");
                    if (!disableFile.exists()) return R.string.status_enabled;
                    BufferedReader br = new BufferedReader(new FileReader(disableFile));
                    String value = br.readLine();
                    br.close();
                    return value.equals("1") ? R.string.status_disabled : R.string.status_enabled;
                } catch (Exception ex) {
                    return R.string.status_unknown;
                }
            } else {
                return R.string.status_noconnect;
            }
        }

        @Override
        protected void onPostExecute(Integer status) {
            if(_context != null) tvStatus.setText(_context.getString(status));
            Boolean enableButtons = (status == R.string.status_enabled || status == R.string.status_disabled);
            bEnable.setEnabled(enableButtons);
            bDisable.setEnabled(enableButtons);
        }
    }
}
