package com.jfsoftware.ipv6autodisable;

import android.app.IntentService;
import android.content.Intent;
import android.content.Context;
import android.content.SharedPreferences;
import android.net.ConnectivityManager;
import android.net.Network;
import android.net.NetworkInfo;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.preference.PreferenceManager;
import android.util.Log;
import android.widget.Toast;

import eu.chainfire.libsuperuser.Shell;

import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileReader;
import java.util.List;

public class NetworkChangeService extends IntentService {
    public NetworkChangeService() {
        super("NetworkChangeService");
    }

    public static void launchService(Context context) {
        if(context != null) context.startService(new Intent(context, NetworkChangeService.class));
    }

    @Override
    protected void onHandleIntent(Intent intent) {
        final ConnectivityManager connMgr = (ConnectivityManager)getSystemService(Context.CONNECTIVITY_SERVICE);
        if(connMgr == null) return;
        final NetworkInfo wifi = connMgr.getNetworkInfo(ConnectivityManager.TYPE_WIFI);
        if(wifi != null && wifi.isConnected()) {
            disableIPv6(this);
        }
    }

    public static void enableIPv6(Context context) {
        if(!Shell.SU.available()) return;
        try {
            File disableFile = new File("/proc/sys/net/ipv6/conf/wlan0", "disable_ipv6");
            if(!disableFile.exists()) return;
            BufferedReader br = new BufferedReader(new FileReader(disableFile));
            String value = br.readLine();
            br.close();
            if(!value.equals("1")) return;

            Shell.SU.run(new String[] {
                "chmod 755 /proc/",
                "echo 0 > /proc/sys/net/ipv6/conf/wlan0/disable_ipv6"
            } );
            final SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences(context);
            final boolean showToast = sharedPref.getBoolean(context.getString(R.string.pref_toast), true);
            final Context ctxt = context;
            if(showToast) new Handler(Looper.getMainLooper()).post(new Runnable() {
                @Override
                public void run() {
                    Toast.makeText(ctxt, R.string.toast_message_enabled, Toast.LENGTH_LONG).show();
                }
            });
        }
        catch(Exception ex) {
            Log.e(context.getString(R.string.log_tag), context.getString(R.string.error_unable_enable), ex);
        }
    }

    public static void disableIPv6(Context context) {
        if(!Shell.SU.available()) return;
        try {
            File disableFile = new File("/proc/sys/net/ipv6/conf/wlan0", "disable_ipv6");
            if (disableFile.exists()) {
                BufferedReader br = new BufferedReader(new FileReader(disableFile));
                String value = br.readLine();
                br.close();
                if(value.equals("1")) return;
            }
            Shell.SU.run(new String[] {
                "chmod 755 /proc/",
                "echo 1 > /proc/sys/net/ipv6/conf/wlan0/disable_ipv6"
            } );
            final SharedPreferences sharedPref = PreferenceManager.getDefaultSharedPreferences(context);
            final boolean showToast = sharedPref.getBoolean(context.getString(R.string.pref_toast), true);
            final Context ctxt = context;
            if(showToast) new Handler(Looper.getMainLooper()).post(new Runnable() {
                @Override
                public void run() {
                    Toast.makeText(ctxt, R.string.toast_message_disabled, Toast.LENGTH_LONG).show();
                }
            });
        }
        catch(Exception ex) {
            Log.e(context.getString(R.string.log_tag), context.getString(R.string.error_unable_disable), ex);
        }
    }
}
