Attribute VB_Name = "mSystemTray"
' mSystemTray
' -----------

' Creates and deletes a system tray icon with menu functionality

' Functions
' ---------
' CreateIcon - Creates a system tray icon from a picture box
' DeleteIcon - Deletes a system tray icon

' Note
' ----
' In order to allow menu functionality, place this code in a MouseMove event of the
' picturebox being used:

' X = X / Screen.TwipsPerPixelX
' Select Case X
'     Case WM_MOUSEMOVE
'         ***YOUR EVENT HERE***
'     Case WM_LBUTTONDBLCLK
'         ***YOUR EVENT HERE***
'     Case WM_LBUTTONDOWN
'         ***YOUR EVENT HERE***
'     Case WM_MBUTTONDBLCLK
'         ***YOUR EVENT HERE***
'     Case WM_MBUTTONDOWN
'         ***YOUR EVENT HERE***
'     Case WM_RBUTTONDBLCLK
'         ***YOUR EVENT HERE***
'     Case WM_RBUTTONDOWN
'         ***YOUR EVENT HERE***
' End Select

' Replace the ***YOUR EVENT HERE*** with something to do.  For example:
' PopupMenu mnuPopup, , Screen.Width, Screen.Height

Declare Function Shell_NotifyIcon Lib "shell32.dll" Alias "Shell_NotifyIconA" _
    (ByVal dwMessage As Long, lpData As NOTIFYICONDATA) As Long

Public Type NOTIFYICONDATA
    cbSize As Long
    hwnd As Long
    uID As Long
    uFlags As Long
    uCallbackMessage As Long
    hIcon As Long
    szTip As String * 64
End Type

Public Const NIM_ADD = &H0
Public Const NIM_MODIFY = &H1
Public Const NIM_DELETE = &H2

Public Const NIF_MESSAGE = &H1
Public Const NIF_ICON = &H2
Public Const NIF_TIP = &H4

Public Const NIF_DOALL = NIF_MESSAGE Or NIF_ICON Or NIF_TIP

Public Const WM_MOUSEMOVE = &H200
Public Const WM_LBUTTONDBLCLK = &H203
Public Const WM_LBUTTONDOWN = &H201
Public Const WM_MBUTTONDBLCLK = &H209
Public Const WM_MBUTTONDOWN = &H207
Public Const WM_RBUTTONDBLCLK = &H206
Public Const WM_RBUTTONDOWN = &H204

Public Sub CreateIcon(ByVal pctTray As PictureBox, szToolTip As String)
    Dim Tic As NOTIFYICONDATA
    Tic.cbSize = Len(Tic)
    Tic.hwnd = pctTray.hwnd
    Tic.uID = 1&
    Tic.uFlags = NIF_DOALL
    Tic.uCallbackMessage = WM_MOUSEMOVE
    Tic.hIcon = pctTray.Picture
    Tic.szTip = szToolTip & Chr$(0)
    erg = Shell_NotifyIcon(NIM_ADD, Tic)
End Sub

Public Sub UpdateIcon(ByVal pctTray As PictureBox)
    Dim Tic As NOTIFYICONDATA
    Tic.cbSize = Len(Tic)
    Tic.hwnd = pctTray.hwnd
    Tic.uID = 1&
    Tic.uFlags = NIF_ICON
    Tic.uCallbackMessage = WM_MOUSEMOVE
    Tic.hIcon = pctTray.Picture
    erg = Shell_NotifyIcon(NIM_MODIFY, Tic)
End Sub

Public Sub ChangeToolTip(ByVal pctTray As PictureBox, szNewToolTip As String)
    Dim Tic As NOTIFYICONDATA
    Tic.cbSize = Len(Tic)
    Tic.hwnd = pctTray.hwnd
    Tic.uID = 1&
    Tic.uFlags = NIF_TIP
    Tic.uCallbackMessage = WM_MOUSEMOVE
    Tic.szTip = szNewToolTip & Chr$(0)
    erg = Shell_NotifyIcon(NIM_MODIFY, Tic)
End Sub

Public Sub DeleteIcon(ByVal pctTray As PictureBox)
    Dim Tic As NOTIFYICONDATA
    Tic.cbSize = Len(Tic)
    Tic.hwnd = pctTray.hwnd
    Tic.uID = 1&
    erg = Shell_NotifyIcon(NIM_DELETE, Tic)
End Sub

