Attribute VB_Name = "mCopied"
Private Declare Function OSfCreateShellLink Lib "vb6stkit.dll" Alias "fCreateShellLink" (ByVal lpstrFolderName As String, ByVal lpstrLinkName As String, ByVal lpstrLinkPath As String, ByVal lpstrLinkArguments As String, ByVal fPrivate As Long, ByVal sParent As String) As Long

' Note: The code below was copied from the Setup1 code
' for VB6 by Microsoft Corp.  All code in this module
' is copyrighted by Microsoft Corp.  Note that I might
' have modified some of the code for this program.

'-----------------------------------------------------------
' SUB: CreateShellLink
'
' Creates (or replaces) a link in either Start>Programs or
' any of its immediate subfolders in the Windows 95 shell.
'
' IN: [strLinkPath] - full path to the target of the link
'                     Ex: 'c:\Program Files\My Application\MyApp.exe"
'     [strLinkArguments] - command-line arguments for the link
'                     Ex: '-f -c "c:\Program Files\My Application\MyApp.dat" -q'
'     [strLinkName] - text caption for the link
'
' OUT:
'   The link will be created in the folder strGroupName
'-----------------------------------------------------------
'
Public Function CreateShellLink(ByVal strLinkPath As String, ByVal strLinkArguments As String, ByVal strGroupName As String, ByVal strLinkName As String) As Boolean
    Dim fPrivate As Boolean
    Dim sParent As String
    Dim fSuccess As Boolean

    strLinkName = strUnQuoteString(strLinkName)
    strLinkPath = strUnQuoteString(strLinkPath)
    fPrivate = True
    sParent = "$(Programs)"
    
    If StrPtr(strLinkArguments) = 0 Then strLinkArguments = ""

    fSuccess = OSfCreateShellLink(strGroupName, strLinkName, strLinkPath, strLinkArguments, fPrivate, sParent)  'the path should never be enclosed in double quotes
    CreateShellLink = fSuccess
End Function

Private Function strUnQuoteString(ByVal strQuotedString As String)
'
' This routine tests to see if strQuotedString is wrapped in quotation
' marks, and, if so, remove them.
'
    strQuotedString = Trim$(strQuotedString)

    If Mid$(strQuotedString, 1, 1) = Chr$(34) Then
        If Right$(strQuotedString, 1) = Chr$(34) Then
            '
            ' It's quoted.  Get rid of the quotes.
            '
            strQuotedString = Mid$(strQuotedString, 2, Len(strQuotedString) - 2)
        End If
    End If
    strUnQuoteString = strQuotedString
End Function
