Attribute VB_Name = "mJFCab"
Private Type FileDBType
    filename As String
    filelen As Long
    filepos As Long
    filedatetime As Date
End Type

Public Function AddFile(ByVal cabname As String, ByVal filename As String, ByVal inputpath As String) As String
Close #1
On Error Resume Next
Open cabname For Binary As #1
If Err Then
    AddFile = "Error: Unable to open cabinet"
    Close #1
    Exit Function
End If
On Error GoTo 0
If LOF(1) = 0 Then
    For a = 1 To 128
        PrintString 1, ""
        PrintLong 1, 0
        PrintLong 1, 0
        PrintDateTime 1, CDate(1.00001)
    Next a
    Seek #1, 1
End If
For a = 1 To 128
    tempfilename = InputString(1)
    tempfilelen = InputLong(1)
    tempfilepos = InputLong(1)
    tempfiledatetime = InputDateTime(1)
    If tempfilename = "" Then Exit For
Next a
If a = 129 Then
    AddFile = "Error: File table full"
    Close #1
    Exit Function
End If
Seek #1, Loc(1) - 53
If Right$(inputpath, 1) <> "\" Then inputpath = inputpath & "\"
On Error Resume Next
Open inputpath & filename For Binary As #2
If Err Then
    AddFile = "Error: Unable to open file"
    Close #1
    Close #2
    Exit Function
End If
On Error GoTo 0
PrintString 1, filename
PrintLong 1, LOF(2)
Close #2
PrintLong 1, LOF(1) + 1
PrintDateTime 1, filedatetime(inputpath & filename)
Seek #1, LOF(1) + 1
PrintFile 1, inputpath & filename
AddFile = "Success"
Close #1
End Function

Public Function ExtractAll(ByVal cabname As String, ByVal extractpath As String) As String
Close #1
On Error Resume Next
Open cabname For Binary As #1
If Err Then
    ExtractAll = "Error: Unable to open cabinet"
    Close #1
    Exit Function
End If
On Error GoTo 0
If LOF(1) = 0 Then
    ExtractAll = "Error: Cabinet is empty"
    Close #1
    Exit Function
End If
Dim tempdb(1 To 128) As FileDBType
For a = 1 To 128
    tempdb(a).filename = InputString(1)
    tempdb(a).filelen = InputLong(1)
    tempdb(a).filepos = InputLong(1)
    tempdb(a).filedatetime = InputDateTime(1)
Next a
tempmsg = ""
If Right$(extractpath, 1) <> "\" Then extractpath = extractpath & "\"
For a = 1 To 128
    If tempdb(a).filename = "" Then Exit For
    Seek #1, tempdb(a).filepos
    On Error Resume Next
    Open extractpath & tempdb(a).filename For Binary As #2
    If Err Then
        tempmsg = tempmsg & "Error: Unable to open file " & extractpath & tempdb(a).filename & vbCrLf
        On Error GoTo 0
        Close #2
    Else
        On Error GoTo 0
        Close #2
        Kill extractpath & tempdb(a).filename
        InputFile 1, extractpath & tempdb(a).filename, tempdb(a).filelen
    End If
Next a
Close #1
If tempmsg <> "" Then
    ExtractAll = Left$(tempmsg, Len(tempmsg) - 1)
Else
    ExtractAll = "Success"
End If
End Function

Public Function ExtractFile(ByVal cabname As String, ByVal filename As String, ByVal extractpath As String) As String
Close #1
On Error Resume Next
Open cabname For Binary As #1
If Err Then
    ExtractFile = "Error: Unable to open cabinet"
    Close #1
    Exit Function
End If
On Error GoTo 0
If LOF(1) = 0 Then
    ExtractFile = "Error: Cabinet is empty"
    Close #1
    Exit Function
End If
For a = 1 To 128
    tempfilename = InputString(1)
    tempfilelen = InputLong(1)
    tempfilepos = InputLong(1)
    tempfiledatetime = InputDateTime(1)
    If tempfilename = filename Then Exit For
Next a
If a = 129 Then
    ExtractFile = "Error: File not found in cabinet"
    Close #1
    Exit Function
End If
Seek #1, tempfilepos
If Right$(extractpath, 1) <> "\" Then extractpath = extractpath & "\"
On Error Resume Next
Open extractpath & filename For Binary As #2
If Err Then
    ExtractFile = "Error: Unable to open file"
    Close #1
    Close #2
    Exit Function
End If
On Error GoTo 0
Close #2
Kill extractpath & filename
InputFile 1, extractpath & filename, tempfilelen
Close #1
ExtractFile = "Success"
End Function

Public Function GetFileDateTime(ByVal cabname As String, ByVal filename As String) As Date
Close #1
On Error Resume Next
Open cabname For Binary As #1
If Err Then
    GetFileDateTime = CDate(-1) 'Error: Unable to open cabinet
    Close #1
    Exit Function
End If
On Error GoTo 0
If LOF(1) = 0 Then
    GetFileDateTime = CDate(-2) 'Error: Cabinet is empty
    Close #1
    Exit Function
End If
For a = 1 To 128
    tempfilename = InputString(1)
    tempfilelen = InputLong(1)
    tempfilepos = InputLong(1)
    tempfiledatetime = InputDateTime(1)
    If tempfilename = filename Then Exit For
Next a
If a = 129 Then
    GetFileDateTime = CDate(-3) 'Error: File not found in cabinet
    Close #1
    Exit Function
End If
GetFileDateTime = tempfiledatetime
End Function

Private Function InputDateTime(ByVal FileNum As Long) As Date
Dim datestr As String * 14
Get #FileNum, , datestr
tempstr = CStr(CLng(Mid$(datestr, 1, 2))) & "/" & CStr(CLng(Mid$(datestr, 3, 2))) & "/" & Mid$(datestr, 5, 4) & " " & CStr(CLng(Mid$(datestr, 9, 2))) & ":" & Mid$(datestr, 11, 2) & ":" & Mid$(datestr, 13, 2)
InputDateTime = CDate(tempstr)
End Function

Private Function InputFile(ByVal FileNum As Long, ByVal OutFilePath As String, ByVal filelen As Long) As Boolean
Dim tempstr As String * 1
Dim str50 As String * 50000
Dim str25 As String * 25000
Dim str20 As String * 10000
Dim str15 As String * 5000
Dim str10 As String * 1000
Dim str5 As String * 500
Dim str1 As String * 100
openfile = FreeFile
On Error Resume Next
Kill OutFilePath
On Error GoTo 0
Open OutFilePath For Binary As #openfile
curpos = 0
While curpos < filelen
    If curpos + 50000 <= filelen Then
        Get #FileNum, , str50
        Put #openfile, , str50
        curpos = curpos + 50000
    Else
        If curpos + 25000 <= filelen Then
            Get #FileNum, , str25
            Put #openfile, , str25
            curpos = curpos + 25000
        Else
            If curpos + 10000 <= filelen Then
                Get #FileNum, , str20
                Put #openfile, , str20
                curpos = curpos + 10000
            Else
                If curpos + 5000 <= filelen Then
                    Get #FileNum, , str15
                    Put #openfile, , str15
                    curpos = curpos + 5000
                Else
                    If curpos + 1000 <= filelen Then
                        Get #FileNum, , str10
                        Put #openfile, , str10
                        curpos = curpos + 1000
                    Else
                        If curpos + 500 <= filelen Then
                            Get #FileNum, , str5
                            Put #openfile, , str5
                            curpos = curpos + 500
                        Else
                            If curpos + 100 <= filelen Then
                                Get #FileNum, , str1
                                Put #openfile, , str1
                                curpos = curpos + 100
                            Else
                                For a = 1 To filelen - curpos
                                    Get #FileNum, , tempstr
                                    Put #openfile, , tempstr
                                Next a
                                curpos = filelen
                            End If
                        End If
                    End If
                End If
            End If
        End If
    End If
Wend
Close #openfile
End Function

Private Function InputLong(ByVal FileNum As Long) As Long
Dim InputStr As String * 4
Get #FileNum, , InputStr
result = 0
For a = 4 To 1 Step -1
    result = result + (Asc(Left$(Right$(InputStr, a), 1)) * (256 ^ (a - 1)))
Next a
InputLong = result
End Function

Private Function InputString(ByVal FileNum As Long) As String
Dim InputStr As String * 32
Get #FileNum, , InputStr
InputString = RTrim(TrimNull(InputStr))
End Function

Private Sub PrintDateTime(ByVal FileNum As Long, ByVal InputDate As Date)
Dim datestr As String * 14
datestr = Format$(InputDate, "mmddyyyyhhnnss")
Put #FileNum, , datestr
End Sub

Private Sub PrintFile(ByVal FileNum As Long, ByVal InFilePath As String)
Dim tempstr As String * 1
Dim str50 As String * 50000
Dim str25 As String * 25000
Dim str20 As String * 10000
Dim str15 As String * 5000
Dim str10 As String * 1000
Dim str5 As String * 500
Dim str1 As String * 100
If InFilePath = "" Then Exit Sub
openfile = FreeFile
Open InFilePath For Binary As #openfile
reslen = LOF(openfile)
curpos = 0
While curpos < reslen
    If curpos + 50000 <= reslen Then
        Get #openfile, , str50
        Put #FileNum, , str50
        curpos = curpos + 50000
    Else
        If curpos + 25000 <= reslen Then
            Get #openfile, , str25
            Put #FileNum, , str25
            curpos = curpos + 25000
        Else
            If curpos + 10000 <= reslen Then
                Get #openfile, , str20
                Put #FileNum, , str20
                curpos = curpos + 10000
            Else
                If curpos + 5000 <= reslen Then
                    Get #openfile, , str15
                    Put #FileNum, , str15
                    curpos = curpos + 5000
                Else
                    If curpos + 1000 <= reslen Then
                        Get #openfile, , str10
                        Put #FileNum, , str10
                        curpos = curpos + 1000
                    Else
                        If curpos + 500 <= reslen Then
                            Get #openfile, , str5
                            Put #FileNum, , str5
                            curpos = curpos + 500
                        Else
                            If curpos + 100 <= reslen Then
                                Get #openfile, , str1
                                Put #FileNum, , str1
                                curpos = curpos + 100
                            Else
                                For a = 1 To reslen - curpos
                                    Get #openfile, , tempstr
                                    Put #FileNum, , tempstr
                                Next a
                                curpos = reslen
                            End If
                        End If
                    End If
                End If
            End If
        End If
    End If
Wend
Close #openfile
End Sub

Private Sub PrintLong(ByVal FileNum As Long, ByVal InputNum As Long)
Dim outputstr As String * 4
tempnum = InputNum
tempstr = ""
For a = 3 To 0 Step -1
    If 256 ^ a <= tempnum Then Exit For
    tempstr = tempstr & Chr$(0)
    If Len(tempstr) = 4 Then GoTo SkipAllElsePL
Next a
For b = a To 0 Step -1
    curnum = Round(tempnum / (256 ^ b))
    If curnum * (256 ^ b) > tempnum Then curnum = curnum - 1
    tempstr = tempstr & Chr$(curnum)
    tempnum = tempnum - (curnum * (256 ^ b))
Next b
SkipAllElsePL:
outputstr = tempstr
Put #FileNum, , outputstr
End Sub

Private Sub PrintString(ByVal FileNum As Long, ByVal InputStr As String)
Dim PrintStr As String * 32
PrintStr = InputStr
Put #FileNum, , PrintStr
End Sub

Private Function TrimNull(item As String) As String
Dim pos As Integer
pos = InStr(item, Chr$(0))
If pos Then
    TrimNull = Left$(item, pos - 1)
Else: TrimNull = RTrim(item)
End If
End Function

