Attribute VB_Name = "mRegistry"
' mRegistry
' ------------------

' Collection of functions that work with the Registry

' Functions
' ---------

' WriteToRegistry - Writes a string or long to the Registry
' GetFromRegistry - Gets a string or long from the Registry
' DeleteRegistryKey - Deletes a registry key (directory)
' DeleteRegistryValue - Deletes a registry value

Const REG_SZ As Long = &H1
Const REG_DWORD As Long = &H4

Public Enum HKEY_CONSTANTS
    HKEY_CLASSES_ROOT = &H80000000
    HKEY_CURRENT_CONFIG = &H80000005
    HKEY_CURRENT_USER = &H80000001
    HKEY_DYN_DATA = &H80000006
    HKEY_LOCAL_MACHINE = &H80000002
    HKEY_PERFORMANCE_DATA = &H80000004
    HKEY_USERS = &H80000003
End Enum

Const KEY_ALL_ACCESS = &HF003F
Const KEY_ENUMERATE_SUB_KEYS = &H8

Public EnumReturn() As String

Declare Function RegCloseKey Lib "advapi32.dll" (ByVal hKey As Long) As Long
Declare Function RegCreateKeyEx Lib "advapi32.dll" Alias "RegCreateKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal Reserved As Long, ByVal lpClass As String, ByVal dwOptions As Long, ByVal samDesired As Long, ByVal lpSecurityAttributes As Long, phkResult As Long, lpdwDisposition As Long) As Long
Declare Function RegOpenKeyEx Lib "advapi32.dll" Alias "RegOpenKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal ulOptions As Long, ByVal samDesired As Long, phkResult As Long) As Long
Declare Function RegSetValueExString Lib "advapi32.dll" Alias "RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, ByVal lpValue As String, ByVal cbData As Long) As Long
Declare Function RegSetValueExLong Lib "advapi32.dll" Alias "RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, lpValue As Long, ByVal cbData As Long) As Long
Declare Function RegDeleteKey Lib "advapi32.dll" Alias "RegDeleteKeyA" (ByVal hKey As Long, ByVal lpSubKey As String) As Long
Declare Function RegDeleteValue Lib "advapi32.dll" Alias "RegDeleteValueA" (ByVal hKey As Long, ByVal lpValueName As String) As Long
Declare Function RegQueryValueExString Lib "advapi32.dll" Alias "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, ByVal strData As String, lpcbData As Long) As Long
Declare Function RegQueryValueExLong Lib "advapi32.dll" Alias "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, lngData As Long, lpcbData As Long) As Long
Declare Function RegEnumKeyEx Lib "advapi32.dll" Alias "RegEnumKeyExA" (ByVal hKey As Long, ByVal dwIndex As Long, ByVal lpName As String, lpcbName As Long, lpReserved As Long, ByVal lpClass As String, lpcbClass As Long, lpftLastWriteTime As FILETIME) As Long

Public Function WriteStringToRegistry(ByVal hKey As HKEY_CONSTANTS, ByVal strSubKey As String, ByVal strValueTitle As String, ByVal strValue As String) As Boolean
Dim keyhandle As Long
Dim result As Long
Dim strBuffer As String
If RegCreateKeyEx(hKey, strSubKey, 0&, vbNullString, 0&, KEY_ALL_ACCESS, 0&, keyhandle, result) <> 0 Then
    WriteStringToRegistry = False
    Exit Function
End If
strBuffer = strValue & vbNullChar
If RegSetValueExString(keyhandle, strValueTitle, 0&, REG_SZ, strBuffer, Len(strBuffer)) <> 0 Then WriteStringToRegistry = False Else WriteStringToRegistry = True
Call RegCloseKey(keyhandle)
End Function

Public Function WriteLongToRegistry(ByVal hKey As HKEY_CONSTANTS, ByVal strSubKey As String, ByVal strValueTitle As String, ByVal lngValue As Long) As Boolean
Dim keyhandle As Long
Dim result As Long
If RegCreateKeyEx(hKey, strSubKey, 0&, vbNullString, 0&, KEY_ALL_ACCESS, 0&, keyhandle, result) <> 0 Then
    WriteLongToRegistry = False
    Exit Function
End If
If strValueTitle = "" Then
    WriteLongToRegistry = False
    Exit Function
End If
If RegSetValueExLong(keyhandle, strValueTitle, 0&, REG_DWORD, lngValue, Len(anyValue)) <> 0 Then WriteLongToRegistry = False Else WriteLongToRegistry = True
Call RegCloseKey(keyhandle)
End Function

Public Function GetFromRegistry(ByVal hKey As HKEY_CONSTANTS, ByVal strSubKey As String, ByVal strValueTitle As String)
Dim keyhandle As Long
Dim datatyperesult As Long
Dim slength As Long
Dim resultstr As String
Dim resultnum As Long
If RegOpenKeyEx(hKey, strSubKey, 0&, KEY_ALL_ACCESS, keyhandle) <> 0 Then
    GetFromRegistry = "Error"
    Exit Function
End If
resultstr = Space(255)
slength = 255
If RegQueryValueExString(keyhandle, strValueTitle, 0&, datatyperesult, resultstr, slength) <> 0 Then
    GetFromRegistry = "Error"
Else
    If datatyperesult = REG_SZ Then
        GetFromRegistry = Left(resultstr, slength - 1)
    Else
        resultnum = 0
        slength = 255
        Call RegQueryValueExLong(keyhandle, strValueTitle, 0&, datatyperesult, resultnum, slength)
        GetFromRegistry = resultnum
    End If
End If
Call RegCloseKey(keyhandle)
End Function

Public Function DeleteRegistryKey(ByVal hKey As HKEY_CONSTANTS, ByVal strSubKey As String) As Boolean
If RegDeleteKey(hKey, strSubKey) <> 0 Then DeleteRegistryKey = True Else DeleteRegistryKey = False
End Function

Public Function DeleteRegistryValue(ByVal hKey As HKEY_CONSTANTS, ByVal strSubKey As String, strValueTitle As String) As Boolean
Dim keyhandle As Long
If RegOpenKeyEx(hKey, strSubKey, 0&, KEY_ALL_ACCESS, keyhandle) <> 0 Then
    DeleteRegistryValue = False
    Exit Function
End If
If RegDeleteValue(keyhandle, strValueTitle) <> 0 Then DeleteRegistryValue = True Else DeleteRegistryValue = False
Call RegCloseKey(keyhandle)
End Function

Public Function GetNumKeys(ByVal hKey As HKEY_CONSTANTS, ByVal strSubKey As String) As Long
Dim KeyName As String
Dim keylen As Long
Dim classname As String
Dim classlen As Long
Dim lastwrite As FILETIME
Dim keyhandle As Long

retval = RegOpenKeyEx(hKey, strSubKey, 0&, KEY_ENUMERATE_SUB_KEYS, keyhandle)
If retval <> 0 Then
    GetNumKeys = 0
    Exit Function
End If
Index = 0
ReDim EnumReturn(1 To 1)
While retval = 0
    KeyName = Space(255)
    classname = Space(255)
    keylen = 255
    classlen = 255
    retval = RegEnumKeyEx(keyhandle, Index, KeyName, keylen, 0&, classname, classlen, lastwrite)
    If retval = 0 Then
        KeyName = Left$(KeyName, keylen)
        ReDim Preserve EnumReturn(1 To Index + 1)
        EnumReturn(Index + 1) = KeyName
    End If
    Index = Index + 1
Wend
retval = RegCloseKey(keyhandle)
GetNumKeys = Index - 1
End Function
