Attribute VB_Name = "mCopied2"
' Note: The code below was copied from the Windows API
' Guide by Paul Kuliniewicz.  All code in this module
' is copyrighted by Paul Kuliniewicz.  Note that I might
' have modified some of the code for this program.

Public Declare Function GetFileVersionInfo Lib "version.dll" Alias "GetFileVersionInfoA" _
    (ByVal lptstrFilename As String, ByVal dwHandle As Long, ByVal dwLen As Long, _
    lpData As Any) As Long
Public Declare Function GetFileVersionInfoSize Lib "version.dll" Alias _
    "GetFileVersionInfoSizeA" (ByVal lptstrFilename As String, lpdwHandle As Long) As Long
Public Declare Function VerQueryValue Lib "version.dll" Alias "VerQueryValueA" (pBlock _
    As Any, ByVal lpSubBlock As String, lplpBuffer As Long, puLen As Long) As Long
Public Declare Function lstrcpy Lib "kernel32.dll" Alias "lstrcpyA" (ByVal lpString1 _
    As Any, ByVal lpString2 As Any) As Long
Public Declare Sub CopyMemory Lib "kernel32.dll" Alias "RtlMoveMemory" (Destination As Any, _
    Source As Any, ByVal Length As Long)
Public Type VS_FIXEDFILEINFO
    dwSignature As Long
    dwStrucVersion As Long
    dwFileVersionMS As Long
    dwFileVersionLS As Long
    dwProductVersionMS As Long
    dwProductVersionLS As Long
    dwFileFlagsMask As Long
    dwFileFlags As Long
    dwFileOS As Long
    dwFileType As Long
    dwFileSubtype As Long
    dwFileDateMS As Long
    dwFileDateLS As Long
End Type

Public Enum GetFileInfoReturns
    gfirFULLVERSION = 1
    gfirVERSIONMAJOR
    gfirVERSIONMINOR
    gfirVERSIONREV1
    gfirVERSIONREV2
    gfirFILETYPE
    gfirFIELDCOMMENTS
    gfirFIELDCOMPANYNAME
    gfirFIELDFILEDESCRIPTION
    gfirFIELDFILEVERSION
    gfirFIELDINTERNALNAME
    gfirFIELDLEGALCOPYRIGHT
    gfirFIELDLEGALTRADEMARKS
    gfirFIELDORIGINALFILENAME
    gfirFIELDPRIVATEBUILD
    gfirFIELDPRODUCTNAME
    gfirFIELDPRODUCTVERSION
    gfirFIELDSPECIALBUILD
End Enum

Public Const VFT_APP = &H1
Public Const VFT_DLL = &H2
Public Const VFT_DRV = &H3
Public Const VFT_VXD = &H5

' *** Place the following function definitions inside a module. ***

' HIWORD and LOWORD are API macros defined below.
Public Function HIWORD(ByVal dwValue As Long) As Long
    Dim hexstr As String
    hexstr = Right("00000000" & Hex(dwValue), 8)
    HIWORD = CLng("&H" & Left(hexstr, 4))
End Function
Public Function LOWORD(ByVal dwValue As Long) As Long
    Dim hexstr As String
    hexstr = Right("00000000" & Hex(dwValue), 8)
    LOWORD = CLng("&H" & Right(hexstr, 4))
End Function

' This nifty subroutine swaps two byte values without needing a buffer variable.
' This technique, which uses Xor, works as long as the two values to be swapped are
' numeric and of the same data type (here, both Byte).
Public Sub SwapByte(byte1 As Byte, byte2 As Byte)
    byte1 = byte1 Xor byte2
    byte2 = byte1 Xor byte2
    byte1 = byte1 Xor byte2
End Sub

' This function creates a hexadecimal string to represent a number, but it
' outputs a string of a fixed number of digits.  Extra zeros are added to make
' the string the proper length.  The "&H" prefix is not put into the string.
Public Function FixedHex(ByVal hexval As Long, ByVal nDigits As Long) As String
    FixedHex = Right("00000000" & Hex(hexval), nDigits)
End Function

Public Function GetFileInfo(ByVal filepath As String, returntype As GetFileInfoReturns) As String
    Dim vffi As VS_FIXEDFILEINFO  ' version info structure
    Dim buffer() As Byte          ' buffer for version info resource
    Dim pData As Long             ' pointer to version info data
    Dim nDataLen As Long          ' length of info pointed at by pData
    Dim cpl(0 To 3) As Byte       ' buffer for code page & language
    Dim cplstr As String          ' 8-digit hex string of cpl
    Dim dispstr As String         ' string used to display version information
    Dim retval As Long            ' generic return value
    
    ' First, get the size of the version info resource.  If this function fails, then Text1
    ' identifies a file that isn't a 32-bit executable/DLL/etc.
    nDataLen = GetFileVersionInfoSize(filepath, pData)
    If nDataLen = 0 Then
        GetFileInfo = "ERROR"
        Exit Function
    End If
    ' Make the buffer large enough to hold the version info resource.
    ReDim buffer(0 To nDataLen - 1) As Byte
    ' Get the version information resource.
    retval = GetFileVersionInfo(filepath, 0, nDataLen, buffer(0))
    
    ' Get a pointer to a structure that holds a bunch of data.
    retval = VerQueryValue(buffer(0), "\", pData, nDataLen)
    ' Copy that structure into the one we can access.
    CopyMemory vffi, ByVal pData, nDataLen
    ' Set the version numbers of the file.
    Select Case returntype
        Case gfirFULLVERSION
            GetFileInfo = Trim(Str(HIWORD(vffi.dwFileVersionMS))) & "." & Trim(Str(LOWORD(vffi.dwFileVersionMS))) & "." & Trim(Str(HIWORD(vffi.dwFileVersionLS))) & "." & Trim(Str(LOWORD(vffi.dwFileVersionLS)))
            Exit Function
        Case gfirVERSIONMAJOR
            GetFileInfo = Trim(Str(HIWORD(vffi.dwFileVersionMS)))
            Exit Function
        Case gfirVERSIONMINOR
            GetFileInfo = Trim(Str(LOWORD(vffi.dwFileVersionMS)))
            Exit Function
        Case gfirVERSIONREV1
            GetFileInfo = Trim(Str(HIWORD(vffi.dwFileVersionLS)))
            Exit Function
        Case gfirVERSIONREV2
            GetFileInfo = Trim(Str(LOWORD(vffi.dwFileVersionLS)))
            Exit Function
    End Select
    ' Set the type of file it is (i.e., executable, DLL, etc.).
    Select Case vffi.dwFileType
        Case VFT_APP
            filetype = "Application"
        Case VFT_DLL
            filetype = "Dynamic Link Library (DLL)"
        Case VFT_DRV
            filetype = "Device Driver"
        Case VFT_VXD
            filetype = "Virtual Device Driver"
        Case Else
            filetype = "Unknown"
    End Select
    If returntype = gfirFILETYPE Then
        GetFileInfo = filetype
        Exit Function
    End If
    
    ' Before reading any strings out of the resource, we must first determine the code page
    ' and language.  The code to get this information follows.
    retval = VerQueryValue(buffer(0), "\VarFileInfo\Translation", pData, nDataLen)
    ' Copy that informtion into the byte array.
    CopyMemory cpl(0), ByVal pData, 4
    ' It is necessary to swap the first two bytes, as well as the last two bytes.
    SwapByte cpl(0), cpl(1)
    SwapByte cpl(2), cpl(3)
    ' Convert those four bytes into a 8-digit hexadecimal string.
    cplstr = FixedHex(cpl(0), 2) & FixedHex(cpl(1), 2) & FixedHex(cpl(2), 2) & _
            FixedHex(cpl(3), 2)
    ' cplstr now represents the code page and language to read strings as.
    
    ' Read the copyright information from the version info resource.
    Select Case returntype
        Case gfirFIELDCOMMENTS
            tempstr = "Comments"
        Case gfirFIELDCOMPANYNAME
            tempstr = "CompanyName"
        Case gfirFIELDFILEDESCRIPTION
            tempstr = "FileDescription"
        Case gfirFIELDFILEVERSION
            tempstr = "FileVersion"
        Case gfirFIELDINTERNALNAME
            tempstr = "InternalName"
        Case gfirFIELDLEGALCOPYRIGHT
            tempstr = "LegalCopyright"
        Case gfirFIELDLEGALTRADEMARKS
            tempstr = "LegalTrademarks"
        Case gfirFIELDORIGINALFILENAME
            tempstr = "OriginalFilename"
        Case gfirFIELDPRIVATEBUILD
            tempstr = "PrivateBuild"
        Case gfirFIELDPRODUCTNAME
            tempstr = "ProductName"
        Case gfirFIELDPRODUCTVERSION
            tempstr = "ProductVersion"
        Case gfirFIELDSPECIALBUILD
            tempstr = "SpecialBuild"
        Case Else
            Exit Function
    End Select
    retval = VerQueryValue(buffer(0), "\StringFileInfo\" & cplstr & "\" & tempstr, _
            pData, nDataLen)
    ' Copy that data into a string for display.
    dispstr = Space(nDataLen)
    retval = lstrcpy(dispstr, pData)
    ' Display the result.
    GetFileInfo = TrimNull(dispstr)
EndOfProg:
End Function

