Attribute VB_Name = "mDrawGradient"
' mDrawGradient
' -------------

' Draws a gradient on the specified control
' These work:
'  - Form
'  - PictureBox
'  - Printer

' Functions
' ---------

' DrawGradient - Draws a two-color gradient
' TriGradient - Draws a three-color gradient

Public Sub DrawGradient(obj As Object, objisprinter As Boolean, topbottom As Boolean, startcolor As Long, endcolor As Long, Optional x As Long, Optional y As Long, Optional height As Long, Optional width As Long)
temp = (startcolor And 255)
rstart = temp And 255
temp = Int(startcolor / 256)
gstart = temp And 255
temp = Int(startcolor / 65536)
bstart = temp And 255
temp = (endcolor And 255)
rend = temp And 255
temp = Int(endcolor / 256)
gend = temp And 255
temp = Int(endcolor / 65536)
bend = temp And 255
On Error Resume Next
obj.AutoRedraw = True
If width = 0 Then width = obj.width
If height = 0 Then height = obj.height
r = rstart
g = gstart
b = bstart
If objisprinter = True Then
    tppy = Printer.TwipsPerPixelY
    tppx = Printer.TwipsPerPixelX
Else
    tppy = Screen.TwipsPerPixelY
    tppx = Screen.TwipsPerPixelX
End If
If topbottom = True Then
    rchange = (rend - rstart) / height
    gchange = (gend - gstart) / height
    bchange = (bend - bstart) / height
    For a = y To height Step tppy
        obj.Line (x, a)-(x + width, a), RGB(r, g, b)
        r = r + (tppy * rchange)
        g = g + (tppy * gchange)
        b = b + (tppy * bchange)
    Next a
Else
    rchange = (rend - rstart) / width
    gchange = (gend - gstart) / width
    bchange = (bend - bstart) / width
    For a = x To width Step tppx
        obj.Line (a, y)-(a, y + height), RGB(r, g, b)
        r = r + (tppx * rchange)
        g = g + (tppx * gchange)
        b = b + (tppx * bchange)
    Next a
End If
End Sub

Public Sub TriGradient(obj As Object, objisprinter As Boolean, topbottom As Boolean, startcolor As Long, middlecolor As Long, endcolor As Long, Optional x As Long, Optional y As Long, Optional height As Long, Optional width As Long)
temp = (startcolor And 255)
rstart = temp And 255
temp = Int(startcolor / 256)
gstart = temp And 255
temp = Int(startcolor / 65536)
bstart = temp And 255
temp = (middlecolor And 255)
rmid = temp And 255
temp = Int(middlecolor / 256)
gmid = temp And 255
temp = Int(middlecolor / 65536)
bmid = temp And 255
temp = (endcolor And 255)
rend = temp And 255
temp = Int(endcolor / 256)
gend = temp And 255
temp = Int(endcolor / 65536)
bend = temp And 255
On Error Resume Next
obj.AutoRedraw = True
If width = 0 Then width = obj.width
If height = 0 Then height = obj.height
r = rstart
g = gstart
b = bstart
If objisprinter = True Then
    tppy = Printer.TwipsPerPixelY
    tppx = Printer.TwipsPerPixelX
Else
    tppy = Screen.TwipsPerPixelY
    tppx = Screen.TwipsPerPixelX
End If
If topbottom = True Then
    rchange = (rmid - rstart) / (height / 2)
    gchange = (gmid - gstart) / (height / 2)
    bchange = (bmid - bstart) / (height / 2)
    For a = y To (height - y) / 2 Step tppy
        obj.Line (x, a)-(x + width, a), RGB(r, g, b)
        r = r + (tppy * rchange)
        g = g + (tppy * gchange)
        b = b + (tppy * bchange)
    Next a
    rchange = (rend - rmid) / (height / 2)
    gchange = (gend - gmid) / (height / 2)
    bchange = (bend - bmid) / (height / 2)
    r = rmid
    g = gmid
    b = bmid
    For a = (height - y) / 2 To height Step tppy
        obj.Line (x, a)-(x + width, a), RGB(r, g, b)
        r = r + (tppy * rchange)
        g = g + (tppy * gchange)
        b = b + (tppy * bchange)
    Next a
Else
    rchange = (rmid - rstart) / (width / 2)
    gchange = (gmid - gstart) / (width / 2)
    bchange = (bmid - bstart) / (width / 2)
    For a = x To (width - x) / 2 Step tppx
        obj.Line (a, y)-(a, y + height), RGB(r, g, b)
        r = r + (tppx * rchange)
        g = g + (tppx * gchange)
        b = b + (tppx * bchange)
    Next a
    rchange = (rend - rmid) / (width / 2)
    gchange = (gend - gmid) / (width / 2)
    bchange = (bend - bmid) / (width / 2)
    r = rmid
    g = gmid
    b = bmid
    For a = (width - x) / 2 To width Step tppx
        obj.Line (a, y)-(a, y + height), RGB(r, g, b)
        r = r + (tppx * rchange)
        g = g + (tppx * gchange)
        b = b + (tppx * bchange)
    Next a
End If
End Sub

