Attribute VB_Name = "mInfoJFC"
Private Type FileDBType
    filename As String
    filelen As Long
    filepos As Long
    filedatetime As Date
End Type

Public cComDlg As CommonDialog

Sub Main()
Set cComDlg = New CommonDialog
Dim cabname As String
Dim InputFile As String
Dim filename As String
Dim tempfilenames(1 To 1) As String
Dim tempfiletypes(1 To 1) As String
tempfilenames(1) = "JFCab Cabinet Files (*.jfc)"
tempfiletypes(1) = "*.jfc"
With cComDlg
    .OSPFileMustExist = True
    .OSPHideNetworkButton = True
    .OSPHideReadOnly = True
    .OSPPathMustExist = True
    .ShowOpen frmExtra, "", "", tempfilenames(), tempfiletypes(), 1, ".jfc", "Select JFCab Cabinet File To Get Info From...", False
    If .OSRPathFile = "" Or .OSRPathFile = "Error" Then End
    On Error Resume Next
    Close #1
    Open .OSRPathFile For Binary As #1
    If Err Then
        MsgBox "Unable to open cabinet file!"
        Close #1
        End
    End If
    cabname = .OSRPathFile
    Close #1
    tempfilenames(1) = "Text Files (*.txt)"
    tempfiletypes(1) = "*.txt"
    .OSPFileMustExist = False
    .ShowSave frmExtra, "", "", tempfilenames(), tempfiletypes(), 1, ".txt", "Select Text File To Dump Info Into..."
    If .OSRPathFile = "" Or .OSRPathFile = "Error" Then End
    On Error Resume Next
    Close #1
    Open .OSRPathFile For Binary As #1
    If Err Then
        MsgBox "Unable to open text file!"
        Close #1
        End
    End If
    textfile = .OSRPathFile
    Close #1
End With
Close #1
On Error Resume Next
Open cabname For Binary As #1
If Err Then
    MsgBox "Unable to open cabinet!"
    Close #1
    End
End If
On Error GoTo 0
If LOF(1) = 0 Then
    MsgBox "Cabinet is empty!"
    Close #1
    End
End If
Dim tempdb(1 To 128) As FileDBType
For a = 1 To 128
    tempdb(a).filename = InputString(1)
    tempdb(a).filelen = InputLong(1)
    tempdb(a).filepos = InputLong(1)
    tempdb(a).filedatetime = InputDateTime(1)
Next a
Close #1
Open textfile For Output As #1
Print #1, "JFCabinet Info Dumper 1.0"
Print #1, "(c)2002 JF Software - Joshua Foster"
Print #1, "JFC Programs and File Format (c)"
Print #1, "-----------------------------------"
Print #1, "Timestamp: " & Now
Print #1, "JFCab Cabinet File: " & cabname
numfiles = 0
For a = 1 To 128
    If tempdb(a).filename <> "" Then numfiles = numfiles + 1
Next a
Print #1, "Number of Files: " & CStr(numfiles)
Print #1, "-----------------------------------"
tempmsg = ""
curfile = 0
For a = 1 To 128
    If tempdb(a).filename = "" Then Exit For
    curfile = curfile + 1
    If curfile > 1 Then Print #1, ""
    Print #1, "JFCab File #" & CStr(curfile)
    Print #1, "Filename: " & tempdb(a).filename
    Print #1, "File size: " & CStr(tempdb(a).filelen)
    Print #1, "File timestamp: " & tempdb(a).filedatetime
Next a
Close #1
MsgBox "Successfully dumped information!"
End
End Sub

Private Function InputDateTime(ByVal FileNum As Long) As Date
Dim datestr As String * 14
Get #FileNum, , datestr
tempstr = CStr(CLng(Mid$(datestr, 1, 2))) & "/" & CStr(CLng(Mid$(datestr, 3, 2))) & "/" & Mid$(datestr, 5, 4) & " " & CStr(CLng(Mid$(datestr, 9, 2))) & ":" & Mid$(datestr, 11, 2) & ":" & Mid$(datestr, 13, 2)
InputDateTime = CDate(tempstr)
End Function

Private Function TInputFile(ByVal FileNum As Long, ByVal OutFilePath As String, ByVal filelen As Long) As Boolean
Dim tempstr As String * 1
Dim str50 As String * 50000
Dim str25 As String * 25000
Dim str20 As String * 10000
Dim str15 As String * 5000
Dim str10 As String * 1000
Dim str5 As String * 500
Dim str1 As String * 100
openfile = FreeFile
On Error Resume Next
Kill OutFilePath
On Error GoTo 0
Open OutFilePath For Binary As #openfile
curpos = 0
While curpos < filelen
    If curpos + 50000 <= filelen Then
        Get #FileNum, , str50
        Put #openfile, , str50
        curpos = curpos + 50000
    Else
        If curpos + 25000 <= filelen Then
            Get #FileNum, , str25
            Put #openfile, , str25
            curpos = curpos + 25000
        Else
            If curpos + 10000 <= filelen Then
                Get #FileNum, , str20
                Put #openfile, , str20
                curpos = curpos + 10000
            Else
                If curpos + 5000 <= filelen Then
                    Get #FileNum, , str15
                    Put #openfile, , str15
                    curpos = curpos + 5000
                Else
                    If curpos + 1000 <= filelen Then
                        Get #FileNum, , str10
                        Put #openfile, , str10
                        curpos = curpos + 1000
                    Else
                        If curpos + 500 <= filelen Then
                            Get #FileNum, , str5
                            Put #openfile, , str5
                            curpos = curpos + 500
                        Else
                            If curpos + 100 <= filelen Then
                                Get #FileNum, , str1
                                Put #openfile, , str1
                                curpos = curpos + 100
                            Else
                                For a = 1 To filelen - curpos
                                    Get #FileNum, , tempstr
                                    Put #openfile, , tempstr
                                Next a
                                curpos = filelen
                            End If
                        End If
                    End If
                End If
            End If
        End If
    End If
Wend
Close #openfile
End Function

Private Function InputLong(ByVal FileNum As Long) As Long
Dim InputStr As String * 4
Get #FileNum, , InputStr
result = 0
For a = 4 To 1 Step -1
    result = result + (Asc(Left$(Right$(InputStr, a), 1)) * (256 ^ (a - 1)))
Next a
InputLong = result
End Function

Private Function InputString(ByVal FileNum As Long) As String
Dim InputStr As String * 32
Get #FileNum, , InputStr
InputString = RTrim(TrimNull(InputStr))
End Function

Private Sub PrintDateTime(ByVal FileNum As Long, ByVal InputDate As Date)
Dim datestr As String * 14
datestr = Format$(InputDate, "mmddyyyyhhnnss")
Put #FileNum, , datestr
End Sub

Private Sub PrintFile(ByVal FileNum As Long, ByVal InFilePath As String)
Dim tempstr As String * 1
Dim str50 As String * 50000
Dim str25 As String * 25000
Dim str20 As String * 10000
Dim str15 As String * 5000
Dim str10 As String * 1000
Dim str5 As String * 500
Dim str1 As String * 100
If InFilePath = "" Then Exit Sub
openfile = FreeFile
Open InFilePath For Binary As #openfile
reslen = LOF(openfile)
curpos = 0
While curpos < reslen
    If curpos + 50000 <= reslen Then
        Get #openfile, , str50
        Put #FileNum, , str50
        curpos = curpos + 50000
    Else
        If curpos + 25000 <= reslen Then
            Get #openfile, , str25
            Put #FileNum, , str25
            curpos = curpos + 25000
        Else
            If curpos + 10000 <= reslen Then
                Get #openfile, , str20
                Put #FileNum, , str20
                curpos = curpos + 10000
            Else
                If curpos + 5000 <= reslen Then
                    Get #openfile, , str15
                    Put #FileNum, , str15
                    curpos = curpos + 5000
                Else
                    If curpos + 1000 <= reslen Then
                        Get #openfile, , str10
                        Put #FileNum, , str10
                        curpos = curpos + 1000
                    Else
                        If curpos + 500 <= reslen Then
                            Get #openfile, , str5
                            Put #FileNum, , str5
                            curpos = curpos + 500
                        Else
                            If curpos + 100 <= reslen Then
                                Get #openfile, , str1
                                Put #FileNum, , str1
                                curpos = curpos + 100
                            Else
                                For a = 1 To reslen - curpos
                                    Get #openfile, , tempstr
                                    Put #FileNum, , tempstr
                                Next a
                                curpos = reslen
                            End If
                        End If
                    End If
                End If
            End If
        End If
    End If
Wend
Close #openfile
End Sub

Private Sub PrintLong(ByVal FileNum As Long, ByVal InputNum As Long)
Dim outputstr As String * 4
tempnum = InputNum
tempstr = ""
For a = 3 To 0 Step -1
    If 256 ^ a <= tempnum Then Exit For
    tempstr = tempstr & Chr$(0)
    If Len(tempstr) = 4 Then GoTo SkipAllElsePL
Next a
For b = a To 0 Step -1
    curnum = Round(tempnum / (256 ^ b))
    If curnum * (256 ^ b) > tempnum Then curnum = curnum - 1
    tempstr = tempstr & Chr$(curnum)
    tempnum = tempnum - (curnum * (256 ^ b))
Next b
SkipAllElsePL:
outputstr = tempstr
Put #FileNum, , outputstr
End Sub

Private Sub PrintString(ByVal FileNum As Long, ByVal InputStr As String)
Dim PrintStr As String * 32
PrintStr = InputStr
Put #FileNum, , PrintStr
End Sub

Private Function TrimNull(item As String) As String
Dim pos As Integer
pos = InStr(item, Chr$(0))
If pos Then
    TrimNull = Left$(item, pos - 1)
Else: TrimNull = RTrim(item)
End If
End Function
