VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Registry"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Procedures that work with the Windows Registry."
Private Const REG_SZ As Long = &H1
Private Const REG_DWORD As Long = &H4

Public Enum HKEY_CONSTANTS
    HKEY_CLASSES_ROOT = &H80000000
    HKEY_CURRENT_CONFIG = &H80000005
    HKEY_CURRENT_USER = &H80000001
    HKEY_DYN_DATA = &H80000006
    HKEY_LOCAL_MACHINE = &H80000002
    HKEY_PERFORMANCE_DATA = &H80000004
    HKEY_USERS = &H80000003
End Enum

Private Const KEY_ALL_ACCESS = &HF003F

Private Declare Function RegCloseKey Lib "advapi32.dll" (ByVal hKey As Long) As Long
Private Declare Function RegCreateKeyEx Lib "advapi32.dll" Alias "RegCreateKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal Reserved As Long, ByVal lpClass As String, ByVal dwOptions As Long, ByVal samDesired As Long, ByVal lpSecurityAttributes As Long, phkResult As Long, lpdwDisposition As Long) As Long
Private Declare Function RegOpenKeyEx Lib "advapi32.dll" Alias "RegOpenKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal ulOptions As Long, ByVal samDesired As Long, phkResult As Long) As Long
Private Declare Function RegSetValueExString Lib "advapi32.dll" Alias "RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, ByVal lpValue As String, ByVal cbData As Long) As Long
Private Declare Function RegSetValueExLong Lib "advapi32.dll" Alias "RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, lpValue As Long, ByVal cbData As Long) As Long
Private Declare Function RegDeleteKey Lib "advapi32.dll" Alias "RegDeleteKeyA" (ByVal hKey As Long, ByVal lpSubKey As String) As Long
Private Declare Function RegDeleteValue Lib "advapi32.dll" Alias "RegDeleteValueA" (ByVal hKey As Long, ByVal lpValueName As String) As Long
Private Declare Function RegQueryValueExString Lib "advapi32.dll" Alias "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, ByVal strData As String, lpcbData As Long) As Long
Private Declare Function RegQueryValueExLong Lib "advapi32.dll" Alias "RegQueryValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal lpReserved As Long, lpType As Long, lngData As Long, lpcbData As Long) As Long

Public Function WriteValue(ByVal hKey As HKEY_CONSTANTS, ByVal strSubKey As String, ByVal strValueTitle As String, ByVal anyValue) As Boolean
Attribute WriteValue.VB_Description = "Writes a string or long value to the Registry."
Attribute WriteValue.VB_UserMemId = 0
Dim keyhandle As Long
Dim result As Long
If RegCreateKeyEx(hKey, strSubKey, 0&, vbNullString, 0&, KEY_ALL_ACCESS, 0&, keyhandle, result) <> 0 Then
    WriteValue = False
    Exit Function
End If
If IsNumeric(anyValue) = True Then
    If strValueTitle = "" Then
        WriteValue = False
        Exit Function
    End If
    If RegSetValueExLong(keyhandle, strValueTitle, 0&, REG_DWORD, anyValue, Len(anyValue)) <> 0 Then WriteValue = False Else WriteValue = True
Else
    Dim strBuffer As String
    strBuffer = anyValue & vbNullChar
    If RegSetValueExString(keyhandle, strValueTitle, 0&, REG_SZ, strBuffer, Len(strBuffer)) <> 0 Then WriteValue = False Else WriteValue = True
End If
Call RegCloseKey(keyhandle)
End Function

Public Function ReadValue(ByVal hKey As HKEY_CONSTANTS, ByVal strSubKey As String, ByVal strValueTitle As String)
Attribute ReadValue.VB_Description = "Reads a value from the Registry."
Dim keyhandle As Long
Dim datatyperesult As Long
Dim slength As Long
Dim resultstr As String
Dim resultnum As Long
If RegOpenKeyEx(hKey, strSubKey, 0&, KEY_ALL_ACCESS, keyhandle) <> 0 Then
    ReadValue = "Error"
    Exit Function
End If
resultstr = Space(255)
slength = 255
If RegQueryValueExString(keyhandle, strValueTitle, 0&, datatyperesult, resultstr, slength) <> 0 Then
    ReadValue = "Error"
Else
    If datatyperesult = REG_SZ Then
        ReadValue = Left(resultstr, slength - 1)
    Else
        resultnum = 0
        slength = 255
        Call RegQueryValueExLong(keyhandle, strValueTitle, 0&, datatyperesult, resultnum, slength)
        ReadValue = resultnum
    End If
End If
Call RegCloseKey(keyhandle)
End Function

Public Function DeleteKey(ByVal hKey As HKEY_CONSTANTS, ByVal strSubKey As String) As Boolean
Attribute DeleteKey.VB_Description = "Deletes a key (folder of values)"
If RegDeleteKey(hKey, strSubKey) <> 0 Then DeleteKey = True Else DeleteKey = False
End Function

Public Function DeleteValue(ByVal hKey As HKEY_CONSTANTS, ByVal strSubKey As String, strValueTitle As String) As Boolean
Attribute DeleteValue.VB_Description = "Deletes a value."
Dim keyhandle As Long
If RegOpenKeyEx(hKey, strSubKey, 0&, KEY_ALL_ACCESS, keyhandle) <> 0 Then
    DeleteValue = False
    Exit Function
End If
If RegDeleteValue(keyhandle, strValueTitle) <> 0 Then DeleteValue = True Else DeleteValue = False
Call RegCloseKey(keyhandle)
End Function


