Attribute VB_Name = "mGraphics"

Public Sub MCircle()
With frmMain
    DisableGraphics
    .txtResults.Text = "Conducting Graphics: Circle test" & vbCrLf
    .txtResults.Text = .txtResults.Text & "Test will consist of drawing and CLSing 1000 50 x 50 circles." & vbCrLf
    .txtStatus.Text = "Preparing for VB test..."
    DoEvents
    .pctBlank.Cls
    .txtStatus.Text = "Testing VB..."
    DoEvents
    starttimer = Timer * 1000
    For a = 1 To 1000
        .pctBlank.Circle (25 * 12, 25 * 12), 25 * 12
        .pctBlank.Cls
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "VB test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Preparing for API test..."
    DoEvents
    .pctBlank.Cls
    .txtStatus.Text = "Testing API..."
    DoEvents
    starttimer = Timer * 1000
    For a = 1 To 1000
        Ellipse .pctBlank.hdc, 0, 0, 50, 50
        .pctBlank.Cls
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "API test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Ready"
    DoEvents
    EnableGraphics
End With
End Sub

Public Sub MCopy()
With frmMain
    DisableGraphics
    .txtResults.Text = "Conducting Graphics: Copy test" & vbCrLf
    .txtResults.Text = .txtResults.Text & "Test will consist of copying and CLSing a 67 x 277 pixel picture 500 times (9,279,500 pixels total)." & vbCrLf
    .txtStatus.Text = "Preparing for VB test..."
    DoEvents
    .pctBlank.Picture = LoadPicture
    .txtStatus.Text = "Testing VB..."
    DoEvents
    starttimer = Timer * 1000
    For a = 1 To 500
        .pctBlank.Picture = .pctLoaded.Picture
        .pctBlank.Picture = LoadPicture
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "VB test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Preparing for API test..."
    DoEvents
    .pctBlank.Cls
    .txtStatus.Text = "Testing API..."
    DoEvents
    starttimer = Timer * 1000
    For a = 1 To 500
        BitBlt .pctBlank.hdc, 0, 0, 277, 67, .pctLoaded.hdc, 0, 0, &HCC0020
        .pctBlank.Cls
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "API test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Ready"
    DoEvents
    EnableGraphics
End With
End Sub

Public Sub MGet()
Dim temppixels As New Collection
With frmMain
    DisableGraphics
    .txtResults.Text = "Conducting Graphics: Get test" & vbCrLf
    .txtResults.Text = .txtResults.Text & "Test will consist of retrieving and storing all 18,559 pixels in the box." & vbCrLf
    .txtStatus.Text = "Testing VB..."
    DoEvents
    starttimer = Timer * 1000
    For a = 0 To 276
        For b = 0 To 66
            temppixels.Add .pctLoaded.Point(a, b)
        Next b
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "VB test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Preparing for API test..."
    DoEvents
    For a = 1 To temppixels.Count
        temppixels.Remove 1
    Next a
    .txtStatus.Text = "Testing API..."
    DoEvents
    starttimer = Timer * 1000
    For a = 0 To 276
        For b = 0 To 66
            temppixels.Add GetPixel(.pctLoaded.hdc, a, b)
        Next b
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "API test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Ready"
    DoEvents
    EnableGraphics
End With
End Sub

Public Sub MLine()
With frmMain
    DisableGraphics
    .txtResults.Text = "Conducting Graphics: Line test" & vbCrLf
    .txtResults.Text = .txtResults.Text & "Test will consist of drawing 27,900 lines 67 pixels in height, filling the entire box 100 times." & vbCrLf
    .txtStatus.Text = "Preparing for VB test..."
    DoEvents
    .pctBlank.Cls
    .txtStatus.Text = "Testing VB..."
    DoEvents
    starttimer = Timer * 1000
    For a = 1 To 100
        For b = 0 To 278
            .pctBlank.Line (b * 12, 0)-(b * 12, 67 * 12)
        Next b
        .pctBlank.Cls
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "VB test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Preparing for API test..."
    DoEvents
    .pctBlank.Cls
    .txtStatus.Text = "Testing API..."
    DoEvents
    starttimer = Timer * 1000
    Dim pt As POINT_TYPE
    For a = 1 To 100
        For b = 0 To 278
            MoveToEx .pctBlank.hdc, b, 0, pt
            LineTo .pctBlank.hdc, b, 67
        Next b
        .pctBlank.Cls
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "API test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Ready"
    DoEvents
    EnableGraphics
End With
End Sub

Public Sub MSet()
With frmMain
    DisableGraphics
    .txtResults.Text = "Conducting Graphics: Set test" & vbCrLf
    .txtResults.Text = .txtResults.Text & "Test will consist of writing to all 18,559 pixels in the box." & vbCrLf
    .txtStatus.Text = "Testing VB..."
    DoEvents
    starttimer = Timer * 1000
    For a = 0 To 276
        For b = 0 To 66
            .pctBlank.PSet (a * 12, b * 12), .pctLoaded.Point(a, b)
        Next b
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "VB test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Preparing for API test..."
    DoEvents
    .pctBlank.Cls
    .txtStatus.Text = "Testing API..."
    DoEvents
    starttimer = Timer * 1000
    For a = 0 To 276
        For b = 0 To 66
            SetPixelV .pctBlank.hdc, a, b, .pctLoaded.Point(a, b)
        Next b
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "API test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Ready"
    DoEvents
    EnableGraphics
End With
End Sub

Private Sub DisableGraphics()
With frmMain
    .SSTab1.Enabled = False
    .cmdCopyPict.Enabled = False
    .cmdCircle.Enabled = False
    .cmdLine.Enabled = False
    .cmdGet.Enabled = False
    .cmdSet.Enabled = False
End With
End Sub

Private Sub EnableGraphics()
With frmMain
    .SSTab1.Enabled = True
    .cmdCopyPict.Enabled = True
    .cmdCircle.Enabled = True
    .cmdLine.Enabled = True
    .cmdGet.Enabled = True
    .cmdSet.Enabled = True
End With
End Sub

