Attribute VB_Name = "mFileSystem"

Public Sub MCopy()
With frmMain
    DisableFileSystem
    .txtResults.Text = "Conducting File System: Copy test" & vbCrLf
    .txtResults.Text = .txtResults.Text & "Test will consist of copying a 500 byte file 250 times (125,000 bytes total)." & vbCrLf
    .txtStatus.Text = "Preparing for VB test..."
    DoEvents
    On Error Resume Next
    Kill workingpath & "temp\*.*"
    RmDir workingpath & "temp"
    On Error GoTo 0
    MkDir workingpath & "temp"
    Open workingpath & "temp\original.txt" For Binary As #1
    Put #1, , outstr
    Close #1
    .txtStatus.Text = "Testing VB..."
    DoEvents
    starttimer = Timer * 1000
    For a = 1 To 250
        FileCopy workingpath & "temp\original.txt", workingpath & "temp\new" & CStr(a) & ".txt"
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "VB test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Preparing for API test..."
    DoEvents
    On Error Resume Next
    Kill workingpath & "temp\*.*"
    RmDir workingpath & "temp"
    On Error GoTo 0
    MkDir workingpath & "temp"
    Open workingpath & "temp\original.txt" For Binary As #1
    Put #1, , outstr
    Close #1
    .txtStatus.Text = "Testing API..."
    DoEvents
    starttimer = Timer * 1000
    For a = 1 To 250
        CopyFile workingpath & "temp\original.txt", workingpath & "temp\new" & CStr(a) & ".txt", 0
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "API test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Cleaning up..."
    DoEvents
    On Error Resume Next
    Kill workingpath & "temp\*.*"
    RmDir workingpath & "temp"
    On Error GoTo 0
    .txtStatus.Text = "Ready"
    EnableFileSystem
End With
End Sub

Public Sub MFind()
Dim storedvalues As New Collection
With frmMain
    DisableFileSystem
    .txtResults.Text = "Conducting File System: Find test" & vbCrLf
    .txtResults.Text = .txtResults.Text & "Test will consist of 'finding' 3000 files." & vbCrLf
    .txtStatus.Text = "Preparing for VB test..."
    DoEvents
    On Error Resume Next
    Kill workingpath & "temp\*.*"
    RmDir workingpath & "temp"
    On Error GoTo 0
    MkDir workingpath & "temp"
    Open workingpath & "temp\original.txt" For Binary As #1
    Put #1, , outstr
    Close #1
    For a = 1 To 3000
        FileCopy workingpath & "temp\original.txt", workingpath & "temp\new" & CStr(a) & ".txt"
    Next a
    .txtStatus.Text = "Testing VB..."
    DoEvents
    starttimer = Timer * 1000
    storedvalues.Add Dir(workingpath & "temp\new*.txt")
    For a = 2 To 3000
        storedvalues.Add Dir
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "VB test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Preparing for API test..."
    For a = 1 To storedvalues.Count
        storedvalues.Remove 1
    Next a
    .txtStatus.Text = "Testing API..."
    DoEvents
    starttimer = Timer * 1000
    Dim findinfo As WIN32_FIND_DATA
    Dim hsearch As Long
    hsearch = FindFirstFile(workingpath & "temp\new*.txt", findinfo)
    If hsearch = -1 Then GoTo EndSearch
    Do
      tempstr = Left(findinfo.cFileName, InStr(findinfo.cFileName, vbNullChar) - 1)
      success = FindNextFile(hsearch, findinfo)
    Loop Until success = 0
EndSearch:
    retval = FindClose(hsearch)
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "API test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Cleaning up..."
    DoEvents
    On Error Resume Next
    Kill workingpath & "temp\*.*"
    RmDir workingpath & "temp"
    On Error GoTo 0
    .txtStatus.Text = "Ready"
    EnableFileSystem
End With
End Sub

Public Sub MGetAttr()
Dim storedvalues As New Collection
With frmMain
    DisableFileSystem
    .txtResults.Text = "Conducting File System: GetAttr test" & vbCrLf
    .txtResults.Text = .txtResults.Text & "Test will consist of reading the attributes of 1000 files." & vbCrLf
    .txtStatus.Text = "Preparing for VB test..."
    DoEvents
    On Error Resume Next
    Kill workingpath & "temp\*.*"
    RmDir workingpath & "temp"
    On Error GoTo 0
    MkDir workingpath & "temp"
    Open workingpath & "temp\original.txt" For Binary As #1
    Put #1, , outstr
    Close #1
    For a = 1 To 1000
        FileCopy workingpath & "temp\original.txt", workingpath & "temp\new" & CStr(a) & ".txt"
    Next a
    .txtStatus.Text = "Testing VB..."
    DoEvents
    starttimer = Timer * 1000
    For a = 1 To 1000
        storedvalues.Add GetAttr(workingpath & "temp\new" & CStr(a) & ".txt")
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "VB test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Preparing for API test..."
    For a = 1 To storedvalues.Count
        storedvalues.Remove 1
    Next a
    .txtStatus.Text = "Testing API..."
    DoEvents
    starttimer = Timer * 1000
    For a = 1 To 1000
        storedvalues.Add GetFileAttributes(workingpath & "temp\new" & CStr(a) & ".txt")
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "API test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Cleaning up..."
    DoEvents
    On Error Resume Next
    Kill workingpath & "temp\*.*"
    RmDir workingpath & "temp"
    On Error GoTo 0
    .txtStatus.Text = "Ready"
    EnableFileSystem
End With
End Sub

Public Sub MKill()
With frmMain
    DisableFileSystem
    .txtResults.Text = "Conducting File System: Delete test" & vbCrLf
    .txtResults.Text = .txtResults.Text & "Test will consist of deleting a 1000-set of 500 byte file (250,000 bytes total)." & vbCrLf
    .txtStatus.Text = "Preparing for VB test..."
    DoEvents
    On Error Resume Next
    Kill workingpath & "temp\*.*"
    RmDir workingpath & "temp"
    On Error GoTo 0
    MkDir workingpath & "temp"
    Open workingpath & "temp\original.txt" For Binary As #1
    Put #1, , outstr
    Close #1
    For a = 1 To 1000
        FileCopy workingpath & "temp\original.txt", workingpath & "temp\new" & CStr(a) & ".txt"
    Next a
    .txtStatus.Text = "Testing VB..."
    DoEvents
    starttimer = Timer * 1000
    For a = 1 To 1000
        Kill workingpath & "temp\new" & CStr(a) & ".txt"
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "VB test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Preparing for API test..."
    DoEvents
    On Error Resume Next
    Kill workingpath & "temp\*.*"
    RmDir workingpath & "temp"
    On Error GoTo 0
    MkDir workingpath & "temp"
    Open workingpath & "temp\original.txt" For Binary As #1
    Put #1, , outstr
    Close #1
    For a = 1 To 1000
        FileCopy workingpath & "temp\original.txt", workingpath & "temp\new" & CStr(a) & ".txt"
    Next a
    .txtStatus.Text = "Testing API..."
    DoEvents
    starttimer = Timer * 1000
    For a = 1 To 1000
        DeleteFile workingpath & "temp\new" & CStr(a) & ".txt"
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "API test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Cleaning up..."
    DoEvents
    On Error Resume Next
    Kill workingpath & "temp\*.*"
    RmDir workingpath & "temp"
    On Error GoTo 0
    .txtStatus.Text = "Ready"
    EnableFileSystem
End With
End Sub

Public Sub MLOF()
Dim storedvalues As New Collection
With frmMain
    DisableFileSystem
    .txtResults.Text = "Conducting File System: Length test" & vbCrLf
    .txtResults.Text = .txtResults.Text & "Test will consist of reading the length of 1000 500-byte files." & vbCrLf
    .txtStatus.Text = "Preparing for VB test..."
    DoEvents
    On Error Resume Next
    Kill workingpath & "temp\*.*"
    RmDir workingpath & "temp"
    On Error GoTo 0
    MkDir workingpath & "temp"
    Open workingpath & "temp\original.txt" For Binary As #1
    Put #1, , outstr
    Close #1
    For a = 1 To 1000
        FileCopy workingpath & "temp\original.txt", workingpath & "temp\new" & CStr(a) & ".txt"
    Next a
    .txtStatus.Text = "Testing VB..."
    DoEvents
    starttimer = Timer * 1000
    Close #1
    For a = 1 To 1000
        Open workingpath & "temp\new" & CStr(a) & ".txt" For Input As #1
        storedvalues.Add LOF(1)
        Close #1
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "VB test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Preparing for API test..."
    For a = 1 To storedvalues.Count
        storedvalues.Remove 1
    Next a
    .txtStatus.Text = "Testing API..."
    DoEvents
    starttimer = Timer * 1000
    Dim temphand As Long
    Dim highorder As Long
    For a = 1 To 1000
        temphand = CreateFile(workingpath & "temp\new" & CStr(a) & ".txt", &H80000000, &H1, ByVal CLng(0), 3, &H20, 0)
        highorder = 0
        loworder = GetFileSize(temphand, highorder)
        If highorder = 0 Then
            storedvalues.Add loworder
        Else
            storedvalues.Add Hex(highorder) & Hex(loworder)
        End If
        CloseHandle temphand
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "API test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Cleaning up..."
    DoEvents
    On Error Resume Next
    Kill workingpath & "temp\*.*"
    RmDir workingpath & "temp"
    On Error GoTo 0
    .txtStatus.Text = "Ready"
    EnableFileSystem
End With
End Sub

Public Sub MMkDir()
With frmMain
    DisableFileSystem
    .txtResults.Text = "Conducting File System: MkDir test" & vbCrLf
    .txtResults.Text = .txtResults.Text & "Test will consist of creating 500 directories." & vbCrLf
    .txtStatus.Text = "Preparing for VB test..."
    DoEvents
    On Error Resume Next
    For a = 1 To 500
        RmDir workingpath & "temp\temp" & CStr(a)
    Next a
    MkDir workingpath & "temp"
    On Error GoTo 0
    .txtStatus.Text = "Testing VB..."
    DoEvents
    starttimer = Timer * 1000
    For a = 1 To 500
        MkDir workingpath & "temp\temp" & CStr(a)
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "VB test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Preparing for API test..."
    DoEvents
    On Error Resume Next
    For a = 1 To 500
        RmDir workingpath & "temp\temp" & CStr(a)
    Next a
    On Error GoTo 0
    .txtStatus.Text = "Testing API..."
    DoEvents
    starttimer = Timer * 1000
    Dim secattr As SECURITY_ATTRIBUTES
    For a = 1 To 500
        secattr.nLength = Len(secattr)
        secattr.lpSecurityDescriptor = 0
        secattr.bInheritHandle = 1
        CreateDirectory workingpath & "temp\temp" & CStr(a), secattr
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "API test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Cleaning up..."
    DoEvents
    On Error Resume Next
    For a = 1 To 500
        RmDir workingpath & "temp\temp" & CStr(a)
    Next a
    RmDir workingpath & "temp"
    On Error GoTo 0
    .txtStatus.Text = "Ready"
    EnableFileSystem
End With
End Sub

Public Sub MRmDir()
With frmMain
    DisableFileSystem
    .txtResults.Text = "Conducting File System: RmDir test" & vbCrLf
    .txtResults.Text = .txtResults.Text & "Test will consist of removing 500 directories." & vbCrLf
    .txtStatus.Text = "Preparing for VB test..."
    DoEvents
    On Error Resume Next
    MkDir workingpath & "temp"
    For a = 1 To 500
        MkDir workingpath & "temp\temp" & CStr(a)
    Next a
    On Error GoTo 0
    .txtStatus.Text = "Testing VB..."
    DoEvents
    starttimer = Timer * 1000
    For a = 1 To 500
        RmDir workingpath & "temp\temp" & CStr(a)
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "VB test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Preparing for API test..."
    DoEvents
    On Error Resume Next
    For a = 1 To 500
        MkDir workingpath & "temp\temp" & CStr(a)
    Next a
    On Error GoTo 0
    .txtStatus.Text = "Testing API..."
    DoEvents
    starttimer = Timer * 1000
    For a = 1 To 500
        RemoveDirectory workingpath & "temp\temp" & CStr(a)
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "API test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Cleaning up..."
    DoEvents
    On Error Resume Next
    For a = 1 To 500
        RmDir workingpath & "temp\temp" & CStr(a)
    Next a
    RmDir workingpath & "temp"
    On Error GoTo 0
    .txtStatus.Text = "Ready"
    EnableFileSystem
End With
End Sub

Public Sub MSetAttr()
With frmMain
    DisableFileSystem
    .txtResults.Text = "Conducting File System: SetAttr test" & vbCrLf
    .txtResults.Text = .txtResults.Text & "Test will consist of setting the hidden attribute of 1000 files." & vbCrLf
    .txtStatus.Text = "Preparing for VB test..."
    DoEvents
    On Error Resume Next
    Kill workingpath & "temp\*.*"
    RmDir workingpath & "temp"
    On Error GoTo 0
    MkDir workingpath & "temp"
    Open workingpath & "temp\original.txt" For Binary As #1
    Put #1, , outstr
    Close #1
    For a = 1 To 1000
        FileCopy workingpath & "temp\original.txt", workingpath & "temp\new" & CStr(a) & ".txt"
    Next a
    .txtStatus.Text = "Testing VB..."
    DoEvents
    starttimer = Timer * 1000
    For a = 1 To 1000
        SetAttr workingpath & "temp\new" & CStr(a) & ".txt", vbHidden
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "VB test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Preparing for API test..."
    For a = 1 To 1000
        SetAttr workingpath & "temp\new" & CStr(a) & ".txt", vbArchive
    Next a
    .txtStatus.Text = "Testing API..."
    DoEvents
    starttimer = Timer * 1000
    For a = 1 To 1000
        SetFileAttributes workingpath & "temp\new" & CStr(a) & ".txt", &H2
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "API test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Cleaning up..."
    DoEvents
    On Error Resume Next
    Kill workingpath & "temp\*.*"
    RmDir workingpath & "temp"
    On Error GoTo 0
    .txtStatus.Text = "Ready"
    EnableFileSystem
End With
End Sub

Public Sub MTime()
Dim storedvalues As New Collection
With frmMain
    DisableFileSystem
    .txtResults.Text = "Conducting File System: Time test" & vbCrLf
    .txtResults.Text = .txtResults.Text & "Test will consist of reading the last modification time of 1000 500-byte files." & vbCrLf
    .txtStatus.Text = "Preparing for VB test..."
    DoEvents
    On Error Resume Next
    Kill workingpath & "temp\*.*"
    RmDir workingpath & "temp"
    On Error GoTo 0
    MkDir workingpath & "temp"
    Open workingpath & "temp\original.txt" For Binary As #1
    Put #1, , outstr
    Close #1
    For a = 1 To 1000
        FileCopy workingpath & "temp\original.txt", workingpath & "temp\new" & CStr(a) & ".txt"
    Next a
    .txtStatus.Text = "Testing VB..."
    DoEvents
    starttimer = Timer * 1000
    For a = 1 To 1000
        storedvalues.Add FileDateTime(workingpath & "temp\new" & CStr(a) & ".txt")
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "VB test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Preparing for API test..."
    For a = 1 To storedvalues.Count
        storedvalues.Remove 1
    Next a
    .txtStatus.Text = "Testing API..."
    DoEvents
    starttimer = Timer * 1000
    Dim temphand As Long
    Dim ctime As FILETIME
    Dim atime As FILETIME
    Dim motime As FILETIME
    Dim thetime As SYSTEMTIME
    For a = 1 To 1000
        temphand = CreateFile(workingpath & "temp\new" & CStr(a) & ".txt", &H80000000, &H1, ByVal CLng(0), 3, &H20, 0)
        GetFileTime temphand, ctime, atime, motime
        FileTimeToLocalFileTime motime, motime
        FileTimeToSystemTime motime, thetime
        storedvalues.Add Format$(CStr(thetime.wMonth) & "/" & CStr(thetime.wDay) & "/" & CStr(thetime.wYear) & " " & CStr(thetime.wHour) & ":" & CStr(thetime.wMinute) & ":" & CStr(thetime.wSecond), "M/D/YY H:NN:SS AM/PM")
        CloseHandle temphand
    Next a
    stoptimer = Timer * 1000
    totaltime = stoptimer - starttimer
    .txtResults.Text = .txtResults.Text & "API test took " & CStr(Round(totaltime, 2)) & " ms" & vbCrLf
    .txtStatus.Text = "Cleaning up..."
    DoEvents
    On Error Resume Next
    Kill workingpath & "temp\*.*"
    RmDir workingpath & "temp"
    On Error GoTo 0
    .txtStatus.Text = "Ready"
    EnableFileSystem
End With
End Sub

Private Sub DisableFileSystem()
With frmMain
    .SSTab1.Enabled = False
    .cmdCopy.Enabled = False
    .cmdMkDir.Enabled = False
    .cmdKill.Enabled = False
    .cmdFind.Enabled = False
    .cmdGetAttr.Enabled = False
    .cmdLOF.Enabled = False
    .cmdTime.Enabled = False
    .cmdRmDir.Enabled = False
    .cmdSetAttr.Enabled = False
End With
End Sub

Private Sub EnableFileSystem()
With frmMain
    .SSTab1.Enabled = True
    .cmdCopy.Enabled = True
    .cmdMkDir.Enabled = True
    .cmdKill.Enabled = True
    .cmdFind.Enabled = True
    .cmdGetAttr.Enabled = True
    .cmdLOF.Enabled = True
    .cmdTime.Enabled = True
    .cmdRmDir.Enabled = True
    .cmdSetAttr.Enabled = True
End With
End Sub

