Attribute VB_Name = "mCreateAssociation"
Public Declare Function RegCloseKey Lib "advapi32.dll" (ByVal hKey As Long) As Long
Public Declare Function RegCreateKeyEx Lib "advapi32.dll" Alias "RegCreateKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal Reserved As Long, ByVal lpClass As String, ByVal dwOptions As Long, ByVal samDesired As Long, ByVal lpSecurityAttributes As Long, phkResult As Long, lpdwDisposition As Long) As Long
Public Declare Function RegOpenKeyEx Lib "advapi32.dll" Alias "RegOpenKeyExA" (ByVal hKey As Long, ByVal lpSubKey As String, ByVal ulOptions As Long, ByVal samDesired As Long, phkResult As Long) As Long
Public Declare Function RegSetValueExString Lib "advapi32.dll" Alias "RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, ByVal lpValue As String, ByVal cbData As Long) As Long
Public Declare Function RegSetValueExLong Lib "advapi32.dll" Alias "RegSetValueExA" (ByVal hKey As Long, ByVal lpValueName As String, ByVal Reserved As Long, ByVal dwType As Long, lpValue As Long, ByVal cbData As Long) As Long

Public Sub CreateArmyAssociation(ByVal sExtension As String, ByVal sAppKeyName As String, ByVal sAppOpenPath As String, ByVal sFileTypeName As String, ByVal sIconPath As String, ByVal errcalled As String)
    On Error GoTo ErrorTrapper
    Dim sPath As String
    CreateNewKey sExtension, &H80000000
    SetKeyValue sExtension, "", sAppKeyName, &H1
    If sAppOpenPath <> "" Then
        CreateNewKey sAppKeyName & "\shell\Edit\command", &H80000000
        SetKeyValue sAppKeyName, "", sFileTypeName, &H1
        SetKeyValue sAppKeyName & "\shell\Edit\command", "", sAppOpenPath, &H1
    End If
    CreateNewKey sAppKeyName & "\DefaultIcon", &H80000000
    SetKeyValue sAppKeyName & "\DefaultIcon", "", sIconPath, &H1
Exit Sub
ErrorTrapper:
temperrmsg = MsgBox("Error number: " & Err.Number & Chr$(13) & "Error description: " & Err.Description & Chr$(13) & "Error source: mCreateAssociation.CreateAssociation (" & errcalled & ")", vbAbortRetryIgnore, "Error")
If temperrmsg = vbAbort Then End
If temperrmsg = vbRetry Then Resume
If temperrmsg = vbIgnore Then Resume Next
End
End Sub

Public Sub CreateSetAssociation(ByVal sExtension As String, ByVal sAppKeyName As String, ByVal sAppOpenPath As String, ByVal sFileTypeName As String, ByVal sIconPath As String, ByVal errcalled As String)
    On Error GoTo ErrorTrapper
    Dim sPath As String
    CreateNewKey sExtension, &H80000000
    SetKeyValue sExtension, "", sAppKeyName, &H1
    If sAppOpenPath <> "" Then
        CreateNewKey sAppKeyName & "\shell\Extract\command", &H80000000
        SetKeyValue sAppKeyName, "", sFileTypeName, &H1
        SetKeyValue sAppKeyName & "\shell\Extract\command", "", sAppOpenPath, &H1
    End If
    CreateNewKey sAppKeyName & "\DefaultIcon", &H80000000
    SetKeyValue sAppKeyName & "\DefaultIcon", "", sIconPath, &H1
Exit Sub
ErrorTrapper:
temperrmsg = MsgBox("Error number: " & Err.Number & Chr$(13) & "Error description: " & Err.Description & Chr$(13) & "Error source: mCreateAssociation.CreateAssociation (" & errcalled & ")", vbAbortRetryIgnore, "Error")
If temperrmsg = vbAbort Then End
If temperrmsg = vbRetry Then Resume
If temperrmsg = vbIgnore Then Resume Next
End
End Sub

Public Function SetValueEx(ByVal hKey As Long, sValueName As String, lType As Long, vValue As Variant) As Long
On Error GoTo ErrorTrapper
Dim nValue As Long
Dim sValue As String
Select Case lType
    Case &H1
        sValue = vValue & Chr$(0)
        SetValueEx = RegSetValueExString(hKey, sValueName, 0&, lType, sValue, Len(sValue))
    Case &H4
        nValue = vValue
        SetValueEx = RegSetValueExLong(hKey, sValueName, 0&, lType, nValue, 4)
End Select
Exit Function
ErrorTrapper:
temperrmsg = MsgBox("Error number: " & Err.Number & Chr$(13) & "Error description: " & Err.Description & Chr$(13) & "Error source: mCreateAssociation.SetValueEx", vbAbortRetryIgnore, "Error")
If temperrmsg = vbAbort Then End
If temperrmsg = vbRetry Then Resume
If temperrmsg = vbIgnore Then Resume Next
End
End Function

Public Sub CreateNewKey(sNewKeyName As String, lPredefinedKey As Long)
    On Error GoTo ErrorTrapper
    Dim hKey As Long
    Dim result As Long
    Call RegCreateKeyEx(lPredefinedKey, sNewKeyName, 0&, vbNullString, 0, &H3F, 0&, hKey, result)
    Call RegCloseKey(hKey)
Exit Sub
ErrorTrapper:
temperrmsg = MsgBox("Error number: " & Err.Number & Chr$(13) & "Error description: " & Err.Description & Chr$(13) & "Error source: mCreateAssociation.CreateNewKey", vbAbortRetryIgnore, "Error")
If temperrmsg = vbAbort Then End
If temperrmsg = vbRetry Then Resume
If temperrmsg = vbIgnore Then Resume Next
End
End Sub

Public Sub SetKeyValue(sKeyName As String, sValueName As String, vValueSetting As Variant, lValueType As Long)
    On Error GoTo ErrorTrapper
    Dim hKey As Long
    Call RegOpenKeyEx(&H80000000, sKeyName, 0, &H3F, hKey)
    Call SetValueEx(hKey, sValueName, lValueType, vValueSetting)
    Call RegCloseKey(hKey)
Exit Sub
ErrorTrapper:
temperrmsg = MsgBox("Error number: " & Err.Number & Chr$(13) & "Error description: " & Err.Description & Chr$(13) & "Error source: mCreateAssociation.SetKeyValue", vbAbortRetryIgnore, "Error")
If temperrmsg = vbAbort Then End
If temperrmsg = vbRetry Then Resume
If temperrmsg = vbIgnore Then Resume Next
End
End Sub

