Attribute VB_Name = "mShowOpenSave"
Public Const OFN_ALLOWMULTISELECT As Long = &H200
Public Const OFN_CREATEPROMPT As Long = &H2000
Public Const OFN_ENABLEHOOK As Long = &H20
Public Const OFN_ENABLETEMPLATE As Long = &H40
Public Const OFN_ENABLETEMPLATEHANDLE As Long = &H80
Public Const OFN_EXPLORER As Long = &H80000
Public Const OFN_EXTENSIONDIFFERENT As Long = &H400
Public Const OFN_FILEMUSTEXIST As Long = &H1000
Public Const OFN_HIDEREADONLY As Long = &H4
Public Const OFN_LONGNAMES As Long = &H200000
Public Const OFN_NOCHANGEDIR As Long = &H8
Public Const OFN_NODEREFERENCELINKS As Long = &H100000
Public Const OFN_NOLONGNAMES As Long = &H40000
Public Const OFN_NONETWORKBUTTON As Long = &H20000
Public Const OFN_NOREADONLYRETURN As Long = &H8000&
Public Const OFN_NOTESTFILECREATE As Long = &H10000
Public Const OFN_NOVALIDATE As Long = &H100
Public Const OFN_OVERWRITEPROMPT As Long = &H2
Public Const OFN_PATHMUSTEXIST As Long = &H800
Public Const OFN_READONLY As Long = &H1
Public Const OFN_SHAREAWARE As Long = &H4000
Public Const OFN_SHAREFALLTHROUGH As Long = 2
Public Const OFN_SHAREWARN As Long = 0
Public Const OFN_SHARENOWARN As Long = 1
Public Const OFN_SHOWHELP As Long = &H10
Public Const OFS_MAXPATHNAME As Long = 260
Public Const OFS_FILE_OPEN_FLAGS = OFN_EXPLORER Or OFN_LONGNAMES Or OFN_CREATEPROMPT Or OFN_NODEREFERENCELINKS
Public Const OFS_FILE_SAVE_FLAGS = OFN_EXPLORER Or OFN_LONGNAMES Or OFN_OVERWRITEPROMPT Or OFN_HIDEREADONLY

Public Type OPENFILENAME
    nStructSize As Long
    hWndOwner As Long
    hInstance As Long
    sFilter As String
    sCustomFilter As String
    nMaxCustFilter As Long
    nFilterIndex As Long
    sFile As String
    nMaxFile As Long
    sFileTitle As String
    nMaxTitle As Long
    sInitialDir As String
    sDialogTitle As String
    flags As Long
    nFileOffset As Integer
    nFileExtension As Integer
    sDefFileExt As String
    nCustData As Long
    fnHook As Long
    sTemplateName As String
End Type

Public Type CMNDLFILTER
    sName As String
    sType As String
End Type

Public Type CMNDLOPEN
    sPathFile As String
    sPath As String
    sFile As String
    sExtension As String
    s83File As String
    s83PathFile As String
    bReadOnly As Boolean
End Type

Public OFN As OPENFILENAME

Public Declare Function GetOpenFileName Lib "comdlg32.dll" Alias "GetOpenFileNameA" (pOpenfilename As OPENFILENAME) As Long
Public Declare Function GetSaveFileName Lib "comdlg32.dll" Alias "GetSaveFileNameA" (pOpenfilename As OPENFILENAME) As Long
Public Declare Function GetShortPathName Lib "kernel32" Alias "GetShortPathNameA" (ByVal lpszLongPath As String, ByVal lpszShortPath As String, ByVal cchBuffer As Long) As Long

Public Function ShowOpen(ByVal frmObject As Form, ByVal sDefaultFileName As String, sDefaultFolder As String, intFilterNum As Integer, fFilter() As CMNDLFILTER, ByVal intFilterIndex As Integer, ByVal sDefaultExt As String, ByVal sDialogTitle As String, ByVal lngFlags As Long) As CMNDLOPEN
On Error GoTo ErrorTrapper
Dim sFilters As String
Dim pos As Long
Dim buff As String
Dim sLongname As String
Dim sShortname As String
sFilters = ""
For a = 1 To intFilterNum
    sFilters = sFilters & fFilter(a).sName & vbNullChar & fFilter(a).sType & vbNullChar
Next a
With OFN
    .nStructSize = Len(OFN)
    .hWndOwner = frmObject.hWnd
    .sFilter = sFilters
    .nFilterIndex = intFilterIndex
    .sFile = sDefaultFileName & Space$(1024) & vbNullChar & vbNullChar
    .nMaxFile = Len(.sFile)
    .sDefFileExt = sDefaultExt & vbNullChar & vbNullChar
    .sFileTitle = vbNullChar & Space$(512) & vbNullChar & vbNullChar
    .nMaxTitle = Len(OFN.sFileTitle)
    .sInitialDir = sDefaultFolder & vbNullChar & vbNullChar
    .sDialogTitle = sDialogTitle
    .flags = lngFlags
End With
If GetOpenFileName(OFN) Then
    buff = Trim$(Left$(OFN.sFile, Len(OFN.sFile) - 2))
    ShowOpen.sPathFile = OFN.sFile
    ShowOpen.sPath = Left$(OFN.sFile, OFN.nFileOffset)
    ShowOpen.sFile = Mid$(OFN.sFile, OFN.nFileOffset + 1, Len(OFN.sFile) - OFN.nFileOffset - 1)
    ShowOpen.sExtension = Mid$(OFN.sFile, OFN.nFileExtension + 1, Len(OFN.sFile) - OFN.nFileExtension)
    sLongname = OFN.sFileTitle
    sShortname = Space$(128)
    pos = GetShortPathName(sLongname, sShortname, Len(sShortname))
    ShowOpen.s83File = LCase$(Left$(sShortname, pos))
    sLongname = OFN.sFile
    sShortname = Space$(128)
    pos = GetShortPathName(sLongname, sShortname, Len(sShortname))
    ShowOpen.s83PathFile = LCase$(Left$(sShortname, pos))
    If Abs((OFN.flags And OFN_READONLY)) = 1 Then
        ShowOpen.bReadOnly = True
    Else
        ShowOpen.bReadOnly = False
    End If
End If
Exit Function
ErrorTrapper:
temperrmsg = MsgBox("Error number: " & Err.Number & Chr$(13) & "Error description: " & Err.Description & Chr$(13) & "Error source: " & Err.Source, vbAbortRetryIgnore, "Error")
If temperrmsg = vbAbort Then End
If temperrmsg = vbRetry Then Resume
If temperrmsg = vbIgnore Then Resume Next
End
End Function

Private Function StripDelimitedItem(startStrg As String, delimiter As String) As String
On Error GoTo ErrorTrapper
Dim pos As Long
Dim item As String
pos = InStr(1, startStrg, delimiter)
If pos Then
    StripDelimitedItem = Mid$(startStrg, 1, pos)
    startStrg = Mid$(startStrg, pos + 1, Len(startStrg))
End If
Exit Function
ErrorTrapper:
temperrmsg = MsgBox("Error number: " & Err.Number & Chr$(13) & "Error description: " & Err.Description & Chr$(13) & "Error source: " & Err.Source, vbAbortRetryIgnore, "Error")
If temperrmsg = vbAbort Then End
If temperrmsg = vbRetry Then Resume
If temperrmsg = vbIgnore Then Resume Next
End
End Function

Private Function TrimNull(item As String) As String
On Error GoTo ErrorTrapper
Dim pos As Integer
pos = InStr(item, Chr$(0))
If pos Then
    TrimNull = Left$(item, pos - 1)
Else: TrimNull = item
End If
Exit Function
ErrorTrapper:
temperrmsg = MsgBox("Error number: " & Err.Number & Chr$(13) & "Error description: " & Err.Description & Chr$(13) & "Error source: " & Err.Source, vbAbortRetryIgnore, "Error")
If temperrmsg = vbAbort Then End
If temperrmsg = vbRetry Then Resume
If temperrmsg = vbIgnore Then Resume Next
End
End Function
