VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CommonDialog"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Calls the Common Dialog boxes Open File, Save File, Choose Color, and Choose Font."
Private Type OPENFILENAME
    nStructSize As Long
    hwndOwner As Long
    hInstance As Long
    sFilter As String
    sCustomFilter As String
    nMaxCustFilter As Long
    nFilterIndex As Long
    sFile As String
    nMaxFile As Long
    sFileTitle As String
    nMaxTitle As Long
    sInitialDir As String
    sDialogTitle As String
    Flags As Long
    nFileOffset As Integer
    nFileExtension As Integer
    sDefFileExt As String
    nCustData As Long
    fnHook As Long
    sTemplateName As String
End Type

Private Type CHOOSECOLOR_TYPE
    lStructSize As Long
    hwndOwner As Long
    hInstance As Long
    rgbResult As Long
    lpCustColors As Long
    Flags As Long
    lCustData As Long
    lpfnHook As Long
    lpTemplateName As String
End Type

Private Type CHOOSEFONT_TYPE
    lStructSize As Long
    hwndOwner As Long
    hDC As Long
    lpLogFont As Long
    iPointSize As Long
    Flags As Long
    rgbColors As Long
    lCustData As Long
    lpfnHook As Long
    lpTemplateName As String
    hInstance As Long
    lpszStyle As String
    nFontType As Integer
    MISSING_ALIGNMENT As Integer
    nSizeMin As Long
    nSizeMax As Long
End Type

Private Type LOGFONT
    lfHeight As Long
    lfWidth As Long
    lfEscapement As Long
    lfOrientation As Long
    lfWeight As Long
    lfItalic As Byte
    lfUnderline As Byte
    lfStrikeOut As Byte
    lfCharSet As Byte
    lfOutPrecision As Byte
    lfClipPrecision As Byte
    lfQuality As Byte
    lfPitchAndFamily As Byte
    lfFaceName As String * 32
End Type

Private Type TPRINTDLG
    lStructSize As Long
    hwndOwner As Long
    hDevMode As Long
    hDevNames As Long
    hDC As Long
    Flags As Long
    nFromPage As Integer
    nToPage As Integer
    nMinPage As Integer
    nMaxPage As Integer
    nCopies As Integer
    hInstance As Long
    lCustData As Long
    lpfnPrintHook As Long
    lpfnSetupHook As Long
    lpPrintTemplateName As String
    lpSetupTemplateName As String
    hPrintTemplate As Long
    hSetupTemplate As Long
End Type

Private OFN As OPENFILENAME

Private Declare Function GetOpenFileName Lib "comdlg32.dll" Alias "GetOpenFileNameA" (pOpenfilename As OPENFILENAME) As Long
Attribute GetOpenFileName.VB_Description = "Private API function to open the Open File dialog box"
Private Declare Function GetSaveFileName Lib "comdlg32.dll" Alias "GetSaveFileNameA" (pOpenfilename As OPENFILENAME) As Long
Attribute GetSaveFileName.VB_Description = "Private API function to open the Save File dialog box"
Private Declare Function GetShortPathName Lib "kernel32" Alias "GetShortPathNameA" (ByVal lpszLongPath As String, ByVal lpszShortPath As String, ByVal cchBuffer As Long) As Long
Attribute GetShortPathName.VB_Description = "Private API function to get the 8.3 path name of a file (ShowOpen and ShowSave)"
Private Declare Function ChooseColor Lib "comdlg32.dll" Alias "ChooseColorA" (lpcc As CHOOSECOLOR_TYPE) As Long
Attribute ChooseColor.VB_Description = "Private API function to open the Choose Color dialog box"
Private Declare Function ChooseFont Lib "comdlg32.dll" Alias "ChooseFontA" (lpcf As CHOOSEFONT_TYPE) As Long
Attribute ChooseFont.VB_Description = "Private API function to open the Choose Font dialog box"
Private Declare Function GlobalAlloc Lib "kernel32.dll" (ByVal wFlags As Long, ByVal dwBytes As Long) As Long
Attribute GlobalAlloc.VB_Description = "Private API function to allocate global memory (ShowColor)"
Private Declare Function GlobalLock Lib "kernel32.dll" (ByVal hMem As Long) As Long
Attribute GlobalLock.VB_Description = "Private API function to lock global memory (ShowColor)"
Private Declare Sub CopyMemory Lib "kernel32.dll" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal Length As Long)
Attribute CopyMemory.VB_Description = "Private API function to copy a memory segment (ShowColor)"
Private Declare Function GlobalUnlock Lib "kernel32.dll" (ByVal hMem As Long) As Long
Attribute GlobalUnlock.VB_Description = "Private API function to unlock global memory (ShowColor)"
Private Declare Function GlobalFree Lib "kernel32.dll" (ByVal hMem As Long) As Long
Attribute GlobalFree.VB_Description = "Private API function to free global memory (ShowColor)"
Private Declare Function PrintDlg Lib "comdlg32.dll" Alias "PrintDlgA" (pPrintdlg As TPRINTDLG) As Long

Private strPathFile As String
Private strPath As String
Private strFile As String
Private strExtension As String
Private str83File As String
Private str83PathFile As String
Private bReadOnly As Boolean
Private lngOSFlags As Long

Private lngColorFlags As Long

Private mstrFontName As String
Private mintFontSize As Integer
Private mbBold As Boolean
Private mbItalic As Boolean
Private mbStrikeThru As Boolean
Private mbUnderline As Boolean

Public Property Get CPAnyColor() As Boolean
Attribute CPAnyColor.VB_Description = "Allow the user to select any color."
CPAnyColor = lngColorFlags And &H100
End Property

Public Property Let CPAnyColor(ByVal blnValue As Boolean)
If blnValue = True Then
    lngOSFlags = lngOSFlags Or &H100
Else
    If lngOSFlags And &H100 <> 0 Then lngOSFlags = lngOSFlags - &H100
End If
End Property

Public Property Get CPFullOpen() As Boolean
Attribute CPFullOpen.VB_Description = "Automatically display the Define Custom Colors half of the dialog box."
CPFullOpen = lngColorFlags And &H2
End Property

Public Property Let CPFullOpen(ByVal blnValue As Boolean)
If blnValue = True Then
    lngOSFlags = lngOSFlags Or &H2
Else
    If lngOSFlags And &H2 <> 0 Then lngOSFlags = lngOSFlags - &H2
End If
End Property

Public Property Get CPDisableFullOpen() As Boolean
Attribute CPDisableFullOpen.VB_Description = "Disable the button that displays the Define Custom Colors half of the dialog box."
CPDisableFullOpen = lngColorFlags And &H4
End Property

Public Property Let CPDisableFullOpen(ByVal blnValue As Boolean)
If blnValue = True Then
    lngOSFlags = lngOSFlags Or &H4
Else
    If lngOSFlags And &H4 <> 0 Then lngOSFlags = lngOSFlags - &H4
End If
End Property

Public Property Get CPSolidColorsOnly() As Boolean
Attribute CPSolidColorsOnly.VB_Description = "Only allow the user to select solid colors. If the user attempts to select a non-solid color, convert it to the closest solid color.\r\n"
CPSolidColorsOnly = lngColorFlags And &H80
End Property

Public Property Let CPSolidColorsOnly(ByVal blnValue As Boolean)
If blnValue = True Then
    lngOSFlags = lngOSFlags Or &H80
Else
    If lngOSFlags And &H80 <> 0 Then lngOSFlags = lngOSFlags - &H80
End If
End Property

Public Property Get FontName() As String
Attribute FontName.VB_Description = "The selected font name."
FontName = mstrFontName
End Property

Public Property Get FontSize() As Integer
Attribute FontSize.VB_Description = "The selected font size."
FontSize = mintFontSize
End Property

Public Property Get FontBold() As Boolean
Attribute FontBold.VB_Description = "The selected bold setting."
FontBold = mbBold
End Property

Public Property Get FontItalic() As Boolean
Attribute FontItalic.VB_Description = "The selected italic setting."
FontItalic = mbItalic
End Property

Public Property Get FontStrikeThru() As Boolean
Attribute FontStrikeThru.VB_Description = "The selected strikethru setting."
FontStrikeThru = mbStrikeThru
End Property

Public Property Get FontUnderline() As Boolean
Attribute FontUnderline.VB_Description = "The selected underline setting."
FontUnderline = mbUnderline
End Property

Public Property Get OSRPathFile() As String
Attribute OSRPathFile.VB_Description = "The path name, file name, and extension of the selected file."
OSRPathFile = strPathFile
End Property

Public Property Get OSRPath() As String
Attribute OSRPath.VB_Description = "The path name only of the selected file."
OSRPath = strPath
End Property

Public Property Get OSRFile() As String
Attribute OSRFile.VB_Description = "The file name and extension only of the selected file."
OSRFile = strFile
End Property

Public Property Get OSRExtension() As String
Attribute OSRExtension.VB_Description = "The extension only of the selected file."
OSRExtension = strExtension
End Property

Public Property Get OSR83File() As String
Attribute OSR83File.VB_Description = "The 8.3 file name and extension only of the selected file."
OSR83File = str83File
End Property

Public Property Get OSR83PathFile() As String
Attribute OSR83PathFile.VB_Description = "The 8.3 path name, file name, and extension of the selected file."
OSR83PathFile = str83PathFile
End Property

Public Property Get OSRReadOnly() As Boolean
Attribute OSRReadOnly.VB_Description = "The read-only attribute of the selected file."
OSRReadOnly = bReadOnly
End Property

Public Property Get OSPPromptCreateIfNotExists() As Boolean
Attribute OSPPromptCreateIfNotExists.VB_Description = "Prompt if a non-existing file is chosen."
OSPPromptCreateIfNotExists = lngOSFlags And &H2000
End Property

Public Property Let OSPPromptCreateIfNotExists(ByVal blnValue As Boolean)
If blnValue = True Then
    lngOSFlags = lngOSFlags Or &H2000
Else
    If lngOSFlags And &H2000 <> 0 Then lngOSFlags = lngOSFlags - &H2000
End If
End Property

Public Property Get OSPFileMustExist() As Boolean
Attribute OSPFileMustExist.VB_Description = "Only allow the selection of existing files."
OSPFileMustExist = lngOSFlags And &H1000
End Property

Public Property Let OSPFileMustExist(ByVal blnValue As Boolean)
If blnValue = True Then
    lngOSFlags = lngOSFlags Or &H1000
Else
    If lngOSFlags And &H1000 <> 0 Then lngOSFlags = lngOSFlags - &H1000
End If
End Property

Public Property Get OSPHideReadOnly() As Boolean
Attribute OSPHideReadOnly.VB_Description = "Hide the Open As Read Only check box."
OSPHideReadOnly = lngOSFlags And &H4
End Property

Public Property Let OSPHideReadOnly(ByVal blnValue As Boolean)
If blnValue = True Then
    lngOSFlags = lngOSFlags Or &H4
Else
    If lngOSFlags And &H4 <> 0 Then lngOSFlags = lngOSFlags - &H4
End If
End Property

Public Property Get OSPPreserveCurrentDirectory() As Boolean
Attribute OSPPreserveCurrentDirectory.VB_Description = "Don't change Windows's current directory to match the one chosen in the dialog box."
OSPPreserveCurrentDirectory = lngOSFlags And &H8
End Property

Public Property Let OSPPreserveCurrentDirectory(ByVal blnValue As Boolean)
If blnValue = True Then
    lngOSFlags = lngOSFlags Or &H8
Else
    If lngOSFlags And &H8 <> 0 Then lngOSFlags = lngOSFlags - &H8
End If
End Property

Public Property Get OSPReturnShortcutFile() As Boolean
Attribute OSPReturnShortcutFile.VB_Description = "If a shortcut file (.lnk or .pif) is chosen, return the shortcut file itself instead of the file or directory it points to."
OSPReturnShortcutFile = lngOSFlags And &H100000
End Property

Public Property Let OSPReturnShortcutFile(ByVal blnValue As Boolean)
If blnValue = True Then
    lngOSFlags = lngOSFlags Or &H100000
Else
    If lngOSFlags And &H100000 <> 0 Then lngOSFlags = lngOSFlags - &H100000
End If
End Property

Public Property Get OSPHideNetworkButton() As Boolean
Attribute OSPHideNetworkButton.VB_Description = "Hide and disable the Network button in the dialog box."
OSPHideNetworkButton = lngOSFlags And &H20000
End Property

Public Property Let OSPHideNetworkButton(ByVal blnValue As Boolean)
If blnValue = True Then
    lngOSFlags = lngOSFlags Or &H20000
Else
    If lngOSFlags And &H20000 <> 0 Then lngOSFlags = lngOSFlags - &H20000
End If
End Property

Public Property Get OSPNoTestFile() As Boolean
Attribute OSPNoTestFile.VB_Description = "Do not create a test file before the box closes. Normally, this check is done to verify that the disk exists, that there is sufficient disk space, etc. However, this check should not be used on a create-nonmodify network share. Setting this flag to True "
OSPNoTestFile = lngOSFlags And &H10000
End Property

Public Property Let OSPNoTestFile(ByVal blnValue As Boolean)
If blnValue = True Then
    lngOSFlags = lngOSFlags Or &H10000
Else
    If lngOSFlags And &H10000 <> 0 Then lngOSFlags = lngOSFlags - &H10000
End If
End Property

Public Property Get OSPNoValidate() As Boolean
Attribute OSPNoValidate.VB_Description = "Don't check the filename for invalid characters."
OSPNoValidate = lngOSFlags And &H100
End Property

Public Property Let OSPNoValidate(ByVal blnValue As Boolean)
If blnValue = True Then
    lngOSFlags = lngOSFlags Or &H100
Else
    If lngOSFlags And &H100 <> 0 Then lngOSFlags = lngOSFlags - &H100
End If
End Property

Public Property Get OSPPromptIfExists() As Boolean
Attribute OSPPromptIfExists.VB_Description = "Prompt the user if the chosen file already exists."
OSPPromptIfExists = lngOSFlags And &H2
End Property

Public Property Let OSPPromptIfExists(ByVal blnValue As Boolean)
If blnValue = True Then
    lngOSFlags = lngOSFlags Or &H2
Else
    If lngOSFlags And &H2 <> 0 Then lngOSFlags = lngOSFlags - &H2
End If
End Property

Public Property Get OSPPathMustExist() As Boolean
Attribute OSPPathMustExist.VB_Description = "Only allow the selection of existing paths."
OSPPathMustExist = lngOSFlags And &H800
End Property

Public Property Let OSPPathMustExist(ByVal blnValue As Boolean)
If blnValue = True Then
    lngOSFlags = lngOSFlags Or &H800
Else
    If lngOSFlags And &H800 <> 0 Then lngOSFlags = lngOSFlags - &H800
End If
End Property

Public Property Get OSPCheckReadOnly() As Boolean
Attribute OSPCheckReadOnly.VB_Description = "Check the Open As Read Only box."
OSPCheckReadOnly = lngOSFlags And &H1
End Property

Public Property Let OSPCheckReadOnly(ByVal blnValue As Boolean)
If blnValue = True Then
    lngOSFlags = lngOSFlags Or &H1
Else
    If lngOSFlags And &H1 <> 0 Then lngOSFlags = lngOSFlags - &H1
End If
End Property

Public Property Get OSPIgnoreSharing() As Boolean
Attribute OSPIgnoreSharing.VB_Description = "Ignore any file sharing violations."
OSPIgnoreSharing = lngOSFlags And &H4000
End Property

Public Property Let OSPIgnoreSharing(ByVal blnValue As Boolean)
If blnValue = True Then
    lngOSFlags = lngOSFlags Or &H4000
Else
    If lngOSFlags And &H4000 <> 0 Then lngOSFlags = lngOSFlags - &H4000
End If
End Property

Public Function ShowOpen(ByVal frmObject As Form, ByVal strDefaultFileName As String, strDefaultFolder As String, strFilterNames() As String, strFilterTypes() As String, ByVal intFilterIndex As Integer, ByVal strDefaultExt As String, ByVal strDialogTitle As String, ByVal blnMulti As Boolean) As Boolean
Attribute ShowOpen.VB_Description = "Shows the Open File dialog box."
Dim sFilters As String
Dim pos As Long
Dim buff As String
Dim sLongname As String
Dim sShortname As String
sFilters = ""
If LBound(strFilterNames) <> LBound(strFilterTypes) Or UBound(strFilterNames) <> UBound(strFilterTypes) Then
    Err.Raise 1000, "ShowOpen", "The boundaries and sizes of the Filter arrays must be the same."
    Exit Function
End If
For a = LBound(strFilterNames) To UBound(strFilterNames)
    sFilters = sFilters & strFilterNames(a) & vbNullChar & strFilterTypes(a) & vbNullChar
Next a
With OFN
    .nStructSize = Len(OFN)
    .hwndOwner = frmObject.hwnd
    .sFilter = sFilters
    .nFilterIndex = intFilterIndex
    .sFile = strDefaultFileName & Space$(1024) & vbNullChar & vbNullChar
    .nMaxFile = Len(.sFile)
    .sDefFileExt = strDefaultExt & vbNullChar & vbNullChar
    .sFileTitle = vbNullChar & Space$(512) & vbNullChar & vbNullChar
    .nMaxTitle = Len(OFN.sFileTitle)
    .sInitialDir = strDefaultFolder & vbNullChar & vbNullChar
    .sDialogTitle = strDialogTitle
    .Flags = lngOSFlags
    If blnMulti = True Then .Flags = .Flags Or &H200
End With
If GetOpenFileName(OFN) Then
    buff = Trim$(Left$(OFN.sFile, Len(OFN.sFile) - 2))
    strPathFile = TrimNull(OFN.sFile)
    strPath = TrimNull(Left$(OFN.sFile, OFN.nFileOffset))
    If blnMulti = True Then
        If Right$(strPath, 1) = " " Then strPath = Left$(strPath, Len(strPath) - 1)
    End If
    strFile = TrimNull(Mid$(OFN.sFile, OFN.nFileOffset + 1, Len(OFN.sFile) - OFN.nFileOffset - 1))
    If blnMulti = False Then
        strExtension = TrimNull(Mid$(OFN.sFile, OFN.nFileExtension + 1, Len(OFN.sFile) - OFN.nFileExtension))
        sLongname = TrimNull(OFN.sFile)
        sShortname = Space$(128)
        pos = GetShortPathName(sLongname, sShortname, 256)
        str83PathFile = LCase$(Left$(sShortname, pos))
        For a = 1 To Len(str83PathFile)
            If InStr(Right$(str83PathFile, a), "\") Then Exit For
        Next a
        str83File = Right$(str83PathFile, a - 1)
        If Abs((OFN.Flags And &H1)) = 1 Then
            bReadOnly = True
        Else
            bReadOnly = False
        End If
    Else
        strExtension = ""
        str83PathFile = ""
        str83File = ""
        bReadOnly = False
    End If
    ShowOpen = True
Else
    strPathFile = "Error"
    strPath = "Error"
    strFile = "Error"
    strExtension = "Error"
    str83File = "Error"
    str83PathFile = "Error"
    bReadOnly = False
    ShowOpen = False
End If
End Function

Public Function ShowPrint(ByVal frmObject As Form) As Boolean
Dim printprop As TPRINTDLG
With printprop
    .Flags = &H4 + &H8 + &H100000 + &H200000
    .hDC = frmObject.hDC
    .hInstance = App.hInstance
    .hwndOwner = frmObject.hwnd
    .lStructSize = Len(printprop)
End With
If PrintDlg(printprop) <> 1 Then ShowPrint = False Else ShowPrint = True
End Function

Public Function ShowPrintSetup(ByVal frmObject As Form) As Boolean
Dim printprop As TPRINTDLG
With printprop
    .Flags = &H40
    .hDC = frmObject.hDC
    .hInstance = App.hInstance
    .hwndOwner = frmObject.hwnd
    .lStructSize = Len(printprop)
End With
If PrintDlg(printprop) <> 1 Then ShowPrintSetup = False Else ShowPrintSetup = True
End Function

Public Function ShowSave(ByVal frmObject As Form, ByVal strDefaultFileName As String, ByVal strDefaultFolder As String, strFilterNames() As String, strFilterTypes() As String, ByVal intFilterIndex As Integer, ByVal strDefaultExt As String, ByVal strDialogTitle As String) As Boolean
Attribute ShowSave.VB_Description = "Shows the Save File dialog box."
Dim sFilters As String
Dim pos As Long
Dim buff As String
Dim sLongname As String
Dim sShortname As String
sFilters = ""
If LBound(strFilterNames) <> LBound(strFilterTypes) Or UBound(strFilterNames) <> UBound(strFilterTypes) Then
    Err.Raise 1000, "ShowSave", "The boundaries and sizes of the Filter arrays must be the same."
    Exit Function
End If
For a = LBound(strFilterNames) To UBound(strFilterNames)
    sFilters = sFilters & strFilterNames(a) & vbNullChar & strFilterTypes(a) & vbNullChar
Next a
With OFN
    .nStructSize = Len(OFN)
    .hwndOwner = frmObject.hwnd
    .sFilter = sFilters
    .nFilterIndex = intFilterIndex
    .sFile = strDefaultFileName & Space$(1024) & vbNullChar & vbNullChar
    .nMaxFile = Len(.sFile)
    .sDefFileExt = strDefaultExt & vbNullChar & vbNullChar
    .sFileTitle = vbNullChar & Space$(512) & vbNullChar & vbNullChar
    .nMaxTitle = Len(OFN.sFileTitle)
    .sInitialDir = strDefaultFolder & vbNullChar & vbNullChar
    .sDialogTitle = strDialogTitle
    .Flags = lngOSFlags
End With
If GetSaveFileName(OFN) Then
    buff = Trim$(Left$(OFN.sFile, Len(OFN.sFile) - 2))
    strPathFile = TrimNull(OFN.sFile)
    strPath = TrimNull(Left$(OFN.sFile, OFN.nFileOffset))
    strFile = TrimNull(Mid$(OFN.sFile, OFN.nFileOffset + 1, Len(OFN.sFile) - OFN.nFileOffset - 1))
    strExtension = TrimNull(Mid$(OFN.sFile, OFN.nFileExtension + 1, Len(OFN.sFile) - OFN.nFileExtension))
    sLongname = TrimNull(OFN.sFile)
    sShortname = Space$(128)
    pos = GetShortPathName(sLongname, sShortname, 256)
    str83PathFile = LCase$(Left$(sShortname, pos))
    For a = 1 To Len(str83PathFile)
        If InStr(Right$(str83PathFile, a), "\") Then Exit For
    Next a
    str83File = Right$(str83PathFile, a - 1)
    If Abs((OFN.Flags And &H1)) = 1 Then
        bReadOnly = True
    Else
        bReadOnly = False
    End If
    ShowSave = True
Else
    strPathFile = "Error"
    strPath = "Error"
    strFile = "Error"
    strExtension = "Error"
    str83File = "Error"
    str83PathFile = "Error"
    bReadOnly = False
    ShowSave = False
End If
End Function

Private Function StripDelimitedItem(startStrg As String, delimiter As String) As String
Attribute StripDelimitedItem.VB_Description = "Private routine to strip delimited items"
Dim pos As Long
Dim item As String
pos = InStr(1, startStrg, delimiter)
If pos Then
    StripDelimitedItem = Mid$(startStrg, 1, pos)
    startStrg = Mid$(startStrg, pos + 1, Len(startStrg))
End If
End Function

Private Function TrimNull(item As String) As String
Attribute TrimNull.VB_Description = "Private routine to remove null characters"
Dim pos As Integer
pos = InStr(item, Chr$(0))
If pos Then
    TrimNull = Left$(item, pos - 1)
Else: TrimNull = item
End If
End Function

Public Function ShowColor(ByVal frmObject As Form, Optional lngRGBInit As Long) As Long
Attribute ShowColor.VB_Description = "Shows the Choose Color dialog box."
    Dim cc As CHOOSECOLOR_TYPE
    Dim hMem As Long
    Dim pMem As Long
    Dim custcols(0 To 15) As Long
    Dim c As Integer
    Dim retval As Long
    Const GMEM_MOVEABLE = &H2
    Const GMEM_ZEROINIT = &H40
    Const CC_RGBINIT = &H1
    For c = 0 To 15
        custcols(c) = 0
    Next c
    hMem = GlobalAlloc(GMEM_MOVEABLE Or GMEM_ZEROINIT, 64)
    pMem = GlobalLock(hMem)
    CopyMemory ByVal pMem, custcols(0), 64
    cc.lStructSize = Len(cc)
    cc.hwndOwner = frmObject.hwnd
    cc.hInstance = 0
    cc.rgbResult = lngRGBInit
    cc.lpCustColors = pMem
    cc.Flags = CC_RGBINIT Or lngColorFlags
    cc.lCustData = 0
    cc.lpfnHook = 0
    cc.lpTemplateName = ""
    retval = ChooseColor(cc)
    If retval <> 0 Then
        CopyMemory custcols(0), ByVal pMem, 64
        ShowColor = cc.rgbResult
    Else
        ShowColor = -1
    End If
    retval = GlobalUnlock(hMem)
    retval = GlobalFree(pMem)
End Function

Public Function ShowFont(ByVal frmObject As Form, strDefaultFontName As String, intDefaultFontSize As Integer, bBold As Boolean, bItalic As Boolean, bUnderline As Boolean, bStrikeThru As Boolean) As Boolean
Attribute ShowFont.VB_Description = "Shows the Choose Font dialog box."
    Dim cf As CHOOSEFONT_TYPE
    Dim lfont As LOGFONT
    Dim hMem As Long, pMem As Long
    Dim FontName As String
    Dim retval As Long
    Const FW_BOLD = 700
    Const FW_NORMAL = 400
    Const DEFAULT_CHARSET = 1
    Const OUT_DEFAULT_PRECIS = 0
    Const CLIP_DEFAULT_PRECIS = 0
    Const DEFAULT_QUALITY = 0
    Const DEFAULT_PITCH = 0
    Const FF_ROMAN = 16
    Const CF_BOTH = &H3
    Const CF_EFFECTS = &H100
    Const CF_FORCEFONTEXIST = &H10000
    Const CF_INITTOLOGFONTSTRUCT = &H40
    Const CF_LIMITSIZE = &H2000
    Const REGULAR_FONTTYPE = &H400
    lfont.lfHeight = 0
    lfont.lfWidth = 0
    lfont.lfEscapement = 0
    lfont.lfOrientation = 0
    If bBold = True Then
        lfont.lfWeight = FW_BOLD
    Else
        lfont.lfWeight = FW_NORMAL
    End If
    If bItalic = True Then
        lfont.lfItalic = 1
    Else
        lfont.lfItalic = 0
    End If
    If bUnderline = True Then
        lfont.lfUnderline = 1
    Else
        lfont.lfUnderline = 0
    End If
    If bStrikeThru = True Then
        lfont.lfStrikeOut = 1
    Else
        lfont.lfStrikeOut = 0
    End If
    lfont.lfCharSet = DEFAULT_CHARSET
    lfont.lfOutPrecision = OUT_DEFAULT_PRECIS
    lfont.lfClipPrecision = CLIP_DEFAULT_PRECIS
    lfont.lfQuality = DEFAULT_QUALITY
    lfont.lfPitchAndFamily = DEFAULT_PITCH Or FF_ROMAN
    lfont.lfFaceName = strDefaultFontName & vbNullChar
    hMem = GlobalAlloc(GMEM_MOVEABLE Or GMEM_ZEROINIT, Len(lfont))
    pMem = GlobalLock(hMem)
    CopyMemory ByVal pMem, lfont, Len(lfont)
    cf.lStructSize = Len(cf)
    cf.hwndOwner = frmObject.hwnd
    cf.hDC = Printer.hDC
    cf.lpLogFont = pMem
    cf.iPointSize = 10 * intDefaultFontSize
    cf.Flags = CF_BOTH Or CF_EFFECTS Or CF_FORCEFONTEXIST Or CF_INITTOLOGFONTSTRUCT Or CF_LIMITSIZE
    cf.rgbColors = 0
    cf.lCustData = 0
    cf.lpfnHook = 0
    cf.lpTemplateName = ""
    cf.hInstance = 0
    cf.lpszStyle = ""
    cf.nFontType = REGULAR_FONTTYPE
    cf.nSizeMin = 1
    cf.nSizeMax = 255
    retval = ChooseFont(cf)
    If retval <> 0 Then
        CopyMemory lfont, ByVal pMem, Len(lfont)
        mstrFontName = Left(lfont.lfFaceName, InStr(lfont.lfFaceName, vbNullChar) - 1)
        mintFontSize = cf.iPointSize / 10
        If lfont.lfWeight >= FW_BOLD Then mbBold = True Else mbBold = False
        If lfont.lfItalic <> 0 Then mbItalic = True Else mbItalic = False
        If lfont.lfUnderline <> 0 Then mbUnderline = True Else mbUnderline = False
        If lfont.lfStrikeOut <> 0 Then mbStrikeThru = True Else mbStrikeThru = False
        ShowFont = True
    Else
        mstrFontName = "Error"
        mintFontSize = 0
        mbBold = False
        mbItalic = False
        mbStrikeThru = False
        mbUnderline = False
        ShowFont = False
    End If
    retval = GlobalUnlock(hMem)
    retval = GlobalFree(hMem)
End Function

