Attribute VB_Name = "mMain"
Public dblSitups As Double
Public dblPullups As Double
Public dblPushups As Double
Public dblRunSecs As Double
Public dblJumpInches As Double
Public geGender As GenderEnum
Public quitprog As Boolean

Public Enum TestTypeEnum
    tteSitups
    ttePullups
    ttePushups
    tteRun
    tteJump
End Enum

Public Enum GenderEnum
    geMale = 0
    geFemale = 1
End Enum

Public Function GetScore(ByVal tteTestType As TestTypeEnum, ByVal dblValue As Double) As Long
Select Case tteTestType
    Case tteSitups
        tablefilename = "situps_"
    Case ttePullups
        tablefilename = "pullups_"
    Case ttePushups
        tablefilename = "pushups_"
    Case tteRun
        tablefilename = "run_"
    Case tteJump
        tablefilename = "longjump_"
    Case Else
        GetScore = -1
        Exit Function
End Select
If Right$(App.Path, 1) = "\" Then
    tablefilename = App.Path & "tempchart\" & tablefilename
Else
    tablefilename = App.Path & "\tempchart\" & tablefilename
End If
tablefilename = tablefilename & IIf(geGender = geMale, "m", "f") & ".dat"
Close #1
Open tablefilename For Input As #1
Line Input #1, tabletitle
Line Input #1, unitname
lastvalue = 0
While EOF(1) = False
    Input #1, rangebottom
    Input #1, rangetop
    Input #1, pointvalue
    If tteTestType = tteRun Then
        If dblValue <= rangetop Then
            GetScore = pointvalue
            Close #1
            Exit Function
        End If
    Else
        If dblValue < rangebottom Then
            GetScore = lastvalue
            Close #1
            Exit Function
        End If
        lastvalue = pointvalue
    End If
    If rangetop = -1 Then
        GetScore = pointvalue
        Close #1
        Exit Function
    End If
Wend
Close #1
GetScore = -1
End Function

Public Sub DumpInfo(ByVal tteTestType As TestTypeEnum, ByVal geGenderChart As GenderEnum, ByVal txtTextBox As TextBox, Optional ByVal lngRecPerTest As Long, Optional ByVal lblRecUnit As Label)
Select Case tteTestType
    Case tteSitups
        tablefilename = "situps_"
        testname = "Sit-Ups"
    Case ttePullups
        tablefilename = "pullups_"
        testname = "Pull-Ups"
    Case ttePushups
        tablefilename = "pushups_"
        testname = "Push-Ups"
    Case tteRun
        tablefilename = "run_"
        testname = "Run"
    Case tteJump
        tablefilename = "longjump_"
        testname = "Standing Long Jump"
    Case Else
        Exit Sub
End Select
If Right$(App.Path, 1) = "\" Then
    tablefilename = App.Path & "tempchart\" & tablefilename
Else
    tablefilename = App.Path & "\tempchart\" & tablefilename
End If
tablefilename = tablefilename & IIf(geGenderChart = geMale, "m", "f") & ".dat"
Close #1
Open tablefilename For Input As #1
Line Input #1, tabletitle
txtTextBox.Text = tabletitle & vbCrLf
Line Input #1, unitname
unitname = Left$(unitname, 13)
txtTextBox.Text = txtTextBox.Text & unitname & Space$(15 - Len(unitname)) & "Points" & vbCrLf
lastbottom = 0
foundrec = False
While EOF(1) = False
    Input #1, rangebottom
    Input #1, rangetop
    Input #1, pointvalue
    If pointvalue <> 0 Then
        If rangebottom = rangetop Then
            txtTextBox.Text = txtTextBox.Text & CStr(rangebottom) & Space$(15 - Len(CStr(rangebottom))) & CStr(pointvalue) & vbCrLf
        ElseIf rangetop = -1 Then
            txtTextBox.Text = txtTextBox.Text & CStr(rangebottom) & " & up" & Space$(10 - Len(CStr(rangebottom))) & CStr(pointvalue) & vbCrLf
        ElseIf rangebottom = 0 Then
            txtTextBox.Text = txtTextBox.Text & CStr(rangetop) & " & lower" & Space$(7 - Len(CStr(rangetop))) & CStr(pointvalue) & vbCrLf
        Else
            txtTextBox.Text = txtTextBox.Text & CStr(rangebottom) & "-" & CStr(rangetop) & Space$(14 - (Len(CStr(rangebottom)) + Len(CStr(rangetop)))) & CStr(pointvalue) & vbCrLf
        End If
    End If
    If testname = "Run" Then
        If pointvalue < lngRecPerTest And foundrec = False Then
            lblRecUnit.Caption = Replace(Replace("Recommended UNITS For TEST: ", "UNITS", unitname), "TEST", testname) & CStr(lastbottom)
            foundrec = True
        End If
    Else
        If pointvalue >= lngRecPerTest And foundrec = False Then
            lblRecUnit.Caption = Replace(Replace("Recommended UNITS For TEST: ", "UNITS", unitname), "TEST", testname) & CStr(rangebottom)
            foundrec = True
        End If
    End If
    lastbottom = rangebottom
Wend
If foundrec = False Then
    lblRecUnit.Caption = Replace(Replace("Recommended UNITS For TEST: ", "UNITS", unitname), "TEST", testname) & CStr(rangebottom)
End If
Close #1
End Sub

Public Sub CheckCharts()
Dim chartlist(1 To 11) As String
Dim chartfound(1 To 11) As Boolean
chartlist(1) = "situps_m.dat"
chartlist(2) = "situps_f.dat"
chartlist(3) = "pullups_m.dat"
chartlist(4) = "pullups_f.dat"
chartlist(5) = "pushups_m.dat"
chartlist(6) = "pushups_f.dat"
chartlist(7) = "run_m.dat"
chartlist(8) = "run_f.dat"
chartlist(9) = "longjump_m.dat"
chartlist(10) = "longjump_f.dat"
chartlist(11) = "charts.lst"
tempapp = App.Path
If Right$(tempapp, 1) <> "\" Then tempapp = tempapp & "\"
tempapp = tempapp & "tempchart\"
numfound = 0
On Error Resume Next
For a = 1 To 11
    Close #1
    Open tempapp & chartlist(a) For Input As #1
    If Err Then
        chartfound(a) = False
    Else
        chartfound(a) = True
        numfound = numfound + 1
    End If
    Close #1
    Err.Clear
Next a
If numfound < 11 Then
    MsgBox "Your 'charts.jfc' file, which contains the charts, is corrupted." & vbCrLf & "You need to get a new copy of this file before you can use this program.", vbOKOnly + vbCritical, "Corrupt File"
    Suicide
End If
End Sub

Public Sub Suicide()
Reset
If Right$(App.Path, 1) <> "\" Then temppath = App.Path & "\" Else temppath = App.Path
On Error Resume Next
Kill temppath & "tempchart\*.*"
RmDir temppath & "tempchart"
End
End Sub
