using System;
using System.Text;
using System.IO;
using System.Net.Sockets;
using System.Net;
using System.Net.Mail;
namespace SMTP
{
	/// <summary>
	/// provides methods to send email via smtp direct to mail server
	/// </summary>
	public class SmtpDirect
	{
		/// <summary>
		/// Get / Set the name of the SMTP mail server
		/// </summary>
		public static string SmtpServer;
		private enum SMTPResponse: int
		{
			CONNECT_SUCCESS = 220,
			GENERIC_SUCCESS = 250,
			DATA_SUCCESS	= 354,
			QUIT_SUCCESS	= 221,
            AUTH_SUCCESS    = 235
    		
		}
		public static bool Send(MailMessage message)
		{
			IPHostEntry IPhst = Dns.GetHostEntry(SmtpServer);
			IPEndPoint endPt = new IPEndPoint(IPhst.AddressList[0], 25);
			Socket s= new Socket(endPt.AddressFamily, SocketType.Stream,ProtocolType.Tcp);
			s.Connect(endPt);
    		
			if(!Check_Response(s, SMTPResponse.CONNECT_SUCCESS))
			{				
				s.Close();
				return false;
			}
    			
			Senddata(s, string.Format("EHLO {0}\r\n", Dns.GetHostName() ));
			if(!Check_Response(s, SMTPResponse.GENERIC_SUCCESS))
			{
				s.Close();
				return false;
			}

            Senddata( s, "AUTH PLAIN amZzb2Z0d2EAamZzb2Z0d2EAY3BzYzIwMDg=\r\n" );
            if(!Check_Response( s, SMTPResponse.AUTH_SUCCESS ))
            {
                s.Close();
                return false;
            }

			Senddata(s, string.Format("MAIL From: {0}\r\n", message.From ));
			if(!Check_Response(s, SMTPResponse.GENERIC_SUCCESS))
			{
				
				s.Close();
				return false;
			}

            string _To = message.To.ToString();
			string[] Tos= _To.Split(new char[] {';'});
			foreach (string To in Tos)
			{
				Senddata(s, string.Format("RCPT TO: {0}\r\n", To));
				if(!Check_Response(s, SMTPResponse.GENERIC_SUCCESS))
				{
					
					s.Close();
					return false;
				}
			}
    			
			if(message.CC.Count > 0)
			{
				Tos= message.CC.ToString().Split(new char[] {';'});
				foreach (string To in Tos)
				{
					Senddata(s, string.Format("RCPT TO: {0}\r\n", To));
					if(!Check_Response(s, SMTPResponse.GENERIC_SUCCESS))
					{					
						s.Close();
						return false;
					}
				}
			}
    			
			StringBuilder Header=new StringBuilder();
			Header.Append("From: " + message.From + "\r\n");
			Tos= message.To.ToString().Split(new char[] {';'});
			Header.Append("To: ");
			for( int i=0; i< Tos.Length; i++)
			{
				Header.Append( i > 0 ? "," : "" );
				Header.Append(Tos[i]);
			}
			Header.Append("\r\n");
			if(message.CC.Count > 0)
			{
				Tos= message.CC.ToString().Split(new char[] {';'});
				Header.Append("Cc: ");
				for( int i=0; i< Tos.Length; i++)
				{
					Header.Append( i > 0 ? "," : "" );
					Header.Append(Tos[i]);
				}
				Header.Append("\r\n");
			}
			Header.Append( "Date: " );
			Header.Append(DateTime.Now.ToString("ddd, d M y H:m:s z" ));
			Header.Append("\r\n");
			Header.Append("Subject: " + message.Subject+ "\r\n");
			Header.Append( "X-Mailer: SMTPDirect v1\r\n" );
			string MsgBody = message.Body;
			if(!MsgBody.EndsWith("\r\n"))
				MsgBody+="\r\n";
    			
			Senddata(s, ("DATA\r\n"));
			if(!Check_Response(s, SMTPResponse.DATA_SUCCESS))
			{
				
				s.Close();
				return false;
			}
			Header.Append( "\r\n" );
			Header.Append( MsgBody );
			Header.Append( ".\r\n" );
			Header.Append( "\r\n" );
			Header.Append( "\r\n" );
			Senddata(s, Header.ToString());
			if(!Check_Response(s, SMTPResponse.GENERIC_SUCCESS ))
			{
				
				s.Close();
				return false;
			}			
    			
			Senddata(s, "QUIT\r\n");
			Check_Response(s, SMTPResponse.QUIT_SUCCESS );
			s.Close();    			
			return true;
		}
		private static void Senddata(Socket s, string msg)
		{
			
			byte[] _msg = Encoding.ASCII.GetBytes(msg);
			s.Send(_msg , 0, _msg .Length, SocketFlags.None);
		}
		private static bool Check_Response(Socket s, SMTPResponse response_expected )
		{
			string sResponse;
			int response;
			byte[] bytes = new byte[1024];
			while (s.Available==0)
			{
				System.Threading.Thread.Sleep(100);
			}
    			
			s.Receive(bytes, 0, s.Available, SocketFlags.None);
			sResponse = Encoding.ASCII.GetString(bytes);
			response = Convert.ToInt32(sResponse.Substring(0,3));
			if(response != (int)response_expected)
				return false;
			return true;
		}
        private static string base64Encode(string data)
        {
            try
            {
                byte[] encData_byte = new byte[ data.Length ];
                encData_byte = System.Text.Encoding.UTF8.GetBytes( data );
                string encodedData = Convert.ToBase64String( encData_byte );
                return encodedData;
            }
            catch(Exception e)
            {
                throw new Exception( "Error in base64Encode" + e.Message );
            }
        }
    }
}

