using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Text.RegularExpressions;
using System.Windows.Forms;
using System.IO;
using System.Net;
using System.Runtime.InteropServices;

namespace RoboPirate
{
    public partial class frmMain : Form
    {
        public enum ShowCommands : int
        {
            SW_HIDE = 0,
            SW_SHOWNORMAL = 1,
            SW_NORMAL = 1,
            SW_SHOWMINIMIZED = 2,
            SW_SHOWMAXIMIZED = 3,
            SW_MAXIMIZE = 3,
            SW_SHOWNOACTIVATE = 4,
            SW_SHOW = 5,
            SW_MINIMIZE = 6,
            SW_SHOWMINNOACTIVE = 7,
            SW_SHOWNA = 8,
            SW_RESTORE = 9,
            SW_SHOWDEFAULT = 10,
            SW_FORCEMINIMIZE = 11,
            SW_MAX = 11
        }

        [DllImport( "shell32.dll" )]
        static extern IntPtr ShellExecute(IntPtr hwnd, string lpOperation, string lpFile, string lpParameters, string lpDirectory, ShowCommands nShowCmd);

        public delegate void DoActionDelegate(RequestState state, WebResponse response, string strResponse);

        private Setting_BadWeather setBadWeather = Setting_BadWeather.KeepGoing;
        private Setting_Bombs setBombs = Setting_Bombs.Random;
        private Setting_EnemyIslands setEnemyIslands = Setting_EnemyIslands.Attack;
        private Setting_DesertIslands setDesertIslands = Setting_DesertIslands.Coin;
        private Setting_EndOfTheLine setEndOfTheLine = Setting_EndOfTheLine.DrinkBuy;
        private Setting_CrewLosses setCrewLosses = Setting_CrewLosses.Maintain;
        private Setting_EnemyShips setEnemyShips = Setting_EnemyShips.Attack;
        private Setting_LowHealth setLowHealth = Setting_LowHealth.UseHam;
        private Setting_LevelUpgrades setLevelUpgrades = Setting_LevelUpgrades.Buy;
        private int setEnemyIslandsPercent = 100;
        private bool setHideMessages = false;
        private bool setEndDigUp = true;
        private string setBombsTarget = "";
        private int setEnemyShipsPercent = 50;
        private int setLowHealthPercent = 50;
        private bool setLowHealthBuy = true;
        private int setMaxLogSize = 200;
        private int setDesertCoin = 1000;
        private int setDesertCount = 10;
        private bool setMinimize = true;

        private CookieCollection cookies;
        private bool m_bStop = true;
        private bool m_bLoading = false;
        private int nDigPrice = 50;
        private int nDigAmt = 0;
        private bool bLastException = false;
        private PurchaseType purchasetype;
        private string strBombTargetID = "";
        private string strBombTargetName = "";
        private int nCurrentLoader = 1;
        private List<string> lstActivityQueue = new List<string>();
        private Dictionary<string, int> dctNeededToLevel = null;
        private int nNumIslands = 0;
        private int nNumCrewStart = -1;
        private int nNumCrewCurrent = -1;
        private string strLastError = "";
        private FormWindowState fwsLastState = FormWindowState.Normal;
        private MouseButtons mbtLastTrayButton = MouseButtons.None;

        private int nLevel = -1;
        private int nHitPoints = -1;
        private int nCoins = -1;

        public frmMain()
        {
            InitializeComponent();
        }

        private void frmMain_Load(object sender, EventArgs e)
        {
            lblCurrentLevel.Text = "      Click the Starrrrrrrt button to begin";
            lblHitPoints.Text = "";
            lblCoins.Text = "";
            lblDistance.Text = "";
            lsvActivityLog.Items.Clear();
            txtErrorLog.Text = "";
            lblAbout.Text = "RoboPirate " + System.Reflection.Assembly.GetExecutingAssembly().GetName().Version;
            LoadSettings();
        }

        private bool FirstCheck(IAsyncResult result, out RequestState state, out WebResponse response, out string strResponse)
        {
            state = (RequestState)result.AsyncState;
            WebRequest request = state.Request;
            response = request.EndGetResponse(result);
            if (((HttpWebResponse)response).Cookies.Count > 0) cookies = ((HttpWebResponse)response).Cookies;
            StreamReader outread = new StreamReader(response.GetResponseStream());
            strResponse = outread.ReadToEnd();
            AdvanceLoader();
            outread.Close();
            response.Close();
            bLastException = false;

            if (response.ResponseUri.AbsoluteUri.Contains("facebook.com/login.php") && state.Callback.Method.Name != "TryLogin")
            {
                Regex rgxChallenge = new Regex(@"\<input type\=" + "\"hidden\"" + @" id\=" + "\"challenge\"" + @" name\=" + "\"challenge\"" + @" value\=" + "\"(.*?)\"" + @" \/\>");
                if (rgxChallenge.IsMatch(strResponse))
                {
                    PromptLogin(rgxChallenge.Match(strResponse).Groups[1].Value, false);
                }
                else
                {
                    AddToErrorLog("Unable to extract challenge from login prompt\r\n\r\nURL: " + response.ResponseUri.AbsoluteUri + "\r\nResponse dump:\r\n" + strResponse, true);
                }
                return false;
            }

            Regex rgxError = new Regex(@"\<h2\>Errors while loading page from application\<\/h2\>");
            if (rgxError.IsMatch(strResponse))
            {
                LoadPage("Retrying download (Facebook error)", false, state.URL, state.Callback, state.Data);
                return false;
            }

            Regex rgxCaptchaAction = new Regex("href\\=\"" + @"captcha_result\.php\?(.*?)\&amp\;choice\=");
            if (rgxCaptchaAction.IsMatch(strResponse))
            {
                Regex rgxImages = new Regex(@"\<img src\=" + "\"" + @"http\:\/\/piratewarsonline\.com\/captcha\/(.*?)\.jpg" + "\" border\\=\"0\" \\/\\>");
                if (rgxImages.IsMatch(strResponse))
                {
                    List<string> lstImages = new List<string>();
                    foreach (Match mchImage in rgxImages.Matches(strResponse))
                    {
                        lstImages.Add("http://piratewarsonline.com/captcha/" + mchImage.Groups[1].Value + ".jpg");
                    }
                    AddToActivityLog("Downloading first CAPTCHA image...", false);
                    CheckCaptcha(lstImages, rgxCaptchaAction.Match(strResponse).Groups[1].Value);
                    return false;
                }
            }

            if (response.ResponseUri.AbsoluteUri == "http://apps.facebook.com/pirates/harbor.php")
            {
                LoadPage("Going sailing", true, "index.php", new DoActionDelegate(GoSailing));
                return false;
            }

            if (response.ResponseUri.AbsoluteUri == "http://apps.facebook.com/pirates/you_were_attacked.php")
            {
                string strPirateName = "an unknown pirate";
                string strPirateLevel = "unknown";

                Regex rgxPirate = new Regex(@"Avast\! the Pirate \<a href\=" + "\"(.*?)\"" + @" onclick\=" + "\"(.*?)\"" + @"\>(.*?)\<\/a\> \(Level ([0-9]*)\) attacked you\!");
                if (rgxPirate.IsMatch(strResponse))
                {
                    strPirateName = rgxPirate.Match(strResponse).Groups[3].Value;
                    strPirateLevel = rgxPirate.Match(strResponse).Groups[4].Value;
                }

                //AddToErrorLog( "Attacked page appeared, here's the response:\r\n" + strResponse.Replace( "\n", "\r\n" ), false );

                Regex rgxWin = new Regex(@"You defended yourself and stole some coins from them\!\!");
                //Regex rgxLoss = new Regex( @"" );
                if (rgxWin.IsMatch(strResponse))
                {
                    LoadPage("Attacked by " + strPirateName + " (level " + strPirateLevel + "), won", false, "clear_was_attacked.php", new DoActionDelegate(GoSailing));
                    return false;
                }
                //else if(rgxLoss.IsMatch( strResponse ))
                //{
                //    LoadPage( "Attacked by " + strPirateName + " (level " + strPirateLevel + "), lost", false, "clear_was_attacked.php", new DoActionDelegate( GoSailing ) );
                //    return false;
                //}
                else
                {
                    LoadPage( "Attacked by " + strPirateName + " (level " + strPirateLevel + "), ran away or lost", false, "clear_was_attacked.php", new DoActionDelegate( GoSailing ) );
                    return false;
                }
            }

            Regex rgxBombed = new Regex(@"\<a href\=" + "\".*?\"" + @"  onclick\=" + "\".*?\"" + @" \>(.*?)\<\/a\> \(Level [0-9]*\) bombed you\!  They stole all the coins on yer ship\!");
            if (rgxBombed.IsMatch(strResponse))
            {
                LoadPage("You were bombed by " + rgxBombed.Match(strResponse).Groups[1].Value + " and lost all your unburied coins", false, "clear_was_attacked.php", new DoActionDelegate(GoSailing));
                return false;
            }

            return true;
        }

        private void CheckCaptcha(List<string> lstImages, string strCaptchaAction)
        {
            if (lstImages.Count == 0)
            {
                AddToActivityLog("Unable to match CAPTCHA image!", false);
                AddToErrorLog("Images have been saved in the application folder.", true);
                return;
            }

            if (m_bStop)
            {
                CleanCaptcha();
                return;
            }
            HttpWebRequest request = HttpWebRequest.Create(lstImages[0]) as HttpWebRequest;
            request.UserAgent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)";
            CaptchaRequestState state = new CaptchaRequestState(request, lstImages[0], strCaptchaAction, lstImages);
            IAsyncResult result = request.BeginGetResponse(new AsyncCallback(TakeCaptcha), state);
            System.Threading.ThreadPool.RegisterWaitForSingleObject(result.AsyncWaitHandle,
                new System.Threading.WaitOrTimerCallback(ScanCaptchaTimeoutCallback), state, (10 * 1000), true);
        }

        private void ScanCaptchaTimeoutCallback(object reqstate, bool timedOut)
        {
            if (timedOut)
            {
                CaptchaRequestState state = (CaptchaRequestState)reqstate;
                if (state != null)
                {
                    state.NumTries++;
                    state.Request.Abort();
                    if (state.NumTries < 3)
                    {
                        AddToActivityLog("Retrying download (timeout)", false);
                        CheckCaptcha(state.Images, state.ActionURL);
                    }
                    else
                    {
                        AddToErrorLog("Unable to contact CAPTCHA server; tried 3 times with no response", true);
                    }
                }
            }
        }

        private void CleanCaptcha()
        {
            foreach (string strImage in Directory.GetFiles(Path.GetDirectoryName(Application.ExecutablePath), "pirate_*.*"))
            {
                File.Delete(strImage);
            }
        }

        // readStream is the stream you need to read
        // writeStream is the stream you want to write to
        private void ReadWriteStream(Stream readStream, Stream writeStream)
        {
            int Length = 256;
            Byte[] buffer = new Byte[Length];
            int bytesRead = readStream.Read(buffer, 0, Length);
            // write the required bytes
            while (bytesRead > 0)
            {
                writeStream.Write(buffer, 0, bytesRead);
                bytesRead = readStream.Read(buffer, 0, Length);
            }
            readStream.Close();
            writeStream.Close();
        }

        private void TakeCaptcha(IAsyncResult result)
        {
            if (this.InvokeRequired)
            {
                AsyncCallback invoker = new AsyncCallback(TakeCaptcha);
                this.BeginInvoke(invoker, new object[] { result });
                return;
            }

            try
            {
                CaptchaRequestState state = (CaptchaRequestState)result.AsyncState;
                WebRequest request = state.Request;
                WebResponse response = request.EndGetResponse(result);
                FileStream fs = new FileStream(Path.Combine(Path.GetDirectoryName(Application.ExecutablePath), "pirate_" + state.URL.Substring(state.URL.LastIndexOf("/") + 1)), FileMode.Create);
                ReadWriteStream(response.GetResponseStream(), fs);
                AdvanceLoader();
                bLastException = false;

                Bitmap bmpTest = Bitmap.FromFile(Path.Combine(Path.GetDirectoryName(Application.ExecutablePath), "pirate_" + state.URL.Substring(state.URL.LastIndexOf("/") + 1))) as Bitmap;

                if (ComparingImages.Compare(bmpTest, RoboPirate.Properties.Resources.pirate1) == ComparingImages.CompareResult.ciCompareOk ||
                    ComparingImages.Compare(bmpTest, RoboPirate.Properties.Resources.pirate2) == ComparingImages.CompareResult.ciCompareOk ||
                    ComparingImages.Compare(bmpTest, RoboPirate.Properties.Resources.pirate3) == ComparingImages.CompareResult.ciCompareOk)
                {
                    CleanCaptcha();
                    LoadPage("Found CAPTCHA image, going sailing", false, "captcha_result.php?" + state.ActionURL.Replace("&amp;", "&") + "&choice=" + Path.GetFileNameWithoutExtension(state.URL.Substring(state.URL.LastIndexOf("/"))), new DoActionDelegate(GoSailing));
                    return;
                }

                AddToActivityLog("Downloading next CAPTCHA image...", true);
                state.Images.RemoveAt(0);
                CheckCaptcha(state.Images, state.ActionURL);
                return;
            }
            catch (Exception ex)
            {
                HandleError(ex);
            }
        }

        private void HandleError(Exception ex)
        {
            if (ex.GetType() == typeof(WebException))
            {
                if (((WebException)ex).Status == WebExceptionStatus.RequestCanceled && ex.Message.Contains("abort"))
                {
                    return;
                }
            }

            string strError = "An exception occurred:";
            while (ex != null && ex.Message != "")
            {
                strError += "\r\n\r\n" + ex.Message + "\r\n";
                if (ex.GetType() == typeof(WebException))
                {
                    strError += "Response URL: " + ((WebException)ex).Response.ResponseUri + "\r\n";
                }
                strError += ex.StackTrace;
                ex = ex.InnerException;
            }
            AddToErrorLog(strError + "\r\n", bLastException);
            if (!bLastException)
            {
                bLastException = true;
                LoadPage("Going sailing (recovering from exception)", true, "index.php", new DoActionDelegate(GoSailing));
            }
        }

        private void TakeAsync(IAsyncResult result)
        {
            if (this.InvokeRequired)
            {
                AsyncCallback invoker = new AsyncCallback(TakeAsync);
                this.BeginInvoke(invoker, new object[] { result });
                return;
            }

            try
            {
                RequestState state;
                WebResponse response;
                string strResponse;
                if (!FirstCheck(result, out state, out response, out strResponse)) return;
                state.Callback(state, response, strResponse);
            }
            catch (Exception ex)
            {
                HandleError(ex);
            }
        }

        private void CheckCrewCount(RequestState state, WebResponse response, string strResponse)
        {
            try
            {
                if (response.ResponseUri.AbsoluteUri == "http://apps.facebook.com/pirates/stats.php")
                {
                    Regex rgxCrewCount = new Regex(@"crew \(level ([0-9]*)\)");
                    if (rgxCrewCount.IsMatch(strResponse))
                    {
                        nNumCrewStart = System.Convert.ToInt32(rgxCrewCount.Match(strResponse).Groups[1].Value);
                        LoadPage("Going sailing", true, "index.php", new DoActionDelegate(GoSailing));
                        return;
                    }
                    else
                    {
                        nNumCrewStart = 0;
                        LoadPage("Unable to determine current crew count, so ignoring and going sailing", false, "index.php", new DoActionDelegate(GoSailing));
                        return;
                    }
                }

                GoSailing( state, response, strResponse );
            }
            catch (Exception ex)
            {
                HandleError(ex);
            }
        }

        private void BuyUpgrade(RequestState state, WebResponse response, string strResponse)
        {
            try
            {
                if (response.ResponseUri.AbsoluteUri == "http://apps.facebook.com/pirates/level_upgrade.php")
                {
                    Regex rgxItemListing = new Regex(@"\<tr\>\<td\>\<h2\>([0-9]*) (.*?)\<\/h2\>\<\/td\>\<td\>You Have ([0-9]*)");
                    if (!rgxItemListing.IsMatch(strResponse))
                    {
                        AddToErrorLog("Unable to find any items in the upgrade list!  Response dump:\r\n" + strResponse.Replace("\n", "\r\n"), true);
                        return;
                    }
                    dctNeededToLevel = new Dictionary<string, int>();
                    int nNeededCoins = -1;
                    int nHaveCoins = -1;
                    foreach (Match mchItem in rgxItemListing.Matches(strResponse))
                    {
                        int nNeed = System.Convert.ToInt32(mchItem.Groups[1].Value);
                        int nHave = System.Convert.ToInt32(mchItem.Groups[3].Value);
                        if (nNeed > nHave && mchItem.Groups[2].Value != "coins")
                        {
                            dctNeededToLevel.Add(mchItem.Groups[2].Value.ToLower().Trim(), nNeed - nHave);
                        }
                        if (mchItem.Groups[2].Value == "coins")
                        {
                            nNeededCoins = nNeed;
                            nHaveCoins = nHave;
                        }
                    }
                    if (nNeededCoins == -1 || nHaveCoins == -1)
                    {
                        AddToErrorLog("Unable to find any coins in the upgrade list!  Response dump:\r\n" + strResponse.Replace("\n", "\r\n"), true);
                        return;
                    }
                    if (dctNeededToLevel.Count == 0)
                    {
                        if (nNeededCoins > nHaveCoins)
                        {
                            int nRemainder = nNeededCoins - nHaveCoins;
                            Regex rgxBuriedCoins = new Regex(@"You also have ([0-9]*) buried coins\.");
                            if (rgxBuriedCoins.IsMatch(strResponse))
                            {
                                int nBuried = System.Convert.ToInt32(rgxBuriedCoins.Match(strResponse).Groups[1].Value);
                                if (nBuried < nRemainder)
                                {
                                    LoadPage("Not enough total gold to buy, going sailing", false, "index.php", new DoActionDelegate(GoSailing));
                                    return;
                                }
                                purchasetype = PurchaseType.Level;
                                nDigAmt = nRemainder;
                                LoadPage("Preparing to dig up coins", true, "retrieve_coins.php", new DoActionDelegate(DigUpCoinsBuyItem));
                                return;
                            }
                            else
                            {
                                LoadPage("Not enough gold on-hand to buy, but can't determine buried amount, going sailing", false, "index.php", new DoActionDelegate(GoSailing));
                                return;
                            }
                        }
                        else
                        {
                            dctNeededToLevel = null;
                            LoadPage("Buying a level", false, "level_up.php", new DoActionDelegate(BuyUpgrade));
                            return;
                        }
                    }
                    else
                    {
                        LoadPage("Can't level up yet, going sailing", true, "index.php", new DoActionDelegate(GoSailing));
                        return;
                    }
                }

                if (response.ResponseUri.AbsoluteUri == "http://apps.facebook.com/pirates/level_up.php")
                {
                    LoadPage("Checking to see if another level can be purchased", true, "level_upgrade.php", new DoActionDelegate(BuyUpgrade));
                    return;
                }

                GoSailing( state, response, strResponse );
            }
            catch (Exception ex)
            {
                HandleError(ex);
            }
        }

        private void CheckHam(RequestState state, WebResponse response, string strResponse)
        {
            try
            {
                Regex rgxBooty = new Regex(@"Respect your booty sea dog\!");
                if (rgxBooty.IsMatch(strResponse))
                {
                    Regex rgxSaltedHam = new Regex(@"Salted Ham\<\/a\> \(x [0-9]*\)");
                    if (rgxSaltedHam.IsMatch(strResponse))
                    {
                        LoadPage("Using salted ham", false, "item_action.php?item=ham", new DoActionDelegate(GoSailing));
                        return;
                    }
                    else if (setLowHealthBuy)
                    {
                        LoadPage("Buying a salted ham", true, "buy.php?u=ham", new DoActionDelegate(CheckHam));
                        return;
                    }
                }

                Regex rgxBoughtHam = new Regex(@"Avast\! You purchased Salted Ham");
                if (rgxBoughtHam.IsMatch(strResponse))
                {
                    LoadPage("Using purchased salted ham", false, "item_action.php?item=ham", new DoActionDelegate(GoSailing));
                    return;
                }

                GoSailing( state, response, strResponse );
            }
            catch (Exception ex)
            {
                HandleError(ex);
            }
        }

        private void AttackIsland(RequestState state, WebResponse response, string strResponse)
        {
            try
            {
                Regex rgxPillage = new Regex(@"\<form action\=" + "\"" + @"process_pillaging_results\.php" + "\"" + @" method\=" + "\"post\"" + @"\>");
                if (rgxPillage.IsMatch(strResponse))
                {
                    Regex rgxNumHouses = new Regex(@"\<input type\=" + "\"hidden\"" + @" name\=" + "\"houseCount\"" + @" value\=" + "\"([0-9]*)\"" + @" \/\>");
                    if (rgxNumHouses.IsMatch(strResponse))
                    {
                        Dictionary<string, string> dctPOSTData = new Dictionary<string, string>();
                        int nMaxHouses = System.Convert.ToInt32(rgxNumHouses.Match(strResponse).Groups[1].Value);
                        nMaxHouses *= (setEnemyIslandsPercent / 100);
                        if (nMaxHouses == 0) nMaxHouses = 1;
                        for (int i = 1; i <= nMaxHouses; i++)
                        {
                            dctPOSTData.Add("house" + i.ToString(), "house");
                        }
                        for (int i = nMaxHouses + 1; i <= System.Convert.ToInt32(rgxNumHouses.Match(strResponse).Groups[1].Value); i++)
                        {
                            dctPOSTData.Add("house" + i.ToString(), "");
                        }
                        dctPOSTData.Add("houseCount", rgxNumHouses.Match(strResponse).Groups[1].Value);
                        LoadPage("Attacking enemy island", true, "process_pillaging_results.php", new DoActionDelegate(AttackIsland), dctPOSTData);
                    }
                    else
                    {
                        AddToErrorLog("Unable to extract number of houses from pillage prompt\r\n\r\nResponse dump:\r\n" + strResponse, true);
                    }
                    return;
                }

                Regex rgxPillageResults = new Regex(@"\<h1\>Pillaging Results\<\/h1\>");
                if (rgxPillageResults.IsMatch(strResponse))
                {
                    Regex rgxPillagePlus = new Regex(@"Your crew pillaged ([0-9]*) coins");
                    Regex rgxPillageMinus = new Regex(@"Your crew lose and the enemy steals ([0-9]*) of your coins");
                    Regex rgxPillageKill = new Regex(@"The enemy captured and KILLED (.*?)\!");
                    Regex rgxPillageItem = new Regex(@"\<h2\>You won an item\!\<\/h2\>\<br \/\>.*?\<center\>\<h5\>(.*?)\<\/h5\>\<br \/\>");
                    int nCoinChg = 0;
                    if (rgxPillagePlus.IsMatch(strResponse))
                    {
                        foreach (Match mchPillagePlus in rgxPillagePlus.Matches(strResponse))
                        {
                            nCoinChg += System.Convert.ToInt32(mchPillagePlus.Groups[1].Value);
                        }
                    }
                    if (rgxPillageMinus.IsMatch(strResponse))
                    {
                        foreach (Match mchPillageMinus in rgxPillageMinus.Matches(strResponse))
                        {
                            nCoinChg -= System.Convert.ToInt32(mchPillageMinus.Groups[1].Value);
                        }
                    }
                    string strMessage = "Pillage results: ";
                    if (nCoinChg > 0)
                    {
                        strMessage += "Gained " + nCoinChg.ToString() + " coins";
                    }
                    else if (nCoinChg < 0)
                    {
                        strMessage += "Lost " + (nCoinChg * -1).ToString() + " coins";
                    }
                    else
                    {
                        strMessage += "No coin change";
                    }
                    if (rgxPillageKill.IsMatch(strResponse))
                    {
                        strMessage += ", lost " + rgxPillageKill.Match(strResponse).Groups[1].Value;
                    }
                    if (rgxPillageItem.IsMatch(strResponse))
                    {
                        strMessage += ", found an item: " + rgxPillageItem.Match(strResponse).Groups[1].Value;
                        foreach (string strItem in dctNeededToLevel.Keys)
                        {
                            if (rgxPillageItem.Match(strResponse).Groups[1].Value.ToLower().Trim().Contains(strItem))
                            {
                                dctNeededToLevel[strItem]--;
                                if (dctNeededToLevel[strItem] == 0)
                                {
                                    dctNeededToLevel.Remove(strItem);
                                    if (dctNeededToLevel.Keys.Count == 0)
                                    {
                                        dctNeededToLevel = null;
                                    }
                                }
                                break;
                            }
                        }
                    }
                    if (rgxPillageKill.IsMatch(strResponse) && setCrewLosses == Setting_CrewLosses.Maintain)
                    {
                        AddToActivityLog(strMessage, false);
                        LoadPage("Checking replacement crew member prices", true, "shipyard.php", new DoActionDelegate(BuyCrew));
                    }
                    else
                    {
                        LoadPage(strMessage, false, "index.php", new DoActionDelegate(GoSailing));
                    }
                    return;
                }

                if (response.ResponseUri.AbsoluteUri == "http://apps.facebook.com/pirates/process_pillaging_results.php")
                {
                    LoadPage("Invalid pillage results page found, ignoring and going sailing", false, "index.php", new DoActionDelegate(GoSailing));
                    return;
                }

                GoSailing( state, response, strResponse );
            }
            catch (Exception ex)
            {
                HandleError(ex);
            }
        }

        private void BuyCrew(RequestState state, WebResponse response, string strResponse)
        {
            try
            {
                Regex rgxCrewPrice = new Regex(@"Buy a ([0-9]*)(st|nd|rd|th) crew member\<\/a\> \(([0-9]*) coins\)\<\/h2\>");
                if (rgxCrewPrice.IsMatch(strResponse))
                {
                    nNumCrewCurrent = System.Convert.ToInt32(rgxCrewPrice.Match(strResponse).Groups[1].Value) - 1;
                    nDigPrice = System.Convert.ToInt32(rgxCrewPrice.Match(strResponse).Groups[3].Value);
                    purchasetype = PurchaseType.Crew;

                    Regex rgxHoldCoins = new Regex(@"You\'re holding ([0-9]*) coins");
                    if (rgxHoldCoins.IsMatch(strResponse))
                    {
                        int nOnHand = System.Convert.ToInt32(rgxHoldCoins.Match(strResponse).Groups[1].Value);
                        if (nOnHand > nDigPrice)
                        {
                            LoadPage("Paying " + nDigPrice.ToString() + " coins for a crew member", false, "buy.php?u=crew", new DoActionDelegate(DigUpCoinsBuyItem));
                            return;
                        }
                        else
                        {
                            LoadPage("Preparing to dig up coins", true, "retrieve_coins.php", new DoActionDelegate(DigUpCoinsBuyItem));
                            nDigAmt = nDigPrice - nOnHand;
                            return;
                        }
                    }
                    else
                    {
                        LoadPage("Preparing to dig up coins", true, "retrieve_coins.php", new DoActionDelegate(DigUpCoinsBuyItem));
                        nDigAmt = nDigPrice;
                        return;
                    }
                }

                GoSailing( state, response, strResponse );
            }
            catch (Exception ex)
            {
                HandleError(ex);
            }
        }

        private void DesertIsland(RequestState state, WebResponse response, string strResponse)
        {
            try
            {
                Regex rgxBuryResults = new Regex(@"Ahoy\!\<br \/\>You buried ([0-9]*) coins\<p\>");
                if (rgxBuryResults.IsMatch(strResponse))
                {
                    LoadPage("Buried " + rgxBuryResults.Match(strResponse).Groups[1].Value + " coins", false, "index.php", new DoActionDelegate(GoSailing));
                    return;
                }

                Regex rgxSearchResults = new Regex(@"Ahoy\!\<br \/\>You found (.*?)\<p\>");
                if (rgxSearchResults.IsMatch(strResponse))
                {
                    if (!rgxSearchResults.Match(strResponse).Groups[1].Value.Contains("pirate coins"))
                    {
                        foreach (string strItem in dctNeededToLevel.Keys)
                        {
                            if (rgxSearchResults.Match(strResponse).Groups[1].Value.ToLower().Trim().Contains(strItem))
                            {
                                dctNeededToLevel[strItem]--;
                                if (dctNeededToLevel[strItem] == 0)
                                {
                                    dctNeededToLevel.Remove(strItem);
                                    if (dctNeededToLevel.Keys.Count == 0)
                                    {
                                        dctNeededToLevel = null;
                                    }
                                }
                                break;
                            }
                        }
                    }
                    LoadPage("Found " + rgxSearchResults.Match(strResponse).Groups[1].Value.Replace("pirate coins", "coins"), false, "index.php", new DoActionDelegate(GoSailing));
                    return;
                }

                Regex rgxSearchResultsEmpty = new Regex(@"You searched around the island but didn\'t find anything\.\.\.maybe another time\.\.\.");
                if (rgxSearchResultsEmpty.IsMatch(strResponse))
                {
                    LoadPage("Found nothing on the island", true, "index.php", new DoActionDelegate(GoSailing));
                    return;
                }

                GoSailing( state, response, strResponse );
            }
            catch (Exception ex)
            {
                HandleError(ex);
            }
        }

        private void BuyWenches(RequestState state, WebResponse response, string strResponse)
        {
            try
            {
                Regex rgxWenchPrice = new Regex(@"Hire Wenches \(([0-9]*) coins\)");
                if (rgxWenchPrice.IsMatch(strResponse))
                {
                    nDigPrice = 50;
                    int nWenchPrice = System.Convert.ToInt32(rgxWenchPrice.Match(strResponse).Groups[1].Value);
                    purchasetype = PurchaseType.Rum;
                    if (nWenchPrice < 50)
                    {
                        purchasetype = PurchaseType.Wenches;
                        nDigPrice = nWenchPrice;
                    }

                    Regex rgxHoldCoins = new Regex(@"You\'re holding ([0-9]*) coins");
                    if (rgxHoldCoins.IsMatch(strResponse))
                    {
                        int nOnHand = System.Convert.ToInt32(rgxHoldCoins.Match(strResponse).Groups[1].Value);
                        if (nOnHand > nDigPrice)
                        {
                            if (purchasetype == PurchaseType.Rum)
                            {
                                LoadPage("Paying 50 coins for rum", false, "buy.php?u=rum", new DoActionDelegate(DigUpCoinsBuyItem));
                                return;
                            }
                            else
                            {
                                LoadPage("Paying " + nDigPrice.ToString() + " coins for wenches", false, "buy.php?u=wenches", new DoActionDelegate(DigUpCoinsBuyItem));
                                return;
                            }
                        }
                        else
                        {
                            if (setEndDigUp)
                            {
                                LoadPage("Preparing to dig up coins", true, "retrieve_coins.php", new DoActionDelegate(DigUpCoinsBuyItem));
                                nDigAmt = nDigPrice - nOnHand;
                                return;
                            }
                            else
                            {
                                AddToErrorLog("Can't sail anymore until the hour! (not enough money on-hand)", true);
                                return;
                            }
                        }
                    }
                    else
                    {
                        if (setEndDigUp)
                        {
                            LoadPage("Preparing to dig up coins", true, "retrieve_coins.php", new DoActionDelegate(DigUpCoinsBuyItem));
                            nDigAmt = nDigPrice;
                            return;
                        }
                        else
                        {
                            AddToErrorLog("Can't sail anymore until the hour! (not enough money on-hand)", true);
                            return;
                        }
                    }
                }

                GoSailing( state, response, strResponse );
            }
            catch (Exception ex)
            {
                HandleError(ex);
            }
        }

        private void AttackShip(RequestState state, WebResponse response, string strResponse)
        {
            try
            {
                Regex rgxAttack = new Regex(@"href\=" + "\"attack_ship.php\"");
                if (rgxAttack.IsMatch(strResponse))
                {
                    LoadPage("Attacking enemy ship", false, "attack_ship.php", new DoActionDelegate(AttackShip));
                    return;
                }

                if (response.ResponseUri.AbsoluteUri.Contains("attack_ship.php"))
                {
                    Regex rgxFight = new Regex(@"Arrrrrrr\.\.\. you fired and caused \<b\>([0-9]*) damage\<\/b\>\.  They fired back\, causing you \<b\>([0-9]*) damage");
                    if (rgxFight.IsMatch(strResponse))
                    {
                        AddToActivityLog("Caused " + rgxFight.Match(strResponse).Groups[1].Value + " damage, took " + rgxFight.Match(strResponse).Groups[2].Value + " damage", true);
                    }
                    Regex rgxMiss = new Regex(@"Arrr\.\.\. You fire and miss\!\!");
                    if (rgxMiss.IsMatch(strResponse))
                    {
                        AddToActivityLog("Fired and missed", true);
                    }

                    Dictionary<string, string> dctPOSTData = new Dictionary<string, string>();
                    bool bGood = true;
                    List<string> lstFields = new List<string>();
                    lstFields.Add("fb_sig_time");
                    lstFields.Add("fb_sig_user");
                    lstFields.Add("fb_sig_profile_update_time");
                    lstFields.Add("fb_sig_session_key");
                    lstFields.Add("fb_sig_expires");
                    lstFields.Add("fb_sig_api_key");
                    lstFields.Add("fb_sig_added");
                    lstFields.Add("fb_sig");
                    lstFields.Add("enemy_id");
                    lstFields.Add("r");

                    foreach (string strField in lstFields)
                    {
                        Regex rgxField = new Regex(@"\<input type\=" + "\"hidden\"" + @" name\=" + "\"" + strField + "\"" + @" value\=" + "\"(.*?)\"" + @" \/\>");
                        Regex rgxField2 = new Regex(@"\<input type\=" + "\"hidden\"" + @" value\=" + "\"(.*?)\"" + @" name\=" + "\"" + strField + "\"" + @" \/\>");
                        if (rgxField.IsMatch(strResponse))
                        {
                            dctPOSTData.Add(strField, rgxField.Match(strResponse).Groups[1].Value);
                        }
                        else if (rgxField2.IsMatch(strResponse))
                        {
                            dctPOSTData.Add(strField, rgxField2.Match(strResponse).Groups[1].Value);
                        }
                        else
                        {
                            bGood = false;
                            break;
                        }
                    }
                    if (bGood)
                    {
                        Random rnd = new Random(DateTime.Now.Millisecond);
                        string strDir = "straight";
                        switch (rnd.Next(1, 3))
                        {
                            case 1:
                                strDir = "left";
                                break;
                            case 2:
                                strDir = "straight";
                                break;
                            case 3:
                                strDir = "right";
                                break;
                        }
                        dctPOSTData.Add("d", strDir);
                        LoadPage("Firing " + strDir + " at the enemy ship", false, "attack_ship_action.php", new DoActionDelegate(AttackShip), dctPOSTData);
                        return;
                    }
                }

                if (response.ResponseUri.AbsoluteUri.Contains("http://apps.facebook.com/pirates/ship_attack_result.php"))
                {
                    Regex rgxWin = new Regex(@"You took ([0-9]*) coins from the  Pirate");
                    if (rgxWin.IsMatch(strResponse))
                    {
                        LoadPage("Won the battle, stole " + rgxWin.Match(strResponse).Groups[1].Value + " coins, going sailing again", false, "index.php", new DoActionDelegate(GoSailing));
                        return;
                    }
                    Regex rgxLoss = new Regex(@"stole ([0-9]*) coins from you");
                    if (rgxLoss.IsMatch(strResponse))
                    {
                        LoadPage("Lost the battle, lost " + rgxLoss.Match(strResponse).Groups[1].Value + " coins, going sailing again", false, "index.php", new DoActionDelegate(GoSailing));
                        return;
                    }
                    Regex rgxTie = new Regex(@"barely escaped alive\!\!");
                    if (rgxTie.IsMatch(strResponse))
                    {
                        LoadPage("Battle was a tie, going sailing again", false, "index.php", new DoActionDelegate(GoSailing));
                        return;
                    }
                }

                Regex rgxAttackFail = new Regex(@"The ship you were chasing outsmarted you and got away\! Arrrr\.\.\.");
                if (rgxAttackFail.IsMatch(strResponse))
                {
                    AddToActivityLog("Enemy ship escaped", false);
                    GoSailing(state, response, strResponse);
                    return;
                }

                if (response.ResponseUri.AbsoluteUri == "http://apps.facebook.com/pirates/attack_ship_action.php")
                {
                    LoadPage("Invalid attack results page found, ignoring and going sailing", false, "index.php", new DoActionDelegate(GoSailing));
                    return;
                }

                GoSailing( state, response, strResponse );
            }
            catch (Exception ex)
            {
                HandleError(ex);
            }
        }

        private void ThrowBomb(RequestState state, WebResponse response, string strResponse)
        {
            try
            {
                Regex rgxBombMsg = new Regex(@"\<a href\=" + "\".*?\"" + @" onclick\=" + "\".*?\"" + @"\>(.*?)\<\/a\> and stole ([0-9]*) coins\!\<\/div\>\<div style\=" + "\"text\\-align\\: center\"" + @"\>Level \+([0-9]*)\<\/div\>\<p\>");
                if (rgxBombMsg.IsMatch(strResponse))
                {
                    AddToActivityLog("Stole " + rgxBombMsg.Match(strResponse).Groups[2].Value + " coins from " + rgxBombMsg.Match(strResponse).Groups[1].Value + ", gained " + rgxBombMsg.Match(strResponse).Groups[3].Value + " level", false);
                    GoSailing(state, response, strResponse);
                    return;
                }
                else if (response.ResponseUri.AbsoluteUri.Contains("http://apps.facebook.com/pirates/index.php?msg=threw-bomb"))
                {
                    Regex rgxGoldAmt = new Regex(@"\&gold\=([0-9]*)\&");
                    if (rgxGoldAmt.IsMatch(response.ResponseUri.AbsoluteUri))
                    {
                        AddToActivityLog("Stole " + rgxGoldAmt.Match(strResponse).Groups[1].Value + " coins", false);
                        GoSailing(state, response, strResponse);
                        return;
                    }
                    else
                    {
                        AddToActivityLog("Unknown bomb status; check error log for dump", false);
                        AddToErrorLog("Bomb msg - URL = " + response.ResponseUri.AbsoluteUri + "\r\n" + strResponse, false);
                    }
                }

                if (response.ResponseUri.AbsoluteUri == "http://apps.facebook.com/pirates/throw_bomb_pick.php")
                {
                    LoadPage("Choosing a target to bomb", true, "pirate_friends.php", new DoActionDelegate(ThrowBomb));
                    return;
                }

                Regex rgxMates = new Regex(@"Pirate Friends");
                if (rgxMates.IsMatch(strResponse))
                {
                    Regex rgxEachMate = new Regex(@"\<td style\=" + "\"" + @"font\-size\: 150\%" + "\"" + @"\>\<a href\=" + "\"" + @"http\:\/\/.*?\.facebook\.com\/profile\.php\?id\=([0-9]*)" + "\"" + @" onclick\=" + "\".*?\"" + @"\>(.*?)\<\/a\>");
                    if (rgxEachMate.IsMatch(strResponse))
                    {
                        Dictionary<string, string> dctMates = new Dictionary<string, string>();
                        List<string> lstMateNames = new List<string>();
                        foreach (Match mchMatch in rgxEachMate.Matches(strResponse))
                        {
                            dctMates.Add(mchMatch.Groups[2].Value, mchMatch.Groups[1].Value);
                            lstMateNames.Add(mchMatch.Groups[2].Value);
                        }
                        strBombTargetID = "";
                        if (setBombs == Setting_Bombs.Specific)
                        {
                            foreach (string strMate in dctMates.Keys)
                            {
                                if (strMate.ToLower().Trim().Contains(setBombsTarget.ToLower().Trim()))
                                {
                                    strBombTargetID = dctMates[strMate];
                                    strBombTargetName = strMate;
                                    break;
                                }
                            }
                        }
                        if (strBombTargetID == "")
                        {
                            if (setBombs == Setting_Bombs.Specific)
                            {
                                AddToActivityLog("Unable to find " + setBombsTarget + " in your pirate friends list!", false);
                            }
                            Random rnd = new Random(DateTime.Now.Millisecond);
                            strBombTargetName = lstMateNames[rnd.Next(0, lstMateNames.Count - 1)];
                            strBombTargetID = dctMates[strBombTargetName];
                        }
                        LoadPage("Preparing to throw a bomb at " + strBombTargetName, true, "throw_bomb_at.php?id=" + strBombTargetID, new DoActionDelegate(ThrowBomb));
                        return;
                    }
                    else
                    {
                        LoadPage("Can't pick a target to bomb, running away", false, "clear_action.php", new DoActionDelegate(GoSailing));
                        return;
                    }
                }

                Regex rgxThrowConfirm = new Regex(@"\<form action\=" + "\"throw_the_bomb_action\\.php\"" + @"\>");
                if (rgxThrowConfirm.IsMatch(strResponse))
                {
                    Dictionary<string, string> dctPOSTData = new Dictionary<string, string>();
                    bool bGood = true;
                    List<string> lstFields = new List<string>();
                    lstFields.Add("fb_sig_time");
                    lstFields.Add("fb_sig_user");
                    lstFields.Add("fb_sig_profile_update_time");
                    lstFields.Add("fb_sig_session_key");
                    lstFields.Add("fb_sig_expires");
                    lstFields.Add("fb_sig_api_key");
                    lstFields.Add("fb_sig_added");
                    lstFields.Add("fb_sig");
                    foreach (string strField in lstFields)
                    {
                        Regex rgxField = new Regex(@"\<input type\=" + "\"hidden\"" + @" name\=" + "\"" + strField + "\"" + @" value\=" + "\"(.*?)\"" + @" \/\>");
                        if (rgxField.IsMatch(strResponse))
                        {
                            dctPOSTData.Add(strField, rgxField.Match(strResponse).Groups[1].Value);
                        }
                        else
                        {
                            bGood = false;
                            break;
                        }
                    }
                    if (bGood)
                    {
                        dctPOSTData.Add("throw_at", strBombTargetID);
                        dctPOSTData.Add("submit", "Throw!");
                        LoadPage("Throwing a bomb at " + strBombTargetName, true, "throw_the_bomb_action.php", new DoActionDelegate(ThrowBomb), dctPOSTData);
                        return;
                    }
                }

                GoSailing( state, response, strResponse );
            }
            catch (Exception ex)
            {
                HandleError(ex);
            }
        }

        private void ExploreIsland(RequestState state, WebResponse response, string strResponse)
        {
            try
            {
                Regex rgxBury = new Regex(@"href\=" + "\"bury_coins.php\"");
                if (rgxBury.IsMatch(strResponse))
                {
                    nNumIslands++;
                    bool bBury = false;
                    if (setDesertIslands == Setting_DesertIslands.Bury) bBury = true;
                    if (setDesertIslands == Setting_DesertIslands.Count && nNumIslands >= setDesertCount)
                    {
                        bBury = true;
                        nNumIslands = 0;
                    }
                    if (setDesertIslands == Setting_DesertIslands.Coin && nCoins > setDesertCoin) bBury = true;
                    if (bBury)
                    {
                        LoadPage("Burying coins", true, "bury_coins.php", new DoActionDelegate(DesertIsland));
                        return;
                    }
                }

                Regex rgxEnemy = new Regex(@"href\=" + "\"pillage_town.php\"");
                if (rgxEnemy.IsMatch(strResponse))
                {
                    if (setEnemyIslands == Setting_EnemyIslands.Attack)
                    {
                        LoadPage("Found an enemy island", true, "pillage_town.php", new DoActionDelegate(AttackIsland));
                        return;
                    }
                    else
                    {
                        LoadPage("Found an enemy island, running away", true, "clear_action.php", new DoActionDelegate(GoSailing));
                        return;
                    }
                }

                Regex rgxBooty = new Regex(@"href\=" + "\"island_booty.php\"");
                if (rgxBooty.IsMatch(strResponse))
                {
                    LoadPage("Searching for booty", true, "island_booty.php", new DoActionDelegate(DesertIsland));
                    return;
                }

                GoSailing( state, response, strResponse );
            }
            catch (Exception ex)
            {
                HandleError(ex);
            }
        }

        private void GoSailing(RequestState state, WebResponse response, string strResponse)
        {
            try
            {
                if (!response.ResponseUri.AbsoluteUri.Contains("http://apps.facebook.com/pirates/index.php") &&
                    !response.ResponseUri.AbsoluteUri.Contains("http://apps.facebook.com/pirates/explore.php") &&
                    response.ResponseUri.AbsoluteUri != "http://apps.facebook.com/pirates/found_land.php" &&
                    response.ResponseUri.AbsoluteUri != "http://apps.facebook.com/pirates/found_ship.php" &&
                    response.ResponseUri.AbsoluteUri != "http://apps.facebook.com/pirates/throw_bomb.php")
                {
                    Dictionary<string, DoActionDelegate> dctRedirs = new Dictionary<string, DoActionDelegate>();
                    dctRedirs.Add( "http://apps.facebook.com/pirates/attack_ship.php", new DoActionDelegate( AttackShip ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/attack_ship_action.php", new DoActionDelegate( AttackShip ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/booty.php", new DoActionDelegate( CheckHam ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/bury_coins.php", new DoActionDelegate( DesertIsland ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/buy.php?u=crew", new DoActionDelegate( DigUpCoinsBuyItem ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/buy.php?u=ham", new DoActionDelegate( CheckHam ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/buy.php?u=rum", new DoActionDelegate( DigUpCoinsBuyItem ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/buy.php?u=wenches", new DoActionDelegate( DigUpCoinsBuyItem ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/enemy_base.php", new DoActionDelegate( ExploreIsland ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/enemy_ship.php", new DoActionDelegate( AttackShip ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/head_towards_land.php", new DoActionDelegate( ExploreIsland ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/island.php", new DoActionDelegate( ExploreIsland ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/island_booty.php", new DoActionDelegate( DesertIsland ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/level_up.php", new DoActionDelegate( BuyUpgrade ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/level_upgrade.php", new DoActionDelegate( BuyUpgrade ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/pillage_town.php", new DoActionDelegate( AttackIsland ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/pirate_friends.php", new DoActionDelegate( ThrowBomb ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/process_pillaging_results.php", new DoActionDelegate( AttackIsland ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/report_pillaging_results.php", new DoActionDelegate( AttackIsland ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/retrieve_coins.php", new DoActionDelegate( DigUpCoinsBuyItem ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/ship_attack_result.php", new DoActionDelegate( AttackShip ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/shipyard.php", new DoActionDelegate( BuyCrew ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/stats.php", new DoActionDelegate( CheckCrewCount ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/throw_bomb_at.php", new DoActionDelegate( ThrowBomb ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/throw_bomb_pick.php", new DoActionDelegate( ThrowBomb ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/throw_the_bomb_action.php", new DoActionDelegate( ThrowBomb ) );
                    dctRedirs.Add( "http://apps.facebook.com/pirates/wenches.php", new DoActionDelegate( BuyWenches ) );
                    foreach(string strPage in dctRedirs.Keys)
                    {
                        if (response.ResponseUri.AbsoluteUri.Contains(strPage))
                        {
                            dctRedirs[strPage](state, response, strResponse);
                            return;
                        }
                    }

                    AddToErrorLog( "GoSailing received: " + response.ResponseUri.AbsoluteUri, false );
                }

                if (nNumCrewStart == -1 && setCrewLosses == Setting_CrewLosses.Maintain)
                {
                    LoadPage("Getting current number of crew members", false, "stats.php", new DoActionDelegate(CheckCrewCount));
                    return;
                }

                if (dctNeededToLevel == null && setLevelUpgrades == Setting_LevelUpgrades.Buy)
                {
                    LoadPage("Getting list of booty needed to upgrade", true, "level_upgrade.php", new DoActionDelegate(BuyUpgrade));
                    return;
                }

                Regex rgxLevel = new Regex(@"\<td\>\<h5 style\=" + "\"text\\-align\\: left\"" + @"\>Level ([0-9]*)");
                Regex rgxHitPoints = new Regex(@"\<td\>\<h5 style\=" + "\"text\\-align\\: center\"" + @"\>Hit Points: ([0-9]*)");
                Regex rgxCoins = new Regex(@"\<td\>\<h5 style\=" + "\"text\\-align\\: right\"" + @"\>Coins: ([0-9]*) Buried: ([0-9]*)");
                Regex rgxDistance = new Regex(@"([0-9]*) miles away");
                if (rgxLevel.IsMatch(strResponse))
                {
                    nLevel = System.Convert.ToInt32(rgxLevel.Match(strResponse).Groups[1].Value);
                    string strNew = lblCurrentLevel.Tag.ToString().Replace("%1", rgxLevel.Match(strResponse).Groups[1].Value);
                    if (strNew != lblCurrentLevel.Text) lblCurrentLevel.Text = strNew;
                }
                if (rgxHitPoints.IsMatch(strResponse))
                {
                    nHitPoints = System.Convert.ToInt32(rgxHitPoints.Match(strResponse).Groups[1].Value);
                    string strNew = lblHitPoints.Tag.ToString().Replace("%1", rgxHitPoints.Match(strResponse).Groups[1].Value);
                    if (strNew != lblHitPoints.Text) lblHitPoints.Text = strNew;
                }
                if (rgxCoins.IsMatch(strResponse))
                {
                    nCoins = System.Convert.ToInt32(rgxCoins.Match(strResponse).Groups[1].Value);
                    string strNew = lblCoins.Tag.ToString().Replace("%1", rgxCoins.Match(strResponse).Groups[1].Value).Replace("%2", rgxCoins.Match(strResponse).Groups[2].Value);
                    if (strNew != lblCoins.Text) lblCoins.Text = strNew;
                }
                if (rgxDistance.IsMatch(strResponse))
                {
                    string strNew = lblDistance.Tag.ToString().Replace("%1", rgxDistance.Match(strResponse).Groups[1].Value);
                    if (strNew != lblDistance.Text) lblDistance.Text = strNew;
                }

                if (response.ResponseUri.AbsoluteUri == "http://apps.facebook.com/pirates/index.php" && setLowHealth == Setting_LowHealth.UseHam && GetPercentHealth() > -1 && GetPercentHealth() < setLowHealthPercent)
                {
                    LoadPage("Checking quantity of on-hand salted ham", true, "booty.php", new DoActionDelegate(CheckHam));
                    return;
                }

                Regex rgxEndOfLine = new Regex(@"You\'ve sailed ([0-9]*) nautical miles");
                if (rgxEndOfLine.IsMatch(strResponse))
                {
                    AddToActivityLog("Reached end of the line at " + rgxEndOfLine.Match(strResponse).Groups[1].Value + " miles", false);
                    Regex rgxDrinkRum = new Regex(@"Drink Rum \(x([0-9]*)\)\- sail an additional ([0-9]*) miles");
                    if (rgxDrinkRum.IsMatch(strResponse) && (setEndOfTheLine == Setting_EndOfTheLine.DrinkBuy || setEndOfTheLine == Setting_EndOfTheLine.DrinkStop))
                    {
                        int nBottles = System.Convert.ToInt32(rgxDrinkRum.Match(strResponse).Groups[1].Value) - 1;
                        LoadPage("Drinking rum (" + nBottles + " bottles left) to sail " + rgxDrinkRum.Match(strResponse).Groups[2].Value + " more miles", false, "item_action.php?item=rum", new DoActionDelegate(GoSailing));
                        return;
                    }

                    if (setEndOfTheLine == Setting_EndOfTheLine.Buy || setEndOfTheLine == Setting_EndOfTheLine.DrinkBuy)
                    {
                        LoadPage("Checking wench prices", true, "wenches.php", new DoActionDelegate(BuyWenches));
                        return;
                    }

                    AddToErrorLog("Can't sail anymore until the hour! (end of the line)", false);
                    return;
                }

                Regex rgxStormDamage = new Regex(@"Your ship was damaged (.*?)\!\<br \/\>Health -([0-9]*)");
                if (rgxStormDamage.IsMatch(strResponse))
                {
                    AddToActivityLog("Ship damaged " + rgxStormDamage.Match(strResponse).Groups[1].Value + ", lost " + rgxStormDamage.Match(strResponse).Groups[2].Value + " health", false);
                }

                Regex rgxStormLevel = new Regex(@"You were hit by a (.*?) but you survived\!\<br \/\>Your skills on the sea have increased\.\<br \/\>Level \+([0-9]*)\<p\>");
                if (rgxStormLevel.IsMatch(strResponse))
                {
                    AddToActivityLog("Survived a " + rgxStormLevel.Match(strResponse).Groups[1].Value + ", gained " + rgxStormLevel.Match(strResponse).Groups[2].Value + " level", false);
                }

                Dictionary<Regex, PageInfo> dctRegexes = new Dictionary<Regex, PageInfo>();
                dctRegexes.Add(new Regex(@"href\=" + "\"head_towards_land.php\""), new PageInfo("head_towards_land.php", "Exploring an island", true, new DoActionDelegate(ExploreIsland)));
                if (setBombs == Setting_Bombs.Never)
                {
                    dctRegexes.Add(new Regex(@"href\=" + "\"throw_bomb_pick.php\""), new PageInfo("clear_action.php", "Got bomb prompt, running away", true, new DoActionDelegate(GoSailing)));
                }
                else
                {
                    dctRegexes.Add(new Regex(@"href\=" + "\"throw_bomb_pick.php\""), new PageInfo("throw_bomb_pick.php", "Got bomb prompt", true, new DoActionDelegate(ThrowBomb)));
                }
                if (setBadWeather == Setting_BadWeather.TurnAround)
                {
                    dctRegexes.Add(new Regex(@"warning clouds sited"), new PageInfo("harbor.php", "Warning clouds sighted, running away", true, new DoActionDelegate(GoSailing)));
                }
                dctRegexes.Add(new Regex("Bad weather has destroyed your ship\\!"), new PageInfo("index.php", "Ship destroyed", false, new DoActionDelegate(GoSailing)));
                if (setEnemyShips == Setting_EnemyShips.Attack && GetPercentHealth() > setEnemyShipsPercent)
                {
                    dctRegexes.Add(new Regex(@"href\=" + "\"enemy_ship.php\""), new PageInfo("enemy_ship.php", "Enemy ship spotted", true, new DoActionDelegate(AttackShip)));
                }
                else
                {
                    dctRegexes.Add(new Regex(@"href\=" + "\"enemy_ship.php\""), new PageInfo("clear_action.php", "Enemy ship spotted, running away", true, new DoActionDelegate(GoSailing)));
                }
                dctRegexes.Add(new Regex(@"href\=" + "\"explore.php\\?d\\=north\""), new PageInfo("explore.php?d=north", "Going sailing", true, new DoActionDelegate(GoSailing)));
                dctRegexes.Add(new Regex(@"href\=" + "\"explore.php\\?d\\=south\""), new PageInfo("explore.php?d=south", "Going sailing", true, new DoActionDelegate(GoSailing)));
                dctRegexes.Add(new Regex(@"href\=" + "\"explore.php\""), new PageInfo("explore.php", "Going sailing", true, new DoActionDelegate(GoSailing)));

                foreach (Regex rgxRegex in dctRegexes.Keys)
                {
                    if (rgxRegex.IsMatch(strResponse))
                    {
                        LoadPage(dctRegexes[rgxRegex].Message, dctRegexes[rgxRegex].IsMinor, dctRegexes[rgxRegex].URL, dctRegexes[rgxRegex].Callback);
                        return;
                    }
                }

                AddToActivityLog("Unexpected page!", false);
                AddToErrorLog("URL = " + response.ResponseUri.AbsoluteUri + "\r\n" + strResponse.Replace("\n", "\r\n"), true);
            }
            catch (Exception ex)
            {
                HandleError(ex);
            }
        }

        private void DigUpCoinsBuyItem(RequestState state, WebResponse response, string strResponse)
        {
            try
            {
                Regex rgxStep1 = new Regex( @"\<form style\=" + "\"padding\\: 10px\"" + @" action\=" + "\"retrieve_coins\\.php\"" + @"\>" );
                if(rgxStep1.IsMatch( strResponse ))
                {
                    Regex rgxBuriedAmt = new Regex( @"Arrr\, you have ([0-9]*) coins buried\." );
                    if(rgxBuriedAmt.IsMatch( strResponse ))
                    {
                        if(System.Convert.ToInt32( rgxBuriedAmt.Match( strResponse ).Groups[ 1 ].Value ) < nDigAmt)
                        {
                            if(purchasetype == PurchaseType.Rum || purchasetype == PurchaseType.Wenches)
                            {
                                AddToErrorLog( "Can't sail anymore until the hour! (not enough money total)", true );
                                return;
                            }
                            else if(purchasetype == PurchaseType.Crew)
                            {
                                LoadPage("Unable to buy new crew member, not enough gold", false, "index.php", new DoActionDelegate(GoSailing));
                                return;
                            }
                            else if(purchasetype == PurchaseType.Level)
                            {
                                LoadPage("Not enough total gold to buy, going sailing", false, "index.php", new DoActionDelegate(GoSailing));
                                return;
                            }
                            else
                            {
                                LoadPage("Unable to dig up enough coins", false, "index.php", new DoActionDelegate(GoSailing));
                                return;
                            }
                        }
                    }
                    else
                    {
                        AddToErrorLog( "Unable to extract buried coin total\r\n\r\nResponse dump:\r\n" + strResponse, true );
                        return;
                    }

                    Dictionary<string, string> dctPOSTData = new Dictionary<string, string>();
                    bool bGood = true;
                    List<string> lstFields = new List<string>();
                    lstFields.Add( "fb_sig_time" );
                    lstFields.Add( "fb_sig_user" );
                    lstFields.Add( "fb_sig_profile_update_time" );
                    lstFields.Add( "fb_sig_session_key" );
                    lstFields.Add( "fb_sig_expires" );
                    lstFields.Add( "fb_sig_api_key" );
                    lstFields.Add( "fb_sig_added" );
                    lstFields.Add( "fb_sig" );
                    foreach(string strField in lstFields)
                    {
                        Regex rgxField = new Regex( @"\<input type\=" + "\"hidden\"" + @" name\=" + "\"" + strField + "\"" + @" value\=" + "\"(.*?)\"" + @" \/\>" );
                        if(rgxField.IsMatch( strResponse ))
                        {
                            dctPOSTData.Add( strField, rgxField.Match( strResponse ).Groups[ 1 ].Value );
                        }
                        else
                        {
                            bGood = false;
                            break;
                        }
                    }
                    if(bGood)
                    {
                        dctPOSTData.Add( "c", nDigAmt.ToString() );
                        LoadPage("Digging up " + nDigAmt.ToString() + " coins", false, "retrieve_coins.php", new DoActionDelegate(DigUpCoinsBuyItem), dctPOSTData);
                        return;
                    }
                }

                Regex rgxStep2 = new Regex( @"Ahoy\!\<br \/\>You dug up [0-9]* coins\." );
                if(rgxStep2.IsMatch( strResponse ))
                {
                    if(purchasetype == PurchaseType.Level)
                    {
                        dctNeededToLevel = null;
                        LoadPage("Buying a level", false, "level_up.php", new DoActionDelegate(BuyUpgrade));
                        return;
                    }
                    else
                    {
                        string strPurchName = purchasetype.ToString().ToLower();
                        LoadPage("Paying " + nDigPrice.ToString() + " coins for " + strPurchName, false, "buy.php?u=" + strPurchName, new DoActionDelegate(DigUpCoinsBuyItem));
                        return;
                    }
                }

                Regex rgxPaidRum = new Regex( @"Avast\!  You purchased rum for 50 coins\!" );
                if(rgxPaidRum.IsMatch( strResponse ))
                {
                    LoadPage("Drinking purchased rum", true, "item_action.php?item=rum", new DoActionDelegate(GoSailing));
                    return;
                }

                Regex rgxPaidWenches = new Regex( @"Avast\!  You purchased wenches for [0-9]* coins\!" );
                if(rgxPaidWenches.IsMatch( strResponse ))
                {
                    LoadPage("Finished purchasing wenches", true, "index.php", new DoActionDelegate(GoSailing));
                    return;
                }

                Regex rgxPaidCrew = new Regex( @"Avast\!  You purchased crew for [0-9]* coins\!" );
                if(rgxPaidCrew.IsMatch( strResponse ))
                {
                    nNumCrewCurrent++;
                    if(nNumCrewCurrent < nNumCrewStart)
                    {
                        LoadPage("Checking replacement crew member prices", true, "shipyard.php", new DoActionDelegate(BuyCrew));
                        return;
                    }
                    else
                    {
                        LoadPage("Finished purchasing crew", true, "index.php", new DoActionDelegate(GoSailing));
                        return;
                    }
                }

                GoSailing( state, response, strResponse );
            }
            catch(Exception ex)
            {
                HandleError(ex);
            }
        }

        private delegate void PromptLoginDelegate(string strChallenge, bool bFailure);
        private void PromptLogin(string strChallenge, bool bFailure)
        {
            if(this.InvokeRequired)
            {
                PromptLoginDelegate pld = new PromptLoginDelegate( PromptLogin );
                this.BeginInvoke( pld, new object[] { strChallenge, bFailure } );
                return;
            }

            AddToActivityLog( "Login required", false );

            if(Properties.Settings.Default.Username != "" && Properties.Settings.Default.Password != "" && !bFailure)
            {
                Dictionary<string, string> dctPOSTData = new Dictionary<string, string>();
                dctPOSTData.Add( "challenge", strChallenge );
                dctPOSTData.Add( "md5pass", "" );
                dctPOSTData.Add( "next", "" );
                dctPOSTData.Add( "email", Properties.Settings.Default.Username );
                dctPOSTData.Add( "pass", Properties.Settings.Default.Password );
                dctPOSTData.Add( "login", "Login" );
                LoadPage("Attempting to login as " + Properties.Settings.Default.Username, false, "https://login.facebook.com/login.php", new DoActionDelegate(TryLogin), dctPOSTData);
                return;
            }

            frmLogin dlg = new frmLogin();
            dlg.Username = Properties.Settings.Default.Username;
            if(dlg.ShowDialog( this ) == DialogResult.OK)
            {
                Properties.Settings.Default.Username = dlg.Username;
                if(dlg.Save)
                {
                    Properties.Settings.Default.Password = dlg.Password;
                }
                Properties.Settings.Default.Save();
                Properties.Settings.Default.Reload();

                Dictionary<string, string> dctPOSTData = new Dictionary<string, string>();
                dctPOSTData.Add( "challenge", strChallenge );
                dctPOSTData.Add( "md5pass", "" );
                dctPOSTData.Add( "next", "http://apps.facebook.com/pirates/index.php" );
                dctPOSTData.Add( "email", dlg.Username );
                dctPOSTData.Add( "pass", dlg.Password );
                dctPOSTData.Add( "login", "Login" );
                LoadPage("Attempting to login as " + dlg.Username, false, "https://login.facebook.com/login.php", new DoActionDelegate(TryLogin), dctPOSTData);
            }
            else
            {
                AddToErrorLog( "Login cancelled by user", true );
            }
        }

        private void TryLogin(RequestState state, WebResponse response, string strResponse)
        {
            try
            {
                Regex rgxRedirect = new Regex( @"\<title\>Redirecting\.\.\.\<\/title\>" );
                if(rgxRedirect.IsMatch( strResponse ))
                {
                    AddToActivityLog( "Login successful", true );
                    LoadPage("Going sailing", true, "index.php", new DoActionDelegate(GoSailing));
                }
                else
                {
                    AddToErrorLog( "Invalid username or password", false );
                    Regex rgxChallenge = new Regex( @"\<input type\=" + "\"hidden\"" + @" id\=" + "\"challenge\"" + @" name\=" + "\"challenge\"" + @" value\=" + "\"(.*?)\"" + @" \/\>" );
                    if(rgxChallenge.IsMatch( strResponse ))
                    {
                        PromptLogin( rgxChallenge.Match( strResponse ).Groups[ 1 ].Value, true );
                    }
                    else
                    {
                        AddToErrorLog( "Unable to extract challenge from login prompt\r\n\r\nResponse dump:\r\n" + strResponse, true );
                    }
                }
            }
            catch(Exception ex)
            {
                HandleError(ex);
            }
        }

        private void btnStart_Click(object sender, EventArgs e)
        {
            if(btnStart.Text == "&Stop")
            {
                strLastError = "";
                AddToErrorLog( "Program stopped by user", true );
            }
            else
            {
                m_bStop = false;
                btnStart.Text = "&Stop";
                btnStart.ImageKey = "Stop";
                mnuSysTrayStart.Text = "&Stop";
                mnuSysTrayStart.Image = imlStartStop.Images[ "Stop" ];
                ntiSysTrayIcon.Icon = Properties.Resources.RoboPirate;
                lblCurrentLevel.Text = "";
                lblHitPoints.Text = "";
                lblCoins.Text = "";
                lblDistance.Text = "";
                lsvActivityLog.Items.Clear();
                txtErrorLog.Text = "";
                tbcLogs.SelectedTab = tbpActivityLog;
                dctNeededToLevel = null;
                LoadPage("Accessing Facebook", true, "index.php", new DoActionDelegate(GoSailing));
            }
        }

        private void lsvActivityLog_KeyDown(object sender, KeyEventArgs e)
        {
            if(e.Control && e.KeyCode == Keys.C)
            {
                string strText = "";
                foreach(ListViewItem lviItem in lsvActivityLog.SelectedItems)
                {
                    strText += lviItem.Text + "\r\n";
                }
                Clipboard.SetText( strText, TextDataFormat.Text );
            }
        }

        private void frmMain_Resize(object sender, EventArgs e)
        {
            if(this.WindowState == FormWindowState.Minimized && setMinimize)
            {
                this.Hide();
                ntiSysTrayIcon.Visible = true;
            }
            else
            {
                if(this.WindowState != FormWindowState.Minimized) fwsLastState = this.WindowState;
                clhItem.Width = lsvActivityLog.ClientSize.Width;
            }
        }

        private void lsvActivityLog_MouseDown(object sender, MouseEventArgs e)
        {
            lsvActivityLog.Tag = true;
        }

        private void lsvActivityLog_MouseUp(object sender, MouseEventArgs e)
        {
            lsvActivityLog.Tag = false;
            ClearQueue();
        }

        private void btnSendLogs_Click(object sender, EventArgs e)
        {
            System.Net.Mail.MailMessage mail = new System.Net.Mail.MailMessage();
            mail.From = new System.Net.Mail.MailAddress( "joshua70448@gmail.com" );
            mail.To.Add( "joshua70448@gmail.com" );
            mail.Subject = "RoboPirate log dump";
            string strBody = "Timestamp: " + DateTime.Now.ToString() + "\r\n";
            strBody += "Version: " + System.Reflection.Assembly.GetExecutingAssembly().GetName().Version + "\r\n";
            strBody += "\r\nError Log:\r\n" + txtErrorLog.Text + "\r\n";
            strBody += "\r\nActivity Log:\r\n";
            foreach(ListViewItem lviItem in lsvActivityLog.Items)
            {
                strBody += lviItem.Text + "\r\n";
            }
            foreach(string strItem in lstActivityQueue)
            {
                strBody += strItem + "\r\n";
            }
            mail.Body = strBody;
            SMTP.SmtpDirect.SmtpServer = "jfsoftware.com";
            if(SMTP.SmtpDirect.Send( mail ))
            {
                MessageBox.Show( "Logs have been sent" );
            }
            else
            {
                Clipboard.SetText( strBody );
                MessageBox.Show( "Unable to send logs!  The log text has been copied to the Clipboard; please send the Clipboard contents (by pasting into your favorite mail program) to joshua70448@gmail.com." );
            }
        }

        private void ntiSysTrayIcon_DoubleClick(object sender, EventArgs e)
        {
            this.Show();
            ntiSysTrayIcon.Visible = false;
            WindowState = fwsLastState;
        }

        private void mnuSysTrayExit_Click(object sender, EventArgs e)
        {
            Application.Exit();
        }

        #region Utility functions
        private void AdvanceLoader()
        {
            nCurrentLoader++;
            if(nCurrentLoader > 8) nCurrentLoader = 1;
            switch(nCurrentLoader)
            {
                case 1:
                    pctLoader.Image = Properties.Resources.loader1;
                    break;
                case 2:
                    pctLoader.Image = Properties.Resources.loader2;
                    break;
                case 3:
                    pctLoader.Image = Properties.Resources.loader3;
                    break;
                case 4:
                    pctLoader.Image = Properties.Resources.loader4;
                    break;
                case 5:
                    pctLoader.Image = Properties.Resources.loader5;
                    break;
                case 6:
                    pctLoader.Image = Properties.Resources.loader6;
                    break;
                case 7:
                    pctLoader.Image = Properties.Resources.loader7;
                    break;
                case 8:
                    pctLoader.Image = Properties.Resources.loader8;
                    break;
            }
            pctLoader.Refresh();
        }

        private int GetPercentHealth()
        {
            if(nLevel <= 0 || nHitPoints == -1) return -1;
            return (int)(((double)nHitPoints / (double)nLevel) * 100);
        }

        private void LoadPage(string strLogMsg, bool bMinor, string strURL, DoActionDelegate callback)
        {
            LoadPage( strLogMsg, bMinor, strURL, callback, new Dictionary<string, string>() );
        }

        private void LoadPage(string strLogMsg, bool bMinor, string strURL, DoActionDelegate callback, Dictionary<string, string> dctPOSTData)
        {
            if(m_bStop) return;
            if(dctPOSTData == null) dctPOSTData = new Dictionary<string, string>();
            if(strLogMsg != "") AddToActivityLog( strLogMsg, bMinor );
            if (strURL.Substring(0, 7) != "http://" && strURL.Substring(0, 8) != "https://") strURL = "http://apps.facebook.com/pirates/" + strURL;
            HttpWebRequest request = HttpWebRequest.Create( strURL ) as HttpWebRequest;
            request.UserAgent = "Mozilla/4.0 (compatible; MSIE 6.0; Windows NT 5.1)";
            request.CookieContainer = new CookieContainer();
            if(cookies != null && cookies.Count > 0) request.CookieContainer.Add( cookies );
            string strPOSTData = "";
            if(dctPOSTData.Count > 0)
            {
                foreach(string strName in dctPOSTData.Keys)
                {
                    if(strPOSTData != "") strPOSTData += "&";
                    strPOSTData += strName + "=" + dctPOSTData[ strName ];
                }
                byte[] postDataBytes = Encoding.UTF8.GetBytes( strPOSTData );
                request.Method = "POST";
                request.ContentType = "application/x-www-form-urlencoded";
                request.ContentLength = postDataBytes.Length;
                Stream requestStream = request.GetRequestStream();
                requestStream.Write( postDataBytes, 0, postDataBytes.Length );
                requestStream.Close();
            }

            RequestState state = new RequestState( request, strURL, callback, dctPOSTData );
            IAsyncResult result = request.BeginGetResponse(new AsyncCallback(TakeAsync), state);
            System.Threading.ThreadPool.RegisterWaitForSingleObject( result.AsyncWaitHandle,
                new System.Threading.WaitOrTimerCallback( ScanTimeoutCallback ), state, (10 * 1000), true );
        }

        private void ScanTimeoutCallback(object reqstate, bool timedOut)
        {
            if(timedOut)
            {
                RequestState state = (RequestState)reqstate;
                if(state != null)
                {
                    state.NumTries++;
                    state.Request.Abort();
                    if(state.NumTries < 3)
                    {
                        LoadPage( "Retrying download (timeout)", false, state.URL, state.Callback, state.Data );
                    }
                    else
                    {
                        AddToErrorLog( "Unable to contact Facebook server; tried 3 times with no response", true );
                    }
                }
            }
        }

        private delegate void AddToActivityLogDelegate(string strItem, bool bMinor);
        private void AddToActivityLog(string strItem, bool bMinor)
        {
            if(bMinor && setHideMessages) return;

            if(this.InvokeRequired)
            {
                AddToActivityLogDelegate atald = new AddToActivityLogDelegate( AddToActivityLog );
                this.BeginInvoke( atald, new object[] { strItem, bMinor } );
                return;
            }

            if((bool)lsvActivityLog.Tag)
            {
                lstActivityQueue.Add( strItem );
            }
            else
            {
                lsvActivityLog.Items.Add( strItem );
                while(lsvActivityLog.Items.Count > setMaxLogSize)
                {
                    lsvActivityLog.Items.RemoveAt( 0 );
                }
                if(lsvActivityLog.Items.Count > 0) lsvActivityLog.EnsureVisible( lsvActivityLog.Items.Count - 1 );
                lsvActivityLog.Refresh();
            }
        }

        private void ClearQueue()
        {
            foreach(string strItem in lstActivityQueue)
            {
                lsvActivityLog.Items.Add( strItem );
            }
            while(lsvActivityLog.Items.Count > setMaxLogSize)
            {
                lsvActivityLog.Items.RemoveAt( 0 );
            }
            if(lsvActivityLog.Items.Count > 0) lsvActivityLog.EnsureVisible( lsvActivityLog.Items.Count - 1 );
            lsvActivityLog.Refresh();
        }

        private delegate void AddToErrorLogDelegate(string strItem, bool bStopped);
        private void AddToErrorLog(string strItem, bool bStopped)
        {
            if(this.InvokeRequired)
            {
                AddToErrorLogDelegate ateld = new AddToErrorLogDelegate( AddToErrorLog );
                this.BeginInvoke( ateld, new object[] { strItem, bStopped } );
                return;
            }

            txtErrorLog.Text += strItem + "\r\n";
            txtErrorLog.SelectionStart = txtErrorLog.Text.Length - 1;
            txtErrorLog.ScrollToCaret();
            if(bStopped)
            {
                AddToActivityLog( "Routine ended; see error log for details", false );
                if(btnStart.Text == "&Stop")
                {
                    strLastError = strItem.Split( new string[] { "\r\n" }, StringSplitOptions.RemoveEmptyEntries )[ 0 ];
                    m_bStop = true;
                    btnStart.Text = "&Starrrrrrrt";
                    btnStart.ImageKey = "Start";
                    mnuSysTrayStart.Text = "&Start";
                    mnuSysTrayStart.Image = imlStartStop.Images["Start"];
                    ntiSysTrayIcon.Icon = Properties.Resources.RoboPirateError;
                }
            }
        }
        #endregion

        #region Settings functions
        private void LoadSettings()
        {
            m_bLoading = true;
            setBadWeather = (Setting_BadWeather)Enum.Parse( typeof( Setting_BadWeather ), Properties.Settings.Default.BadWeather );
            setBombs = (Setting_Bombs)Enum.Parse( typeof( Setting_Bombs ), Properties.Settings.Default.Bombs );
            setEnemyIslands = (Setting_EnemyIslands)Enum.Parse( typeof( Setting_EnemyIslands ), Properties.Settings.Default.EnemyIslands );
            setDesertIslands = (Setting_DesertIslands)Enum.Parse( typeof( Setting_DesertIslands ), Properties.Settings.Default.DesertIslands );
            setEndOfTheLine = (Setting_EndOfTheLine)Enum.Parse( typeof( Setting_EndOfTheLine ), Properties.Settings.Default.EndOfTheLine );
            setCrewLosses = (Setting_CrewLosses)Enum.Parse( typeof( Setting_CrewLosses ), Properties.Settings.Default.CrewLosses );
            setEnemyShips = (Setting_EnemyShips)Enum.Parse( typeof( Setting_EnemyShips ), Properties.Settings.Default.EnemyShips );
            setLowHealth = (Setting_LowHealth)Enum.Parse( typeof( Setting_LowHealth ), Properties.Settings.Default.LowHealth );
            setLevelUpgrades = (Setting_LevelUpgrades)Enum.Parse( typeof( Setting_LevelUpgrades ), Properties.Settings.Default.LevelUpgrades );
            setEnemyIslandsPercent = Properties.Settings.Default.EnemyIslandsPercent;
            setHideMessages = Properties.Settings.Default.HideMessages;
            setEndDigUp = Properties.Settings.Default.EndDigUp;
            setBombsTarget = Properties.Settings.Default.BombsTarget;
            setEnemyShipsPercent = Properties.Settings.Default.EnemyShipsPercent;
            setLowHealthPercent = Properties.Settings.Default.LowHealthPercent;
            setLowHealthBuy = Properties.Settings.Default.LowHealthBuy;
            setMaxLogSize = Properties.Settings.Default.MaxLogSize;
            setDesertCoin = Properties.Settings.Default.DesertCoin;
            setDesertCount = Properties.Settings.Default.DesertCount;
            setMinimize = Properties.Settings.Default.Minimize;

            SetRadioButton( grpBadWeather, setBadWeather );
            SetRadioButton( grpBombs, setBombs );
            SetRadioButton( grpEnemyIslands, setEnemyIslands );
            SetRadioButton( grpDesertIslands, setDesertIslands );
            SetRadioButton( grpEndOfTheLine, setEndOfTheLine );
            SetRadioButton( grpCrewLosses, setCrewLosses );
            SetRadioButton( grpEnemyShips, setEnemyShips );
            SetRadioButton( grpLowHealth, setLowHealth );
            SetRadioButton( grpLevelUpgrades, setLevelUpgrades );
            nudEnemyPercent.Value = (decimal)setEnemyIslandsPercent;
            chkHideMessages.Checked = setHideMessages;
            chkEndDigUp.Checked = setEndDigUp;
            txtBombsTarget.Text = setBombsTarget;
            nudEnemyShipsPercent.Value = (decimal)setEnemyShipsPercent;
            nudLowHealthPercent.Value = (decimal)setLowHealthPercent;
            chkLowHealthBuy.Checked = setLowHealthBuy;
            nudMaxLogSize.Value = (decimal)setMaxLogSize;
            nudDesertCoin.Value = (decimal)setDesertCoin;
            nudDesertCount.Value = (decimal)setDesertCount;
            chkMinimize.Checked = setMinimize;
            m_bLoading = false;
        }

        private void SaveSettings(object sender, EventArgs e)
        {
            SaveSettings();
            if(!m_bLoading)
            {
                if(sender == txtBombsTarget)
                {
                    rbtBombsSpecific.Checked = true;
                }
                if(sender == nudEnemyPercent)
                {
                    rbtEnemyAttack.Checked = true;
                }
                if(sender == rbtCrewMaintain || sender == rbtCrewNothing)
                {
                    if(rbtCrewMaintain.Checked) nNumCrewStart = -1;
                }
            }
        }

        private void SaveSettings()
        {
            if(m_bLoading) return;
            Properties.Settings.Default.BadWeather = GetGroupValue( grpBadWeather );
            Properties.Settings.Default.Bombs = GetGroupValue( grpBombs );
            Properties.Settings.Default.EnemyIslands = GetGroupValue( grpEnemyIslands );
            Properties.Settings.Default.DesertIslands = GetGroupValue( grpDesertIslands );
            Properties.Settings.Default.EndOfTheLine = GetGroupValue( grpEndOfTheLine );
            Properties.Settings.Default.CrewLosses = GetGroupValue( grpCrewLosses );
            Properties.Settings.Default.EnemyShips = GetGroupValue( grpEnemyShips );
            Properties.Settings.Default.LowHealth = GetGroupValue( grpLowHealth );
            Properties.Settings.Default.LevelUpgrades = GetGroupValue( grpLevelUpgrades );
            Properties.Settings.Default.EnemyIslandsPercent = (int)nudEnemyPercent.Value;
            Properties.Settings.Default.HideMessages = chkHideMessages.Checked;
            Properties.Settings.Default.EndDigUp = chkEndDigUp.Checked;
            Properties.Settings.Default.BombsTarget = txtBombsTarget.Text;
            Properties.Settings.Default.EnemyShipsPercent = (int)nudEnemyShipsPercent.Value;
            Properties.Settings.Default.LowHealthPercent = (int)nudLowHealthPercent.Value;
            Properties.Settings.Default.LowHealthBuy = chkLowHealthBuy.Checked;
            Properties.Settings.Default.MaxLogSize = (int)nudMaxLogSize.Value;
            Properties.Settings.Default.DesertCoin = (int)nudDesertCoin.Value;
            Properties.Settings.Default.DesertCount = (int)nudDesertCount.Value;
            Properties.Settings.Default.Minimize = chkMinimize.Checked;
            Properties.Settings.Default.Save();
            Properties.Settings.Default.Reload();

            setBadWeather = (Setting_BadWeather)Enum.Parse( typeof( Setting_BadWeather ), Properties.Settings.Default.BadWeather );
            setBombs = (Setting_Bombs)Enum.Parse( typeof( Setting_Bombs ), Properties.Settings.Default.Bombs );
            setEnemyIslands = (Setting_EnemyIslands)Enum.Parse( typeof( Setting_EnemyIslands ), Properties.Settings.Default.EnemyIslands );
            setDesertIslands = (Setting_DesertIslands)Enum.Parse( typeof( Setting_DesertIslands ), Properties.Settings.Default.DesertIslands );
            setEndOfTheLine = (Setting_EndOfTheLine)Enum.Parse( typeof( Setting_EndOfTheLine ), Properties.Settings.Default.EndOfTheLine );
            setCrewLosses = (Setting_CrewLosses)Enum.Parse( typeof( Setting_CrewLosses ), Properties.Settings.Default.CrewLosses );
            setEnemyShips = (Setting_EnemyShips)Enum.Parse( typeof( Setting_EnemyShips ), Properties.Settings.Default.EnemyShips );
            setLowHealth = (Setting_LowHealth)Enum.Parse( typeof( Setting_LowHealth ), Properties.Settings.Default.LowHealth );
            setLevelUpgrades = (Setting_LevelUpgrades)Enum.Parse( typeof( Setting_LevelUpgrades ), Properties.Settings.Default.LevelUpgrades );
            setEnemyIslandsPercent = Properties.Settings.Default.EnemyIslandsPercent;
            setHideMessages = Properties.Settings.Default.HideMessages;
            setEndDigUp = Properties.Settings.Default.EndDigUp;
            setBombsTarget = Properties.Settings.Default.BombsTarget;
            setEnemyShipsPercent = Properties.Settings.Default.EnemyShipsPercent;
            setLowHealthPercent = Properties.Settings.Default.LowHealthPercent;
            setLowHealthBuy = Properties.Settings.Default.LowHealthBuy;
            setMaxLogSize = Properties.Settings.Default.MaxLogSize;
            setDesertCoin = Properties.Settings.Default.DesertCoin;
            setDesertCount = Properties.Settings.Default.DesertCount;
            setMinimize = Properties.Settings.Default.Minimize;
        }

        private void SetRadioButton(GroupBox grpContainer, object value)
        {
            foreach(Control ctl in grpContainer.Controls)
            {
                if(ctl.GetType() == typeof( RadioButton ) && ctl.Tag != null)
                {
                    if(ctl.Tag.ToString() == value.ToString())
                    {
                        ((RadioButton)ctl).Checked = true;
                    }
                    else
                    {
                        ((RadioButton)ctl).Checked = false;
                    }
                }
            }
        }

        private string GetGroupValue(GroupBox grpContainer)
        {
            foreach(Control ctl in grpContainer.Controls)
            {
                if(ctl.GetType() == typeof( RadioButton ) && ctl.Tag != null)
                {
                    if(((RadioButton)ctl).Checked) return ctl.Tag.ToString();
                }
            }
            return "";
        }

        private void btnChangeSavedInfo_Click(object sender, EventArgs e)
        {
            frmLogin dlg = new frmLogin();
            dlg.Username = Properties.Settings.Default.Username;
            dlg.Save = true;
            if(dlg.ShowDialog( this ) == DialogResult.OK)
            {
                Properties.Settings.Default.Username = dlg.Username;
                if(dlg.Save)
                {
                    Properties.Settings.Default.Password = dlg.Password;
                }
                Properties.Settings.Default.Save();
                Properties.Settings.Default.Reload();
            }
        }

        private void btnRemoveSavedInfo_Click(object sender, EventArgs e)
        {
            Properties.Settings.Default.Username = "";
            Properties.Settings.Default.Password = "";
            Properties.Settings.Default.Save();
            Properties.Settings.Default.Reload();
            MessageBox.Show( "Saved login information removed!" );
        }
        #endregion

        private void lnkAbout_LinkClicked(object sender, LinkLabelLinkClickedEventArgs e)
        {
            ShellExecute( IntPtr.Zero, "open", "http://jfsoftware.com/product/82", "", "", ShowCommands.SW_SHOWNOACTIVATE );
        }

        private void ntiSysTrayIcon_Click(object sender, EventArgs e)
        {
            if(mbtLastTrayButton == MouseButtons.Right) return;
            if(m_bStop && strLastError != "")
            {
                ntiSysTrayIcon.BalloonTipIcon = ToolTipIcon.Error;
                ntiSysTrayIcon.BalloonTipTitle = "RoboPirate stopped!";
                ntiSysTrayIcon.BalloonTipText = strLastError;
            }
            else if(m_bStop)
            {
                ntiSysTrayIcon.BalloonTipIcon = ToolTipIcon.Info;
                ntiSysTrayIcon.BalloonTipTitle = "RoboPirate ready";
                ntiSysTrayIcon.BalloonTipText = "Right-click and select Start to begin";
            }
            else
            {
                ntiSysTrayIcon.BalloonTipIcon = ToolTipIcon.Info;
                ntiSysTrayIcon.BalloonTipTitle = "RoboPirate running";
                ntiSysTrayIcon.BalloonTipText = lblCurrentLevel.Text.Trim() + "\r\n" + lblHitPoints.Text.Trim() + "\r\n" + lblCoins.Text.Trim() + "\r\n" + lblDistance.Text.Trim();
            }
            ntiSysTrayIcon.ShowBalloonTip( 3000 );
        }

        private void ntiSysTrayIcon_MouseUp(object sender, MouseEventArgs e)
        {
            mbtLastTrayButton = e.Button;
        }

        private void cmsSysTray_Opening(object sender, CancelEventArgs e)
        {
            mnuSysTrayHeader.Text = this.Text;
        }
    }

    public enum PurchaseType
    {
        Wenches,
        Rum,
        Crew,
        Level
    }

    public enum Setting_BadWeather
    {
        TurnAround,
        KeepGoing
    }

    public enum Setting_Bombs
    {
        Never,
        Random,
        Specific
    }

    public enum Setting_EnemyIslands
    {
        Attack,
        Run
    }

    public enum Setting_DesertIslands
    {
        Look,
        Bury,
        Coin,
        Count
    }

    public enum Setting_EndOfTheLine
    {
        Stop,
        DrinkStop,
        DrinkBuy,
        Buy
    }

    public enum Setting_CrewLosses
    {
        Nothing,
        Maintain
    }

    public enum Setting_EnemyShips
    {
        Attack,
        Run
    }

    public enum Setting_LowHealth
    {
        Ignore,
        UseHam
    }

    public enum Setting_LevelUpgrades
    {
        Buy,
        DontBuy
    }

    public class RequestState
    {
        public WebRequest Request;
        public string URL;
        public frmMain.DoActionDelegate Callback;
        public Dictionary<string, string> Data = null;
        public int NumTries = 0;

        public RequestState(WebRequest Request, string URL, frmMain.DoActionDelegate Callback, Dictionary<string, string> Data)
        {
            this.Request = Request;
            this.URL = URL;
            this.Callback = Callback;
            this.Data = Data;
        }
    }

    public class CaptchaRequestState
    {
        public WebRequest Request;
        public string URL;
        public string ActionURL;
        public List<string> Images = null;
        public int NumTries = 0;

        public CaptchaRequestState(WebRequest Request, string URL, string ActionURL, List<string> Images)
        {
            this.Request = Request;
            this.URL = URL;
            this.ActionURL = ActionURL;
            this.Images = Images;
        }
    }

    public class PageInfo
    {
        public string URL;
        public string Message;
        public bool IsMinor;
        public frmMain.DoActionDelegate Callback;

        public PageInfo(string URL, string Message, bool IsMinor, frmMain.DoActionDelegate Callback)
        {
            this.URL = URL;
            this.Message = Message;
            this.IsMinor = IsMinor;
            this.Callback = Callback;
        }
    }
}