Imports System
Imports LcdStudio.CoreInterfaces

Public Class Plugin
    Inherits AbstractDataPlugin

    Public Overrides ReadOnly Property Serializable() As Boolean
        Get
            Return True
        End Get
    End Property

    Public Overrides ReadOnly Property ConfigType() As Type
        Get
            Return GetType(MySettings)
        End Get
    End Property

    Public Overrides ReadOnly Property ConfigPanel() As System.Windows.Forms.Control
        Get
            Return New UserControl1(CType(_settings, MySettings))
        End Get
    End Property

    Public Overrides Sub RegisterData(ByVal ds As IDataService)
        ds.RegisterVariable(Group, "AquaReader.LastUpdate", "AquaReader\LastUpdate")
        ds.RegisterVariable(Group, "AquaReader.Sensors.1", "AquaReader\Sensors\1")
        ds.RegisterVariable(Group, "AquaReader.Sensors.2", "AquaReader\Sensors\2")
        ds.RegisterVariable(Group, "AquaReader.Sensors.3", "AquaReader\Sensors\3")
        ds.RegisterVariable(Group, "AquaReader.Sensors.4", "AquaReader\Sensors\4")
        ds.RegisterVariable(Group, "AquaReader.Sensors.5", "AquaReader\Sensors\5")
        ds.RegisterVariable(Group, "AquaReader.Sensors.6", "AquaReader\Sensors\6")
        ds.RegisterVariable(Group, "AquaReader.Fans.1.RPM", "AquaReader\Fans\1\RPM")
        ds.RegisterVariable(Group, "AquaReader.Fans.2.RPM", "AquaReader\Fans\2\RPM")
        ds.RegisterVariable(Group, "AquaReader.Fans.3.RPM", "AquaReader\Fans\3\RPM")
        ds.RegisterVariable(Group, "AquaReader.Fans.4.RPM", "AquaReader\Fans\4\RPM")
        ds.RegisterVariable(Group, "AquaReader.Fans.1.Power", "AquaReader\Fans\1\Power")
        ds.RegisterVariable(Group, "AquaReader.Fans.2.Power", "AquaReader\Fans\2\Power")
        ds.RegisterVariable(Group, "AquaReader.Fans.3.Power", "AquaReader\Fans\3\Power")
        ds.RegisterVariable(Group, "AquaReader.Fans.4.Power", "AquaReader\Fans\4\Power")
        ds.RegisterVariable(Group, "AquaReader.Leds.1", "AquaReader\Leds\1")
        ds.RegisterVariable(Group, "AquaReader.Leds.2", "AquaReader\Leds\2")
        ds.RegisterVariable(Group, "AquaReader.Flows.1.Hour", "AquaReader\Flows\1\Hour")
        ds.RegisterVariable(Group, "AquaReader.Flows.1.Minute", "AquaReader\Flows\1\Minute")
        ds.RegisterVariable(Group, "AquaReader.Flows.2.Hour", "AquaReader\Flows\2\Hour")
        ds.RegisterVariable(Group, "AquaReader.Flows.2.Minute", "AquaReader\Flows\2\Minute")
        ds.RegisterVariable(Group, "AquaReader.Tubemeter.Level", "AquaReader\Tubemeter\Level")
        ds.RegisterVariable(Group, "AquaReader.Tubemeter.Wave", "AquaReader\Tubemeter\Wave")
        ds.RegisterVariable(Group, "AquaReader.PowerSensors.1", "AquaReader\PowerSensors\1")
        ds.RegisterVariable(Group, "AquaReader.PowerSensors.2", "AquaReader\PowerSensors\2")
        ds.RegisterVariable(Group, "AquaReader.AquaStreams.1.Voltage", "AquaReader\AquaStreams\1\Voltage")
        ds.RegisterVariable(Group, "AquaReader.AquaStreams.1.Current", "AquaReader\AquaStreams\1\Current")
        ds.RegisterVariable(Group, "AquaReader.AquaStreams.1.Power", "AquaReader\AquaStreams\1\Power")
        ds.RegisterVariable(Group, "AquaReader.AquaStreams.1.Frequency", "AquaReader\AquaStreams\1\Frequency")
        ds.RegisterVariable(Group, "AquaReader.AquaStreams.2.Voltage", "AquaReader\AquaStreams\2\Voltage")
        ds.RegisterVariable(Group, "AquaReader.AquaStreams.2.Current", "AquaReader\AquaStreams\2\Current")
        ds.RegisterVariable(Group, "AquaReader.AquaStreams.2.Power", "AquaReader\AquaStreams\2\Power")
        ds.RegisterVariable(Group, "AquaReader.AquaStreams.2.Frequency", "AquaReader\AquaStreams\2\Frequency")
        ds.RegisterVariable(Group, "AquaReader.Settings.LogPath", "AquaReader\Settings\LogPath")
        Me.UpdateInterval = 1000
        'Update every 1000ms (1 sec)
    End Sub

    Public Overrides Sub UpdateData(ByVal ds As IDataService)
        Dim mySet As MySettings = CType(_settings, MySettings)
        ds.SetValue("AquaReader.Settings.LogPath", mySet.LogPath)

        If Not System.IO.File.Exists(mySet.LogPath) Then
            ds.SetValue("AquaReader.LastUpdate", "Unable to read log file")
            ds.SetValue("AquaReader.Sensors.1", 0)
            ds.SetValue("AquaReader.Sensors.2", 0)
            ds.SetValue("AquaReader.Sensors.3", 0)
            ds.SetValue("AquaReader.Sensors.4", 0)
            ds.SetValue("AquaReader.Sensors.5", 0)
            ds.SetValue("AquaReader.Sensors.6", 0)
            ds.SetValue("AquaReader.Fans.1.RPM", 0)
            ds.SetValue("AquaReader.Fans.2.RPM", 0)
            ds.SetValue("AquaReader.Fans.3.RPM", 0)
            ds.SetValue("AquaReader.Fans.4.RPM", 0)
            ds.SetValue("AquaReader.Fans.1.Power", 0)
            ds.SetValue("AquaReader.Fans.2.Power", 0)
            ds.SetValue("AquaReader.Fans.3.Power", 0)
            ds.SetValue("AquaReader.Fans.4.Power", 0)
            ds.SetValue("AquaReader.Leds.1", 0)
            ds.SetValue("AquaReader.Leds.2", 0)
            ds.SetValue("AquaReader.Flows.1.Hour", 0)
            ds.SetValue("AquaReader.Flows.1.Minute", 0)
            ds.SetValue("AquaReader.Flows.2.Hour", 0)
            ds.SetValue("AquaReader.Flows.2.Minute", 0)
            ds.SetValue("AquaReader.Tubemeter.Level", 0)
            ds.SetValue("AquaReader.Tubemeter.Wave", 0)
            ds.SetValue("AquaReader.PowerSensors.1", 0)
            ds.SetValue("AquaReader.PowerSensors.2", 0)
            ds.SetValue("AquaReader.AquaStreams.1.Voltage", 0)
            ds.SetValue("AquaReader.AquaStreams.1.Current", 0)
            ds.SetValue("AquaReader.AquaStreams.1.Power", 0)
            ds.SetValue("AquaReader.AquaStreams.1.Frequency", 0)
            ds.SetValue("AquaReader.AquaStreams.2.Voltage", 0)
            ds.SetValue("AquaReader.AquaStreams.2.Current", 0)
            ds.SetValue("AquaReader.AquaStreams.2.Power", 0)
            ds.SetValue("AquaReader.AquaStreams.2.Frequency", 0)
        Else
            Dim fr As New System.IO.StreamReader(New System.IO.FileStream(mySet.LogPath, IO.FileMode.Open, IO.FileAccess.Read))
            Dim xmltext As String = fr.ReadToEnd()
            fr.Close()

            ds.SetValue("AquaReader.LastUpdate", readValue(xmltext, "date") + " " + readValue(xmltext, "time"))
            ds.SetValue("AquaReader.Sensors.1", readDecValue(xmltext, "sensor1", 2))
            ds.SetValue("AquaReader.Sensors.2", readDecValue(xmltext, "sensor2", 2))
            ds.SetValue("AquaReader.Sensors.3", readDecValue(xmltext, "sensor3", 2))
            ds.SetValue("AquaReader.Sensors.4", readDecValue(xmltext, "sensor4", 2))
            ds.SetValue("AquaReader.Sensors.5", readDecValue(xmltext, "sensor5", 2))
            ds.SetValue("AquaReader.Sensors.6", readDecValue(xmltext, "sensor6", 2))
            ds.SetValue("AquaReader.Fans.1.RPM", readIntValue(xmltext, "fan1rpm"))
            ds.SetValue("AquaReader.Fans.2.RPM", readIntValue(xmltext, "fan2rpm"))
            ds.SetValue("AquaReader.Fans.3.RPM", readIntValue(xmltext, "fan3rpm"))
            ds.SetValue("AquaReader.Fans.4.RPM", readIntValue(xmltext, "fan4rpm"))
            ds.SetValue("AquaReader.Fans.1.Power", readDecValue(xmltext, "fan1power", 2))
            ds.SetValue("AquaReader.Fans.2.Power", readDecValue(xmltext, "fan2power", 2))
            ds.SetValue("AquaReader.Fans.3.Power", readDecValue(xmltext, "fan3power", 2))
            ds.SetValue("AquaReader.Fans.4.Power", readDecValue(xmltext, "fan4power", 2))
            ds.SetValue("AquaReader.Leds.1", readDecValue(xmltext, "led1power", 2))
            ds.SetValue("AquaReader.Leds.2", readDecValue(xmltext, "led2power", 2))
            ds.SetValue("AquaReader.Flows.1.Hour", readDecValue(xmltext, "flow1hour", 4))
            ds.SetValue("AquaReader.Flows.1.Minute", readDecValue(xmltext, "flow1minute", 4))
            ds.SetValue("AquaReader.Flows.2.Hour", readDecValue(xmltext, "flow2hour", 4))
            ds.SetValue("AquaReader.Flows.2.Minute", readDecValue(xmltext, "flow2minute", 4))
            ds.SetValue("AquaReader.Tubemeter.Level", readDecValue(xmltext, "tubemeterlevel", 2))
            ds.SetValue("AquaReader.Tubemeter.Wave", readDecValue(xmltext, "tubemeterwave", 2))
            ds.SetValue("AquaReader.PowerSensors.1", readDecValue(xmltext, "powersensor1", 2))
            ds.SetValue("AquaReader.PowerSensors.2", readDecValue(xmltext, "powersensor2", 2))
            ds.SetValue("AquaReader.AquaStreams.1.Voltage", readDecValue(xmltext, "aquastream1voltage", 1))
            ds.SetValue("AquaReader.AquaStreams.1.Current", readIntValue(xmltext, "aquastream1current"))
            ds.SetValue("AquaReader.AquaStreams.1.Power", readDecValue(xmltext, "aquastream1power", 1))
            ds.SetValue("AquaReader.AquaStreams.1.Frequency", readIntValue(xmltext, "aquastream1frequence"))
            ds.SetValue("AquaReader.AquaStreams.2.Voltage", readDecValue(xmltext, "aquastream2voltage", 1))
            ds.SetValue("AquaReader.AquaStreams.2.Current", readIntValue(xmltext, "aquastream2current"))
            ds.SetValue("AquaReader.AquaStreams.2.Power", readDecValue(xmltext, "aquastream2power", 1))
            ds.SetValue("AquaReader.AquaStreams.2.Frequency", readIntValue(xmltext, "aquastream2frequence"))
        End If
    End Sub

    Public Function readValue(ByVal strFullText As String, ByVal strTag As String) As String
        Dim firstpos As Integer = strFullText.ToLower().IndexOf("<" + strTag.ToLower() + ">")
        If firstpos = -1 Then Return ""
        firstpos += strTag.Length + 2
        Dim secondpos As Integer = strFullText.ToLower().IndexOf("</" + strTag.ToLower() + ">", firstpos)
        If secondpos = -1 Then Return ""
        Return strFullText.Substring(firstpos, secondpos - firstpos)
    End Function

    Public Function readIntValue(ByVal strFullText As String, ByVal strTag As String) As Integer
        Dim firstpos As Integer = strFullText.ToLower().IndexOf("<" + strTag.ToLower() + ">")
        If firstpos = -1 Then Return ""
        firstpos += strTag.Length + 2
        Dim secondpos As Integer = strFullText.ToLower().IndexOf("</" + strTag.ToLower() + ">", firstpos)
        If secondpos = -1 Then Return ""
        If IsNumeric(strFullText.Substring(firstpos, secondpos - firstpos).Replace("-", "0")) Then
            Return CInt(strFullText.Substring(firstpos, secondpos - firstpos).Replace("-", "0"))
        Else
            Return 999999
        End If
    End Function

    Public Function readDecValue(ByVal strFullText As String, ByVal strTag As String, ByVal intNumDecPoints As Integer) As Decimal
        Dim firstpos As Integer = strFullText.ToLower().IndexOf("<" + strTag.ToLower() + ">")
        If firstpos = -1 Then Return ""
        firstpos += strTag.Length + 2
        Dim secondpos As Integer = strFullText.ToLower().IndexOf("</" + strTag.ToLower() + ">", firstpos)
        If secondpos = -1 Then Return ""
        If IsNumeric(strFullText.Substring(firstpos, secondpos - firstpos).Replace(",", "").Replace(".", "").Replace("-", "0")) Then
            Return CDec(CDec(strFullText.Substring(firstpos, secondpos - firstpos).Replace(",", "").Replace(".", "").Replace("-", "0")) / Math.Pow(10, intNumDecPoints))
        Else
            Return 999999
        End If
    End Function
End Class
