Imports System
Imports System.Collections
Imports System.ComponentModel
Imports System.Drawing
Imports System.Data
Imports System.Windows.Forms
Imports System.Xml
Imports System.IO
Imports Scripting

Public Class UserControl1
    Inherits System.Windows.Forms.UserControl

#Region " Windows Form Designer generated code "

    Public Sub New(ByVal settings As MySettings)
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call
        Me.SetStyle(ControlStyles.SupportsTransparentBackColor, True)
        Me.BackColor = Color.Transparent
        _settings = settings

        Dim dir As Directory
        Dim filelist() As String = dir.GetFiles(".", "bdt*.xml")
        Dim selitem As String = ""
        cmbLanguage.Items.Clear()
        cmbLanguage.Items.Add("Default: English")
        cmbLanguage.SelectedIndex = 0
        For Each filename As String In filelist
            Dim langcode As String = filename.Substring(5)
            langcode = langcode.Substring(0, langcode.IndexOf("."))
            Dim langname As String = getLangName(filename)
            If langname <> "" Then
                cmbLanguage.Items.Add(langname + " (" + langcode + ")")
                If langcode = settings.Language Then selitem = langname + " (" + langcode + ")"
            End If
        Next filename
        cmbLanguage.SelectedItem = selitem
        isready = True
    End Sub

    'UserControl overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents cmbLanguage As System.Windows.Forms.ComboBox
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.Label1 = New System.Windows.Forms.Label
        Me.cmbLanguage = New System.Windows.Forms.ComboBox
        Me.SuspendLayout()
        '
        'Label1
        '
        Me.Label1.AutoSize = True
        Me.Label1.Location = New System.Drawing.Point(8, 10)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(89, 16)
        Me.Label1.TabIndex = 1
        Me.Label1.Text = "Select language:"
        '
        'cmbLanguage
        '
        Me.cmbLanguage.DropDownStyle = System.Windows.Forms.ComboBoxStyle.DropDownList
        Me.cmbLanguage.Location = New System.Drawing.Point(96, 8)
        Me.cmbLanguage.Name = "cmbLanguage"
        Me.cmbLanguage.Size = New System.Drawing.Size(184, 21)
        Me.cmbLanguage.TabIndex = 2
        '
        'UserControl1
        '
        Me.Controls.Add(Me.cmbLanguage)
        Me.Controls.Add(Me.Label1)
        Me.Name = "UserControl1"
        Me.Size = New System.Drawing.Size(288, 240)
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private _settings As MySettings = Nothing
    Private isready As Boolean = False

    Private Sub cmbLanguage_SelectedIndexChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles cmbLanguage.SelectedIndexChanged
        If isready Then
            If cmbLanguage.Text = "Default: English" Then
                _settings.Language = ""
            Else
                Dim langcode As String = cmbLanguage.Text
                langcode = langcode.Substring(langcode.LastIndexOf("(") + 1)
                langcode = langcode.Substring(0, langcode.Length - 1)
                _settings.Language = langcode
            End If
        End If
    End Sub

    Function getLangName(ByVal strPath As String) As String
        Dim reader As XmlTextReader
        Try
            reader = New XmlTextReader(New FileStream(strPath, FileMode.Open))
        Catch ex As Exception
            Return ""
        End Try
        While reader.Name <> "root" And reader.EOF = False
            reader.Read()
        End While
        If reader.EOF Then Return ""
        Dim retstr As String = reader.GetAttribute("lang")
        reader.Close()
        Return retstr
    End Function
End Class
