Imports System
Imports LcdStudio.CoreInterfaces
Imports System.Resources
Imports System.Reflection
Imports System.Xml
Imports System.IO

Public Class Plugin
    Inherits AbstractDataPlugin

    Public Overrides ReadOnly Property Serializable() As Boolean
        Get
            Return True
        End Get
    End Property

    Public Overrides ReadOnly Property ConfigType() As Type
        Get
            Return GetType(MySettings)
        End Get
    End Property

    Public Overrides ReadOnly Property ConfigPanel() As System.Windows.Forms.Control
        Get
            Return New UserControl1(CType(_settings, MySettings))
        End Get
    End Property

    Public Overrides Sub RegisterData(ByVal ds As IDataService)
        Dim mySet As MySettings = CType(_settings, MySettings)
        ds.RegisterVariable(Group, "BetterDateTime.Time.Hour12", "BetterDateTime\Time\Hour12")
        ds.RegisterVariable(Group, "BetterDateTime.Time.Hour24", "BetterDateTime\Time\Hour24")
        ds.RegisterVariable(Group, "BetterDateTime.Time.Minute", "BetterDateTime\Time\Minute")
        ds.RegisterVariable(Group, "BetterDateTime.Time.Second", "BetterDateTime\Time\Second")
        ds.RegisterVariable(Group, "BetterDateTime.Time.AMPM", "BetterDateTime\Time\AMPM")
        ds.RegisterVariable(Group, "BetterDateTime.Date.Month", "BetterDateTime\Date\Month")
        ds.RegisterVariable(Group, "BetterDateTime.Date.MonthNameLong", "BetterDateTime\Date\MonthNameLong")
        ds.RegisterVariable(Group, "BetterDateTime.Date.MonthNameShort", "BetterDateTime\Date\MonthNameShort")
        ds.RegisterVariable(Group, "BetterDateTime.Date.Day", "BetterDateTime\Date\Day")
        ds.RegisterVariable(Group, "BetterDateTime.Date.DayOfWeek", "BetterDateTime\Date\DayOfWeek")
        ds.RegisterVariable(Group, "BetterDateTime.Date.DayOfWeekNameLong", "BetterDateTime\Date\DayOfWeekNameLong")
        ds.RegisterVariable(Group, "BetterDateTime.Date.DayOfWeekNameShort", "BetterDateTime\Date\DayOfWeekNameShort")
        ds.RegisterVariable(Group, "BetterDateTime.Date.DayOfYear", "BetterDateTime\Date\DayOfYear")
        ds.RegisterVariable(Group, "BetterDateTime.Date.Year4", "BetterDateTime\Date\Year4")
        ds.RegisterVariable(Group, "BetterDateTime.Date.Year2", "BetterDateTime\Date\Year2")
        ds.RegisterVariable(Group, "BetterDateTime.Date.NumberDaysInMonth", "BetterDateTime\Date\NumberDaysInMonth")
        ds.RegisterVariable(Group, "BetterDateTime.Date.IsLeapYear", "BetterDateTime\Date\IsLeapYear")
        ds.RegisterVariable(Group, "BetterDateTime.Settings.Language", "BetterDateTime\Settings\Language")
        Me.UpdateInterval = 1000
        'Update every 1000ms (1 sec)
    End Sub

    Public Overrides Sub UpdateData(ByVal ds As IDataService)
        Dim mySet As MySettings = CType(_settings, MySettings)
        ds.SetValue("BetterDateTime.Settings.Language", mySet.Language)
        ds.SetValue("BetterDateTime.Time.Hour12", IIf(Now.Hour = 0, 12, IIf(Now.Hour > 12, Format(Now.Hour - 12, "00"), Format(Now.Hour, "00"))))
        ds.SetValue("BetterDateTime.Time.Hour24", Format(Now.Hour, "00"))
        ds.SetValue("BetterDateTime.Time.Minute", Format(Now.Minute, "00"))
        ds.SetValue("BetterDateTime.Time.Second", Format(Now.Second, "00"))
        ds.SetValue("BetterDateTime.Time.AMPM", IIf(Now.Hour < 12, "AM", "PM"))
        ds.SetValue("BetterDateTime.Date.Month", Now.Month)
        ds.SetValue("BetterDateTime.Date.MonthNameLong", getLongMonth(mySet.Language, Now.Month))
        ds.SetValue("BetterDateTime.Date.MonthNameShort", getShortMonth(mySet.Language, Now.Month))
        ds.SetValue("BetterDateTime.Date.Day", Now.Day)
        ds.SetValue("BetterDateTime.Date.DayOfWeek", CInt(Now.DayOfWeek) + 1)
        ds.SetValue("BetterDateTime.Date.DayOfWeekNameLong", getLongWeek(mySet.Language, CInt(Now.DayOfWeek) + 1))
        ds.SetValue("BetterDateTime.Date.DayOfWeekNameShort", getShortWeek(mySet.Language, CInt(Now.DayOfWeek) + 1))
        ds.SetValue("BetterDateTime.Date.DayOfYear", Now.DayOfYear)
        ds.SetValue("BetterDateTime.Date.Year4", Now.Year)
        ds.SetValue("BetterDateTime.Date.Year2", Right(CStr(Now.Year), 2))
        ds.SetValue("BetterDateTime.Date.NumberDaysInMonth", Date.DaysInMonth(Now.Year, Now.Month))
        ds.SetValue("BetterDateTime.Date.IsLeapYear", Date.IsLeapYear(Now.Year))
    End Sub

    Function getShortMonth(ByVal strLangCode As String, ByVal intMonthNum As Integer) As String
        If strLangCode = "" Then
            Select Case intMonthNum
                Case 1
                    Return "Jan"
                Case 2
                    Return "Feb"
                Case 3
                    Return "Mar"
                Case 4
                    Return "Apr"
                Case 5
                    Return "May"
                Case 6
                    Return "Jun"
                Case 7
                    Return "Jul"
                Case 8
                    Return "Aug"
                Case 9
                    Return "Sep"
                Case 10
                    Return "Oct"
                Case 11
                    Return "Nov"
                Case 12
                    Return "Dec"
            End Select
        End If
        Dim retstr As String = getValue(strLangCode, "month", "short" + CStr(intMonthNum))
        Return retstr
    End Function

    Function getLongMonth(ByVal strLangCode As String, ByVal intMonthNum As Integer) As String
        If strLangCode = "" Then
            Select Case intMonthNum
                Case 1
                    Return "January"
                Case 2
                    Return "February"
                Case 3
                    Return "March"
                Case 4
                    Return "April"
                Case 5
                    Return "May"
                Case 6
                    Return "June"
                Case 7
                    Return "July"
                Case 8
                    Return "August"
                Case 9
                    Return "September"
                Case 10
                    Return "October"
                Case 11
                    Return "November"
                Case 12
                    Return "December"
            End Select
        End If
        Dim retstr As String = getValue(strLangCode, "month", "long" + CStr(intMonthNum))
        Return retstr
    End Function

    Function getShortWeek(ByVal strLangCode As String, ByVal intWeekNum As Integer) As String
        If strLangCode = "" Then
            Select Case intWeekNum
                Case 1
                    Return "Sun"
                Case 2
                    Return "Mon"
                Case 3
                    Return "Tue"
                Case 4
                    Return "Wed"
                Case 5
                    Return "Thu"
                Case 6
                    Return "Fri"
                Case 7
                    Return "Sat"
            End Select
        End If
        Dim retstr As String = getValue(strLangCode, "week", "short" + CStr(intWeekNum))
        Return retstr
    End Function

    Function getLongWeek(ByVal strLangCode As String, ByVal intWeekNum As Integer) As String
        If strLangCode = "" Then
            Select Case intWeekNum
                Case 1
                    Return "Sunday"
                Case 2
                    Return "Monday"
                Case 3
                    Return "Tuesday"
                Case 4
                    Return "Wednesday"
                Case 5
                    Return "Thursday"
                Case 6
                    Return "Friday"
                Case 7
                    Return "Saturday"
            End Select
        End If
        Dim retstr As String = getValue(strLangCode, "week", "long" + CStr(intWeekNum))
        Return retstr
    End Function

    Function getValue(ByVal strLangCode As String, ByVal strGroupName As String, ByVal strDataName As String) As String
        Dim reader As XmlTextReader
        Try
            reader = New XmlTextReader(New FileStream(".\BDT" + strLangCode + ".xml", FileMode.Open))
        Catch ex As Exception
            Return ""
        End Try
        While reader.GetAttribute("type") <> strGroupName And reader.EOF = False
            reader.Read()
        End While
        If reader.EOF Then Return ""
        While reader.GetAttribute("name") <> strDataName And reader.EOF = False
            reader.Read()
        End While
        If reader.EOF Then Return ""
        While reader.Name <> "value" And reader.EOF = False
            reader.Read()
        End While
        If reader.EOF Then Return ""
        Dim retstr As String = reader.ReadElementString()
        reader.Close()
        Return retstr
    End Function
End Class
