Imports System.Runtime.InteropServices
Imports System.Reflection
Imports System.Drawing
Imports System.Threading
Imports LcdStudio.CoreInterfaces

Module KeyHook
    Public Declare Function UnhookWindowsHookEx Lib "user32" _
      (ByVal hHook As Integer) As Integer

    Public Declare Function SetWindowsHookEx Lib "user32" _
      Alias "SetWindowsHookExA" (ByVal idHook As Integer, _
      ByVal lpfn As KeyboardHookDelegate, ByVal hmod As Integer, _
      ByVal dwThreadId As Integer) As Integer

    Private Declare Function GetAsyncKeyState Lib "user32" _
      (ByVal vKey As Integer) As Integer

    Private Declare Function CallNextHookEx Lib "user32" _
      (ByVal hHook As Integer, _
      ByVal nCode As Integer, _
      ByVal wParam As Integer, _
      ByVal lParam As KBDLLHOOKSTRUCT) As Integer

    Public Structure KBDLLHOOKSTRUCT
        Public vkCode As Integer
        Public scanCode As Integer
        Public flags As Integer
        Public time As Integer
        Public dwExtraInfo As Integer
    End Structure

    Public Enum keynames
        BACKSPACE = 8
        TAB = 9
        NUMPAD_5_OFF = 12
        ENTER = 13
        PAUSE = 19
        CAPS_LOCK = 20
        ESCAPE = 27
        SPACE = 32
        PAGE_UP = 33
        PAGE_DOWN = 34
        END_KEY = 35
        HOME = 36
        LEFT_ARROW = 37
        UP_ARROW = 38
        RIGHT_ARROW = 39
        DOWN_ARROW = 40
        PRINT_SCREEN = 44
        INSERT = 45
        DELETE = 46
        NUMBER_0 = 48
        NUMBER_1 = 49
        NUMBER_2 = 50
        NUMBER_3 = 51
        NUMBER_4 = 52
        NUMBER_5 = 53
        NUMBER_6 = 54
        NUMBER_7 = 55
        NUMBER_8 = 56
        NUMBER_9 = 57
        A = 65
        B = 66
        C = 67
        D = 68
        E = 69
        F = 70
        G = 71
        H = 72
        I = 73
        J = 74
        K = 75
        L = 76
        M = 77
        N = 78
        O = 79
        P = 80
        Q = 81
        R = 82
        S = 83
        T = 84
        U = 85
        V = 86
        W = 87
        X = 88
        Y = 89
        Z = 90
        LEFT_WIN = 91
        RIGHT_WIN = 92
        CONTEXT = 93
        NUMPAD_0 = 96
        NUMPAD_1 = 97
        NUMPAD_2 = 98
        NUMPAD_3 = 99
        NUMPAD_4 = 100
        NUMPAD_5 = 101
        NUMPAD_6 = 102
        NUMPAD_7 = 103
        NUMPAD_8 = 104
        NUMPAD_9 = 105
        NUMPAD_MULTIPLY = 106
        NUMPAD_ADD = 107
        NUMPAD_SUBTRACT = 109
        NUMPAD_DECIMAL = 110
        NUMPAD_DIVIDE = 111
        F1 = 112
        F2 = 113
        F3 = 114
        F4 = 115
        F5 = 116
        F6 = 117
        F7 = 118
        F8 = 119
        F9 = 120
        F10 = 121
        F11 = 122
        F12 = 123
        F13 = 124
        F14 = 125
        F15 = 126
        F16 = 127
        F17 = 128
        F18 = 129
        F19 = 130
        F20 = 131
        F21 = 132
        F22 = 133
        F23 = 134
        F24 = 135
        NUM_LOCK = 144
        SCROLL_LOCK = 145
        BROWSER_BACK = 166
        BROWSER_FORWARD = 167
        BROWSER_REFRESH = 168
        BROWSER_STOP = 169
        BROWSER_SEARCH = 170
        BROWSER_FAVORITES = 171
        BROWSER_HOME = 172
        MEDIA_MUTE = 173
        MEDIA_VOL_DOWN = 174
        MEDIA_VOL_UP = 175
        MEDIA_NEXT_TRACK = 176
        MEDIA_PREV_TRACK = 177
        MEDIA_STOP = 178
        MEDIA_PLAY_PAUSE = 179
        LAUNCH_MAIL = 180
        LAUNCH_MEDIA = 181
        LAUNCH_APP1 = 182
        LAUNCH_APP2 = 183
        SEMICOLON = 186
        PLUS = 187
        COMMA = 188
        MINUS = 189
        PERIOD = 190
        QUESTION_MARK = 191
        TILDE = 192
        BRACKET_LEFT = 219
        BACKSLASH = 220
        BRACKET_RIGHT = 221
        QUOTE = 222
        OEM_8 = 223
        OEM_102 = 226
    End Enum

    ' Low-Level Keyboard Constants
    Private Const HC_ACTION As Integer = 0

    Private Const WH_KEYBOARD_LL As Integer = 13&
    Public KeyboardHandle As Integer

    Public keynamelist(256) As String
    Public curval1 As String = ""
    Public curval2 As String = ""
    Public curoper As String = ""
    Public display As String = "0"
    Public isactive As Boolean = False
    Public lastoper As String = ""
    Public lastvalue As String = ""

    Public Const FLAG_SHIFT As Integer = 1
    Public Const FLAG_ALT As Integer = 2
    Public Const FLAG_CTRL As Integer = 4

    Public isshiftdown As Boolean = False
    Public isctrldown As Boolean = False
    Public isaltdown As Boolean = False

    Public setflag_toggle As Boolean = False
    Public toggle_keycode As Integer = -1
    Public toggle_keyflags As Integer = 0

    ' Implement this function to block as many
    ' key combinations as you'd like
    Public Function IsHooked(ByRef Hookstruct As KBDLLHOOKSTRUCT) As Boolean
        Dim pressed As Boolean
        If Hookstruct.flags And 128 Then pressed = False Else pressed = True
        Dim flags As Integer
        If isshiftdown Then flags += FLAG_SHIFT
        If isctrldown Then flags += FLAG_CTRL
        If isaltdown Then flags += FLAG_ALT
        Dim blockthiskey As Boolean = isactive

        If Hookstruct.vkCode <> 160 And Hookstruct.vkCode <> 161 And Hookstruct.vkCode <> 162 And Hookstruct.vkCode <> 163 And Hookstruct.vkCode <> 164 And Hookstruct.vkCode <> 165 And pressed Then
            If setflag_toggle Then
                toggle_keycode = Hookstruct.vkCode
                toggle_keyflags = flags
                setflag_toggle = False
                Return True
            End If

            If Hookstruct.vkCode = toggle_keycode And flags = toggle_keyflags Then
                isactive = Not isactive
                If Not isactive Then blockthiskey = True
            End If

            If isactive Then
                Dim curbutton As String = "~"

                If Hookstruct.vkCode >= keynames.NUMBER_0 And Hookstruct.vkCode <= keynames.NUMBER_9 Then curbutton = CStr(Hookstruct.vkCode - keynames.NUMBER_0)
                If Hookstruct.vkCode >= keynames.NUMPAD_0 And Hookstruct.vkCode <= keynames.NUMPAD_9 Then curbutton = CStr(Hookstruct.vkCode - keynames.NUMPAD_0)
                If Hookstruct.vkCode = keynames.NUMPAD_5_OFF Then curbutton = "5"
                If Hookstruct.vkCode = keynames.PERIOD Or Hookstruct.vkCode = keynames.NUMPAD_DECIMAL Then curbutton = "."
                If Hookstruct.vkCode = keynames.ENTER Or (Hookstruct.vkCode = keynames.PLUS And Not isshiftdown) Then curbutton = "="
                If Hookstruct.vkCode = (keynames.QUESTION_MARK And Not isshiftdown) Or Hookstruct.vkCode = keynames.NUMPAD_DIVIDE Then curbutton = "/"
                If Hookstruct.vkCode = (keynames.NUMBER_8 And isshiftdown) Or Hookstruct.vkCode = keynames.X Or Hookstruct.vkCode = keynames.NUMPAD_MULTIPLY Then curbutton = "*"
                If Hookstruct.vkCode = (keynames.MINUS And Not isshiftdown) Or Hookstruct.vkCode = keynames.NUMPAD_SUBTRACT Then curbutton = "-"
                If Hookstruct.vkCode = (keynames.PLUS And isshiftdown) Or Hookstruct.vkCode = keynames.NUMPAD_ADD Then curbutton = "+"
                If Hookstruct.vkCode = keynames.ESCAPE Then curbutton = "C"
                If Hookstruct.vkCode = keynames.BACKSPACE Then curbutton = "B"

                If curbutton = "=" And curoper = "=" Then repeatOperation()
                If curbutton = "C" Then
                    curval1 = ""
                    curval2 = ""
                    curoper = ""
                    lastvalue = ""
                    lastoper = ""
                End If
                If curbutton = "B" And curoper <> "=" Then
                    If curoper <> "" Then
                        If curval2.Length > 0 Then curval2 = Left(curval2, curval2.Length - 1)
                    Else
                        If curval1.Length > 0 Then curval1 = Left(curval1, curval1.Length - 1)
                    End If
                End If
                If Asc(curbutton) >= 48 And Asc(curbutton) <= 57 Then
                    If curoper <> "" Then
                        If curoper = "=" Then
                            curval1 = curbutton
                            curval2 = ""
                            curoper = ""
                            lastvalue = ""
                            lastoper = ""
                        Else
                            curval2 += curbutton
                        End If
                    Else
                        curval1 += curbutton
                    End If
                End If
                If curbutton = "+" Or curbutton = "-" Or curbutton = "/" Or curbutton = "*" Or (curbutton = "=" And curoper <> "=") Then
                    If curoper <> "" Then executeOperation()
                    curoper = curbutton
                End If
                If curbutton = "." Then
                    If curoper <> "" Then
                        If curval2.IndexOf(".") = -1 Then curval2 += "."
                    Else
                        If curval1.IndexOf(".") = -1 Then curval1 += "."
                    End If
                End If

                If curoper <> "" Then
                    If curval2 <> "" Then
                        display = curval2
                    Else
                        If curval1 <> "" Then
                            display = curval1
                        Else
                            display = "0"
                        End If
                    End If
                Else
                        If curval1 <> "" Then
                            display = curval1
                        Else
                            display = "0"
                        End If
                End If
            End If
        End If

        If Hookstruct.vkCode = 160 Or Hookstruct.vkCode = 161 Then isshiftdown = pressed
        If Hookstruct.vkCode = 162 Or Hookstruct.vkCode = 163 Then isctrldown = pressed
        If Hookstruct.vkCode = 164 Or Hookstruct.vkCode = 165 Then isaltdown = pressed

        Return isactive
    End Function

    Public Function KeyboardCallback(ByVal Code As Integer, _
      ByVal wParam As Integer, _
      ByRef lParam As KBDLLHOOKSTRUCT) As Integer

        If (Code = HC_ACTION) Then
            If (IsHooked(lParam)) Then
                Return 1
            End If

        End If

        Return CallNextHookEx(KeyboardHandle, _
          Code, wParam, lParam)

    End Function

    Public Delegate Function KeyboardHookDelegate( _
      ByVal Code As Integer, _
      ByVal wParam As Integer, ByRef lParam As KBDLLHOOKSTRUCT) _
                   As Integer

    <MarshalAs(UnmanagedType.FunctionPtr)> _
    Private callback As KeyboardHookDelegate

    Public Sub HookKeyboard()
        callback = New KeyboardHookDelegate(AddressOf KeyboardCallback)

        KeyboardHandle = SetWindowsHookEx( _
          WH_KEYBOARD_LL, callback, _
          Marshal.GetHINSTANCE( _
          [Assembly].GetExecutingAssembly.GetModules()(0)).ToInt32, 0)
    End Sub

    Private Function Hooked()
        Hooked = KeyboardHandle <> 0
    End Function

    Public Sub UnhookKeyboard()
        If (Hooked()) Then
            Call UnhookWindowsHookEx(KeyboardHandle)
        End If
    End Sub

    Public Sub executeOperation()
        If curoper = "" Then Exit Sub
        Dim decval1, decval2 As Decimal
        If curval1 <> "" Then decval1 = CDec(curval1)
        If curval2 <> "" Then decval2 = CDec(curval2)
        If curoper = "+" Then curval1 = CStr(decval1 + decval2)
        If curoper = "-" Then curval1 = CStr(decval1 - decval2)
        If curoper = "*" Then curval1 = CStr(decval1 * decval2)
        If curoper = "/" Then curval1 = CStr(decval1 / decval2)
        lastoper = curoper
        lastvalue = curval2
        curval2 = ""
    End Sub

    Public Sub repeatOperation()
        If lastoper = "" Then Exit Sub
        Dim decval1, decval2 As Decimal
        If curval1 <> "" Then decval1 = CDec(curval1)
        If lastvalue <> "" Then decval2 = CDec(lastvalue)
        If lastoper = "+" Then curval1 = CStr(decval1 + decval2)
        If lastoper = "-" Then curval1 = CStr(decval1 - decval2)
        If lastoper = "*" Then curval1 = CStr(decval1 * decval2)
        If lastoper = "/" Then curval1 = CStr(decval1 / decval2)
    End Sub
End Module
