Imports System
Imports LcdStudio.CoreInterfaces

Public Class Plugin
    Inherits AbstractDataPlugin

    Public Overrides ReadOnly Property Serializable() As Boolean
        Get
            Return True
        End Get
    End Property

    Public Overrides ReadOnly Property ConfigType() As Type
        Get
            Return GetType(MySettings)
        End Get
    End Property

    Public Overrides ReadOnly Property ConfigPanel() As System.Windows.Forms.Control
        Get
            Return New UserControl1(CType(_settings, MySettings))
        End Get
    End Property

    Public Overrides Sub RegisterData(ByVal ds As IDataService)
        ds.RegisterVariable(Group, "Calculator.Display", "Calculator\Display")
        ds.RegisterVariable(Group, "Calculator.CurrentOperation", "Calculator\CurrentOperation")
        ds.RegisterVariable(Group, "Calculator.IsActive", "Calculator\IsActive")
        ds.RegisterVariable(Group, "Calculator.Settings.ToggleKeyCode", "Calculator\Settings\ToggleKeyCode")
        ds.RegisterVariable(Group, "Calculator.Settings.ToggleKeyFlags", "Calculator\Settings\ToggleKeyFlags")
        setKeyNames()
        Me.UpdateInterval = 100
        'Update every 100ms (1/10 sec)
        HookKeyboard()
    End Sub

    Public Overrides Sub UpdateData(ByVal ds As IDataService)
        Dim mySet As MySettings = CType(_settings, MySettings)
        ds.SetValue("Calculator.Settings.ToggleKeyCode", mySet.ToggleKeyCode)
        ds.SetValue("Calculator.Settings.ToggleKeyFlags", mySet.ToggleKeyFlags)
        toggle_keycode = mySet.ToggleKeyCode
        toggle_keyflags = mySet.ToggleKeyFlags


        ds.SetValue("Calculator.Display", display)
        ds.SetValue("Calculator.CurrentOperation", curoper)
        ds.SetValue("Calculator.IsActive", isactive)
    End Sub

    Public Sub setKeyNames()
        ReDim keynamelist(256)
        Dim a As Integer
        For a = 1 To 256
            keynamelist(a) = "Key #" + CStr(a)
        Next a
        keynamelist(8) = "Backspace"
        keynamelist(9) = "Tab"
        keynamelist(12) = "Numpad 5 (Off)"
        keynamelist(13) = "Enter"
        keynamelist(19) = "Pause"
        keynamelist(20) = "Caps Lock"
        keynamelist(27) = "Escape"
        keynamelist(32) = "Space"
        keynamelist(33) = "Page Up"
        keynamelist(34) = "Page Down"
        keynamelist(35) = "End"
        keynamelist(36) = "Home"
        keynamelist(37) = "Left"
        keynamelist(38) = "Up"
        keynamelist(39) = "Right"
        keynamelist(40) = "Down"
        keynamelist(44) = "Print Screen"
        keynamelist(45) = "Insert"
        keynamelist(46) = "Delete"
        keynamelist(48) = "0"
        keynamelist(49) = "1"
        keynamelist(50) = "2"
        keynamelist(51) = "3"
        keynamelist(52) = "4"
        keynamelist(53) = "5"
        keynamelist(54) = "6"
        keynamelist(55) = "7"
        keynamelist(56) = "8"
        keynamelist(57) = "9"
        keynamelist(65) = "A"
        keynamelist(66) = "B"
        keynamelist(67) = "C"
        keynamelist(68) = "D"
        keynamelist(69) = "E"
        keynamelist(70) = "F"
        keynamelist(71) = "G"
        keynamelist(72) = "H"
        keynamelist(73) = "I"
        keynamelist(74) = "J"
        keynamelist(75) = "K"
        keynamelist(76) = "L"
        keynamelist(77) = "M"
        keynamelist(78) = "N"
        keynamelist(79) = "O"
        keynamelist(80) = "P"
        keynamelist(81) = "Q"
        keynamelist(82) = "R"
        keynamelist(83) = "S"
        keynamelist(84) = "T"
        keynamelist(85) = "U"
        keynamelist(86) = "V"
        keynamelist(87) = "W"
        keynamelist(88) = "X"
        keynamelist(89) = "Y"
        keynamelist(90) = "Z"
        keynamelist(91) = "Left Windows"
        keynamelist(92) = "Right Windows"
        keynamelist(93) = "Context"
        keynamelist(96) = "Numpad 0"
        keynamelist(97) = "Numpad 1"
        keynamelist(98) = "Numpad 2"
        keynamelist(99) = "Numpad 3"
        keynamelist(100) = "Numpad 4"
        keynamelist(101) = "Numpad 5"
        keynamelist(102) = "Numpad 6"
        keynamelist(103) = "Numpad 7"
        keynamelist(104) = "Numpad 8"
        keynamelist(105) = "Numpad 9"
        keynamelist(106) = "Numpad *"
        keynamelist(107) = "Numpad +"
        keynamelist(109) = "Numpad -"
        keynamelist(110) = "Numpad ."
        keynamelist(111) = "Numpad /"
        keynamelist(112) = "F1"
        keynamelist(113) = "F2"
        keynamelist(114) = "F3"
        keynamelist(115) = "F4"
        keynamelist(116) = "F5"
        keynamelist(117) = "F6"
        keynamelist(118) = "F7"
        keynamelist(119) = "F8"
        keynamelist(120) = "F9"
        keynamelist(121) = "F10"
        keynamelist(122) = "F11"
        keynamelist(123) = "F12"
        keynamelist(124) = "F13"
        keynamelist(125) = "F14"
        keynamelist(126) = "F15"
        keynamelist(127) = "F16"
        keynamelist(128) = "F17"
        keynamelist(129) = "F18"
        keynamelist(130) = "F19"
        keynamelist(131) = "F20"
        keynamelist(132) = "F21"
        keynamelist(133) = "F22"
        keynamelist(134) = "F23"
        keynamelist(135) = "F24"
        keynamelist(144) = "Num Lock"
        keynamelist(145) = "Scroll Lock"
        keynamelist(166) = "Browser Back"
        keynamelist(167) = "Browser Forward"
        keynamelist(168) = "Browser Refresh"
        keynamelist(169) = "Browser Stop"
        keynamelist(170) = "Browser Search"
        keynamelist(171) = "Browser Favorites"
        keynamelist(172) = "Browser Home"
        keynamelist(173) = "Media Mute"
        keynamelist(174) = "Media Volume Down"
        keynamelist(175) = "Media Volume Up"
        keynamelist(176) = "Media Next Track"
        keynamelist(177) = "Media Prev Track"
        keynamelist(178) = "Media Stop"
        keynamelist(179) = "Media Play/Pause"
        keynamelist(180) = "Launch Mail"
        keynamelist(181) = "Launch Media"
        keynamelist(182) = "Launch App1"
        keynamelist(183) = "Launch App2"
        keynamelist(186) = ";"
        keynamelist(187) = "="
        keynamelist(188) = ","
        keynamelist(189) = "-"
        keynamelist(190) = "."
        keynamelist(191) = "/"
        keynamelist(192) = "`"
        keynamelist(219) = "["
        keynamelist(220) = "\"
        keynamelist(221) = "]"
        keynamelist(222) = "'"
        keynamelist(223) = "OEM 8"
        keynamelist(226) = "OEM 102"
    End Sub
End Class
