Imports System
Imports LcdStudio.CoreInterfaces
Imports Scripting

Public Class Plugin
    Inherits AbstractDataPlugin

    Dim isreg(26) As Boolean

    Public Overrides Sub RegisterData(ByVal ds As IDataService)
        ds.RegisterVariable(Group, "DiskInfo.OverallTotalSpace", "DiskInfo\OverallTotalSpace")
        ds.RegisterVariable(Group, "DiskInfo.OverallFreeSpace", "DiskInfo\OverallFreeSpace")
        ds.RegisterVariable(Group, "DiskInfo.HardDriveTotalSpace", "DiskInfo\HardDriveTotalSpace")
        ds.RegisterVariable(Group, "DiskInfo.HardDriveFreeSpace", "DiskInfo\HardDriveFreeSpace")
        ds.RegisterVariable(Group, "DiskInfo.NetworkDriveTotalSpace", "DiskInfo\NetworkDriveTotalSpace")
        ds.RegisterVariable(Group, "DiskInfo.NetworkDriveFreeSpace", "DiskInfo\NetworkDriveFreeSpace")
        Dim fso As New FileSystemObject
        Dim drv As Drive
        Dim a As Integer
        For a = 2 To 25
            Try
                drv = fso.Drives(CStr(Chr(65 + a)))
                ds.RegisterVariable(Group, "DiskInfo." + Chr(65 + a) + "Drive.IsReady", "DiskInfo\" + Chr(65 + a) + "Drive\IsReady")
                ds.RegisterVariable(Group, "DiskInfo." + Chr(65 + a) + "Drive.TotalSpace", "DiskInfo\" + Chr(65 + a) + "Drive\TotalSpace")
                ds.RegisterVariable(Group, "DiskInfo." + Chr(65 + a) + "Drive.FreeSpace", "DiskInfo\" + Chr(65 + a) + "Drive\FreeSpace")
                ds.RegisterVariable(Group, "DiskInfo." + Chr(65 + a) + "Drive.DriveType", "DiskInfo\" + Chr(65 + a) + "Drive\DriveType")
                ds.RegisterVariable(Group, "DiskInfo." + Chr(65 + a) + "Drive.FileSystem", "DiskInfo\" + Chr(65 + a) + "Drive\FileSystem")
                ds.RegisterVariable(Group, "DiskInfo." + Chr(65 + a) + "Drive.SerialNumber", "DiskInfo\" + Chr(65 + a) + "Drive\SerialNumber")
                ds.RegisterVariable(Group, "DiskInfo." + Chr(65 + a) + "Drive.VolumeName", "DiskInfo\" + Chr(65 + a) + "Drive\VolumeName")
                isreg(a) = True
            Catch ex As Exception
            End Try
        Next a
        Me.UpdateInterval = 3000
        'Update every 3000ms (3 sec)
    End Sub

    Public Overrides Sub UpdateData(ByVal ds As IDataService)
        Dim totalspace, freespace, hdtotalspace, hdfreespace, nwtotalspace, nwfreespace As Double

        Dim fso As New FileSystemObject
        Dim drv As Drive
        Dim a As Integer
        For a = 2 To 25
            Try
                drv = fso.Drives(CStr(Chr(65 + a)))
                If drv.IsReady Then
                    totalspace += CDbl(drv.TotalSize)
                    freespace += CDbl(drv.FreeSpace)
                    If drv.DriveType = DriveTypeConst.Fixed Then
                        hdtotalspace += CDbl(drv.TotalSize)
                        hdfreespace += CDbl(drv.FreeSpace)
                    End If
                    If drv.DriveType = DriveTypeConst.Remote Then
                        nwtotalspace += CDbl(drv.TotalSize)
                        nwfreespace += CDbl(drv.FreeSpace)
                    End If
                    If isreg(a) Then
                        ds.SetValue("DiskInfo." + Chr(65 + a) + "Drive.IsReady", drv.IsReady)
                        ds.SetValue("DiskInfo." + Chr(65 + a) + "Drive.TotalSpace", drv.TotalSize)
                        ds.SetValue("DiskInfo." + Chr(65 + a) + "Drive.FreeSpace", drv.FreeSpace)
                        ds.SetValue("DiskInfo." + Chr(65 + a) + "Drive.DriveType", drv.DriveType)
                        ds.SetValue("DiskInfo." + Chr(65 + a) + "Drive.FileSystem", drv.FileSystem)
                        ds.SetValue("DiskInfo." + Chr(65 + a) + "Drive.SerialNumber", drv.SerialNumber)
                        ds.SetValue("DiskInfo." + Chr(65 + a) + "Drive.VolumeName", drv.VolumeName)
                    End If
                Else
                    If isreg(a) Then
                        ds.SetValue("DiskInfo." + Chr(65 + a) + "Drive.IsReady", False)
                        ds.SetValue("DiskInfo." + Chr(65 + a) + "Drive.TotalSpace", Nothing)
                        ds.SetValue("DiskInfo." + Chr(65 + a) + "Drive.FreeSpace", Nothing)
                        ds.SetValue("DiskInfo." + Chr(65 + a) + "Drive.DriveType", Nothing)
                        ds.SetValue("DiskInfo." + Chr(65 + a) + "Drive.FileSystem", Nothing)
                        ds.SetValue("DiskInfo." + Chr(65 + a) + "Drive.SerialNumber", Nothing)
                        ds.SetValue("DiskInfo." + Chr(65 + a) + "Drive.VolumeName", Nothing)
                    End If
                End If
            Catch ex As Exception
            End Try
        Next a

        ds.SetValue("DiskInfo.OverallTotalSpace", CStr(totalspace))
        ds.SetValue("DiskInfo.OverallFreeSpace", CStr(freespace))
        ds.SetValue("DiskInfo.HardDriveTotalSpace", CStr(hdtotalspace))
        ds.SetValue("DiskInfo.HardDriveFreeSpace", CStr(hdfreespace))
        ds.SetValue("DiskInfo.NetworkDriveTotalSpace", CStr(nwtotalspace))
        ds.SetValue("DiskInfo.NetworkDriveFreeSpace", CStr(nwfreespace))
    End Sub
End Class
