Imports System
Imports System.Collections
Imports System.ComponentModel
Imports System.Drawing
Imports System.Data
Imports System.Windows.Forms

Public Class UserControl1
    Inherits System.Windows.Forms.UserControl

#Region " Windows Form Designer generated code "

    Public Sub New(ByVal settings As MySettings)
        MyBase.New()

        'This call is required by the Windows Form Designer.
        InitializeComponent()

        'Add any initialization after the InitializeComponent() call
        Me.SetStyle(ControlStyles.SupportsTransparentBackColor, True)
        Me.BackColor = Color.Transparent
        _settings = settings

        chkHideNormal.Checked = settings.HideNormal
        chkHideShift.Checked = settings.HideShift
        chkHideCtrl.Checked = settings.HideCtrl
        chkHideAlt.Checked = settings.HideAlt
        chkHideCtrlShift.Checked = settings.HideCtrlShift
        chkHideCtrlAlt.Checked = settings.HideCtrlAlt
        chkHideAltShift.Checked = settings.HideAltShift
        chkHideCtrlAltShift.Checked = settings.HideCtrlAltShift
        If settings.CalcToggleKeyCode = -1 Then
            txtToggleKey.Text = "(None set)"
        Else
            txtToggleKey.Text = IIf(settings.CalcToggleKeyFlags And FLAG_CTRL, "Ctrl+", "") + IIf(settings.CalcToggleKeyFlags And FLAG_SHIFT, "Shift+", "") + IIf(settings.CalcToggleKeyFlags And FLAG_ALT, "Alt+", "") + keynamelist(settings.CalcToggleKeyCode)
        End If
        chkEnableCalc.Checked = settings.CalcEnabled
        btnChangeToggleKey.Enabled = settings.CalcEnabled
    End Sub

    'UserControl overrides dispose to clean up the component list.
    Protected Overloads Overrides Sub Dispose(ByVal disposing As Boolean)
        If disposing Then
            If Not (components Is Nothing) Then
                components.Dispose()
            End If
        End If
        MyBase.Dispose(disposing)
    End Sub

    'Required by the Windows Form Designer
    Private components As System.ComponentModel.IContainer

    'NOTE: The following procedure is required by the Windows Form Designer
    'It can be modified using the Windows Form Designer.  
    'Do not modify it using the code editor.
    Friend WithEvents chkHideNormal As System.Windows.Forms.CheckBox
    Friend WithEvents chkHideShift As System.Windows.Forms.CheckBox
    Friend WithEvents chkHideCtrl As System.Windows.Forms.CheckBox
    Friend WithEvents chkHideAlt As System.Windows.Forms.CheckBox
    Friend WithEvents chkHideCtrlShift As System.Windows.Forms.CheckBox
    Friend WithEvents chkHideCtrlAlt As System.Windows.Forms.CheckBox
    Friend WithEvents chkHideAltShift As System.Windows.Forms.CheckBox
    Friend WithEvents chkHideCtrlAltShift As System.Windows.Forms.CheckBox
    Friend WithEvents Label1 As System.Windows.Forms.Label
    Friend WithEvents chkEnableCalc As System.Windows.Forms.CheckBox
    Friend WithEvents btnChangeToggleKey As System.Windows.Forms.Button
    Friend WithEvents txtToggleKey As System.Windows.Forms.TextBox
    Friend WithEvents Label2 As System.Windows.Forms.Label
    Friend WithEvents Timer1 As System.Windows.Forms.Timer
    <System.Diagnostics.DebuggerStepThrough()> Private Sub InitializeComponent()
        Me.components = New System.ComponentModel.Container
        Me.chkHideNormal = New System.Windows.Forms.CheckBox
        Me.chkHideShift = New System.Windows.Forms.CheckBox
        Me.chkHideCtrl = New System.Windows.Forms.CheckBox
        Me.chkHideAlt = New System.Windows.Forms.CheckBox
        Me.chkHideCtrlShift = New System.Windows.Forms.CheckBox
        Me.chkHideCtrlAlt = New System.Windows.Forms.CheckBox
        Me.chkHideAltShift = New System.Windows.Forms.CheckBox
        Me.chkHideCtrlAltShift = New System.Windows.Forms.CheckBox
        Me.Label1 = New System.Windows.Forms.Label
        Me.chkEnableCalc = New System.Windows.Forms.CheckBox
        Me.btnChangeToggleKey = New System.Windows.Forms.Button
        Me.txtToggleKey = New System.Windows.Forms.TextBox
        Me.Label2 = New System.Windows.Forms.Label
        Me.Timer1 = New System.Windows.Forms.Timer(Me.components)
        Me.SuspendLayout()
        '
        'chkHideNormal
        '
        Me.chkHideNormal.Location = New System.Drawing.Point(8, 8)
        Me.chkHideNormal.Name = "chkHideNormal"
        Me.chkHideNormal.Size = New System.Drawing.Size(272, 16)
        Me.chkHideNormal.TabIndex = 0
        Me.chkHideNormal.Text = "Hide the Normal keystates"
        '
        'chkHideShift
        '
        Me.chkHideShift.Location = New System.Drawing.Point(8, 24)
        Me.chkHideShift.Name = "chkHideShift"
        Me.chkHideShift.Size = New System.Drawing.Size(272, 16)
        Me.chkHideShift.TabIndex = 0
        Me.chkHideShift.Text = "Hide the Shift keystates"
        '
        'chkHideCtrl
        '
        Me.chkHideCtrl.Location = New System.Drawing.Point(8, 40)
        Me.chkHideCtrl.Name = "chkHideCtrl"
        Me.chkHideCtrl.Size = New System.Drawing.Size(272, 16)
        Me.chkHideCtrl.TabIndex = 0
        Me.chkHideCtrl.Text = "Hide the Ctrl keystates"
        '
        'chkHideAlt
        '
        Me.chkHideAlt.Location = New System.Drawing.Point(8, 56)
        Me.chkHideAlt.Name = "chkHideAlt"
        Me.chkHideAlt.Size = New System.Drawing.Size(272, 16)
        Me.chkHideAlt.TabIndex = 0
        Me.chkHideAlt.Text = "Hide the Alt keystates"
        '
        'chkHideCtrlShift
        '
        Me.chkHideCtrlShift.Location = New System.Drawing.Point(8, 72)
        Me.chkHideCtrlShift.Name = "chkHideCtrlShift"
        Me.chkHideCtrlShift.Size = New System.Drawing.Size(272, 16)
        Me.chkHideCtrlShift.TabIndex = 0
        Me.chkHideCtrlShift.Text = "Hide the CtrlShift keystates"
        '
        'chkHideCtrlAlt
        '
        Me.chkHideCtrlAlt.Location = New System.Drawing.Point(8, 88)
        Me.chkHideCtrlAlt.Name = "chkHideCtrlAlt"
        Me.chkHideCtrlAlt.Size = New System.Drawing.Size(272, 16)
        Me.chkHideCtrlAlt.TabIndex = 0
        Me.chkHideCtrlAlt.Text = "Hide the CtrlAlt keystates"
        '
        'chkHideAltShift
        '
        Me.chkHideAltShift.Location = New System.Drawing.Point(8, 104)
        Me.chkHideAltShift.Name = "chkHideAltShift"
        Me.chkHideAltShift.Size = New System.Drawing.Size(272, 16)
        Me.chkHideAltShift.TabIndex = 0
        Me.chkHideAltShift.Text = "Hide the AltShift keystates"
        '
        'chkHideCtrlAltShift
        '
        Me.chkHideCtrlAltShift.Location = New System.Drawing.Point(8, 120)
        Me.chkHideCtrlAltShift.Name = "chkHideCtrlAltShift"
        Me.chkHideCtrlAltShift.Size = New System.Drawing.Size(272, 16)
        Me.chkHideCtrlAltShift.TabIndex = 0
        Me.chkHideCtrlAltShift.Text = "Hide the CtrlAltShift keystates"
        '
        'Label1
        '
        Me.Label1.BorderStyle = System.Windows.Forms.BorderStyle.Fixed3D
        Me.Label1.Location = New System.Drawing.Point(8, 144)
        Me.Label1.Name = "Label1"
        Me.Label1.Size = New System.Drawing.Size(272, 40)
        Me.Label1.TabIndex = 1
        Me.Label1.Text = "You must restart LCDStudio for changes above to go into effect!"
        '
        'chkEnableCalc
        '
        Me.chkEnableCalc.Location = New System.Drawing.Point(8, 200)
        Me.chkEnableCalc.Name = "chkEnableCalc"
        Me.chkEnableCalc.Size = New System.Drawing.Size(272, 16)
        Me.chkEnableCalc.TabIndex = 2
        Me.chkEnableCalc.Text = "Enable Calculator"
        '
        'btnChangeToggleKey
        '
        Me.btnChangeToggleKey.Location = New System.Drawing.Point(272, 224)
        Me.btnChangeToggleKey.Name = "btnChangeToggleKey"
        Me.btnChangeToggleKey.Size = New System.Drawing.Size(72, 24)
        Me.btnChangeToggleKey.TabIndex = 5
        Me.btnChangeToggleKey.Text = "Change"
        '
        'txtToggleKey
        '
        Me.txtToggleKey.Location = New System.Drawing.Point(88, 224)
        Me.txtToggleKey.Name = "txtToggleKey"
        Me.txtToggleKey.ReadOnly = True
        Me.txtToggleKey.Size = New System.Drawing.Size(176, 20)
        Me.txtToggleKey.TabIndex = 4
        Me.txtToggleKey.Text = ""
        '
        'Label2
        '
        Me.Label2.AutoSize = True
        Me.Label2.Location = New System.Drawing.Point(24, 227)
        Me.Label2.Name = "Label2"
        Me.Label2.Size = New System.Drawing.Size(63, 16)
        Me.Label2.TabIndex = 3
        Me.Label2.Text = "Toggle key:"
        '
        'Timer1
        '
        '
        'UserControl1
        '
        Me.Controls.Add(Me.btnChangeToggleKey)
        Me.Controls.Add(Me.txtToggleKey)
        Me.Controls.Add(Me.Label2)
        Me.Controls.Add(Me.chkEnableCalc)
        Me.Controls.Add(Me.Label1)
        Me.Controls.Add(Me.chkHideNormal)
        Me.Controls.Add(Me.chkHideShift)
        Me.Controls.Add(Me.chkHideCtrl)
        Me.Controls.Add(Me.chkHideAlt)
        Me.Controls.Add(Me.chkHideCtrlShift)
        Me.Controls.Add(Me.chkHideCtrlAlt)
        Me.Controls.Add(Me.chkHideAltShift)
        Me.Controls.Add(Me.chkHideCtrlAltShift)
        Me.Name = "UserControl1"
        Me.Size = New System.Drawing.Size(352, 280)
        Me.ResumeLayout(False)

    End Sub

#End Region

    Private _settings As MySettings = Nothing

    Private Sub chkHideNormal_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkHideNormal.CheckedChanged
        _settings.HideNormal = chkHideNormal.Checked
    End Sub

    Private Sub chkHideShift_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkHideShift.CheckedChanged
        _settings.HideShift = chkHideShift.Checked
    End Sub

    Private Sub chkHideCtrl_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkHideCtrl.CheckedChanged
        _settings.HideCtrl = chkHideCtrl.Checked
    End Sub

    Private Sub chkHideAlt_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkHideAlt.CheckedChanged
        _settings.HideAlt = chkHideAlt.Checked
    End Sub

    Private Sub chkHideCtrlShift_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkHideCtrlShift.CheckedChanged
        _settings.HideCtrlShift = chkHideCtrlShift.Checked
    End Sub

    Private Sub chkHideCtrlAlt_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkHideCtrlAlt.CheckedChanged
        _settings.HideCtrlAlt = chkHideCtrlAlt.Checked
    End Sub

    Private Sub chkHideAltShift_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkHideAltShift.CheckedChanged
        _settings.HideAltShift = chkHideAltShift.Checked
    End Sub

    Private Sub chkHideCtrlAltShift_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkHideCtrlAltShift.CheckedChanged
        _settings.HideCtrlAltShift = chkHideCtrlAltShift.Checked
    End Sub

    Private Sub btnChangeToggleKey_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnChangeToggleKey.Click
        txtToggleKey.Text = "Press any key to set"
        btnChangeToggleKey.Enabled = False
        setflag_toggle = True
        Timer1.Enabled = True
    End Sub

    Private Sub Timer1_Tick(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles Timer1.Tick
        If setflag_toggle Then Return
        Timer1.Enabled = False
        _settings.CalcToggleKeyCode = toggle_keycode
        _settings.CalcToggleKeyFlags = toggle_keyflags
        If _settings.CalcToggleKeyCode < keynamelist.GetLowerBound(0) Or _settings.CalcToggleKeyCode > keynamelist.GetUpperBound(0) Then
            txtToggleKey.Text = IIf(_settings.CalcToggleKeyFlags And FLAG_CTRL, "Ctrl+", "") + IIf(_settings.CalcToggleKeyFlags And FLAG_SHIFT, "Shift+", "") + IIf(_settings.CalcToggleKeyFlags And FLAG_ALT, "Alt+", "") + "Key #" + CStr(_settings.CalcToggleKeyCode)
        Else
            txtToggleKey.Text = IIf(_settings.CalcToggleKeyFlags And FLAG_CTRL, "Ctrl+", "") + IIf(_settings.CalcToggleKeyFlags And FLAG_SHIFT, "Shift+", "") + IIf(_settings.CalcToggleKeyFlags And FLAG_ALT, "Alt+", "") + keynamelist(_settings.CalcToggleKeyCode)
        End If
        btnChangeToggleKey.Enabled = True
    End Sub

    Private Sub chkEnableCalc_CheckedChanged(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles chkEnableCalc.CheckedChanged
        _settings.CalcEnabled = chkEnableCalc.Checked
        btnChangeToggleKey.Enabled = chkEnableCalc.Checked
    End Sub
End Class
