Imports System
Imports LcdStudio.CoreInterfaces

Imports System.Globalization
Imports System.Threading

Public Class Plugin
    Inherits AbstractDataPlugin

    Public Overrides ReadOnly Property Serializable() As Boolean
        Get
            Return True
        End Get
    End Property

    Public Overrides ReadOnly Property ConfigType() As Type
        Get
            Return GetType(MySettings)
        End Get
    End Property

    Public Overrides ReadOnly Property ConfigPanel() As System.Windows.Forms.Control
        Get
            Return New UserControl1(CType(_settings, MySettings))
        End Get
    End Property

    Public Overrides Sub RegisterData(ByVal ds As IDataService)
        Dim mySet As MySettings = CType(_settings, MySettings)
        ds.RegisterVariable(Group, "KeyCapture.KeyName", "KeyCapture\KeyName")
        ds.RegisterVariable(Group, "KeyCapture.KeyCode", "KeyCapture\KeyCode")
        ds.RegisterVariable(Group, "KeyCapture.ScanCode", "KeyCapture\ScanCode")
        ds.RegisterVariable(Group, "KeyCapture.IsKeyDown", "KeyCapture\IsKeyDown")
        ds.RegisterVariable(Group, "KeyCapture.IsShiftDown", "KeyCapture\IsShiftDown")
        ds.RegisterVariable(Group, "KeyCapture.IsAltDown", "KeyCapture\IsAltDown")
        ds.RegisterVariable(Group, "KeyCapture.IsCtrlDown", "KeyCapture\IsCtrlDown")
        ds.RegisterVariable(Group, "KeyCapture.Settings.HideNormal", "KeyCapture\Settings\HideNormal")
        ds.RegisterVariable(Group, "KeyCapture.Settings.HideShift", "KeyCapture\Settings\HideShift")
        ds.RegisterVariable(Group, "KeyCapture.Settings.HideCtrl", "KeyCapture\Settings\HideCtrl")
        ds.RegisterVariable(Group, "KeyCapture.Settings.HideAlt", "KeyCapture\Settings\HideAlt")
        ds.RegisterVariable(Group, "KeyCapture.Settings.HideCtrlShift", "KeyCapture\Settings\HideCtrlShift")
        ds.RegisterVariable(Group, "KeyCapture.Settings.HideCtrlAlt", "KeyCapture\Settings\HideCtrlAlt")
        ds.RegisterVariable(Group, "KeyCapture.Settings.HideAltShift", "KeyCapture\Settings\HideAltShift")
        ds.RegisterVariable(Group, "KeyCapture.Settings.HideCtrlAltShift", "KeyCapture\Settings\HideCtrlAltShift")
        ds.RegisterVariable(Group, "KeyCapture.Calculator.Display", "KeyCapture\Calculator\Display")
        ds.RegisterVariable(Group, "KeyCapture.Calculator.CurrentOperation", "KeyCapture\Calculator\CurrentOperation")
        ds.RegisterVariable(Group, "KeyCapture.Calculator.MemStatus", "KeyCapture\Calculator\MemStatus")
        ds.RegisterVariable(Group, "KeyCapture.Calculator.MemValue", "KeyCapture\Calculator\MemValue")
        ds.RegisterVariable(Group, "KeyCapture.Calculator.IsActive", "KeyCapture\Calculator\IsActive")
        ds.RegisterVariable(Group, "KeyCapture.Calculator.IsEnabled", "KeyCapture\Calculator\IsEnabled")
        ds.RegisterVariable(Group, "KeyCapture.Calculator.FullDisplay", "KeyCapture\Calculator\FullDisplay")
        ds.RegisterVariable(Group, "KeyCapture.Settings.CalcEnabled", "KeyCapture\Settings\CalcEnabled")
        ds.RegisterVariable(Group, "KeyCapture.Settings.CalcToggleKeyCode", "KeyCapture\Settings\CalcToggleKeyCode")
        ds.RegisterVariable(Group, "KeyCapture.Settings.CalcToggleKeyFlags", "KeyCapture\Settings\CalcToggleKeyFlags")
        setKeyNames()
        Dim tempkey As keynames
        For tempkey = 1 To 256
            keystates(tempkey).changed = True
            keystates(tempkey).keystate = False
            keystates(tempkey).isaltdown = False
            keystates(tempkey).isctrldown = False
            keystates(tempkey).isshiftdown = False
            If tempkey.ToString() <> CStr(tempkey) Then
                If Not mySet.HideNormal Then ds.RegisterVariable(Group, "KeyCapture.KeyStates.Normal." + tempkey.ToString(), "KeyCapture\KeyStates\Normal\" + tempkey.ToString())
                If Not mySet.HideShift Then ds.RegisterVariable(Group, "KeyCapture.KeyStates.Shift." + tempkey.ToString(), "KeyCapture\KeyStates\Shift\" + tempkey.ToString())
                If Not mySet.HideCtrl Then ds.RegisterVariable(Group, "KeyCapture.KeyStates.Ctrl." + tempkey.ToString(), "KeyCapture\KeyStates\Ctrl\" + tempkey.ToString())
                If Not mySet.HideAlt Then ds.RegisterVariable(Group, "KeyCapture.KeyStates.Alt." + tempkey.ToString(), "KeyCapture\KeyStates\Alt\" + tempkey.ToString())
                If Not mySet.HideCtrlShift Then ds.RegisterVariable(Group, "KeyCapture.KeyStates.CtrlShift." + tempkey.ToString(), "KeyCapture\KeyStates\CtrlShift\" + tempkey.ToString())
                If Not mySet.HideAltShift Then ds.RegisterVariable(Group, "KeyCapture.KeyStates.AltShift." + tempkey.ToString(), "KeyCapture\KeyStates\AltShift\" + tempkey.ToString())
                If Not mySet.HideCtrlAlt Then ds.RegisterVariable(Group, "KeyCapture.KeyStates.CtrlAlt." + tempkey.ToString(), "KeyCapture\KeyStates\CtrlAlt\" + tempkey.ToString())
                If Not mySet.HideCtrlAltShift Then ds.RegisterVariable(Group, "KeyCapture.KeyStates.CtrlAltShift." + tempkey.ToString(), "KeyCapture\KeyStates\CtrlAltShift\" + tempkey.ToString())
            End If
        Next tempkey
        status_Normal = Not mySet.HideNormal
        status_Shift = Not mySet.HideShift
        status_Ctrl = Not mySet.HideCtrl
        status_Alt = Not mySet.HideAlt
        status_CtrlShift = Not mySet.HideCtrlShift
        status_AltShift = Not mySet.HideAltShift
        status_CtrlAlt = Not mySet.HideCtrlAlt
        status_CtrlAltShift = Not mySet.HideCtrlAltShift
        ds.RegisterVariable(Group, "KeyCapture.LastKey.KeyName", "KeyCapture\LastKey\KeyName")
        ds.RegisterVariable(Group, "KeyCapture.LastKey.KeyCode", "KeyCapture\LastKey\KeyCode")
        ds.RegisterVariable(Group, "KeyCapture.LastKey.ScanCode", "KeyCapture\LastKey\ScanCode")
        ds.RegisterVariable(Group, "KeyCapture.LastKey.IsShiftDown", "KeyCapture\LastKey\IsShiftDown")
        ds.RegisterVariable(Group, "KeyCapture.LastKey.IsAltDown", "KeyCapture\LastKey\IsAltDown")
        ds.RegisterVariable(Group, "KeyCapture.LastKey.IsCtrlDown", "KeyCapture\LastKey\IsCtrlDown")
        ds.SetValue("KeyCapture.LastKey.KeyName", "")
        ds.SetValue("KeyCapture.LastKey.KeyCode", -1)
        ds.SetValue("KeyCapture.LastKey.ScanCode", -1)
        ds.SetValue("KeyCapture.LastKey.IsShiftDown", False)
        ds.SetValue("KeyCapture.LastKey.IsAltDown", False)
        ds.SetValue("KeyCapture.LastKey.IsCtrlDown", False)
        decimalchar = Thread.CurrentThread.CurrentCulture.NumberFormat.NumberDecimalSeparator
        Me.UpdateInterval = 100
        'Update every 100ms (1/10 sec)
        HookKeyboard()
    End Sub

    Public Overrides Sub UpdateData(ByVal ds As IDataService)
        Dim mySet As MySettings = CType(_settings, MySettings)
        ds.SetValue("KeyCapture.Settings.HideNormal", mySet.HideNormal)
        ds.SetValue("KeyCapture.Settings.HideShift", mySet.HideShift)
        ds.SetValue("KeyCapture.Settings.HideCtrl", mySet.HideCtrl)
        ds.SetValue("KeyCapture.Settings.HideAlt", mySet.HideAlt)
        ds.SetValue("KeyCapture.Settings.HideCtrlShift", mySet.HideCtrlShift)
        ds.SetValue("KeyCapture.Settings.HideCtrlAlt", mySet.HideCtrlAlt)
        ds.SetValue("KeyCapture.Settings.HideAltShift", mySet.HideAltShift)
        ds.SetValue("KeyCapture.Settings.HideCtrlAltShift", mySet.HideCtrlAltShift)
        ds.SetValue("KeyCapture.Settings.CalcEnabled", mySet.CalcEnabled)
        ds.SetValue("KeyCapture.Settings.CalcToggleKeyCode", mySet.CalcToggleKeyCode)
        ds.SetValue("KeyCapture.Settings.CalcToggleKeyFlags", mySet.CalcToggleKeyFlags)
        usecalc = mySet.CalcEnabled
        If Not usecalc Then isactive = False
        toggle_keycode = mySet.CalcToggleKeyCode
        toggle_keyflags = mySet.CalcToggleKeyFlags

        ds.SetValue("KeyCapture.Calculator.Display", display)
        ds.SetValue("KeyCapture.Calculator.FullDisplay", fulldisplay)
        ds.SetValue("KeyCapture.Calculator.CurrentOperation", curoper)
        ds.SetValue("KeyCapture.Calculator.MemStatus", IIf(memval <> "", "M", ""))
        ds.SetValue("KeyCapture.Calculator.MemValue", memval)
        ds.SetValue("KeyCapture.Calculator.IsActive", isactive)
        ds.SetValue("KeyCapture.Calculator.IsEnabled", usecalc)

        Dim tempkey As keynames = keyvalue
        If tempkey.ToString() <> CStr(tempkey) Then
            ds.SetValue("KeyCapture.KeyName", tempkey.ToString())
        Else
            ds.SetValue("KeyCapture.KeyName", "")
        End If
        ds.SetValue("KeyCapture.KeyCode", keyvalue)
        ds.SetValue("KeyCapture.ScanCode", scancode)
        ds.SetValue("KeyCapture.IsKeyDown", iskeydown)
        ds.SetValue("KeyCapture.IsShiftDown", isshiftdown)
        ds.SetValue("KeyCapture.IsAltDown", isaltdown)
        ds.SetValue("KeyCapture.IsCtrlDown", isctrldown)
        For tempkey = 1 To 256
            If tempkey.ToString() <> CStr(tempkey) And keystates(tempkey).changed Then
                If status_Normal Then ds.SetValue("KeyCapture.KeyStates.Normal." + tempkey.ToString(), keystates(tempkey).keystate)
                If status_Shift Then ds.SetValue("KeyCapture.KeyStates.Shift." + tempkey.ToString(), keystates(tempkey).keystate And keystates(tempkey).isshiftdown)
                If status_Ctrl Then ds.SetValue("KeyCapture.KeyStates.Ctrl." + tempkey.ToString(), keystates(tempkey).keystate And keystates(tempkey).isctrldown)
                If status_Alt Then ds.SetValue("KeyCapture.KeyStates.Alt." + tempkey.ToString(), keystates(tempkey).keystate And keystates(tempkey).isaltdown)
                If status_CtrlShift Then ds.SetValue("KeyCapture.KeyStates.CtrlShift." + tempkey.ToString(), keystates(tempkey).keystate And keystates(tempkey).isctrldown And keystates(tempkey).isshiftdown)
                If status_AltShift Then ds.SetValue("KeyCapture.KeyStates.AltShift." + tempkey.ToString(), keystates(tempkey).keystate And keystates(tempkey).isaltdown And keystates(tempkey).isshiftdown)
                If status_CtrlAlt Then ds.SetValue("KeyCapture.KeyStates.CtrlAlt." + tempkey.ToString(), keystates(tempkey).keystate And keystates(tempkey).isctrldown And keystates(tempkey).isaltdown)
                If status_CtrlAltShift Then ds.SetValue("KeyCapture.KeyStates.CtrlAltShift." + tempkey.ToString(), keystates(tempkey).keystate And keystates(tempkey).isctrldown And keystates(tempkey).isaltdown And keystates(tempkey).isshiftdown)
                keystates(tempkey).changed = False
            End If
        Next tempkey

        If iskeydown Then
            tempkey = keyvalue
            If tempkey.ToString() <> CStr(tempkey) Then
                ds.SetValue("KeyCapture.LastKey.KeyName", tempkey.ToString())
            Else
                ds.SetValue("KeyCapture.LastKey.KeyName", "")
            End If
            ds.SetValue("KeyCapture.LastKey.KeyCode", keyvalue)
            ds.SetValue("KeyCapture.LastKey.ScanCode", scancode)
            ds.SetValue("KeyCapture.LastKey.IsShiftDown", isshiftdown)
            ds.SetValue("KeyCapture.LastKey.IsAltDown", isaltdown)
            ds.SetValue("KeyCapture.LastKey.IsCtrlDown", isctrldown)
        End If
    End Sub

    Public Sub setKeyNames()
        ReDim keynamelist(256)
        Dim a As Integer
        For a = 1 To 256
            keynamelist(a) = "Key #" + CStr(a)
        Next a
        keynamelist(8) = "Backspace"
        keynamelist(9) = "Tab"
        keynamelist(12) = "Numpad 5 (Off)"
        keynamelist(13) = "Enter"
        keynamelist(19) = "Pause"
        keynamelist(20) = "Caps Lock"
        keynamelist(27) = "Escape"
        keynamelist(32) = "Space"
        keynamelist(33) = "Page Up"
        keynamelist(34) = "Page Down"
        keynamelist(35) = "End"
        keynamelist(36) = "Home"
        keynamelist(37) = "Left"
        keynamelist(38) = "Up"
        keynamelist(39) = "Right"
        keynamelist(40) = "Down"
        keynamelist(44) = "Print Screen"
        keynamelist(45) = "Insert"
        keynamelist(46) = "Delete"
        keynamelist(48) = "0"
        keynamelist(49) = "1"
        keynamelist(50) = "2"
        keynamelist(51) = "3"
        keynamelist(52) = "4"
        keynamelist(53) = "5"
        keynamelist(54) = "6"
        keynamelist(55) = "7"
        keynamelist(56) = "8"
        keynamelist(57) = "9"
        keynamelist(65) = "A"
        keynamelist(66) = "B"
        keynamelist(67) = "C"
        keynamelist(68) = "D"
        keynamelist(69) = "E"
        keynamelist(70) = "F"
        keynamelist(71) = "G"
        keynamelist(72) = "H"
        keynamelist(73) = "I"
        keynamelist(74) = "J"
        keynamelist(75) = "K"
        keynamelist(76) = "L"
        keynamelist(77) = "M"
        keynamelist(78) = "N"
        keynamelist(79) = "O"
        keynamelist(80) = "P"
        keynamelist(81) = "Q"
        keynamelist(82) = "R"
        keynamelist(83) = "S"
        keynamelist(84) = "T"
        keynamelist(85) = "U"
        keynamelist(86) = "V"
        keynamelist(87) = "W"
        keynamelist(88) = "X"
        keynamelist(89) = "Y"
        keynamelist(90) = "Z"
        keynamelist(91) = "Left Windows"
        keynamelist(92) = "Right Windows"
        keynamelist(93) = "Context"
        keynamelist(96) = "Numpad 0"
        keynamelist(97) = "Numpad 1"
        keynamelist(98) = "Numpad 2"
        keynamelist(99) = "Numpad 3"
        keynamelist(100) = "Numpad 4"
        keynamelist(101) = "Numpad 5"
        keynamelist(102) = "Numpad 6"
        keynamelist(103) = "Numpad 7"
        keynamelist(104) = "Numpad 8"
        keynamelist(105) = "Numpad 9"
        keynamelist(106) = "Numpad *"
        keynamelist(107) = "Numpad +"
        keynamelist(109) = "Numpad -"
        keynamelist(110) = "Numpad ."
        keynamelist(111) = "Numpad /"
        keynamelist(112) = "F1"
        keynamelist(113) = "F2"
        keynamelist(114) = "F3"
        keynamelist(115) = "F4"
        keynamelist(116) = "F5"
        keynamelist(117) = "F6"
        keynamelist(118) = "F7"
        keynamelist(119) = "F8"
        keynamelist(120) = "F9"
        keynamelist(121) = "F10"
        keynamelist(122) = "F11"
        keynamelist(123) = "F12"
        keynamelist(124) = "F13"
        keynamelist(125) = "F14"
        keynamelist(126) = "F15"
        keynamelist(127) = "F16"
        keynamelist(128) = "F17"
        keynamelist(129) = "F18"
        keynamelist(130) = "F19"
        keynamelist(131) = "F20"
        keynamelist(132) = "F21"
        keynamelist(133) = "F22"
        keynamelist(134) = "F23"
        keynamelist(135) = "F24"
        keynamelist(144) = "Num Lock"
        keynamelist(145) = "Scroll Lock"
        keynamelist(166) = "Browser Back"
        keynamelist(167) = "Browser Forward"
        keynamelist(168) = "Browser Refresh"
        keynamelist(169) = "Browser Stop"
        keynamelist(170) = "Browser Search"
        keynamelist(171) = "Browser Favorites"
        keynamelist(172) = "Browser Home"
        keynamelist(173) = "Media Mute"
        keynamelist(174) = "Media Volume Down"
        keynamelist(175) = "Media Volume Up"
        keynamelist(176) = "Media Next Track"
        keynamelist(177) = "Media Prev Track"
        keynamelist(178) = "Media Stop"
        keynamelist(179) = "Media Play/Pause"
        keynamelist(180) = "Launch Mail"
        keynamelist(181) = "Launch Media"
        keynamelist(182) = "Launch App1"
        keynamelist(183) = "Launch App2"
        keynamelist(186) = ";"
        keynamelist(187) = "="
        keynamelist(188) = ","
        keynamelist(189) = "-"
        keynamelist(190) = "."
        keynamelist(191) = "/"
        keynamelist(192) = "`"
        keynamelist(219) = "["
        keynamelist(220) = "\"
        keynamelist(221) = "]"
        keynamelist(222) = "'"
        keynamelist(223) = "OEM 8"
        keynamelist(226) = "OEM 102"
    End Sub
End Class
