Imports System
Imports LcdStudio.CoreInterfaces

Public Class Plugin
    Inherits AbstractDataPlugin

    Public Overrides ReadOnly Property Serializable() As Boolean
        Get
            Return True
        End Get
    End Property

    Public Overrides ReadOnly Property ConfigType() As Type
        Get
            Return GetType(MySettings)
        End Get
    End Property

    Public Overrides ReadOnly Property ConfigPanel() As System.Windows.Forms.Control
        Get
            Return New UserControl1(CType(_settings, MySettings))
        End Get
    End Property

    Public Overrides Sub RegisterData(ByVal ds As IDataService)
        ds.RegisterVariable(Group, "MyPlugin.HelloWorld", "MyPlugin\Hello world")
        ds.RegisterVariable(Group, "MyPlugin.TimeMsg", "MyPlugin\Time")
        ds.RegisterVariable(Group, "MyPlugin.Text1", "MyPlugin\text 1")
        ds.RegisterVariable(Group, "MyPlugin.Text2", "MyPlugin\text 2")
        Me.UpdateInterval = 3000
        'Update every 3000ms (3 sec)
    End Sub

    Public Overrides Sub UpdateData(ByVal ds As IDataService)
        Dim mySet As MySettings = CType(_settings, MySettings)
        ds.SetValue("MyPlugin.Text1", mySet.MyText1)
        ds.SetValue("MyPlugin.Text2", mySet.MyText2)
        ds.SetValue("MyPlugin.HelloWorld", "Hello world")
        ds.SetValue("MyPlugin.TimeMsg", String.Format("The time is {0} ", DateTime.Now.ToShortTimeString))
    End Sub
End Class

