Imports System
Imports LcdStudio.CoreInterfaces
Imports System.Net
Imports System.IO
Imports System.Web

Public Class Plugin
    Inherits AbstractDataPlugin

    Public Structure QuoteStruc
        Public ID As Integer
        Public Score As Integer
        Public Text As String
    End Structure

    Private secondcount As Integer = -99

    Public Overrides ReadOnly Property Serializable() As Boolean
        Get
            Return True
        End Get
    End Property

    Public Overrides ReadOnly Property ConfigType() As Type
        Get
            Return GetType(MySettings)
        End Get
    End Property

    Public Overrides ReadOnly Property ConfigPanel() As System.Windows.Forms.Control
        Get
            Return New UserControl1(CType(_settings, MySettings))
        End Get
    End Property

    Public Overrides Sub RegisterData(ByVal ds As IDataService)
        Dim mySet As MySettings = CType(_settings, MySettings)
        ds.RegisterVariable(Group, "RandomQuote.QuoteID", "RandomQuote\QuoteID")
        ds.RegisterVariable(Group, "RandomQuote.QuoteScore", "RandomQuote\QuoteScore")
        ds.RegisterVariable(Group, "RandomQuote.QuoteText", "RandomQuote\QuoteText")
        ds.RegisterVariable(Group, "RandomQuote.Settings.RefreshTime", "RandomQuote\Settings\RefreshTime")
        ds.RegisterVariable(Group, "RandomQuote.Settings.MinimumScore", "RandomQuote\Settings\MinimumScore")
        Me.UpdateInterval = 1000
        'Update every 1000ms (1 sec)
    End Sub

    Public Overrides Sub UpdateData(ByVal ds As IDataService)
        Dim mySet As MySettings = CType(_settings, MySettings)
        ds.SetValue("RandomQuote.Settings.RefreshTime", mySet.RefreshTime)
        ds.SetValue("RandomQuote.Settings.MinimumScore", mySet.MinimumScore)
        secondcount += 1
        If secondcount >= mySet.RefreshTime Or secondcount < 0 Then
            secondcount = 0
            Dim quotelist As String = ReadURL("http://www.bash.org/?random" + IIf(mySet.MinimumScore > 0, "1", ""))
            Dim quotes() As QuoteStruc
            Dim hiquote As QuoteStruc
            Dim tempquote As QuoteStruc
            Dim numquotes As Integer = 0
            While True
                Dim strpos As Integer = quotelist.IndexOf("<p class=" + Chr(34) + "quote" + Chr(34) + ">")
                If strpos = -1 Then Exit While
                quotelist = quotelist.Substring(strpos)
                Dim thisquote As String = quotelist.Substring(0, quotelist.IndexOf("</p>"))
                tempquote.ID = CInt(thisquote.Substring(thisquote.IndexOf("<b>#") + "<b>#".Length, thisquote.IndexOf("</b>", thisquote.IndexOf("<b>#")) - thisquote.IndexOf("<b>#") - "<b>#".Length))
                tempquote.Score = CInt(thisquote.Substring(thisquote.IndexOf("+</a>(") + "+</a>(".Length, thisquote.IndexOf(")<a href=", thisquote.IndexOf("+</a>(")) - thisquote.IndexOf("+</a>(") - "+</a>(".Length))
                quotelist = quotelist.Substring(quotelist.IndexOf("</p>") + "</p>".Length)
                thisquote = quotelist.Substring(("<p class=" + Chr(34) + "qt" + Chr(34) + ">").Length, quotelist.IndexOf("</p>") - ("<p class=" + Chr(34) + "qt" + Chr(34) + ">").Length)
                tempquote.Text = HttpUtility.HtmlDecode(thisquote).Replace("<br />", "")
                If tempquote.Score >= mySet.MinimumScore Then
                    numquotes += 1
                    ReDim Preserve quotes(numquotes)
                    quotes(numquotes) = tempquote
                End If
                If tempquote.Score > hiquote.Score Then hiquote = tempquote
            End While
            If numquotes > 0 Then
                Dim pickquote As Integer = CInt(Int(numquotes * Rnd() + 1))
                ds.SetValue("RandomQuote.QuoteID", quotes(pickquote).ID)
                ds.SetValue("RandomQuote.QuoteScore", quotes(pickquote).Score)
                ds.SetValue("RandomQuote.QuoteText", quotes(pickquote).Text)
            Else
                ds.SetValue("RandomQuote.QuoteID", hiquote.ID)
                ds.SetValue("RandomQuote.QuoteScore", hiquote.Score)
                ds.SetValue("RandomQuote.QuoteText", hiquote.Text)
            End If
        End If
    End Sub

    Public Function ReadURL(ByVal strLocation As String) As String
        Try
            Dim myUri As New Uri(strLocation)
            Dim myWebRequest As WebRequest = WebRequest.Create(myUri)
            Dim myWebResponse As WebResponse = myWebRequest.GetResponse()
            Dim respstream As Stream = myWebResponse.GetResponseStream
            Dim streamread As StreamReader = New StreamReader(respstream)
            ReadURL = streamread.ReadToEnd()
            streamread.Close()
            respstream.Close()
            myWebResponse.Close()
        Catch ex As Exception
            ReadURL = ""
        End Try
    End Function
End Class
