Imports System
Imports LcdStudio.CoreInterfaces

Public Class Plugin
    Inherits AbstractDataPlugin

    Private Declare Function SystemParametersInfo Lib "user32" Alias "SystemParametersInfoA" (ByVal uAction As Integer, ByVal uParam As Integer, ByRef lpvParam As Boolean, ByVal fuWinIni As Integer) As Integer
    Private Const SPI_GETSCREENSAVEACTIVE As Integer = &H10
    Private Const SPI_GETSCREENSAVERRUNNING As Integer = &H72
    Private Const SPI_GETLOWPOWERACTIVE As Integer = 83
    Private Const SPI_GETPOWEROFFACTIVE As Integer = 84

    Private Const SPIF_NOUPDATEINIFILE = &H0
    Private Const SPIF_UPDATEINIFILE = &H1

    Public Overrides Sub RegisterData(ByVal ds As IDataService)
        ds.RegisterVariable(Group, "SSPlugin.ScreenSaverEnabled", "SSPlugin\ScreenSaverEnabled")
        ds.RegisterVariable(Group, "SSPlugin.ScreenSaverRunning", "SSPlugin\ScreenSaverRunning")
        ds.RegisterVariable(Group, "SSPlugin.LowPowerEnabled", "SSPlugin\LowPowerEnabled")
        ds.RegisterVariable(Group, "SSPlugin.PowerOffEnabled", "SSPlugin\PowerOffEnabled")
        Me.UpdateInterval = 1000
        'Update every 1000ms (1 sec)
    End Sub

    Public Overrides Sub UpdateData(ByVal ds As IDataService)
        Dim blnReturn As Boolean

        SystemParametersInfo(SPI_GETSCREENSAVEACTIVE, 0, blnReturn, SPIF_NOUPDATEINIFILE)
        ds.SetValue("SSPlugin.ScreenSaverEnabled", blnReturn)

        SystemParametersInfo(SPI_GETSCREENSAVERRUNNING, 0, blnReturn, SPIF_NOUPDATEINIFILE)
        ds.SetValue("SSPlugin.ScreenSaverRunning", blnReturn)

        SystemParametersInfo(SPI_GETLOWPOWERACTIVE, 0, blnReturn, SPIF_NOUPDATEINIFILE)
        ds.SetValue("SSPlugin.LowPowerEnabled", blnReturn)

        SystemParametersInfo(SPI_GETPOWEROFFACTIVE, 0, blnReturn, SPIF_NOUPDATEINIFILE)
        ds.SetValue("SSPlugin.PowerOffEnabled", blnReturn)
    End Sub
End Class
