Imports System
Imports LcdStudio.CoreInterfaces
Imports System.Net
Imports System.IO

Public Class Plugin
    Inherits AbstractDataPlugin

    Public Overrides ReadOnly Property Serializable() As Boolean
        Get
            Return True
        End Get
    End Property

    Public Overrides ReadOnly Property ConfigType() As Type
        Get
            Return GetType(MySettings)
        End Get
    End Property

    Public Overrides ReadOnly Property ConfigPanel() As System.Windows.Forms.Control
        Get
            Return New UserControl1(CType(_settings, MySettings))
        End Get
    End Property

    Public Overrides Sub RegisterData(ByVal ds As IDataService)
        Dim mySet As MySettings = CType(_settings, MySettings)
        ds.RegisterVariable(Group, "TrueIP.IPAddress", "TrueIP\IPAddress")
        ds.RegisterVariable(Group, "TrueIP.Settings.URL", "TrueIP\Settings\URL")
        Me.UpdateInterval = 300000
        'Update every 300000ms (5 min)
    End Sub

    Public Overrides Sub UpdateData(ByVal ds As IDataService)
        Dim mySet As MySettings = CType(_settings, MySettings)
        ds.SetValue("TrueIP.Settings.URL", mySet.URL)
        ds.SetValue("TrueIP.IPAddress", ReadURL(mySet.URL))
    End Sub

    Public Function ReadURL(ByVal strLocation As String) As String
        Try
            Dim myUri As New Uri(strLocation)
            Dim myWebRequest As WebRequest = WebRequest.Create(myUri)
            Dim myWebResponse As WebResponse = myWebRequest.GetResponse()
            Dim respstream As Stream = myWebResponse.GetResponseStream
            Dim streamread As StreamReader = New StreamReader(respstream)
            ReadURL = streamread.ReadToEnd()
            streamread.Close()
            respstream.Close()
            myWebResponse.Close()
        Catch ex As Exception
            ReadURL = ""
        End Try
    End Function
End Class
