VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "CDDrive"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Controls any CD-ROM drive."
Private Declare Function mciSendString Lib "winmm.dll" Alias "mciSendStringA" (ByVal lpszCommand As String, ByVal lpszReturnString As String, ByVal cchReturnLength As Long, ByVal hwndCallback As Long) As Long
Private Declare Function GetLogicalDriveStrings Lib "kernel32" Alias "GetLogicalDriveStringsA" (ByVal nBufferLength As Long, ByVal lpBuffer As String) As Long
Private Declare Function GetDriveType Lib "kernel32" Alias "GetDriveTypeA" (ByVal nDrive As String) As Long
Private Declare Function GetVolumeInformation& Lib "kernel32" Alias "GetVolumeInformationA" (ByVal lpRootPathName As String, ByVal pVolumeNameBuffer As String, ByVal nVolumeNameSize As Long, lpVolumeSerialNumber As Long, lpMaximumComponentLength As Long, lpFileSystemFlags As Long, ByVal lpFileSystemNameBuffer As String, ByVal nFileSystemNameSize As Long)
Private Declare Function GetWindowsDirectory Lib "kernel32.dll" Alias "GetWindowsDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long) As Long
Private Declare Function GetPrivateProfileString Lib "kernel32.dll" Alias "GetPrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As Any, ByVal lpDefault As String, ByVal lpReturnedString As String, ByVal nSize As Long, ByVal lpFileName As String) As Long
Private Declare Function WritePrivateProfileString Lib "kernel32.dll" Alias "WritePrivateProfileStringA" (ByVal lpApplicationName As String, ByVal lpKeyName As String, ByVal lpString As String, ByVal lpFileName As String) As Long

Public Function CloseDoor(ByVal strAliasName As String) As Boolean
retvalue = mciSendString("set " & strAliasName & " door closed wait", returnstring, 127, 0)
If retvalue = 0 Then CloseDoor = True Else CloseDoor = False
End Function

Public Function CloseDrive(ByVal strAliasName As String) As Boolean
If mciSendString("close " & strAliasName, "", 0&, 0&) = 0 Then
    CloseDrive = True
Else
    CloseDrive = False
End If
End Function

Public Function GetArtistName(ByVal strCDDrive As String) As String
Dim No As Long
Dim SerNum As String
Dim tempstr As String
If InStr(strCDDrive, ":\") = 0 Then
    If InStr(strCDDrive, ":") Then strCDDrive = strCDDrive & "\" Else strCDDrive = strCDDrive & ":\"
End If
SerNum = GetVolumeNumber(strCDDrive)
If Left$(SerNum, 2) <> "No" Then
    Dim windir As String
    Dim result As String
    windir = Space(255)
    No = GetWindowsDirectory(windir, 255)
    windir = Left(windir, No)
    If Right$(windir, 1) <> "\" Then windir = windir & "\"
    result = Space(255)
    No = GetPrivateProfileString(SerNum, "artist", "New Artist", result, 255, windir & "cdplayer.ini")
    result = Left(result, No)
    GetArtistName = result
Else
    GetArtistName = SerNum
End If
End Function

Public Function GetCurrentMinuteInTrack(ByVal strAliasName As String) As Long
Call mciSendString("set " & strAliasName & " time format tmsf", "", 0&, 0&)
Dim tempmcistr As String
tempmcistr = Space(255)
If mciSendString("status " & strAliasName & " position", tempmcistr, 255, 0&) = 0 Then
    tempmcistr = Left$(tempmcistr, InStr(tempmcistr, Chr$(0)) - 4)
    GetCurrentMinuteInTrack = CLng(Mid(tempmcistr, 4, 2))
Else
    GetCurrentMinuteInTrack = -1
End If
End Function

Public Function GetCurrentSecondInTrack(ByVal strAliasName As String) As Long
Call mciSendString("set " & strAliasName & " time format tmsf", "", 0&, 0&)
Dim tempmcistr As String
tempmcistr = Space(255)
If mciSendString("status " & strAliasName & " position", tempmcistr, 255, 0&) = 0 Then
    tempmcistr = Left$(tempmcistr, InStr(tempmcistr, Chr$(0)) - 4)
    GetCurrentSecondInTrack = CLng(Mid(tempmcistr, 7, 2))
Else
    GetCurrentSecondInTrack = -1
End If
End Function

Public Function GetCurrentMinuteTotal(ByVal strAliasName As String) As Long
Call mciSendString("set " & strAliasName & " time format msf", "", 0&, 0&)
Dim tempmcistr As String
tempmcistr = Space(255)
If mciSendString("status " & strAliasName & " position", tempmcistr, 255, 0&) = 0 Then
    tempmcistr = Left$(tempmcistr, InStr(tempmcistr, Chr$(0)) - 4)
    GetCurrentMinuteTotal = CLng(Left(tempmcistr, 2))
Else
    GetCurrentMinuteTotal = -1
End If
End Function

Public Function GetCurrentSecondTotal(ByVal strAliasName As String) As Long
Call mciSendString("set " & strAliasName & " time format msf", "", 0&, 0&)
Dim tempmcistr As String
tempmcistr = Space(255)
If mciSendString("status " & strAliasName & " position", tempmcistr, 255, 0&) = 0 Then
    tempmcistr = Left$(tempmcistr, InStr(tempmcistr, Chr$(0)) - 4)
    GetCurrentSecondTotal = CLng(Mid(tempmcistr, 4, 2))
Else
    GetCurrentSecondTotal = -1
End If
End Function

Public Function GetCurrentTrack(ByVal strAliasName As String) As Long
Call mciSendString("set " & strAliasName & " time format tmsf", "", 0&, 0&)
Dim tempmcistr As String
tempmcistr = Space(255)
If mciSendString("status " & strAliasName & " position", tempmcistr, 255, 0&) = 0 Then
    tempmcistr = Left$(tempmcistr, InStr(tempmcistr, Chr$(0)) - 4)
    GetCurrentTrack = CLng(Left(tempmcistr, 2))
Else
    GetCurrentTrack = -1
End If
End Function

Public Function GetNumberTracks(ByVal strAliasName As String) As Long
Dim tempmcistr As String
tempmcistr = Space(255)
If mciSendString("status " & strAliasName & " number of tracks", tempmcistr, 255, 0&) = 0 Then
    tempmcistr = Left$(tempmcistr, InStr(tempmcistr, Chr$(0)) - 1)
    GetNumberTracks = CLng(tempmcistr)
Else
    GetNumberTracks = -1
End If
End Function

Public Function GetStartOfTrackMinutes(ByVal strAliasName As String, ByVal lngTrackNum As Long) As Long
Call mciSendString("set " & strAliasName & " time format msf", "", 0&, 0&)
Dim tempmcistr As String
tempmcistr = Space(255)
If mciSendString("status " & strAliasName & " position track " & CStr(lngTrackNum), tempmcistr, 255, 0&) = 0 Then
    tempmcistr = Left$(tempmcistr, InStr(tempmcistr, Chr$(0)) - 4)
    GetStartOfTrackMinutes = CLng(Left(tempmcistr, 2))
Else
    GetStartOfTrackMinutes = -1
End If
End Function

Public Function GetStartOfTrackSeconds(ByVal strAliasName As String, ByVal lngTrackNum As Long) As Long
Call mciSendString("set " & strAliasName & " time format msf", "", 0&, 0&)
Dim tempmcistr As String
tempmcistr = Space(255)
If mciSendString("status " & strAliasName & " position track " & CStr(lngTrackNum), tempmcistr, 255, 0&) = 0 Then
    tempmcistr = Left$(tempmcistr, InStr(tempmcistr, Chr$(0)) - 4)
    GetStartOfTrackSeconds = CLng(Mid(tempmcistr, 4, 2))
Else
    GetStartOfTrackSeconds = -1
End If
End Function

Public Function GetTitleName(ByVal strCDDrive As String) As String
Dim No As Long
Dim SerNum As String
Dim tempstr As String
If InStr(strCDDrive, ":\") = 0 Then
    If InStr(strCDDrive, ":") Then strCDDrive = strCDDrive & "\" Else strCDDrive = strCDDrive & ":\"
End If
SerNum = GetVolumeNumber(strCDDrive)
If Left$(SerNum, 2) <> "No" Then
    Dim windir As String
    Dim result As String
    windir = Space(255)
    No = GetWindowsDirectory(windir, 255)
    windir = Left(windir, No)
    If Right$(windir, 1) <> "\" Then windir = windir & "\"
    result = Space(255)
    No = GetPrivateProfileString(SerNum, "title", "New Title", result, 255, windir & "cdplayer.ini")
    result = Left(result, No)
    GetTitleName = result
Else
    GetTitleName = SerNum
End If
End Function

Public Function GetTotalLength(ByVal strAliasName As String) As Long
Call mciSendString("set " & strAliasName & " time format ms", "", 0&, 0&)
Dim tempmcistr As String
tempmcistr = Space(255)
If mciSendString("status " & strAliasName & " length", tempmcistr, 255, 0&) = 0 Then
    tempmcistr = Left$(tempmcistr, InStr(tempmcistr, Chr$(0)) - 1)
    GetTotalLength = CLng(CLng(tempmcistr) / 1000)
Else
    GetTotalLength = -1
End If
End Function

Public Function GetTrackLength(ByVal strAliasName As String, ByVal lngTrackNum As Long) As Long
Call mciSendString("set " & strAliasName & " time format ms", "", 0&, 0&)
Dim tempmcistr As String
tempmcistr = Space(255)
If mciSendString("status " & strAliasName & " length track " & CStr(lngTrackNum), tempmcistr, 255, 0&) = 0 Then
    tempmcistr = Left$(tempmcistr, InStr(tempmcistr, Chr$(0)) - 1)
    GetTrackLength = CLng(CLng(tempmcistr) / 1000)
Else
    GetTrackLength = -1
End If
End Function

Public Function GetTrackName(ByVal strCDDrive As String, ByVal lngTrackNum As Long) As String
Dim No As Long
Dim SerNum As String
Dim tempstr As String
If InStr(strCDDrive, ":\") = 0 Then
    If InStr(strCDDrive, ":") Then strCDDrive = strCDDrive & "\" Else strCDDrive = strCDDrive & ":\"
End If
SerNum = GetVolumeNumber(strCDDrive)
If Left$(SerNum, 2) <> "No" Then
    Dim windir As String
    Dim result As String
    windir = Space(255)
    No = GetWindowsDirectory(windir, 255)
    windir = Left(windir, No)
    If Right$(windir, 1) <> "\" Then windir = windir & "\"
    result = Space(255)
    No = GetPrivateProfileString(SerNum, CStr(lngTrackNum - 1), "Track " & CStr(lngTrackNum), result, 255, windir & "cdplayer.ini")
    result = Left(result, No)
    GetTrackName = result
Else
    GetTrackName = SerNum
End If
End Function

Private Function GetVolumeNumber(ByVal strDrive As String) As String
Dim No As Long
Dim volname As String
Dim templng1 As Long
Dim templng2 As Long
Dim tempstr As String
tempstr = Space$(256)
volname = Space$(256)
If InStr(strDrive, ":\") = 0 Then
    If InStr(strDrive, ":") Then strDrive = strDrive & "\" Else strDrive = strDrive & ":\"
End If
Call GetVolumeInformation(strDrive, volname, Len(volname), No, templng1, templng2, tempstr, Len(tempstr))
If Left$(volname, 8) = "Audio CD" Then
    GetVolumeNumber = Trim(Hex(No))
Else
    If No = 0 Then
        GetVolumeNumber = "No media loaded"
    Else
        GetVolumeNumber = "Not Audio"
    End If
End If
End Function

Public Function IsMediaInDrive(ByVal strAliasName As String) As Boolean
Dim tempmcistr As String
tempmcistr = Space(255)
If mciSendString("status " & strAliasName & " media present", tempmcistr, 255, 0&) = 0 Then
    If UCase(Left$(tempmcistr, 4)) = "TRUE" Then IsMediaInDrive = True Else IsMediaInDrive = False
Else
    IsMediaInDrive = False
End If
End Function

Public Function IsPaused(ByVal strAliasName As String) As Boolean
Dim tempmcistr As String
tempmcistr = Space(255)
If mciSendString("status " & strAliasName & " mode", tempmcistr, 255, 0&) = 0 Then
    If UCase(Left$(tempmcistr, 6)) = "PAUSED" Then IsPaused = True Else IsPaused = False
Else
    IsPaused = False
End If
End Function

Public Function IsPlaying(ByVal strAliasName As String) As Boolean
Dim tempmcistr As String
tempmcistr = Space(255)
If mciSendString("status " & strAliasName & " mode", tempmcistr, 255, 0&) = 0 Then
    If UCase(Left$(tempmcistr, 7)) = "PLAYING" Then IsPlaying = True Else IsPlaying = False
Else
    IsPlaying = False
End If
End Function

Public Function IsStopped(ByVal strAliasName As String) As Boolean
Dim tempmcistr As String
tempmcistr = Space(255)
If mciSendString("status " & strAliasName & " mode", tempmcistr, 255, 0&) = 0 Then
    If UCase(Left$(tempmcistr, 7)) = "STOPPED" Or UCase(Left$(tempmcistr, 4)) = "OPEN" Then IsStopped = True Else IsStopped = False
Else
    IsStopped = False
End If
End Function

Public Function LeftChannel(ByVal strAliasName As String, ByVal blnStatus As Boolean) As Boolean
Dim tempstr As String
If blnStatus = True Then tempstr = "on" Else tempstr = "off"
If mciSendString("set " & strAliasName & "audio left " & tempstr, "", 0&, 0&) = 0 Then
    LeftChannel = True
Else
    LeftChannel = False
End If
End Function

Public Function Mute(ByVal strAliasName As String, ByVal blnStatus As Boolean) As Boolean
Dim tempstr As String
If blnStatus = True Then tempstr = "on" Else tempstr = "off"
If mciSendString("set " & strAliasName & "audio all " & tempstr, "", 0&, 0&) = 0 Then
    Mute = True
Else
    Mute = False
End If
End Function

Public Function OpenDoor(ByVal strAliasName As String) As Boolean
Attribute OpenDoor.VB_Description = "Opens the CD drive."
retvalue = mciSendString("set " & strAliasName & " door open wait", returnstring, 127, 0)
If retvalue = 0 Then OpenDoor = True Else OpenDoor = False
End Function

Public Function OpenDrive(ByVal strCDDrive As String, ByVal strAliasName As String) As Boolean
If InStr(strCDDrive, ":\") = 0 Then
    If InStr(strCDDrive, ":") Then strCDDrive = strCDDrive & "\" Else strCDDrive = strCDDrive & ":\"
End If
Call mciSendString("close " & strAliasName, "", 0&, 0&)
If mciSendString("open " & Left$(strCDDrive, 2) & " type CDAudio alias " & strAliasName & " shareable wait", "", 0&, 0&) = 0 Then
    OpenDrive = True
Else
    OpenDrive = False
End If
End Function

Public Function PauseCD(ByVal strAliasName As String) As Boolean
If mciSendString("pause " & strAliasName, "", 0&, 0&) = 0 Then
    PauseCD = True
Else
    PauseCD = False
End If
End Function

Public Function PlayCD(ByVal strAliasName As String) As Boolean
If mciSendString("play " & strAliasName, "", 0&, 0&) = 0 Then
    PlayCD = True
Else
    PlayCD = False
End If
End Function

Public Function RightChannel(ByVal strAliasName As String, ByVal blnStatus As Boolean) As Boolean
Dim tempstr As String
If blnStatus = True Then tempstr = "on" Else tempstr = "off"
If mciSendString("set " & strAliasName & "audio right " & tempstr, "", 0&, 0&) = 0 Then
    RightChannel = True
Else
    RightChannel = False
End If
End Function

Public Function SetArtistName(ByVal strCDDrive As String, ByVal strNewArtistName As String) As Boolean
Dim No As Long
Dim SerNum As String
Dim tempstr As String
If InStr(strCDDrive, ":\") = 0 Then
    If InStr(strCDDrive, ":") Then strCDDrive = strCDDrive & "\" Else strCDDrive = strCDDrive & ":\"
End If
SerNum = GetVolumeNumber(strCDDrive)
If Left$(SerNum, 2) <> "No" Then
    Dim windir As String
    Dim result As String
    windir = Space(255)
    No = GetWindowsDirectory(windir, 255)
    windir = Left(windir, No)
    If Right$(windir, 1) <> "\" Then windir = windir & "\"
    result = Space(255)
    No = GetPrivateProfileString(SerNum, "EntryType", "None", result, 255, windir & "cdplayer.ini")
    result = Left(result, No)
    If result = "None" Then
        No = WritePrivateProfileString(SerNum, "EntryType", "1", windir & "cdplayer.ini")
        Call mciSendString("open " & Left$(strCDDrive, 2) & " type CDAudio alias CDDrive shareable wait", "", 0&, 0&)
        Dim tempmcistr As String
        tempmcistr = Space(255)
        Call mciSendString("status CDDrive number of tracks", tempmcistr, 255, 0&)
        tempmcistr = Left$(tempmcistr, InStr(tempmcistr, Chr$(0)) - 1)
        Call mciSendString("close CDDrive", "", 0&, 0&)
        No = WritePrivateProfileString(SerNum, "numtracks", tempmcistr, windir & "cdplayer.ini")
    End If
    No = WritePrivateProfileString(SerNum, "artist", strNewArtistName, windir & "cdplayer.ini")
    If No = 0 Then SetArtistName = False Else SetArtistName = True
Else
    SetArtistName = False
End If
End Function

Public Function SetCurrentPosition(ByVal strAliasName As String, Optional ByVal lngTrackNum As Long, Optional lngMinutes As Long, Optional lngSeconds As Long) As Boolean
Call mciSendString("set " & strAliasName & " time format tmsf", "", 0&, 0&)
If lngTrackNum > 99 Then lngTrackNum = 99
If lngMinutes > 99 Then lngMinutes = 99
If lngSeconds > 59 Then lngSeconds = 59
If IsPlaying(strAliasName) = True Then
    currentlyplaying = True
    Call mciSendString("stop " & strAliasName, "", 0&, 0&)
End If
If lngTrackNum > 0 Then
    If mciSendString("seek " & strAliasName & " to " & CStr(lngTrackNum) & ":" & CStr(lngMinutes) & ":" & CStr(lngSeconds), "", 0&, 0&) = 0 Then
        If currentlyplaying = True Then
            Call mciSendString("play " & strAliasName, "", 0&, 0&)
        End If
        SetCurrentPosition = True
    Else
        SetCurrentPosition = False
    End If
Else
    If mciSendString("seek " & strAliasName & " to start", "", 0&, 0&) = 0 Then
        If currentlyplaying = True Then
            Call mciSendString("play " & strAliasName, "", 0&, 0&)
        End If
        SetCurrentPosition = True
    Else
        SetCurrentPosition = False
    End If
End If
End Function

Public Function SetTitleName(ByVal strCDDrive As String, ByVal strNewTitleName As String) As Boolean
Dim No As Long
Dim SerNum As String
Dim tempstr As String
If InStr(strCDDrive, ":\") = 0 Then
    If InStr(strCDDrive, ":") Then strCDDrive = strCDDrive & "\" Else strCDDrive = strCDDrive & ":\"
End If
SerNum = GetVolumeNumber(strCDDrive)
If Left$(SerNum, 2) <> "No" Then
    Dim windir As String
    Dim result As String
    windir = Space(255)
    No = GetWindowsDirectory(windir, 255)
    windir = Left(windir, No)
    If Right$(windir, 1) <> "\" Then windir = windir & "\"
    result = Space(255)
    No = GetPrivateProfileString(SerNum, "EntryType", "None", result, 255, windir & "cdplayer.ini")
    result = Left(result, No)
    If result = "None" Then
        No = WritePrivateProfileString(SerNum, "EntryType", "1", windir & "cdplayer.ini")
        Call mciSendString("open " & Left$(strCDDrive, 2) & " type CDAudio alias CDDrive shareable wait", "", 0&, 0&)
        Dim tempmcistr As String
        tempmcistr = Space(255)
        Call mciSendString("status CDDrive number of tracks", tempmcistr, 255, 0&)
        tempmcistr = Left$(tempmcistr, InStr(tempmcistr, Chr$(0)) - 1)
        Call mciSendString("close CD", "", 0&, 0&)
        No = WritePrivateProfileString(SerNum, "numtracks", tempmcistr, windir & "cdplayer.ini")
    End If
    No = WritePrivateProfileString(SerNum, "title", strNewTitleName, windir & "cdplayer.ini")
    If No = 0 Then SetTitleName = False Else SetTitleName = True
Else
    SetTitleName = False
End If
End Function

Public Function SetTrackName(ByVal strCDDrive As String, ByVal lngTrackNum As Long, ByVal strNewTrackName As String) As Boolean
Dim No As Long
Dim SerNum As String
Dim tempstr As String
If InStr(strCDDrive, ":\") = 0 Then
    If InStr(strCDDrive, ":") Then strCDDrive = strCDDrive & "\" Else strCDDrive = strCDDrive & ":\"
End If
SerNum = GetVolumeNumber(strCDDrive)
If Left$(SerNum, 2) <> "No" Then
    Dim windir As String
    Dim result As String
    windir = Space(255)
    No = GetWindowsDirectory(windir, 255)
    windir = Left(windir, No)
    If Right$(windir, 1) <> "\" Then windir = windir & "\"
    result = Space(255)
    No = GetPrivateProfileString(SerNum, "EntryType", "None", result, 255, windir & "cdplayer.ini")
    result = Left(result, No)
    If result = "None" Then
        No = WritePrivateProfileString(SerNum, "EntryType", "1", windir & "cdplayer.ini")
        No = WritePrivateProfileString(SerNum, "artist", "New Artist", windir & "cdplayer.ini")
        No = WritePrivateProfileString(SerNum, "title", "New Title", windir & "cdplayer.ini")
        Call mciSendString("open " & Left$(strCDDrive, 2) & " type CDAudio alias CDDrive shareable wait", "", 0&, 0&)
        Dim tempmcistr As String
        tempmcistr = Space(255)
        Call mciSendString("status CDDrive number of tracks", tempmcistr, 255, 0&)
        tempmcistr = Left$(tempmcistr, InStr(tempmcistr, Chr$(0)) - 1)
        Call mciSendString("close CD", "", 0&, 0&)
        No = WritePrivateProfileString(SerNum, "numtracks", tempmcistr, windir & "cdplayer.ini")
    End If
    No = WritePrivateProfileString(SerNum, CStr(lngTrackNum - 1), strNewTrackName, windir & "cdplayer.ini")
    If No = 0 Then SetTrackName = False Else SetTrackName = True
Else
    SetTrackName = False
End If
End Function

Public Function StopCD(ByVal strAliasName As String) As Boolean
If mciSendString("stop " & strAliasName, "", 0&, 0&) = 0 Then
    StopCD = True
Else
    StopCD = False
End If
End Function

