VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "DrawGradient"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Public Enum GradientTypes
    GTopToBottom = 1
    GLeftToRight
    GBottomToTop
    GRightToLeft
End Enum

Public Sub Draw(obj As Object, gradtype As GradientTypes, colorlist() As Long, Optional x As Long, Optional y As Long, Optional height As Long, Optional width As Long)
Attribute Draw.VB_Description = "Draws a multi-colored gradient"
Attribute Draw.VB_UserMemId = 0
uppercolors = UBound(colorlist)
lowercolors = LBound(colorlist)
numcolors = (uppercolors - lowercolors) + 1
If gradtype = GBottomToTop Or gradtype = GRightToLeft Then
    ReDim temparray(LBound(colorlist) To UBound(colorlist)) As Long
    For a = uppercolors To lowercolors Step -1
        temparray((uppercolors - a) + 1) = colorlist(a)
    Next a
    For a = lowercolors To uppercolors
        colorlist(a) = temparray(a)
    Next a
End If
On Error Resume Next
If TypeOf obj Is Form Then
    If width = 0 Then width = obj.ScaleWidth
    If height = 0 Then height = obj.ScaleHeight
Else
    If width = 0 Then width = obj.width
    If height = 0 Then height = obj.height
End If
If TypeOf obj Is Printer Then
    tppy = Printer.TwipsPerPixelY
    tppx = Printer.TwipsPerPixelX
Else
    obj.AutoRedraw = True
    tppy = Screen.TwipsPerPixelY
    tppx = Screen.TwipsPerPixelX
End If
For b = lowercolors To uppercolors - 1
    temp = (colorlist(b) And 255)
    ra = temp And 255
    temp = Int(colorlist(b) / 256)
    ga = temp And 255
    temp = Int(colorlist(b) / 65536)
    ba = temp And 255
    temp = (colorlist(b + 1) And 255)
    rb = temp And 255
    temp = Int(colorlist(b + 1) / 256)
    gb = temp And 255
    temp = Int(colorlist(b + 1) / 65536)
    bb = temp And 255
    If gradtype = GTopToBottom Or gradtype = GBottomToTop Then
        rchange = (rb - ra) / (height / (numcolors - 1))
        gchange = (gb - ga) / (height / (numcolors - 1))
        bchange = (bb - ba) / (height / (numcolors - 1))
        For a = y + (((height - y) / (numcolors - 1)) * (b - 1)) To y + (((height - y) / (numcolors - 1)) * b) Step tppy
            obj.Line (x, a)-(x + width, a), RGB(ra, ga, ba)
            ra = ra + (tppy * rchange)
            ga = ga + (tppy * gchange)
            ba = ba + (tppy * bchange)
        Next a
    Else
        rchange = (rb - ra) / (width / (numcolors - 1))
        gchange = (gb - ga) / (width / (numcolors - 1))
        bchange = (bb - ba) / (width / (numcolors - 1))
        For a = x + (((width - x) / (numcolors - 1)) * (b - 1)) To x + (((width - x) / (numcolors - 1)) * b) Step tppx
            obj.Line (a, y)-(a, y + height), RGB(ra, ga, ba)
            ra = ra + (tppx * rchange)
            ga = ga + (tppx * gchange)
            ba = ba + (tppx * bchange)
        Next a
    End If
Next b
End Sub

