VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "File"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "A collection of routines for file manipulation"
Private Type FILETIME
  dwLowDateTime As Long
  dwHighDateTime As Long
End Type

Private Type BY_HANDLE_FILE_INFORMATION
  dwFileAttributes As Long
  ftCreationTime As FILETIME
  ftLastAccessTime As FILETIME
  ftLastWriteTime As FILETIME
  dwVolumeSerialNumber As Long
  nFileSizeHigh As Long
  nFileSizeLow As Long
  nNumberOfLinks As Long
  nFileIndexHigh As Long
  nFileIndexLow As Long
End Type

Private Type ULARGE_INTEGER
  LowPart As Long
  HighPart As Long
End Type

Public Enum OpenFileVerbs
    OFVread = &H80000000
    OFVwrite = &H40000000
End Enum

Private Const FILE_ATTRIBUTE_ARCHIVE = &H20
Private Const FILE_ATTRIBUTE_COMPRESSED = &H800
Private Const FILE_ATTRIBUTE_DIRECTORY = &H10
Private Const FILE_ATTRIBUTE_HIDDEN = &H2
Private Const FILE_ATTRIBUTE_NORMAL = &H80
Private Const FILE_ATTRIBUTE_READONLY = &H1
Private Const FILE_ATTRIBUTE_SYSTEM = &H4

Private mblnArchive(1 To 255) As Boolean
Private mblnCompressed(1 To 255) As Boolean
Private mblnHidden(1 To 255) As Boolean
Private mblnReadOnly(1 To 255) As Boolean
Private mblnSystem(1 To 255) As Boolean
Private mdwVolumeSerialNumber(1 To 255) As Long
Private mlngFileSize(1 To 255) As Long
Private mstrFileSize(1 To 255) As String
Private mlngFileHandle(1 To 255) As Long
Private mstrPathFile(1 To 255) As String
Private mstrPath(1 To 255) As String
Private mstrFile(1 To 255) As String
Private mstrExtension(1 To 255) As String
Private mstr83File(1 To 255) As String
Private mstr83PathFile(1 To 255) As String
Private mlngFilePos(1 To 255) As Long
Private mstrSlotsUsed(1 To 255) As String

Private Declare Function CreateFile Lib "kernel32.dll" Alias "CreateFileA" (ByVal lpFileName As String, ByVal dwDesiredAccess As Long, ByVal dwShareMode As Long, lpSecurityAttributes As Any, ByVal dwCreationDisposition As Long, ByVal dwFlagsAndAttributes As Long, ByVal hTemplateFile As Long) As Long
Private Declare Function CloseHandle Lib "kernel32.dll" (ByVal hObject As Long) As Long
Private Declare Function WriteFile Lib "kernel32.dll" (ByVal hFile As Long, lpBuffer As Any, ByVal nNumberOfBytesToWrite As Long, lpNumberOfBytesWritten As Long, lpOverlapped As Any) As Long
Private Declare Function ReadFile Lib "kernel32.dll" (ByVal hFile As Long, lpBuffer As Any, ByVal nNumberOfBytesToRead As Long, lpNumberOfBytesRead As Long, lpOverlapped As Any) As Long
Private Declare Function GetFileInformationByHandle Lib "kernel32.dll" (ByVal hFile As Long, lpFileInformation As BY_HANDLE_FILE_INFORMATION) As Long
Private Declare Sub CopyMemory Lib "kernel32.dll" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal Length As Long)
Private Declare Function GetShortPathName Lib "kernel32.dll" Alias "GetShortPathNameA" (ByVal lpszLongPath As String, ByVal lpszShortPath As String, ByVal cchBuffer As Long) As Long
Private Declare Function SetFilePointer Lib "kernel32.dll" (ByVal hFile As Long, ByVal lDistanceToMove As Long, lpDistanceToMoveHigh As Long, ByVal dwMoveMethod As Long) As Long

Public Property Get Archive(ByVal lngSlotNumber As Long) As Boolean
Attribute Archive.VB_Description = "The file's Archive property."
Archive = mblnArchive(lngSlotNumber)
End Property

Public Property Get Compressed(ByVal lngSlotNumber As Long) As Boolean
Attribute Compressed.VB_Description = "The file's Compressed property."
Compressed = mblnCompressed(lngSlotNumber)
End Property

Public Property Get Hidden(ByVal lngSlotNumber As Long) As Boolean
Attribute Hidden.VB_Description = "The file's Hidden property."
Hidden = mblnHidden(lngSlotNumber)
End Property

Public Property Get ReadOnly(ByVal lngSlotNumber As Long) As Boolean
Attribute ReadOnly.VB_Description = "The file's Read-only property."
ReadOnly = mblnReadOnly(lngSlotNumber)
End Property

Public Property Get System(ByVal lngSlotNumber As Long) As Boolean
Attribute System.VB_Description = "The file's System property."
System = mblnSystem(lngSlotNumber)
End Property

Public Property Get VolumeSerialNumber(ByVal lngSlotNumber As Long) As Long
Attribute VolumeSerialNumber.VB_Description = "The serial number of the volume that the file is on."
VolumeSerialNumber = mdwVolumeSerialNumber(lngSlotNumber)
End Property

Public Property Get FileSizeLong(ByVal lngSlotNumber As Long) As Long
Attribute FileSizeLong.VB_Description = "A numerical representation of the size of the file."
FileSizeLong = mlngFileSize(lngSlotNumber)
End Property

Public Property Get FileSizeStr(ByVal lngSlotNumber As Long) As String
Attribute FileSizeStr.VB_Description = "A string representation of the size of the file."
FileSizeStr = mstrFileSize(lngSlotNumber)
End Property

Public Property Get FileHandle(ByVal lngSlotNumber As Long) As Long
Attribute FileHandle.VB_Description = "The handle to the file opened."
FileHandle = mlngFileHandle(lngSlotNumber)
End Property

Public Property Get PathFile(ByVal lngSlotNumber As Long) As String
Attribute PathFile.VB_Description = "The path name, file name, and extension of the file."
PathFile = mstrPathFile(lngSlotNumber)
End Property

Public Property Get PathName(ByVal lngSlotNumber As Long) As String
Attribute PathName.VB_Description = "The path name only of the file."
Path = mstrPath(lngSlotNumber)
End Property

Public Property Get FileName(ByVal lngSlotNumber As Long) As String
Attribute FileName.VB_Description = "The file name and extension only of the file."
FileName = mstrFile(lngSlotNumber)
End Property

Public Property Get Extension(ByVal lngSlotNumber As Long) As String
Attribute Extension.VB_Description = "The extension only of the file."
Extension = mstrExtension(lngSlotNumber)
End Property

Public Property Get ShortFileName(ByVal lngSlotNumber As Long) As String
Attribute ShortFileName.VB_Description = "The 8.3 file name and extension only of the file."
ShortFileName = mstr83File(lngSlotNumber)
End Property

Public Property Get ShortPathFile(ByVal lngSlotNumber As Long) As String
Attribute ShortPathFile.VB_Description = "The 8.3 path name, file name, and extension of the file."
ShortPathFile = mstr83PathFile(lngSlotNumber)
End Property

Public Property Get FilePos(ByVal lngSlotNumber As Long) As Long
Attribute FilePos.VB_Description = "The position of the file pointer (where Read operations start)."
FilePos = mlngFilePos(lngSlotNumber)
End Property

Public Property Get FileMode(ByVal lngSlotNumber As Long) As String
Attribute FileMode.VB_Description = "The current mode of the file.\r\n* ""Empty"" - No file exists in this slot.\r\n* ""Read""  - The file in this slot is opened for Reading.\r\n* ""Write"" - The file in this slot is opened for Writing."
If mstrSlotsUsed(lngSlotNumber) = "" Then FileMode = "Empty" Else FileMode = mstrSlotsUsed(lngSlotNumber)
End Property

Public Function OpenF(ByVal lngSlotNumber As Long, ByVal strFile As String, ByVal vrbType As OpenFileVerbs, ByVal blnMustExist As Boolean) As Boolean
Attribute OpenF.VB_Description = "Opens or creates a file for input or output"
If lngSlotNumber > 255 Or lngSlotNumber < 1 Then
    Err.Raise 1000, "OpenF", "Slot number must be between 1 and 255"
    Exit Function
End If
If mstrSlotsUsed(lngSlotNumber) <> "" Then
    Err.Raise 1000, "OpenF", "Slot is currently being used."
    Exit Function
End If
Dim tempval As Long
Dim fileinfo As BY_HANDLE_FILE_INFORMATION
Dim tempularge As ULARGE_INTEGER
If blnMustExist = True Then tempval = 3 Else tempval = 1
mlngFileHandle(lngSlotNumber) = CreateFile(strFile, vrbType, &H1, ByVal CLng(0), tempval, &H80, 0)
If mlngFileHandle(lngSlotNumber) = -1 Then
    OpenF = False
    Exit Function
End If
OpenF = True
If vrbType = OFVread Then mstrSlotsUsed(lngSlotNumber) = "Read" Else mstrSlotsUsed(lngSlotNumber) = "Write"
mlngFilePos(lngSlotNumber) = 0
retval = GetFileInformationByHandle(mlngFileHandle(lngSlotNumber), fileinfo)
If fileinfo.dwFileAttributes And FILE_ATTRIBUTE_ARCHIVE Then mblnArchive(lngSlotNumber) = True Else mblnArchive(lngSlotNumber) = False
If fileinfo.dwFileAttributes And FILE_ATTRIBUTE_COMPRESSED Then mblnCompressed(lngSlotNumber) = True Else mblnCompressed(lngSlotNumber) = False
If fileinfo.dwFileAttributes And FILE_ATTRIBUTE_HIDDEN Then mblnHidden(lngSlotNumber) = True Else mblnHidden(lngSlotNumber) = False
If fileinfo.dwFileAttributes And FILE_ATTRIBUTE_READONLY Then mblnReadOnly(lngSlotNumber) = True Else mblnReadOnly(lngSlotNumber) = False
If fileinfo.dwFileAttributes And FILE_ATTRIBUTE_SYSTEM Then mblnSystem(lngSlotNumber) = True Else mblnSystem(lngSlotNumber) = False
mdwVolumeSerialNumber(lngSlotNumber) = fileinfo.dwVolumeSerialNumber
tempularge.LowPart = fileinfo.nFileSizeLow
tempularge.HighPart = fileinfo.nFileSizeHigh
mlngFileSize(lngSlotNumber) = FindULARGEValue(tempularge)
mstrFileSize(lngSlotNumber) = FindByteString(FindULARGEValue(tempularge))
mstrPathFile(lngSlotNumber) = LCase(strFile)
For a = 1 To Len(mstrPathFile(lngSlotNumber))
    If InStr(right$(mstrPathFile(lngSlotNumber), a), "\") Then Exit For
Next a
mstrFile(lngSlotNumber) = right$(mstrPathFile(lngSlotNumber), a - 1)
mstrPath(lngSlotNumber) = left$(mstrPathFile(lngSlotNumber), Len(mstrPathFile(lngSlotNumber)) - a + 1)
For a = 1 To Len(mstrPathFile(lngSlotNumber))
    If InStr(right$(mstrPathFile(lngSlotNumber), a), ".") Then Exit For
Next a
mstrExtension(lngSlotNumber) = right$(mstrPathFile(lngSlotNumber), a - 1)
Dim sLongname As String
Dim sShortname As String
sLongname = mstrPathFile(lngSlotNumber)
sShortname = Space$(256)
tempval = Len(sShortname)
pos = GetShortPathName(sLongname, sShortname, tempval)
mstr83PathFile(lngSlotNumber) = LCase$(left$(sShortname, pos))
For a = 1 To Len(mstr83PathFile(lngSlotNumber))
    If InStr(right$(mstr83PathFile(lngSlotNumber), a), "\") Then Exit For
Next a
mstr83File(lngSlotNumber) = right$(mstr83PathFile(lngSlotNumber), a - 1)
End Function

Public Function CloseF(ByVal lngSlotNumber As Long) As Boolean
Attribute CloseF.VB_Description = "Closes a file opened with OpenF"
If lngSlotNumber > 255 Or lngSlotNumber < 1 Then
    Err.Raise 1000, "CloseF", "Slot number must be between 1 and 255"
    Exit Function
End If
If mstrSlotsUsed(lngSlotNumber) = "" Then
    Err.Raise 1000, "CloseF", "Slot is currently empty."
    Exit Function
End If
If CloseHandle(mlngFileHandle(lngSlotNumber)) = 0 Then
    CloseF = False
Else
    CloseF = True
    mstrSlotsUsed(lngSlotNumber) = ""
    mblnArchive(lngSlotNumber) = False
    mblnCompressed(lngSlotNumber) = False
    mblnHidden(lngSlotNumber) = False
    mblnReadOnly(lngSlotNumber) = False
    mblnSystem(lngSlotNumber) = False
    mdwVolumeSerialNumber(lngSlotNumber) = 0
    mlngFileSize(lngSlotNumber) = 0
    mstrFileSize(lngSlotNumber) = ""
    mlngFileHandle(lngSlotNumber) = 0
    mstrPathFile(lngSlotNumber) = ""
    mstrPath(lngSlotNumber) = ""
    mstrFile(lngSlotNumber) = ""
    mstrExtension(lngSlotNumber) = ""
    mstr83File(lngSlotNumber) = ""
    mstr83PathFile(lngSlotNumber) = ""
    mlngFilePos(lngSlotNumber) = 0
End If
End Function

Public Function WriteF(ByVal lngSlotNumber As Long, ByVal anyText) As Boolean
Attribute WriteF.VB_Description = "Writes to a file previously opened"
If lngSlotNumber > 255 Or lngSlotNumber < 1 Then
    Err.Raise 1000, "WriteF", "Slot number must be between 1 and 255"
    Exit Function
End If
If mstrSlotsUsed(lngSlotNumber) <> "Write" Then
    Err.Raise 1000, "WriteF", "Slot is not opened for Write access."
    Exit Function
End If
Dim temp As Long
If WriteFile(mlngFileHandle(lngSlotNumber), anyText, Len(anyText), temp, ByVal CLng(0)) = 0 Then WriteF = False Else WriteF = True
End Function

Public Function ReadBytes(ByVal lngSlotNumber As Long, ByVal lngNumBytes As Long)
Attribute ReadBytes.VB_Description = "Reads a certain number of bytes from a file, starting at the current file pointer."
If lngSlotNumber > 255 Or lngSlotNumber < 1 Then
    Err.Raise 1000, "ReadBytes", "Slot number must be between 1 and 255"
    Exit Function
End If
If mstrSlotsUsed(lngSlotNumber) <> "Read" Then
    Err.Raise 1000, "ReadBytes", "Slot is not opened for Read access."
    Exit Function
End If
Dim temp As Long
If ReadFile(mlngFileHandle(lngSlotNumber), tempret, lngNumBytes, temp, ByVal CLng(0)) = 0 Then
    ReadBytes = False
Else
    ReadBytes = tempret
    mlngFilePos(lngSlotNumber) = mlngFilePos(lngSlotNumber) + lngNumBytes
End If
End Function

Public Function ReadLine(ByVal lngSlotNumber As Long) As String
Attribute ReadLine.VB_Description = "Reads from a file until a carriage return is found, starting at the current file pointer."
If lngSlotNumber > 255 Or lngSlotNumber < 1 Then
    Err.Raise 1000, "ReadLine", "Slot number must be between 1 and 255"
    Exit Function
End If
If mstrSlotsUsed(lngSlotNumber) <> "Read" Then
    Err.Raise 1000, "ReadLine", "Slot is not opened for Read access."
    Exit Function
End If
Dim temp As Long
Dim totalstr As String
Dim tempret As String
totalstr = ""
While tempret <> Chr$(13)
    tempret = " "
    If ReadFile(mlngFileHandle(lngSlotNumber), ByVal tempret, 1, temp, ByVal CLng(0)) = 0 Then
        ReadLine = "Error"
        Exit Function
    End If
    If temp < Len(tempret) Then
        If totalstr = "" Then
            ReadLine = "EOF"
        Else
            ReadLine = totalstr
            mlngFilePos(lngSlotNumber) = mlngFilePos(lngSlotNumber) + Len(totalstr)
        End If
        Exit Function
    End If
    If tempret = Chr$(13) Or (tempret = Chr$(10) And totalstr = "") Then
    Else
        totalstr = totalstr & tempret
    End If
Wend
mlngFilePos(lngSlotNumber) = mlngFilePos(lngSlotNumber) + Len(totalstr) + 1
ReadLine = totalstr
End Function

Public Function MoveStart(ByVal lngSlotNumber As Long) As Boolean
Attribute MoveStart.VB_Description = "Moves the file pointer to the beginning of the file."
If lngSlotNumber > 255 Or lngSlotNumber < 1 Then
    Err.Raise 1000, "MoveStart", "Slot number must be between 1 and 255"
    Exit Function
End If
If mstrSlotsUsed(lngSlotNumber) = "" Then
    Err.Raise 1000, "MoveStart", "Slot is currently empty."
    Exit Function
End If
highbyte = 0
If SetFilePointer(mlngFileHandle(lngSlotNumber), 0&, highbyte, 0&) = -1 Then MoveStart = False Else MoveStart = True
End Function

Public Function FirstOpenSlot() As Long
Attribute FirstOpenSlot.VB_Description = "Finds the first open file slot."
FirstOpenSlot = 0
For a = 1 To 255
    If mstrSlotsUsed(a) = "" And FirstOpenSlot = 0 Then FirstOpenSlot = a
Next a
End Function

Private Function FindULARGEValue(uliValue As ULARGE_INTEGER) As Long
Dim tempval As Currency
CopyMemory tempval, uliValue, 8
tempval = tempval * 10000
FindULARGEValue = CLng(tempval)
End Function

Private Function FindByteString(ByVal lngBytes As Long) As String
If lngBytes < 1000 ^ 1 Then
    FindByteString = CStr(lngBytes) & " bytes"
ElseIf lngBytes < 1000 ^ 2 Then
    FindByteString = CStr(Round(lngBytes / (1024 ^ 1), 2)) & " kilobytes"
ElseIf lngBytes < 1000 ^ 3 Then
    FindByteString = CStr(Round(lngBytes / (1024 ^ 2), 2)) & " megabytes"
Else
    FindByteString = CStr(Round(lngBytes / (1024 ^ 3), 2)) & " gigabytes"
End If
End Function

Private Function TrimNull(item As String) As String
Dim pos As Integer
pos = InStr(item, Chr$(0))
If pos Then
    TrimNull = left$(item, pos - 1)
Else: TrimNull = item
End If
End Function

Private Sub Class_Terminate()
For a = 1 To 255
    If mstrSlotsUsed(a) <> "" Then CloseF (a)
Next a
End Sub
