VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "FileSystemClass"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "A collection of routines for file system interaction"
Private mlngBytesFree As Long
Private mlngBytesTotal As Long
Private mstrBytesFree As String
Private mstrBytesTotal As String

Private mdteDriveType As DriveTypeEnum
Private mstrDriveType As String

Private mblnArchive As Boolean
Private mblnCompressed As Boolean
Private mblnDirectory As Boolean
Private mblnHidden As Boolean
Private mblnReadOnly As Boolean
Private mblnSystem As Boolean

Private mblnDrivesExist(1 To 26) As Boolean

Private Type SECURITY_ATTRIBUTES
  nLength As Long
  lpSecurityDescriptor As Long
  bInheritHandle As Boolean
End Type

Private Type FILETIME
  dwLowDateTime As Long
  dwHighDateTime As Long
End Type

Private Type WIN32_FIND_DATA
  dwFileAttributes As Long
  ftCreationTime As FILETIME
  ftLastAccessTime As FILETIME
  ftLastWriteTime As FILETIME
  nFileSizeHigh As Long
  nFileSizeLow As Long
  dwReserved0 As Long
  dwReserved1 As Long
  cFileName As String * 260
  cAlternate As String * 14
End Type

Private Type BY_HANDLE_FILE_INFORMATION
  dwFileAttributes As Long
  ftCreationTime As FILETIME
  ftLastAccessTime As FILETIME
  ftLastWriteTime As FILETIME
  dwVolumeSerialNumber As Long
  nFileSizeHigh As Long
  nFileSizeLow As Long
  nNumberOfLinks As Long
  nFileIndexHigh As Long
  nFileIndexLow As Long
End Type

Private Type ULARGE_INTEGER
  LowPart As Long
  HighPart As Long
End Type

Public Enum DriveTypeEnum
    DRIVE_NOTEXIST = 1
    DRIVE_REMOVABLE
    DRIVE_FIXED
    DRIVE_NETWORK
    DRIVE_CDROM
    DRIVE_RAMDISK
End Enum

Private Const FILE_ATTRIBUTE_ARCHIVE = &H20
Private Const FILE_ATTRIBUTE_COMPRESSED = &H800
Private Const FILE_ATTRIBUTE_DIRECTORY = &H10
Private Const FILE_ATTRIBUTE_HIDDEN = &H2
Private Const FILE_ATTRIBUTE_NORMAL = &H80
Private Const FILE_ATTRIBUTE_READONLY = &H1
Private Const FILE_ATTRIBUTE_SYSTEM = &H4

Private Declare Function CopyFileAPI Lib "kernel32.dll" Alias "CopyFileA" (ByVal lpExistingFileName As String, ByVal lpNewFileName As String, ByVal bFailIfExists As Long) As Long
Private Declare Function DeleteFileAPI Lib "kernel32.dll" Alias "DeleteFileA" (ByVal lpFileName As String) As Long
Private Declare Function CreateDirectory Lib "kernel32.dll" Alias "CreateDirectoryA" (ByVal lpPathName As String, lpSecurityAttributes As SECURITY_ATTRIBUTES) As Long
Private Declare Function MoveFileAPI Lib "kernel32.dll" Alias "MoveFileA" (ByVal lpExistingFileName As String, ByVal lpNewFileName As String) As Long
Private Declare Function RemoveDirectory Lib "kernel32.dll" Alias "RemoveDirectoryA" (ByVal lpPathName As String) As Long
Private Declare Function FindFirstFile Lib "kernel32.dll" Alias "FindFirstFileA" (ByVal lpFileName As String, lpFindFileData As WIN32_FIND_DATA) As Long
Private Declare Function FindNextFile Lib "kernel32.dll" Alias "FindNextFileA" (ByVal hFindFile As Long, lpFindFileData As WIN32_FIND_DATA) As Long
Private Declare Function FindClose Lib "kernel32.dll" (ByVal hFindFile As Long) As Long
Private Declare Function GetDiskFreeSpace Lib "kernel32.dll" Alias "GetDiskFreeSpaceA" (ByVal lpRootPathName As String, lpSectorsPerCluster As Long, lpBytesPerSector As Long, lpNumberOfFreeClusters As Long, lpTotalNumberOfClusters As Long) As Long
Private Declare Function GetDriveType Lib "kernel32.dll" Alias "GetDriveTypeA" (ByVal nDrive As String) As Long
Private Declare Function GetFileAttributes Lib "kernel32.dll" Alias "GetFileAttributesA" (ByVal lpFileName As String) As Long
Private Declare Sub CopyMemory Lib "kernel32.dll" Alias "RtlMoveMemory" (Destination As Any, Source As Any, ByVal Length As Long)
Private Declare Function GetLogicalDrives Lib "kernel32.dll" () As Long
Private Declare Function GetShortPathName Lib "kernel32.dll" Alias "GetShortPathNameA" (ByVal lpszLongPath As String, ByVal lpszShortPath As String, ByVal cchBuffer As Long) As Long
Private Declare Function SetFileAttributes Lib "kernel32.dll" Alias "SetFileAttributesA" (ByVal lpFileName As String, ByVal dwFileAttributes As Long) As Long
Private Declare Function GetSystemDirectoryAPI Lib "kernel32.dll" Alias "GetSystemDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long) As Long
Private Declare Function GetWindowsDirectoryAPI Lib "kernel32.dll" Alias "GetWindowsDirectoryA" (ByVal lpBuffer As String, ByVal nSize As Long) As Long
Private Declare Function GetTempPath Lib "kernel32.dll" Alias "GetTempPathA" (ByVal nBufferLength As Long, ByVal lpBuffer As String) As Long

Public Property Get DriveBytesFreeLong() As Long
Attribute DriveBytesFreeLong.VB_Description = "A numerical representation of the number of bytes left on the drive."
DriveBytesFreeLong = mlngBytesFree
End Property

Public Property Get DriveBytesTotalLong() As Long
Attribute DriveBytesTotalLong.VB_Description = "A numerical representation of the number of bytes total on the drive."
DriveBytesTotalLong = mlngBytesTotal
End Property

Public Property Get DriveBytesFreeStr() As String
Attribute DriveBytesFreeStr.VB_Description = "A string representation of the number of bytes left on the drive."
DriveBytesFreeStr = mstrBytesFree
End Property

Public Property Get DriveBytesTotalStr() As String
Attribute DriveBytesTotalStr.VB_Description = "A string representation of the number of bytes total on the drive."
DriveBytesTotalStr = mstrBytesTotal
End Property

Public Property Get DriveTypeDTE() As String
Attribute DriveTypeDTE.VB_Description = "The number of the type of drive. (type DriveTypeEnum)"
DriveTypeDTE = mdteDriveType
End Property

Public Property Get DriveTypeStr() As String
Attribute DriveTypeStr.VB_Description = "A string describing the type of drive."
DriveTypeStr = mstrDriveType
End Property

Public Property Get FileArchive() As Boolean
Attribute FileArchive.VB_Description = "The file/directory's Archive property."
FileArchive = mblnArchive
End Property

Public Property Get FileCompressed() As Boolean
Attribute FileCompressed.VB_Description = "The file/directory's Compressed property. (Windows 2000 and ME only)"
FileCompressed = mblnCompressed
End Property

Public Property Get FileDirectory() As Boolean
Attribute FileDirectory.VB_Description = "If true, then the file is really a directory."
FileDirectory = mblnDirectory
End Property

Public Property Get FileHidden() As Boolean
Attribute FileHidden.VB_Description = "The file/directory's Hidden property."
FileHidden = mblnHidden
End Property

Public Property Get FileReadOnly() As Boolean
Attribute FileReadOnly.VB_Description = "The file/directory's Read-Only property."
FileReadOnly = mblnReadOnly
End Property

Public Property Get FileSystem() As Boolean
Attribute FileSystem.VB_Description = "The file/directory's System property."
FileSystem = mblnSystem
End Property

Public Property Get DriveExists(ByVal drivenum As Long) As Boolean
Attribute DriveExists.VB_Description = "Whether the drive exists or not (drivenum must be between 1 and 26)"
If drivenum < 1 Or drivenum > 26 Then
    Err.Raise 1000, "DriveExists", "Drive number must be between 1 and 26."
    Exit Property
End If
DriveExists = mblnDrivesExist(drivenum)
End Property

Public Function CopyFile(ByVal strFrom As String, ByVal strTo As String, ByVal blnOverwrite As Boolean) As Boolean
Attribute CopyFile.VB_Description = "Copies a file"
Dim temp As Long
If blnOverwrite = False Then temp = 1
If CopyFileAPI(strFrom, strTo, temp) = 0 Then CopyFile = False Else CopyFile = True
End Function

Public Function MoveFile(ByVal strFrom As String, ByVal strTo As String) As Boolean
Attribute MoveFile.VB_Description = "Moves a file (copies and deletes)"
If MoveFileAPI(strFrom, strTo) = 0 Then MoveFile = False Else MoveFile = True
End Function

Public Function RenameDirectory(ByVal strFrom As String, ByVal strTo As String) As Boolean
Attribute RenameDirectory.VB_Description = "Renames a directory"
If MoveFileAPI(strFrom, strTo) = 0 Then RenameDirectory = False Else RenameDirectory = True
End Function

Public Function DeleteFile(ByVal strFile As String) As Boolean
Attribute DeleteFile.VB_Description = "Deletes a file"
If DeleteFileAPI(strPath) = 0 Then DeleteFile = False Else DeleteFile = True
End Function

Public Function MakeDirectory(ByVal strPath As String) As Boolean
Attribute MakeDirectory.VB_Description = "Creates a directory"
Dim tempdir As SECURITY_ATTRIBUTES
tempdir.nLength = Len(secattr)
tempdir.lpSecurityDescriptor = 0
tempdir.bInheritHandle = 1
If CreateDirectory(strPath, tempdir) = 0 Then MakeDirectory = False Else MakeDirectory = True
End Function

Public Function DeleteDirectory(ByVal strPath As String) As Boolean
Attribute DeleteDirectory.VB_Description = "Deletes a directory"
If RemoveDirectory(strPath) = 0 Then DeleteDirectory = False Else DeleteDirectory = True
End Function

Public Function FindFiles(ByVal strPathFilter As String, ByRef strRetVals() As String) As Integer
Attribute FindFiles.VB_Description = "Finds files of a certain type in a directory."
FindFiles = 0
Dim hsearch As Long
Dim findinfo As WIN32_FIND_DATA
Dim success As Long
Dim buffer As String
hsearch = FindFirstFile(strPathFilter, findinfo)
If hsearch = -1 Then
    ReDim strRetVals(0 To 0) As String
    Exit Function
End If
Do
    buffer = Left(findinfo.cFileName, InStr(findinfo.cFileName, vbNullChar) - 1)
    If findinfo.dwFileAttributes And FILE_ATTRIBUTE_DIRECTORY Then buffer = "[Folder]" & buffer
    FindFiles = FindFiles + 1
    ReDim Preserve strRetVals(1 To FindFiles) As String
    strRetVals(FindFiles) = buffer
    success = FindNextFile(hsearch, findinfo)
Loop Until success = 0
retval = FindClose(hsearch)
End Function

Public Sub FindDiskSpace(ByVal strDrive As String)
Attribute FindDiskSpace.VB_Description = "Finds the amount of free and total disk space on a drive."
Dim secPerClus As Long
Dim bytePerSec As Long
Dim freeClus As Long
Dim totalClus As Long
Dim retval As Long
retval = GetDiskFreeSpace(strDrive, secPerClus, bytePerSec, freeClus, totalClus)
mlngBytesFree = freeClus * secPerClus * bytePerSec
mlngBytesTotal = totalClus * secPerClus * bytePerSec
mstrBytesFree = FindByteString(tlngBytesFree)
mstrBytesTotal = FindByteString(tlngBytesTotal)
End Sub

Public Function FindDriveType(ByVal strDrive As String) As String
Attribute FindDriveType.VB_Description = "Finds what type a drive is."
mdteDriveType = GetDriveType(strDrive)
Select Case mdteDriveType
    Case DRIVE_NOTEXIST
        mstrDriveType = "Drive doesn't exist"
    Case DRIVE_REMOVABLE
        mstrDriveType = "Removable drive"
    Case DRIVE_FIXED
        mstrDriveType = "Hard drive"
    Case DRIVE_NETWORK
        mstrDriveType = "Network drive"
    Case DRIVE_CDROM
        mstrDriveType = "CD-ROM drive"
    Case DRIVE_RAMDISK
        mstrDriveType = "Virtual drive"
End Select
FindDriveType = mstrDriveType
End Function

Public Sub GetFileAttribs(ByVal strFile As String)
Attribute GetFileAttribs.VB_Description = "Finds the attributes of a file or directory."
retval = GetFileAttributes(strFile)
If retval And FILE_ATTRIBUTE_ARCHIVE Then mblnArchive = True Else mblnArchive = False
If retval And FILE_ATTRIBUTE_COMPRESSED Then mblnCompressed = True Else mblnCompressed = False
If retval And FILE_ATTRIBUTE_DIRECTORY Then mblnDirectory = True Else mblnDirectory = False
If retval And FILE_ATTRIBUTE_HIDDEN Then mblnHidden = True Else mblnHidden = False
If retval And FILE_ATTRIBUTE_READONLY Then mblnReadOnly = True Else mblnReadOnly = False
If retval And FILE_ATTRIBUTE_SYSTEM Then mblnSystem = True Else mblnSystem = False
End Sub

Public Function SetFileAttribs(ByVal strFile As String, blnArchive As Boolean, blnHidden As Boolean, blnReadOnly As Boolean, blnSystem As Boolean) As Boolean
Attribute SetFileAttribs.VB_Description = "Sets the attributes of a file or directory."
Dim fileattrs As Long
fileattrs = 0
If blnArchive = True Then fileattrs = fileattrs Or FILE_ATTRIBUTE_ARCHIVE
If blnHidden = True Then fileattrs = fileattrs Or FILE_ATTRIBUTE_HIDDEN
If blnReadOnly = True Then fileattrs = fileattrs Or FILE_ATTRIBUTE_READONLY
If blnSystem = True Then fileattrs = fileattrs Or FILE_ATTRIBUTE_SYSTEM
If (blnArchive = False) And (blnHidden = False) And (blnReadOnly = False) And (blnSystem = False) Then fileattrs = fileattrs Or FILE_ATTRIBUTE_NORMAL
If SetFileAttributes(strFile, fileattrs) = 0 Then SetFileAttribs = False Else SetFileAttribs = True
End Function

Private Function FindByteString(ByVal lngBytes As Long) As String
If lngBytes < 1000 ^ 1 Then
    FindByteString = CStr(lngBytes) & " bytes"
ElseIf lngBytes < 1000 ^ 2 Then
    FindByteString = CStr(Round(lngBytes / (1024 ^ 1), 2)) & " kilobytes"
ElseIf lngBytes < 1000 ^ 3 Then
    FindByteString = CStr(Round(lngBytes / (1024 ^ 2), 2)) & " megabytes"
Else
    FindByteString = CStr(Round(lngBytes / (1024 ^ 3), 2)) & " gigabytes"
End If
End Function

Public Function GetSystemDrives(Optional strDrive As String) As Boolean
Attribute GetSystemDrives.VB_Description = "Finds the status of drive(s)."
retval = GetLogicalDrives()
For a = 0 To 25
    If (retval And 2 ^ a) = 2 ^ a Then
        mblnDrivesExist(a + 1) = True
        If Asc(UCase(Left$(strDrive, 1))) - 65 = a Then GetSystemDrives = True
    End If
Next a
End Function

Public Function Get83FilePathName(ByVal strFilePath As String) As String
Attribute Get83FilePathName.VB_Description = "Finds the 8.3 format of a file and path name."
    Dim tempstr As String
    tempstr = Space(256)
    retval = GetShortPathName(strFilePath, tempstr, 256)
    Get83FilePathName = Left(tempstr, retval)
End Function

Public Function GetSystemDirectory() As String
Attribute GetSystemDirectory.VB_Description = "Finds the path of the System directory (usually, but not always, ""C:\\Windows\\System"")"
Dim sysdir As String
sysdir = Space(255)
retval = GetSystemDirectory(sysdir, 255)
GetSystemDirectory = Left(sysdir, retval)
End Function

Public Function GetWindowsDirectory() As String
Attribute GetWindowsDirectory.VB_Description = "Finds the path of the Windows directory (usually, but not always, ""C:\\Windows"")"
Dim windir As String
windir = Space(255)
retval = GetWindowsDirectoryAPI(windir, 255)
GetWindowsDirectory = Left(windir, retval)
End Function

Public Function GetTempDirectory() As String
Attribute GetTempDirectory.VB_Description = "Finds the path of the Temp directory (usually, but not always, ""C:\\Windows\\Temp"")"
Dim tempdir As String
tempdir = Space(255)
retval = GetTempPath(tempdir, 255)
GetSystemDirectory = Left(tempdir, retval)
End Function

