VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "MP3Info"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Procedures that work with MP3 audio files."
Private mstrSongName As String
Private mstrArtist As String
Private mstrAlbum As String
Private mstrYear As String
Private mstrComment As String
Private mlngGenreNum As Long
Private mstrGenreStr As String

Private Type TagInfo
    Tag As String * 3
    SongName As String * 30
    Artist As String * 30
    Album As String * 30
    Year As String * 4
    Comment As String * 30
    Genre As String * 1
End Type

Public Property Get SongName() As String
Attribute SongName.VB_Description = "The name of the song."
SongName = mstrSongName
End Property

Public Property Get Artist() As String
Attribute Artist.VB_Description = "The artist of the song."
Artist = mstrArtist
End Property

Public Property Get Album() As String
Attribute Album.VB_Description = "The album of the song."
Album = mstrAlbum
End Property

Public Property Get Year() As String
Attribute Year.VB_Description = "The year that the song was released."
Year = mstrYear
End Property

Public Property Get Comment() As String
Attribute Comment.VB_Description = "Comments"
Comment = mstrComment
End Property

Public Property Get GenreNum() As Long
Attribute GenreNum.VB_Description = "A number representation of the genre of the song."
GenreNum = mlngGenreNum
End Property

Public Property Get GenreStr() As String
Attribute GenreStr.VB_Description = "A string representation of the genre of the song."
GenreStr = mstrGenreStr
End Property

Public Function GetTagInfo(ByVal strFileName As String) As String
Attribute GetTagInfo.VB_Description = "Finds the ID3 tags in an MP3 file."
Attribute GetTagInfo.VB_UserMemId = 0
Close #1
Dim CurrentTag As TagInfo
Dim temp As String
On Error Resume Next
Open strFileName For Binary As #1
With CurrentTag
    Get #1, FileLen(strFileName) - 127, .Tag
    If Not .Tag = "TAG" Then
        GetTagInfo = "No information available"
        mstrSongName = "No information available"
        mstrArtist = "No information available"
        mstrAlbum = "No information available"
        mstrYear = "No information available"
        mstrComment = "No information available"
        mlngGenreNum = 0
        mstrGenreStr = "No information available"
        Close #1
        Exit Function
    End If
    Get #1, , .SongName
    Get #1, , .Artist
    Get #1, , .Album
    Get #1, , .Year
    Get #1, , .Comment
    Get #1, , .Genre
    Close #1
    mstrSongName = TrimExcess(.SongName)
    GetTagInfo = tstrSongName
    mstrArtist = TrimExcess(.Artist)
    mstrAlbum = TrimExcess(.Album)
    mstrYear = TrimExcess(.Year)
    mstrComment = TrimExcess(.Comment)
    If .Genre <> " " Then temp = RTrim(.Genre) Else temp = " "
    temp = Asc(temp)
    mlngGenreNum = temp
    Select Case temp
        Case 255
            mstrGenreStr = ""
        Case 123
            mstrGenreStr = "Acapella"
        Case 34
            mstrGenreStr = "Acid"
        Case 74
            mstrGenreStr = "Acid Jazz"
        Case 73
            mstrGenreStr = "Acid Punk"
        Case 99
            mstrGenreStr = "Acoustic"
        Case 40
            mstrGenreStr = "Alt. Rock"
        Case 20
            mstrGenreStr = "Alternative"
        Case 26
            mstrGenreStr = "Ambient"
        Case 90
            mstrGenreStr = "Avantgarde"
        Case 116
            mstrGenreStr = "Ballad"
        Case 41
            mstrGenreStr = "Bass"
        Case 135
            mstrGenreStr = "Beat"
        Case 85
            mstrGenreStr = "Bebop"
        Case 96
            mstrGenreStr = "Big Band"
        Case 138
            mstrGenreStr = "Black Metal"
        Case 89
            mstrGenreStr = "Bluegrass"
        Case 0
            mstrGenreStr = "Blues"
        Case 107
            mstrGenreStr = "Booty Bass"
        Case 132
            mstrGenreStr = "BritPop"
        Case 65
            mstrGenreStr = "Cabaret"
        Case 88
            mstrGenreStr = "Celtic"
        Case 104
            mstrGenreStr = "Chamber Music"
        Case 102
            mstrGenreStr = "Chanson"
        Case 97
            mstrGenreStr = "Chorus"
        Case 136
            mstrGenreStr = "Christian Gangsta Rap"
        Case 61
            mstrGenreStr = "Christian Rap"
        Case 141
            mstrGenreStr = "Christian Rock"
        Case 1
            mstrGenreStr = "Classic Rock"
        Case 32
            mstrGenreStr = "Classical"
        Case 112
            mstrGenreStr = "Club"
        Case 128
            mstrGenreStr = "Club-House"
        Case 57
            mstrGenreStr = "Comedy"
        Case 140
            mstrGenreStr = "Contemporary Christian"
        Case 2
            mstrGenreStr = "Country"
        Case 139
            mstrGenreStr = "Crossover"
        Case 58
            mstrGenreStr = "Cult"
        Case 3
            mstrGenreStr = "Dance"
        Case 125
            mstrGenreStr = "Dance Hall"
        Case 50
            mstrGenreStr = "Darkwave"
        Case 22
            mstrGenreStr = "Death Metal"
        Case 4
            mstrGenreStr = "Disco"
        Case 55
            mstrGenreStr = "Dream"
        Case 127
            mstrGenreStr = "Drum & Bass"
        Case 122
            mstrGenreStr = "Drum Solo"
        Case 120
            mstrGenreStr = "Duet"
        Case 98
            mstrGenreStr = "Easy Listening"
        Case 52
            mstrGenreStr = "Electronic"
        Case 48
            mstrGenreStr = "Ethnic"
        Case 54
            mstrGenreStr = "Eurodance"
        Case 124
            mstrGenreStr = "Euro-House"
        Case 25
            mstrGenreStr = "Euro-Techno"
        Case 84
            mstrGenreStr = "Fast Fusion"
        Case 80
            mstrGenreStr = "Folk"
        Case 81
            mstrGenreStr = "Folk-Rock"
        Case 115
            mstrGenreStr = "Folklore"
        Case 119
            mstrGenreStr = "Freestyle"
        Case 5
            mstrGenreStr = "Funk"
        Case 30
            mstrGenreStr = "Fusion"
        Case 36
            mstrGenreStr = "Game"
        Case 59
            mstrGenreStr = "Gangsta Rap"
        Case 126
            mstrGenreStr = "Goa"
        Case 38
            mstrGenreStr = "Gospel"
        Case 49
            mstrGenreStr = "Gothic"
        Case 91
            mstrGenreStr = "Gothic Rock"
        Case 6
            mstrGenreStr = "Grunge"
        Case 79
            mstrGenreStr = "Hard Rock"
        Case 129
            mstrGenreStr = "Hardcore"
        Case 137
            mstrGenreStr = "Heavy Metal"
        Case 7
            mstrGenreStr = "Hip-Hop"
        Case 35
            mstrGenreStr = "House"
        Case 100
            mstrGenreStr = "Humor"
        Case 131
            mstrGenreStr = "Indie"
        Case 19
            mstrGenreStr = "Industrial"
        Case 33
            mstrGenreStr = "Instrumental"
        Case 46
            mstrGenreStr = "Instrumental Pop"
        Case 47
            mstrGenreStr = "Instrumental Rock"
        Case 8
            mstrGenreStr = "Jazz"
        Case 29
            mstrGenreStr = "Jazz+Funk"
        Case 146
            mstrGenreStr = "JPop"
        Case 63
            mstrGenreStr = "Jungle"
        Case 86
            mstrGenreStr = "Latin"
        Case 71
            mstrGenreStr = "Lo-Fi"
        Case 45
            mstrGenreStr = "Meditative"
        Case 142
            mstrGenreStr = "Merengue"
        Case 9
            mstrGenreStr = "Metal"
        Case 77
            mstrGenreStr = "Musical"
        Case 82
            mstrGenreStr = "National Folk"
        Case 64
            mstrGenreStr = "Native American"
        Case 133
            mstrGenreStr = "Negerpunk"
        Case 10
            mstrGenreStr = "New Age"
        Case 66
            mstrGenreStr = "New Wave"
        Case 39
            mstrGenreStr = "Noise"
        Case 11
            mstrGenreStr = "Oldies"
        Case 103
            mstrGenreStr = "Opera"
        Case 12
            mstrGenreStr = "Other"
        Case 75
            mstrGenreStr = "Polka"
        Case 134
            mstrGenreStr = "Polsk Punk"
        Case 13
            mstrGenreStr = "Pop"
        Case 62
            mstrGenreStr = "Pop/Funk"
        Case 53
            mstrGenreStr = "Pop-Folk"
        Case 109
            mstrGenreStr = "Porn Groove"
        Case 117
            mstrGenreStr = "Power Ballad"
        Case 23
            mstrGenreStr = "Pranks"
        Case 108
            mstrGenreStr = "Primus"
        Case 92
            mstrGenreStr = "Progressive Rock"
        Case 67
            mstrGenreStr = "Psychedelic"
        Case 93
            mstrGenreStr = "Psychedelic Rock"
        Case 43
            mstrGenreStr = "Punk"
        Case 121
            mstrGenreStr = "Punk Rock"
        Case 14
            mstrGenreStr = "R&B"
        Case 15
            mstrGenreStr = "Rap"
        Case 68
            mstrGenreStr = "Rave"
        Case 16
            mstrGenreStr = "Reggae"
        Case 76
            mstrGenreStr = "Retro"
        Case 87
            mstrGenreStr = "Revival"
        Case 118
            mstrGenreStr = "Rhythmic Soul"
        Case 17
            mstrGenreStr = "Rock"
        Case 78
            mstrGenreStr = "Rock & Roll"
        Case 143
            mstrGenreStr = "Salsa"
        Case 114
            mstrGenreStr = "Samba"
        Case 110
            mstrGenreStr = "Satire"
        Case 69
            mstrGenreStr = "Showtunes"
        Case 21
            mstrGenreStr = "Ska"
        Case 111
            mstrGenreStr = "Slow Jam"
        Case 95
            mstrGenreStr = "Slow Rock"
        Case 105
            mstrGenreStr = "Sonata"
        Case 42
            mstrGenreStr = "Soul"
        Case 37
            mstrGenreStr = "Sound Clip"
        Case 24
            mstrGenreStr = "Soundtrack"
        Case 56
            mstrGenreStr = "Southern Rock"
        Case 44
            mstrGenreStr = "Space"
        Case 101
            mstrGenreStr = "Speech"
        Case 83
            mstrGenreStr = "Swing"
        Case 94
            mstrGenreStr = "Symphonic Rock"
        Case 106
            mstrGenreStr = "Symphony"
        Case 147
            mstrGenreStr = "Synthpop"
        Case 113
            mstrGenreStr = "Tango"
        Case 18
            mstrGenreStr = "Techno"
        Case 51
            mstrGenreStr = "Techno-Industrial"
        Case 130
            mstrGenreStr = "Terror"
        Case 144
            mstrGenreStr = "Thrash Metal"
        Case 60
            mstrGenreStr = "Top 40"
        Case 70
            mstrGenreStr = "Trailer"
        Case 31
            mstrGenreStr = "Trance"
        Case 72
            mstrGenreStr = "Tribal"
        Case 27
            mstrGenreStr = "Trip-Hop"
        Case 28
            mstrGenreStr = "Vocal"
    End Select
End With
End Function

Private Function TrimExcess(strinput As String) As String
For a = Len(strinput) To 1 Step -1
    If Asc(Mid$(strinput, a, 1)) > 32 Then
        TrimExcess = Left$(strinput, a)
        Exit Function
    End If
Next a
TrimExcess = strinput
End Function

