VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Tasks"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Attribute VB_Description = "Procedures that work with tasks and windows."
Private Type RECT
    left As Long
    top As Long
    right As Long
    bottom As Long
End Type

Private Declare Function GetWindow Lib "user32" (ByVal hwnd As Long, ByVal wCmd As Long) As Long
Private Declare Function GetParent Lib "user32" (ByVal hwnd As Long) As Long
Private Declare Function GetWindowTextLength Lib "user32" Alias "GetWindowTextLengthA" (ByVal hwnd As Long) As Long
Private Declare Function GetWindowText Lib "user32" Alias "GetWindowTextA" (ByVal hwnd As Long, ByVal lpString As String, ByVal cch As Long) As Long
Private Declare Function MoveWindowAPI Lib "user32.dll" Alias "MoveWindow" (ByVal hwnd As Long, ByVal x As Long, ByVal y As Long, ByVal nWidth As Long, ByVal nHeight As Long, ByVal bRepaint As Long) As Long
Private Declare Function GetWindowRect Lib "user32.dll" (ByVal hwnd As Long, lpRect As RECT) As Long
Private Declare Function SendMessage Lib "user32.dll" Alias "SendMessageA" (ByVal hwnd As Long, ByVal Msg As Long, wParam As Any, lParam As Any) As Long
Private Declare Function SetWindowPos Lib "user32" (ByVal hwnd As Long, ByVal hWndInsertAfter As Long, ByVal x As Long, ByVal y As Long, ByVal cx As Long, ByVal cy As Long, ByVal wFlags As Long) As Long

Const WM_CLOSE = &H10

Const GW_HWNDFIRST = 0
Const GW_HWNDNEXT = 2

Const SWP_NOMOVE = 2
Const SWP_NOSIZE = 1
Const FLAGS = SWP_NOMOVE Or SWP_NOSIZE
Const HWND_TOPMOST = -1
Const HWND_NOTOPMOST = -2

Public Function FindAll(ByVal frmStartFrom As Form, strTaskTitleList() As String, lngTaskHandleList() As Long) As Integer
Attribute FindAll.VB_Description = "Finds every window's title and handle."
Attribute FindAll.VB_UserMemId = 0
Dim CurrWnd As Long
Dim Length As Long
Dim TaskName As String
Dim Parent As Long
Dim numfound As Long
CurrWnd = GetWindow(frmStartFrom.hwnd, GW_HWNDFIRST)
numfound = 0
ReDim strTaskTitleList(0 To 0) As String
ReDim lngTaskHandleList(0 To 0) As Long
While CurrWnd <> 0
    Parent = GetParent(CurrWnd)
    Length = GetWindowTextLength(CurrWnd)
    TaskName = Space$(Length + 1)
    Length = GetWindowText(CurrWnd, TaskName, Length + 1)
    TaskName = left$(TaskName, Len(TaskName) - 1)
    If Length > 0 Then
        If TaskName <> frmStartFrom.Caption Then
            numfound = numfound + 1
            ReDim Preserve strTaskTitleList(0 To numfound) As String
            ReDim Preserve lngTaskHandleList(0 To numfound) As Long
            strTaskTitleList(numfound) = TaskName
            lngTaskHandleList(numfound) = CurrWnd
        End If
    End If
    CurrWnd = GetWindow(CurrWnd, GW_HWNDNEXT)
    DoEvents
Wend
FindAll = numfound
End Function

Public Function FindWithText(ByVal frmStartFrom As Form, strSearchText As String) As Long
Attribute FindWithText.VB_Description = "Finds a window's handle whose title contains the specified text."
Dim CurrWnd As Long
Dim Length As Long
Dim TaskName As String
Dim Parent As Long
Dim numfound As Long
CurrWnd = GetWindow(frmStartFrom.hwnd, GW_HWNDFIRST)
ReDim strTaskTitleList(0 To 0) As String
ReDim lngTaskHandleList(0 To 0) As Long
While CurrWnd <> 0
    Parent = GetParent(CurrWnd)
    Length = GetWindowTextLength(CurrWnd)
    TaskName = Space$(Length + 1)
    Length = GetWindowText(CurrWnd, TaskName, Length + 1)
    TaskName = left$(TaskName, Len(TaskName) - 1)
    If Length > 0 Then
        If TaskName <> frmStartFrom.Caption Then
            If InStr(UCase(TaskName), UCase(strSearchText)) <> 0 Then FindWithText = CurrWnd
        End If
    End If
    CurrWnd = GetWindow(CurrWnd, GW_HWNDNEXT)
    DoEvents
Wend
End Function

Public Function MoveWindow(lngHandle As Long, x As Long, y As Long, Optional width As Long, Optional height As Long) As Boolean
Attribute MoveWindow.VB_Description = "Moves a window."
Dim errocc As Boolean
If width = 0 Or height = 0 Then
    Dim temprect As RECT
    If GetWindowRect(lngHandle, temprect) = 0 Then
        MoveWindow = False
        errocc = True
    Else
        If width = 0 Then width = temprect.right - temprect.left
        If height = 0 Then height = temprect.bottom - temprect.top
    End If
End If
If errocc = False Then
    If MoveWindowAPI(lngHandle, x, y, width, height, 1) = 0 Then MoveWindow = False Else MoveWindow = True
End If
End Function

Public Sub CloseWindow(lngHandle As Long)
Attribute CloseWindow.VB_Description = """Asks"" a window to close."
Call SendMessage(lngHandle, WM_CLOSE, 0&, 0&)
End Sub

Public Function MakeTopMost(frmTarget As Form) As Boolean
Attribute MakeTopMost.VB_Description = "Makes a form ***in your program*** topmost."
retval = SetWindowPos(frmTarget.hwnd, HWND_TOPMOST, 0, 0, 0, 0, FLAGS)
If retval = 0 Then MakeTopMost = False Else MakeTopMost = True
End Function

Public Function OffTopMost(frmTarget As Form) As Boolean
Attribute OffTopMost.VB_Description = "Turns off topmost on a form ***in your program***."
retval = SetWindowPos(frmTarget.hwnd, HWND_NOTOPMOST, 0, 0, 0, 0, FLAGS)
If retval = 0 Then OffTopMost = False Else OffTopMost = True
End Function

